/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSPushSubscriptionChangeEvent.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSPushSubscription.h"
#include "JSPushSubscriptionChangeEventInit.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsPushSubscriptionChangeEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPushSubscriptionChangeEvent_newSubscription);
static JSC_DECLARE_CUSTOM_GETTER(jsPushSubscriptionChangeEvent_oldSubscription);

class JSPushSubscriptionChangeEventPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSPushSubscriptionChangeEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSPushSubscriptionChangeEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSPushSubscriptionChangeEventPrototype>(vm)) JSPushSubscriptionChangeEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPushSubscriptionChangeEventPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSPushSubscriptionChangeEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPushSubscriptionChangeEventPrototype, JSPushSubscriptionChangeEventPrototype::Base);

using JSPushSubscriptionChangeEventDOMConstructor = JSDOMConstructor<JSPushSubscriptionChangeEvent>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSPushSubscriptionChangeEventDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSPushSubscriptionChangeEventDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto typeConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    if (typeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto eventInitDictConversionResult = convert<IDLDictionary<PushSubscriptionChangeEventInit>>(*lexicalGlobalObject, argument1.value());
    if (eventInitDictConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto object = PushSubscriptionChangeEvent::create(typeConversionResult.releaseReturnValue(), eventInitDictConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<PushSubscriptionChangeEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<PushSubscriptionChangeEvent>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSPushSubscriptionChangeEventDOMConstructorConstruct, JSPushSubscriptionChangeEventDOMConstructor::construct);

template<> const ClassInfo JSPushSubscriptionChangeEventDOMConstructor::s_info = { "PushSubscriptionChangeEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPushSubscriptionChangeEventDOMConstructor) };

template<> JSValue JSPushSubscriptionChangeEventDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSExtendableEvent::getConstructor(vm, &globalObject);
}

template<> void JSPushSubscriptionChangeEventDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "PushSubscriptionChangeEvent"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSPushSubscriptionChangeEvent::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 3> JSPushSubscriptionChangeEventPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPushSubscriptionChangeEventConstructor, 0 } },
    HashTableValue { "newSubscription"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPushSubscriptionChangeEvent_newSubscription, 0 } },
    HashTableValue { "oldSubscription"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPushSubscriptionChangeEvent_oldSubscription, 0 } },
};

const ClassInfo JSPushSubscriptionChangeEventPrototype::s_info = { "PushSubscriptionChangeEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPushSubscriptionChangeEventPrototype) };

void JSPushSubscriptionChangeEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSPushSubscriptionChangeEvent::info(), JSPushSubscriptionChangeEventPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSPushSubscriptionChangeEvent::s_info = { "PushSubscriptionChangeEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPushSubscriptionChangeEvent) };

JSPushSubscriptionChangeEvent::JSPushSubscriptionChangeEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<PushSubscriptionChangeEvent>&& impl)
    : JSExtendableEvent(structure, globalObject, WTFMove(impl))
{
}

Ref<PushSubscriptionChangeEvent> JSPushSubscriptionChangeEvent::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, PushSubscriptionChangeEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSPushSubscriptionChangeEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSPushSubscriptionChangeEventPrototype::createStructure(vm, &globalObject, JSExtendableEvent::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSPushSubscriptionChangeEventPrototype::create(vm, &globalObject, structure);
}

JSObject* JSPushSubscriptionChangeEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSPushSubscriptionChangeEvent>(vm, globalObject);
}

JSValue JSPushSubscriptionChangeEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPushSubscriptionChangeEventDOMConstructor, DOMConstructorID::PushSubscriptionChangeEvent>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsPushSubscriptionChangeEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPushSubscriptionChangeEventPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSPushSubscriptionChangeEvent::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsPushSubscriptionChangeEvent_newSubscriptionGetter(JSGlobalObject& lexicalGlobalObject, JSPushSubscriptionChangeEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<PushSubscription>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.newSubscription())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPushSubscriptionChangeEvent_newSubscription, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPushSubscriptionChangeEvent>::get<jsPushSubscriptionChangeEvent_newSubscriptionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPushSubscriptionChangeEvent_oldSubscriptionGetter(JSGlobalObject& lexicalGlobalObject, JSPushSubscriptionChangeEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<PushSubscription>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.oldSubscription())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPushSubscriptionChangeEvent_oldSubscription, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPushSubscriptionChangeEvent>::get<jsPushSubscriptionChangeEvent_oldSubscriptionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSPushSubscriptionChangeEvent::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSPushSubscriptionChangeEvent, UseCustomHeapCellType::No>(vm, "JSPushSubscriptionChangeEvent"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForPushSubscriptionChangeEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForPushSubscriptionChangeEvent = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForPushSubscriptionChangeEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForPushSubscriptionChangeEvent = std::forward<decltype(space)>(space); }
    );
}

void JSPushSubscriptionChangeEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSPushSubscriptionChangeEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7PushSubscriptionChangeEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore27PushSubscriptionChangeEventE[]; }
#endif
template<std::same_as<PushSubscriptionChangeEvent> T>
static inline void verifyVTable(PushSubscriptionChangeEvent* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7PushSubscriptionChangeEvent@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore27PushSubscriptionChangeEventE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // PushSubscriptionChangeEvent has subclasses. If PushSubscriptionChangeEvent has subclasses that get passed
        // to toJS() we currently require PushSubscriptionChangeEvent you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<PushSubscriptionChangeEvent>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<PushSubscriptionChangeEvent>(impl.ptr());
#endif
    return createWrapper<PushSubscriptionChangeEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, PushSubscriptionChangeEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

PushSubscriptionChangeEvent* JSPushSubscriptionChangeEvent::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSPushSubscriptionChangeEvent*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
