/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGPreserveAspectRatio.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsSVGPreserveAspectRatioConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGPreserveAspectRatio_align);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGPreserveAspectRatio_align);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGPreserveAspectRatio_meetOrSlice);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGPreserveAspectRatio_meetOrSlice);

class JSSVGPreserveAspectRatioPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGPreserveAspectRatioPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGPreserveAspectRatioPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGPreserveAspectRatioPrototype>(vm)) JSSVGPreserveAspectRatioPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGPreserveAspectRatioPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGPreserveAspectRatioPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGPreserveAspectRatioPrototype, JSSVGPreserveAspectRatioPrototype::Base);

using JSSVGPreserveAspectRatioDOMConstructor = JSDOMConstructorNotConstructable<JSSVGPreserveAspectRatio>;

/* Hash table for constructor */

static const std::array<HashTableValue, 14> JSSVGPreserveAspectRatioConstructorTableValues {
    HashTableValue { "SVG_PRESERVEASPECTRATIO_UNKNOWN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
    HashTableValue { "SVG_PRESERVEASPECTRATIO_NONE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    HashTableValue { "SVG_PRESERVEASPECTRATIO_XMINYMIN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
    HashTableValue { "SVG_PRESERVEASPECTRATIO_XMIDYMIN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 3 } },
    HashTableValue { "SVG_PRESERVEASPECTRATIO_XMAXYMIN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 4 } },
    HashTableValue { "SVG_PRESERVEASPECTRATIO_XMINYMID"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 5 } },
    HashTableValue { "SVG_PRESERVEASPECTRATIO_XMIDYMID"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 6 } },
    HashTableValue { "SVG_PRESERVEASPECTRATIO_XMAXYMID"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 7 } },
    HashTableValue { "SVG_PRESERVEASPECTRATIO_XMINYMAX"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 8 } },
    HashTableValue { "SVG_PRESERVEASPECTRATIO_XMIDYMAX"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 9 } },
    HashTableValue { "SVG_PRESERVEASPECTRATIO_XMAXYMAX"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 10 } },
    HashTableValue { "SVG_MEETORSLICE_UNKNOWN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
    HashTableValue { "SVG_MEETORSLICE_MEET"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    HashTableValue { "SVG_MEETORSLICE_SLICE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
};

static_assert(SVGPreserveAspectRatioValue::SVG_PRESERVEASPECTRATIO_UNKNOWN == 0, "SVG_PRESERVEASPECTRATIO_UNKNOWN in SVGPreserveAspectRatioValue does not match value from IDL");
static_assert(SVGPreserveAspectRatioValue::SVG_PRESERVEASPECTRATIO_NONE == 1, "SVG_PRESERVEASPECTRATIO_NONE in SVGPreserveAspectRatioValue does not match value from IDL");
static_assert(SVGPreserveAspectRatioValue::SVG_PRESERVEASPECTRATIO_XMINYMIN == 2, "SVG_PRESERVEASPECTRATIO_XMINYMIN in SVGPreserveAspectRatioValue does not match value from IDL");
static_assert(SVGPreserveAspectRatioValue::SVG_PRESERVEASPECTRATIO_XMIDYMIN == 3, "SVG_PRESERVEASPECTRATIO_XMIDYMIN in SVGPreserveAspectRatioValue does not match value from IDL");
static_assert(SVGPreserveAspectRatioValue::SVG_PRESERVEASPECTRATIO_XMAXYMIN == 4, "SVG_PRESERVEASPECTRATIO_XMAXYMIN in SVGPreserveAspectRatioValue does not match value from IDL");
static_assert(SVGPreserveAspectRatioValue::SVG_PRESERVEASPECTRATIO_XMINYMID == 5, "SVG_PRESERVEASPECTRATIO_XMINYMID in SVGPreserveAspectRatioValue does not match value from IDL");
static_assert(SVGPreserveAspectRatioValue::SVG_PRESERVEASPECTRATIO_XMIDYMID == 6, "SVG_PRESERVEASPECTRATIO_XMIDYMID in SVGPreserveAspectRatioValue does not match value from IDL");
static_assert(SVGPreserveAspectRatioValue::SVG_PRESERVEASPECTRATIO_XMAXYMID == 7, "SVG_PRESERVEASPECTRATIO_XMAXYMID in SVGPreserveAspectRatioValue does not match value from IDL");
static_assert(SVGPreserveAspectRatioValue::SVG_PRESERVEASPECTRATIO_XMINYMAX == 8, "SVG_PRESERVEASPECTRATIO_XMINYMAX in SVGPreserveAspectRatioValue does not match value from IDL");
static_assert(SVGPreserveAspectRatioValue::SVG_PRESERVEASPECTRATIO_XMIDYMAX == 9, "SVG_PRESERVEASPECTRATIO_XMIDYMAX in SVGPreserveAspectRatioValue does not match value from IDL");
static_assert(SVGPreserveAspectRatioValue::SVG_PRESERVEASPECTRATIO_XMAXYMAX == 10, "SVG_PRESERVEASPECTRATIO_XMAXYMAX in SVGPreserveAspectRatioValue does not match value from IDL");
static_assert(SVGPreserveAspectRatioValue::SVG_MEETORSLICE_UNKNOWN == 0, "SVG_MEETORSLICE_UNKNOWN in SVGPreserveAspectRatioValue does not match value from IDL");
static_assert(SVGPreserveAspectRatioValue::SVG_MEETORSLICE_MEET == 1, "SVG_MEETORSLICE_MEET in SVGPreserveAspectRatioValue does not match value from IDL");
static_assert(SVGPreserveAspectRatioValue::SVG_MEETORSLICE_SLICE == 2, "SVG_MEETORSLICE_SLICE in SVGPreserveAspectRatioValue does not match value from IDL");

template<> const ClassInfo JSSVGPreserveAspectRatioDOMConstructor::s_info = { "SVGPreserveAspectRatio"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGPreserveAspectRatioDOMConstructor) };

template<> JSValue JSSVGPreserveAspectRatioDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSSVGPreserveAspectRatioDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "SVGPreserveAspectRatio"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSSVGPreserveAspectRatio::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSSVGPreserveAspectRatio::info(), JSSVGPreserveAspectRatioConstructorTableValues, *this);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 17> JSSVGPreserveAspectRatioPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGPreserveAspectRatioConstructor, 0 } },
    HashTableValue { "align"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGPreserveAspectRatio_align, setJSSVGPreserveAspectRatio_align } },
    HashTableValue { "meetOrSlice"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGPreserveAspectRatio_meetOrSlice, setJSSVGPreserveAspectRatio_meetOrSlice } },
    HashTableValue { "SVG_PRESERVEASPECTRATIO_UNKNOWN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
    HashTableValue { "SVG_PRESERVEASPECTRATIO_NONE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    HashTableValue { "SVG_PRESERVEASPECTRATIO_XMINYMIN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
    HashTableValue { "SVG_PRESERVEASPECTRATIO_XMIDYMIN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 3 } },
    HashTableValue { "SVG_PRESERVEASPECTRATIO_XMAXYMIN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 4 } },
    HashTableValue { "SVG_PRESERVEASPECTRATIO_XMINYMID"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 5 } },
    HashTableValue { "SVG_PRESERVEASPECTRATIO_XMIDYMID"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 6 } },
    HashTableValue { "SVG_PRESERVEASPECTRATIO_XMAXYMID"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 7 } },
    HashTableValue { "SVG_PRESERVEASPECTRATIO_XMINYMAX"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 8 } },
    HashTableValue { "SVG_PRESERVEASPECTRATIO_XMIDYMAX"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 9 } },
    HashTableValue { "SVG_PRESERVEASPECTRATIO_XMAXYMAX"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 10 } },
    HashTableValue { "SVG_MEETORSLICE_UNKNOWN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
    HashTableValue { "SVG_MEETORSLICE_MEET"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    HashTableValue { "SVG_MEETORSLICE_SLICE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
};

const ClassInfo JSSVGPreserveAspectRatioPrototype::s_info = { "SVGPreserveAspectRatio"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGPreserveAspectRatioPrototype) };

void JSSVGPreserveAspectRatioPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGPreserveAspectRatio::info(), JSSVGPreserveAspectRatioPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSSVGPreserveAspectRatio::s_info = { "SVGPreserveAspectRatio"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGPreserveAspectRatio) };

JSSVGPreserveAspectRatio::JSSVGPreserveAspectRatio(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGPreserveAspectRatio>&& impl)
    : JSDOMWrapper<SVGPreserveAspectRatio>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, SVGPreserveAspectRatio>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSSVGPreserveAspectRatio::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSSVGPreserveAspectRatioPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSSVGPreserveAspectRatioPrototype::create(vm, &globalObject, structure);
}

JSObject* JSSVGPreserveAspectRatio::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGPreserveAspectRatio>(vm, globalObject);
}

JSValue JSSVGPreserveAspectRatio::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGPreserveAspectRatioDOMConstructor, DOMConstructorID::SVGPreserveAspectRatio>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSSVGPreserveAspectRatio::destroy(JSC::JSCell* cell)
{
    JSSVGPreserveAspectRatio* thisObject = static_cast<JSSVGPreserveAspectRatio*>(cell);
    thisObject->JSSVGPreserveAspectRatio::~JSSVGPreserveAspectRatio();
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGPreserveAspectRatioConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGPreserveAspectRatioPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGPreserveAspectRatio::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsSVGPreserveAspectRatio_alignGetter(JSGlobalObject& lexicalGlobalObject, JSSVGPreserveAspectRatio& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.align())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGPreserveAspectRatio_align, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGPreserveAspectRatio>::get<jsSVGPreserveAspectRatio_alignGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGPreserveAspectRatio_alignSetter(JSGlobalObject& lexicalGlobalObject, JSSVGPreserveAspectRatio& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnsignedShort>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAlign(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGPreserveAspectRatio_align, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGPreserveAspectRatio>::set<setJSSVGPreserveAspectRatio_alignSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGPreserveAspectRatio_meetOrSliceGetter(JSGlobalObject& lexicalGlobalObject, JSSVGPreserveAspectRatio& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.meetOrSlice())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGPreserveAspectRatio_meetOrSlice, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGPreserveAspectRatio>::get<jsSVGPreserveAspectRatio_meetOrSliceGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGPreserveAspectRatio_meetOrSliceSetter(JSGlobalObject& lexicalGlobalObject, JSSVGPreserveAspectRatio& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnsignedShort>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMeetOrSlice(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGPreserveAspectRatio_meetOrSlice, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGPreserveAspectRatio>::set<setJSSVGPreserveAspectRatio_meetOrSliceSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSSVGPreserveAspectRatio::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSSVGPreserveAspectRatio, UseCustomHeapCellType::No>(vm, "JSSVGPreserveAspectRatio"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForSVGPreserveAspectRatio.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForSVGPreserveAspectRatio = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForSVGPreserveAspectRatio.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForSVGPreserveAspectRatio = std::forward<decltype(space)>(space); }
    );
}

void JSSVGPreserveAspectRatio::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGPreserveAspectRatio*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSSVGPreserveAspectRatioOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSSVGPreserveAspectRatioOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSVGPreserveAspectRatio = static_cast<JSSVGPreserveAspectRatio*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSVGPreserveAspectRatio->protectedWrapped().ptr(), jsSVGPreserveAspectRatio);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7SVGPreserveAspectRatio@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore22SVGPreserveAspectRatioE[]; }
#endif
template<std::same_as<SVGPreserveAspectRatio> T>
static inline void verifyVTable(SVGPreserveAspectRatio* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7SVGPreserveAspectRatio@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore22SVGPreserveAspectRatioE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // SVGPreserveAspectRatio has subclasses. If SVGPreserveAspectRatio has subclasses that get passed
        // to toJS() we currently require SVGPreserveAspectRatio you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<SVGPreserveAspectRatio>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<SVGPreserveAspectRatio>(impl.ptr());
#endif
    return createWrapper<SVGPreserveAspectRatio>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, SVGPreserveAspectRatio& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

SVGPreserveAspectRatio* JSSVGPreserveAspectRatio::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSVGPreserveAspectRatio*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
