/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_CODECS)

#include "JSWebCodecsVideoEncoder.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "DOMPromiseProxy.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "JSWebCodecsCodecState.h"
#include "JSWebCodecsEncodedVideoChunkOutputCallback.h"
#include "JSWebCodecsErrorCallback.h"
#include "JSWebCodecsVideoEncoderConfig.h"
#include "JSWebCodecsVideoEncoderEncodeOptions.h"
#include "JSWebCodecsVideoEncoderSupport.h"
#include "JSWebCodecsVideoFrame.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_CODECS)

template<> ConversionResult<IDLDictionary<WebCodecsVideoEncoder::Init>> convertDictionary<WebCodecsVideoEncoder::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    WebCodecsVideoEncoder::Init result;
    JSValue errorValue;
    if (isNullOrUndefined)
        errorValue = jsUndefined();
    else {
        errorValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "error"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (errorValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "error"_s, "WebCodecsVideoEncoderInit"_s, "WebCodecsErrorCallback"_s);
        return ConversionResultException { };
    }
    auto errorConversionResult = convert<IDLCallbackFunction<JSWebCodecsErrorCallback>>(lexicalGlobalObject, errorValue, *jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject));
    if (errorConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.error = errorConversionResult.releaseReturnValue();
    JSValue outputValue;
    if (isNullOrUndefined)
        outputValue = jsUndefined();
    else {
        outputValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "output"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (outputValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "output"_s, "WebCodecsVideoEncoderInit"_s, "WebCodecsEncodedVideoChunkOutputCallback"_s);
        return ConversionResultException { };
    }
    auto outputConversionResult = convert<IDLCallbackFunction<JSWebCodecsEncodedVideoChunkOutputCallback>>(lexicalGlobalObject, outputValue, *jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject));
    if (outputConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.output = outputConversionResult.releaseReturnValue();
    return result;
}

#endif

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsWebCodecsVideoEncoderPrototypeFunction_configure);
static JSC_DECLARE_HOST_FUNCTION(jsWebCodecsVideoEncoderPrototypeFunction_encode);
static JSC_DECLARE_HOST_FUNCTION(jsWebCodecsVideoEncoderPrototypeFunction_flush);
static JSC_DECLARE_HOST_FUNCTION(jsWebCodecsVideoEncoderPrototypeFunction_reset);
static JSC_DECLARE_HOST_FUNCTION(jsWebCodecsVideoEncoderPrototypeFunction_close);
static JSC_DECLARE_HOST_FUNCTION(jsWebCodecsVideoEncoderConstructorFunction_isConfigSupported);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsWebCodecsVideoEncoderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWebCodecsVideoEncoder_state);
static JSC_DECLARE_CUSTOM_GETTER(jsWebCodecsVideoEncoder_encodeQueueSize);
static JSC_DECLARE_CUSTOM_GETTER(jsWebCodecsVideoEncoder_ondequeue);
static JSC_DECLARE_CUSTOM_SETTER(setJSWebCodecsVideoEncoder_ondequeue);

class JSWebCodecsVideoEncoderPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebCodecsVideoEncoderPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebCodecsVideoEncoderPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebCodecsVideoEncoderPrototype>(vm)) JSWebCodecsVideoEncoderPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebCodecsVideoEncoderPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebCodecsVideoEncoderPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebCodecsVideoEncoderPrototype, JSWebCodecsVideoEncoderPrototype::Base);

using JSWebCodecsVideoEncoderDOMConstructor = JSDOMConstructor<JSWebCodecsVideoEncoder>;

/* Hash table for constructor */

static const std::array<HashTableValue, 1> JSWebCodecsVideoEncoderConstructorTableValues {
    HashTableValue { "isConfigSupported"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebCodecsVideoEncoderConstructorFunction_isConfigSupported, 1 } },
};

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSWebCodecsVideoEncoderDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSWebCodecsVideoEncoderDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = castedThis->scriptExecutionContext();
    if (!context) [[unlikely]]
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "VideoEncoder"_s);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto initConversionResult = convert<IDLDictionary<WebCodecsVideoEncoder::Init>>(*lexicalGlobalObject, argument0.value());
    if (initConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto object = WebCodecsVideoEncoder::create(*context, initConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<WebCodecsVideoEncoder>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<WebCodecsVideoEncoder>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSWebCodecsVideoEncoderDOMConstructorConstruct, JSWebCodecsVideoEncoderDOMConstructor::construct);

template<> const ClassInfo JSWebCodecsVideoEncoderDOMConstructor::s_info = { "VideoEncoder"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebCodecsVideoEncoderDOMConstructor) };

template<> JSValue JSWebCodecsVideoEncoderDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSWebCodecsVideoEncoderDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "VideoEncoder"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSWebCodecsVideoEncoder::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSWebCodecsVideoEncoder::info(), JSWebCodecsVideoEncoderConstructorTableValues, *this);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 9> JSWebCodecsVideoEncoderPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWebCodecsVideoEncoderConstructor, 0 } },
    HashTableValue { "state"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebCodecsVideoEncoder_state, 0 } },
    HashTableValue { "encodeQueueSize"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebCodecsVideoEncoder_encodeQueueSize, 0 } },
    HashTableValue { "ondequeue"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebCodecsVideoEncoder_ondequeue, setJSWebCodecsVideoEncoder_ondequeue } },
    HashTableValue { "configure"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebCodecsVideoEncoderPrototypeFunction_configure, 1 } },
    HashTableValue { "encode"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebCodecsVideoEncoderPrototypeFunction_encode, 1 } },
    HashTableValue { "flush"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebCodecsVideoEncoderPrototypeFunction_flush, 0 } },
    HashTableValue { "reset"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebCodecsVideoEncoderPrototypeFunction_reset, 0 } },
    HashTableValue { "close"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebCodecsVideoEncoderPrototypeFunction_close, 0 } },
};

const ClassInfo JSWebCodecsVideoEncoderPrototype::s_info = { "VideoEncoder"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebCodecsVideoEncoderPrototype) };

void JSWebCodecsVideoEncoderPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebCodecsVideoEncoder::info(), JSWebCodecsVideoEncoderPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebCodecsVideoEncoder::s_info = { "VideoEncoder"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebCodecsVideoEncoder) };

JSWebCodecsVideoEncoder::JSWebCodecsVideoEncoder(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebCodecsVideoEncoder>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

Ref<WebCodecsVideoEncoder> JSWebCodecsVideoEncoder::protectedWrapped() const
{
    return wrapped();
}

static_assert(std::is_base_of<ActiveDOMObject, WebCodecsVideoEncoder>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSWebCodecsVideoEncoder::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebCodecsVideoEncoderPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSWebCodecsVideoEncoderPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebCodecsVideoEncoder::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebCodecsVideoEncoder>(vm, globalObject);
}

JSValue JSWebCodecsVideoEncoder::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebCodecsVideoEncoderDOMConstructor, DOMConstructorID::WebCodecsVideoEncoder>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebCodecsVideoEncoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebCodecsVideoEncoderPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebCodecsVideoEncoder::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsWebCodecsVideoEncoder_stateGetter(JSGlobalObject& lexicalGlobalObject, JSWebCodecsVideoEncoder& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<WebCodecsCodecState>>(lexicalGlobalObject, throwScope, impl.state())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebCodecsVideoEncoder_state, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebCodecsVideoEncoder>::get<jsWebCodecsVideoEncoder_stateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebCodecsVideoEncoder_encodeQueueSizeGetter(JSGlobalObject& lexicalGlobalObject, JSWebCodecsVideoEncoder& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.encodeQueueSize())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebCodecsVideoEncoder_encodeQueueSize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebCodecsVideoEncoder>::get<jsWebCodecsVideoEncoder_encodeQueueSizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebCodecsVideoEncoder_ondequeueGetter(JSGlobalObject& lexicalGlobalObject, JSWebCodecsVideoEncoder& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().dequeueEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebCodecsVideoEncoder_ondequeue, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebCodecsVideoEncoder>::get<jsWebCodecsVideoEncoder_ondequeueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSWebCodecsVideoEncoder_ondequeueSetter(JSGlobalObject& lexicalGlobalObject, JSWebCodecsVideoEncoder& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().dequeueEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSWebCodecsVideoEncoder_ondequeue, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebCodecsVideoEncoder>::set<setJSWebCodecsVideoEncoder_ondequeueSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsWebCodecsVideoEncoderPrototypeFunction_configureBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebCodecsVideoEncoder>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (!context) [[unlikely]]
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto configConversionResult = convert<IDLDictionary<WebCodecsVideoEncoderConfig>>(*lexicalGlobalObject, argument0.value());
    if (configConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.configure(*context, configConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebCodecsVideoEncoderPrototypeFunction_configure, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebCodecsVideoEncoder>::call<jsWebCodecsVideoEncoderPrototypeFunction_configureBody>(*lexicalGlobalObject, *callFrame, "configure");
}

static inline JSC::EncodedJSValue jsWebCodecsVideoEncoderPrototypeFunction_encodeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebCodecsVideoEncoder>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto frameConversionResult = convert<IDLInterface<WebCodecsVideoFrame>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "frame"_s, "VideoEncoder"_s, "encode"_s, "WebCodecsVideoFrame"_s); });
    if (frameConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto optionsConversionResult = convert<IDLDictionary<WebCodecsVideoEncoderEncodeOptions>>(*lexicalGlobalObject, argument1.value());
    if (optionsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.encode(*frameConversionResult.releaseReturnValue(), optionsConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebCodecsVideoEncoderPrototypeFunction_encode, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebCodecsVideoEncoder>::call<jsWebCodecsVideoEncoderPrototypeFunction_encodeBody>(*lexicalGlobalObject, *callFrame, "encode");
}

static inline JSC::EncodedJSValue jsWebCodecsVideoEncoderPrototypeFunction_flushBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSWebCodecsVideoEncoder>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.flush(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebCodecsVideoEncoderPrototypeFunction_flush, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSWebCodecsVideoEncoder>::call<jsWebCodecsVideoEncoderPrototypeFunction_flushBody>(*lexicalGlobalObject, *callFrame, "flush");
}

static inline JSC::EncodedJSValue jsWebCodecsVideoEncoderPrototypeFunction_resetBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebCodecsVideoEncoder>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.reset(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebCodecsVideoEncoderPrototypeFunction_reset, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebCodecsVideoEncoder>::call<jsWebCodecsVideoEncoderPrototypeFunction_resetBody>(*lexicalGlobalObject, *callFrame, "reset");
}

static inline JSC::EncodedJSValue jsWebCodecsVideoEncoderPrototypeFunction_closeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebCodecsVideoEncoder>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.close(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebCodecsVideoEncoderPrototypeFunction_close, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebCodecsVideoEncoder>::call<jsWebCodecsVideoEncoderPrototypeFunction_closeBody>(*lexicalGlobalObject, *callFrame, "close");
}

static inline JSC::EncodedJSValue jsWebCodecsVideoEncoderConstructorFunction_isConfigSupportedBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (!context) [[unlikely]]
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto configConversionResult = convert<IDLDictionary<WebCodecsVideoEncoderConfig>>(*lexicalGlobalObject, argument0.value());
    if (configConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLDictionary<WebCodecsVideoEncoderSupport>>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, [&]() -> decltype(auto) { return WebCodecsVideoEncoder::isConfigSupported(*context, configConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebCodecsVideoEncoderConstructorFunction_isConfigSupported, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSWebCodecsVideoEncoder>::callStatic<jsWebCodecsVideoEncoderConstructorFunction_isConfigSupportedBody>(*lexicalGlobalObject, *callFrame, "isConfigSupported");
}

JSC::GCClient::IsoSubspace* JSWebCodecsVideoEncoder::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebCodecsVideoEncoder, UseCustomHeapCellType::No>(vm, "JSWebCodecsVideoEncoder"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebCodecsVideoEncoder.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebCodecsVideoEncoder = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebCodecsVideoEncoder.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebCodecsVideoEncoder = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSWebCodecsVideoEncoder::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSWebCodecsVideoEncoder*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

DEFINE_VISIT_CHILDREN(JSWebCodecsVideoEncoder);

template<typename Visitor>
void JSWebCodecsVideoEncoder::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSWebCodecsVideoEncoder*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSWebCodecsVideoEncoder::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSWebCodecsVideoEncoder::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSWebCodecsVideoEncoder::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebCodecsVideoEncoder*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebCodecsVideoEncoderOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsWebCodecsVideoEncoder = jsCast<JSWebCodecsVideoEncoder*>(handle.slot()->asCell());
    SUPPRESS_UNCOUNTED_LOCAL auto& wrapped = jsWebCodecsVideoEncoder->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (reason) [[unlikely]]
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSWebCodecsVideoEncoderOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebCodecsVideoEncoder = static_cast<JSWebCodecsVideoEncoder*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWebCodecsVideoEncoder->protectedWrapped().ptr(), jsWebCodecsVideoEncoder);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebCodecsVideoEncoder@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore21WebCodecsVideoEncoderE[]; }
#endif
template<std::same_as<WebCodecsVideoEncoder> T>
static inline void verifyVTable(WebCodecsVideoEncoder* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebCodecsVideoEncoder@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore21WebCodecsVideoEncoderE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebCodecsVideoEncoder has subclasses. If WebCodecsVideoEncoder has subclasses that get passed
        // to toJS() we currently require WebCodecsVideoEncoder you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebCodecsVideoEncoder>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<WebCodecsVideoEncoder>(impl.ptr());
#endif
    return createWrapper<WebCodecsVideoEncoder>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebCodecsVideoEncoder& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebCodecsVideoEncoder* JSWebCodecsVideoEncoder::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebCodecsVideoEncoder*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_CODECS)
