/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(USER_MESSAGE_HANDLERS)

#include "JSWebKitNamespace.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "DOMWrapperWorld.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSNode.h"
#include "JSUserMessageHandlersNamespace.h"
#include "JSWebKitNodeInfo.h"
#include "JSWebKitSerializedNode.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<WebKitNamespace::SerializedNodeInit>> convertDictionary<WebKitNamespace::SerializedNodeInit>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    WebKitNamespace::SerializedNodeInit result;
    JSValue deepValue;
    if (isNullOrUndefined)
        deepValue = jsUndefined();
    else {
        deepValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "deep"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!deepValue.isUndefined()) {
        auto deepConversionResult = convert<IDLBoolean>(lexicalGlobalObject, deepValue);
        if (deepConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.deep = deepConversionResult.releaseReturnValue();
    }
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsWebKitNamespacePrototypeFunction_createNodeInfo);
static JSC_DECLARE_HOST_FUNCTION(jsWebKitNamespacePrototypeFunction_serializeNode);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsWebKitNamespaceConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWebKitNamespace_messageHandlers);

class JSWebKitNamespacePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebKitNamespacePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebKitNamespacePrototype* ptr = new (NotNull, JSC::allocateCell<JSWebKitNamespacePrototype>(vm)) JSWebKitNamespacePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebKitNamespacePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebKitNamespacePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebKitNamespacePrototype, JSWebKitNamespacePrototype::Base);

using JSWebKitNamespaceDOMConstructor = JSDOMConstructorNotConstructable<JSWebKitNamespace>;

template<> const ClassInfo JSWebKitNamespaceDOMConstructor::s_info = { "WebKitNamespace"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebKitNamespaceDOMConstructor) };

template<> JSValue JSWebKitNamespaceDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebKitNamespaceDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "WebKitNamespace"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSWebKitNamespace::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 4> JSWebKitNamespacePrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWebKitNamespaceConstructor, 0 } },
    HashTableValue { "messageHandlers"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebKitNamespace_messageHandlers, 0 } },
    HashTableValue { "createNodeInfo"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebKitNamespacePrototypeFunction_createNodeInfo, 1 } },
    HashTableValue { "serializeNode"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebKitNamespacePrototypeFunction_serializeNode, 1 } },
};

const ClassInfo JSWebKitNamespacePrototype::s_info = { "WebKitNamespace"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebKitNamespacePrototype) };

void JSWebKitNamespacePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebKitNamespace::info(), JSWebKitNamespacePrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!worldForDOMObject(*this).nodeInfoEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "createNodeInfo"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!worldForDOMObject(*this).nodeInfoEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "serializeNode"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebKitNamespace::s_info = { "WebKitNamespace"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebKitNamespace) };

JSWebKitNamespace::JSWebKitNamespace(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebKitNamespace>&& impl)
    : JSDOMWrapper<WebKitNamespace>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, WebKitNamespace>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSWebKitNamespace::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebKitNamespacePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSWebKitNamespacePrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebKitNamespace::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebKitNamespace>(vm, globalObject);
}

JSValue JSWebKitNamespace::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebKitNamespaceDOMConstructor, DOMConstructorID::WebKitNamespace>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSWebKitNamespace::destroy(JSC::JSCell* cell)
{
    JSWebKitNamespace* thisObject = static_cast<JSWebKitNamespace*>(cell);
    thisObject->JSWebKitNamespace::~JSWebKitNamespace();
}

JSC_DEFINE_CUSTOM_GETTER(jsWebKitNamespaceConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebKitNamespacePrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebKitNamespace::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsWebKitNamespace_messageHandlersGetter(JSGlobalObject& lexicalGlobalObject, JSWebKitNamespace& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<UserMessageHandlersNamespace>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.messageHandlers())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebKitNamespace_messageHandlers, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebKitNamespace>::get<jsWebKitNamespace_messageHandlersGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsWebKitNamespacePrototypeFunction_createNodeInfoBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebKitNamespace>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto nodeConversionResult = convert<IDLInterface<Node>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node"_s, "WebKitNamespace"_s, "createNodeInfo"_s, "Node"_s); });
    if (nodeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<WebKitNodeInfo>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createNodeInfo(*nodeConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsWebKitNamespacePrototypeFunction_createNodeInfo, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebKitNamespace>::call<jsWebKitNamespacePrototypeFunction_createNodeInfoBody>(*lexicalGlobalObject, *callFrame, "createNodeInfo");
}

static inline JSC::EncodedJSValue jsWebKitNamespacePrototypeFunction_serializeNodeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebKitNamespace>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto nodeConversionResult = convert<IDLInterface<Node>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node"_s, "WebKitNamespace"_s, "serializeNode"_s, "Node"_s); });
    if (nodeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto initConversionResult = convert<IDLDictionary<WebKitNamespace::SerializedNodeInit>>(*lexicalGlobalObject, argument1.value());
    if (initConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<WebKitSerializedNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.serializeNode(*nodeConversionResult.releaseReturnValue(), initConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsWebKitNamespacePrototypeFunction_serializeNode, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebKitNamespace>::call<jsWebKitNamespacePrototypeFunction_serializeNodeBody>(*lexicalGlobalObject, *callFrame, "serializeNode");
}

JSC::GCClient::IsoSubspace* JSWebKitNamespace::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebKitNamespace, UseCustomHeapCellType::No>(vm, "JSWebKitNamespace"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebKitNamespace.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebKitNamespace = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebKitNamespace.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebKitNamespace = std::forward<decltype(space)>(space); }
    );
}

void JSWebKitNamespace::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebKitNamespace*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebKitNamespaceOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSWebKitNamespaceOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebKitNamespace = static_cast<JSWebKitNamespace*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWebKitNamespace->protectedWrapped().ptr(), jsWebKitNamespace);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebKitNamespace@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore15WebKitNamespaceE[]; }
#endif
template<std::same_as<WebKitNamespace> T>
static inline void verifyVTable(WebKitNamespace* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebKitNamespace@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore15WebKitNamespaceE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebKitNamespace has subclasses. If WebKitNamespace has subclasses that get passed
        // to toJS() we currently require WebKitNamespace you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebKitNamespace>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<WebKitNamespace>(impl.ptr());
#endif
    return createWrapper<WebKitNamespace>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebKitNamespace& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebKitNamespace* JSWebKitNamespace::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebKitNamespace*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(USER_MESSAGE_HANDLERS)
