/* PlayerRow.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from PlayerRow.vala, do not modify */

/*
* SPDX-License-Identifier: GPL-2.0-or-later
* SPDX-FileCopyrightText: 2014 Ikey Doherty <ikey.doherty@gmail.com>
*                         2016-2025 elementary, Inc. (https://elementary.io)
*/

#include <glib.h>
#include "sound.h"
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <glib/gstdio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <cairo-gobject.h>
#include <granite.h>
#include <float.h>
#include <math.h>
#include <gio/gdesktopappinfo.h>
#include <pango/pango.h>

#define ICON_SIZE 48
#define SOUND_WIDGETS_PLAYER_ROW_NOT_PLAYING _ ("Not playing")
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SOUND_WIDGETS_PLAYER_ROW_0_PROPERTY,
	SOUND_WIDGETS_PLAYER_ROW_APP_INFO_PROPERTY,
	SOUND_WIDGETS_PLAYER_ROW_CLIENT_PROPERTY,
	SOUND_WIDGETS_PLAYER_ROW_NUM_PROPERTIES
};
static GParamSpec* sound_widgets_player_row_properties[SOUND_WIDGETS_PLAYER_ROW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _SoundWidgetsPlayerRowLoadRemoteArtData SoundWidgetsPlayerRowLoadRemoteArtData;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
enum  {
	SOUND_WIDGETS_PLAYER_ROW_CLOSE_SIGNAL,
	SOUND_WIDGETS_PLAYER_ROW_NUM_SIGNALS
};
static guint sound_widgets_player_row_signals[SOUND_WIDGETS_PLAYER_ROW_NUM_SIGNALS] = {0};

struct _SoundWidgetsPlayerRowPrivate {
	GtkImage* background;
	GtkImage* mask;
	GtkLabel* title_label;
	GtkLabel* artist_label;
	GtkButton* prev_btn;
	GtkButton* play_btn;
	GtkButton* next_btn;
	GIcon* app_icon;
	GCancellable* load_remote_art_cancel;
	gboolean launched_by_indicator;
	gchar* app_name;
	gchar* last_art_url;
	GAppInfo* ainfo;
	SoundServicesMprisClient* client_;
	SoundServicesMediaPlayer* mp_client;
};

struct _SoundWidgetsPlayerRowLoadRemoteArtData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SoundWidgetsPlayerRow* self;
	gchar* uri;
	GFile* file;
	GFile* _tmp0_;
	GFileInputStream* stream;
	GFile* _tmp1_;
	GCancellable* _tmp2_;
	GFileInputStream* _tmp3_;
	GdkPixbuf* pixbuf;
	GFileInputStream* _tmp4_;
	GCancellable* _tmp5_;
	GdkPixbuf* _tmp6_;
	GdkPixbuf* _tmp7_;
	GtkImage* _tmp8_;
	GdkPixbuf* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GdkPixbuf* _tmp12_;
	GdkPixbuf* _tmp13_;
	GtkImage* _tmp14_;
	GtkStyleContext* _tmp15_;
	GtkImage* _tmp16_;
	GtkImage* _tmp17_;
	GtkImage* _tmp18_;
	GIcon* _tmp19_;
	GtkImage* _tmp20_;
	GtkStyleContext* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	GtkImage* _tmp24_;
	GtkImage* _tmp25_;
	GError* _inner_error0_;
};

static gint SoundWidgetsPlayerRow_private_offset;
static gpointer sound_widgets_player_row_parent_class = NULL;

static void sound_widgets_player_row_update_controls (SoundWidgetsPlayerRow* self);
static void sound_widgets_player_row_update_art (SoundWidgetsPlayerRow* self,
                                          const gchar* uri);
static void sound_widgets_player_row_connect_to_client (SoundWidgetsPlayerRow* self);
static void __lambda17_ (SoundWidgetsPlayerRow* self,
                  const gchar* i,
                  GHashTable* p,
                  gchar** inv,
                  gint inv_length1);
static void ___lambda18_ (SoundWidgetsPlayerRow* self,
                   const gchar* k,
                   GVariant* v);
static gboolean ___lambda19_ (SoundWidgetsPlayerRow* self);
static gboolean ____lambda19__gsource_func (gpointer self);
static gboolean ____lambda20_ (SoundWidgetsPlayerRow* self);
static void sound_widgets_player_row_update_play_status (SoundWidgetsPlayerRow* self);
static gboolean _____lambda20__gsource_func (gpointer self);
static gboolean _____lambda21_ (SoundWidgetsPlayerRow* self);
static gboolean ______lambda21__gsource_func (gpointer self);
static void ____lambda18__gh_func (gconstpointer key,
                            gconstpointer value,
                            gpointer self);
static void ___lambda17__sound_services_dbus_prop_iface_properties_changed (SoundServicesDbusPropIface* _sender,
                                                                     const gchar* iface,
                                                                     GHashTable* changed,
                                                                     gchar** invalid,
                                                                     gint invalid_length1,
                                                                     gpointer self);
static gboolean sound_widgets_player_row_raise_player (SoundWidgetsPlayerRow* self);
static void* _____lambda23_ (SoundWidgetsPlayerRow* self);
static gpointer ______lambda23__gthread_func (gpointer self);
static GdkPixbuf* sound_widgets_player_row_mask_pixbuf (GdkPixbuf* pixbuf,
                                                 gint scale);
static void sound_widgets_player_row_load_remote_art (SoundWidgetsPlayerRow* self,
                                               const gchar* uri,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static void sound_widgets_player_row_load_remote_art_finish (SoundWidgetsPlayerRow* self,
                                                      GAsyncResult* _res_);
static void sound_widgets_player_row_load_remote_art_data_free (gpointer _data);
static gboolean sound_widgets_player_row_load_remote_art_co (SoundWidgetsPlayerRowLoadRemoteArtData* _data_);
static void sound_widgets_player_row_load_remote_art_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
static gboolean _sound_widgets_player_row_client_____lambda22_ (SoundWidgetsPlayerRow* self);
static gboolean __sound_widgets_player_row_client_____lambda22__gsource_func (gpointer self);
static GObject * sound_widgets_player_row_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
static gboolean _sound_widgets_player_row_raise_player_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                               GdkEventButton* event,
                                                                               gpointer self);
static void _sound_widgets_player_row___lambda24_ (SoundWidgetsPlayerRow* self);
static gboolean __lambda25_ (SoundWidgetsPlayerRow* self);
static void* ___lambda26_ (SoundWidgetsPlayerRow* self);
static gpointer ____lambda26__gthread_func (gpointer self);
static gboolean ___lambda25__gsource_func (gpointer self);
static void __sound_widgets_player_row___lambda24__gtk_button_clicked (GtkButton* _sender,
                                                                gpointer self);
static void _sound_widgets_player_row___lambda27_ (SoundWidgetsPlayerRow* self);
static gboolean __lambda28_ (SoundWidgetsPlayerRow* self);
static void* ___lambda29_ (SoundWidgetsPlayerRow* self);
static gpointer ____lambda29__gthread_func (gpointer self);
static gboolean ___lambda28__gsource_func (gpointer self);
static void __sound_widgets_player_row___lambda27__gtk_button_clicked (GtkButton* _sender,
                                                                gpointer self);
static void _sound_widgets_player_row___lambda30_ (SoundWidgetsPlayerRow* self);
static gboolean __lambda31_ (SoundWidgetsPlayerRow* self);
static void* ___lambda32_ (SoundWidgetsPlayerRow* self);
static gpointer ____lambda32__gthread_func (gpointer self);
static gboolean ___lambda31__gsource_func (gpointer self);
static void __sound_widgets_player_row___lambda30__gtk_button_clicked (GtkButton* _sender,
                                                                gpointer self);
static void sound_widgets_player_row_finalize (GObject * obj);
static GType sound_widgets_player_row_get_type_once (void);
static void _vala_sound_widgets_player_row_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_sound_widgets_player_row_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
sound_widgets_player_row_get_instance_private (SoundWidgetsPlayerRow* self)
{
	return G_STRUCT_MEMBER_P (self, SoundWidgetsPlayerRow_private_offset);
}

/**
     * Create a new PlayerRow
     *
     * @param client The underlying MprisClient instance to use
     */
SoundWidgetsPlayerRow*
sound_widgets_player_row_construct (GType object_type,
                                    SoundServicesMprisClient* mpris_client)
{
	SoundWidgetsPlayerRow * self = NULL;
	g_return_val_if_fail (mpris_client != NULL, NULL);
	self = (SoundWidgetsPlayerRow*) g_object_new (object_type, "client", mpris_client, NULL);
	return self;
}

SoundWidgetsPlayerRow*
sound_widgets_player_row_new (SoundServicesMprisClient* mpris_client)
{
	return sound_widgets_player_row_construct (SOUND_WIDGETS_TYPE_PLAYER_ROW, mpris_client);
}

/**
     * Create a new PlayerRow for bluetooth controls
     *
     * @param client The underlying MediaPlayer instance to use
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

SoundWidgetsPlayerRow*
sound_widgets_player_row_construct_bluetooth (GType object_type,
                                              SoundServicesMediaPlayer* media_player_client,
                                              const gchar* name,
                                              const gchar* icon)
{
	SoundWidgetsPlayerRow * self = NULL;
	SoundServicesMediaPlayer* _tmp0_;
	GThemedIcon* _tmp1_;
	GtkImage* _tmp2_;
	GIcon* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	g_return_val_if_fail (media_player_client != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (icon != NULL, NULL);
	self = (SoundWidgetsPlayerRow*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (media_player_client);
	_g_object_unref0 (self->priv->mp_client);
	self->priv->mp_client = _tmp0_;
	_tmp1_ = (GThemedIcon*) g_themed_icon_new (icon);
	_g_object_unref0 (self->priv->app_icon);
	self->priv->app_icon = (GIcon*) _tmp1_;
	_tmp2_ = self->priv->background;
	_tmp3_ = self->priv->app_icon;
	g_object_set (_tmp2_, "gicon", _tmp3_, NULL);
	_tmp4_ = self->priv->title_label;
	gtk_label_set_label (_tmp4_, name);
	_tmp5_ = self->priv->artist_label;
	gtk_label_set_label (_tmp5_, SOUND_WIDGETS_PLAYER_ROW_NOT_PLAYING);
	sound_widgets_player_row_update_controls (self);
	return self;
}

SoundWidgetsPlayerRow*
sound_widgets_player_row_new_bluetooth (SoundServicesMediaPlayer* media_player_client,
                                        const gchar* name,
                                        const gchar* icon)
{
	return sound_widgets_player_row_construct_bluetooth (SOUND_WIDGETS_TYPE_PLAYER_ROW, media_player_client, name, icon);
}

/**
     * Create a new PlayerRow for the default player
     *
     * @param info The AppInfo of the default music player
     */
SoundWidgetsPlayerRow*
sound_widgets_player_row_construct_default (GType object_type,
                                            GAppInfo* info)
{
	SoundWidgetsPlayerRow * self = NULL;
	gchar** title_info = NULL;
	GSettings* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint title_info_length1;
	gint _title_info_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	GtkLabel* _tmp19_;
	const gchar* _tmp20_;
	GtkLabel* _tmp21_;
	g_return_val_if_fail (info != NULL, NULL);
	self = (SoundWidgetsPlayerRow*) g_object_new (object_type, "app-info", info, "client", NULL, NULL);
	_tmp0_ = sound_indicator_settings;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, "last-title-info");
	title_info = _tmp2_;
	title_info_length1 = _vala_array_length (_tmp1_);
	_title_info_size_ = title_info_length1;
	_tmp3_ = title_info;
	_tmp3__length1 = title_info_length1;
	if (_tmp3__length1 == 4) {
		gchar** _tmp4_;
		gint _tmp4__length1;
		const gchar* _tmp5_;
		GAppInfo* _tmp6_;
		GAppInfo* _tmp7_;
		const gchar* _tmp8_;
		_tmp4_ = title_info;
		_tmp4__length1 = title_info_length1;
		_tmp5_ = _tmp4_[0];
		_tmp6_ = sound_widgets_player_row_get_app_info (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_app_info_get_id (_tmp7_);
		if (g_strcmp0 (_tmp5_, _tmp8_) == 0) {
			GtkLabel* _tmp9_;
			gchar** _tmp10_;
			gint _tmp10__length1;
			const gchar* _tmp11_;
			GtkLabel* _tmp12_;
			gchar** _tmp13_;
			gint _tmp13__length1;
			const gchar* _tmp14_;
			gchar** _tmp15_;
			gint _tmp15__length1;
			const gchar* _tmp16_;
			_tmp9_ = self->priv->title_label;
			_tmp10_ = title_info;
			_tmp10__length1 = title_info_length1;
			_tmp11_ = _tmp10_[1];
			gtk_label_set_label (_tmp9_, _tmp11_);
			_tmp12_ = self->priv->artist_label;
			_tmp13_ = title_info;
			_tmp13__length1 = title_info_length1;
			_tmp14_ = _tmp13_[2];
			gtk_label_set_label (_tmp12_, _tmp14_);
			_tmp15_ = title_info;
			_tmp15__length1 = title_info_length1;
			_tmp16_ = _tmp15_[3];
			if (g_strcmp0 (_tmp16_, "") != 0) {
				gchar** _tmp17_;
				gint _tmp17__length1;
				const gchar* _tmp18_;
				_tmp17_ = title_info;
				_tmp17__length1 = title_info_length1;
				_tmp18_ = _tmp17_[3];
				sound_widgets_player_row_update_art (self, _tmp18_);
			}
			title_info = (_vala_array_free (title_info, title_info_length1, (GDestroyNotify) g_free), NULL);
			return self;
		}
	}
	_tmp19_ = self->priv->title_label;
	_tmp20_ = self->priv->app_name;
	gtk_label_set_label (_tmp19_, _tmp20_);
	_tmp21_ = self->priv->artist_label;
	gtk_label_set_label (_tmp21_, SOUND_WIDGETS_PLAYER_ROW_NOT_PLAYING);
	title_info = (_vala_array_free (title_info, title_info_length1, (GDestroyNotify) g_free), NULL);
	return self;
}

SoundWidgetsPlayerRow*
sound_widgets_player_row_new_default (GAppInfo* info)
{
	return sound_widgets_player_row_construct_default (SOUND_WIDGETS_TYPE_PLAYER_ROW, info);
}

static gboolean
___lambda19_ (SoundWidgetsPlayerRow* self)
{
	gboolean result;
	sound_widgets_player_row_update_from_meta (self);
	result = FALSE;
	return result;
}

static gboolean
____lambda19__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda19_ ((SoundWidgetsPlayerRow*) self);
	return result;
}

static gboolean
____lambda20_ (SoundWidgetsPlayerRow* self)
{
	gboolean result;
	sound_widgets_player_row_update_play_status (self);
	result = FALSE;
	return result;
}

static gboolean
_____lambda20__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda20_ ((SoundWidgetsPlayerRow*) self);
	return result;
}

static gboolean
_____lambda21_ (SoundWidgetsPlayerRow* self)
{
	gboolean result;
	sound_widgets_player_row_update_controls (self);
	result = FALSE;
	return result;
}

static gboolean
______lambda21__gsource_func (gpointer self)
{
	gboolean result;
	result = _____lambda21_ ((SoundWidgetsPlayerRow*) self);
	return result;
}

static void
___lambda18_ (SoundWidgetsPlayerRow* self,
              const gchar* k,
              GVariant* v)
{
	g_return_if_fail (k != NULL);
	g_return_if_fail (v != NULL);
	if (g_strcmp0 (k, "Metadata") == 0) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda19__gsource_func, g_object_ref (self), g_object_unref);
	} else {
		if (g_strcmp0 (k, "PlaybackStatus") == 0) {
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _____lambda20__gsource_func, g_object_ref (self), g_object_unref);
		} else {
			gboolean _tmp0_ = FALSE;
			if (g_strcmp0 (k, "CanGoNext") == 0) {
				_tmp0_ = TRUE;
			} else {
				_tmp0_ = g_strcmp0 (k, "CanGoPrevious") == 0;
			}
			if (_tmp0_) {
				g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ______lambda21__gsource_func, g_object_ref (self), g_object_unref);
			}
		}
	}
}

static void
____lambda18__gh_func (gconstpointer key,
                       gconstpointer value,
                       gpointer self)
{
	___lambda18_ ((SoundWidgetsPlayerRow*) self, (const gchar*) key, (GVariant*) value);
}

static void
__lambda17_ (SoundWidgetsPlayerRow* self,
             const gchar* i,
             GHashTable* p,
             gchar** inv,
             gint inv_length1)
{
	g_return_if_fail (i != NULL);
	g_return_if_fail (p != NULL);
	if (g_strcmp0 (i, "org.mpris.MediaPlayer2.Player") == 0) {
		g_hash_table_foreach (p, ____lambda18__gh_func, self);
	}
}

static void
___lambda17__sound_services_dbus_prop_iface_properties_changed (SoundServicesDbusPropIface* _sender,
                                                                const gchar* iface,
                                                                GHashTable* changed,
                                                                gchar** invalid,
                                                                gint invalid_length1,
                                                                gpointer self)
{
	__lambda17_ ((SoundWidgetsPlayerRow*) self, iface, changed, invalid, invalid_length1);
}

static void
sound_widgets_player_row_connect_to_client (SoundWidgetsPlayerRow* self)
{
	SoundServicesMprisClient* _tmp0_;
	SoundServicesMprisClient* _tmp1_;
	SoundServicesDbusPropIface* _tmp2_;
	SoundServicesDbusPropIface* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = sound_widgets_player_row_get_client (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = sound_services_mpris_client_get_prop (_tmp1_);
	_tmp3_ = _tmp2_;
	g_signal_connect_object (_tmp3_, "properties-changed", (GCallback) ___lambda17__sound_services_dbus_prop_iface_properties_changed, self, 0);
}

static void*
_____lambda23_ (SoundWidgetsPlayerRow* self)
{
	GError* _inner_error0_ = NULL;
	void* result;
	{
		SoundServicesMprisClient* _tmp0_;
		SoundServicesMprisClient* _tmp1_;
		SoundServicesPlayerIface* _tmp2_;
		SoundServicesPlayerIface* _tmp3_;
		_tmp0_ = sound_widgets_player_row_get_client (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = sound_services_mpris_client_get_player (_tmp1_);
		_tmp3_ = _tmp2_;
		sound_services_mpris_iface_raise ((SoundServicesMprisIface*) _tmp3_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("PlayerRow.vala:406: Raising the player probably failed (faulty MPRIS i" \
"nterface): %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = NULL;
	return result;
}

static gpointer
______lambda23__gthread_func (gpointer self)
{
	gpointer result;
	result = _____lambda23_ ((SoundWidgetsPlayerRow*) self);
	g_object_unref (self);
	return result;
}

static gboolean
sound_widgets_player_row_raise_player (SoundWidgetsPlayerRow* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gboolean _tmp0_ = FALSE;
		SoundServicesMprisClient* _tmp1_;
		SoundServicesMprisClient* _tmp2_;
		g_signal_emit (self, sound_widgets_player_row_signals[SOUND_WIDGETS_PLAYER_ROW_CLOSE_SIGNAL], 0);
		_tmp1_ = sound_widgets_player_row_get_client (self);
		_tmp2_ = _tmp1_;
		if (_tmp2_ != NULL) {
			SoundServicesMprisClient* _tmp3_;
			SoundServicesMprisClient* _tmp4_;
			SoundServicesPlayerIface* _tmp5_;
			SoundServicesPlayerIface* _tmp6_;
			gboolean _tmp7_;
			gboolean _tmp8_;
			_tmp3_ = sound_widgets_player_row_get_client (self);
			_tmp4_ = _tmp3_;
			_tmp5_ = sound_services_mpris_client_get_player (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = sound_services_mpris_iface_get_can_raise ((SoundServicesMprisIface*) _tmp6_);
			_tmp8_ = _tmp7_;
			_tmp0_ = _tmp8_;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			if (!g_thread_supported ()) {
				g_warning ("PlayerRow.vala:395: Threading is not supported. DBus timeout could be " \
"blocking UI");
				{
					SoundServicesMprisClient* _tmp9_;
					SoundServicesMprisClient* _tmp10_;
					SoundServicesPlayerIface* _tmp11_;
					SoundServicesPlayerIface* _tmp12_;
					_tmp9_ = sound_widgets_player_row_get_client (self);
					_tmp10_ = _tmp9_;
					_tmp11_ = sound_services_mpris_client_get_player (_tmp10_);
					_tmp12_ = _tmp11_;
					sound_services_mpris_iface_raise ((SoundServicesMprisIface*) _tmp12_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch1_g_error;
					}
				}
				goto __finally1;
				__catch1_g_error:
				{
					GError* e = NULL;
					GError* _tmp13_;
					const gchar* _tmp14_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp13_ = e;
					_tmp14_ = _tmp13_->message;
					g_warning ("PlayerRow.vala:399: Raising the player probably failed (faulty MPRIS i" \
"nterface): %s", _tmp14_);
					_g_error_free0 (e);
				}
				__finally1:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			} else {
				GThread* _tmp15_;
				GThread* _tmp16_;
				_tmp15_ = g_thread_new ("wingpanel_indicator_sound_dbus_backward_thread", ______lambda23__gthread_func, g_object_ref (self));
				_tmp16_ = _tmp15_;
				_g_thread_unref0 (_tmp16_);
			}
		} else {
			GAppInfo* _tmp17_;
			GAppInfo* _tmp18_;
			_tmp17_ = sound_widgets_player_row_get_app_info (self);
			_tmp18_ = _tmp17_;
			if (_tmp18_ != NULL) {
				GAppInfo* _tmp19_;
				GAppInfo* _tmp20_;
				_tmp19_ = sound_widgets_player_row_get_app_info (self);
				_tmp20_ = _tmp19_;
				g_app_info_launch (_tmp20_, NULL, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_warning ("PlayerRow.vala:415: Could not launch player");
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp21_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp21_;
	}
	result = GDK_EVENT_STOP;
	return result;
}

/**
     * Update play status based on player requirements
     */
static void
sound_widgets_player_row_update_play_status (SoundWidgetsPlayerRow* self)
{
	SoundServicesMprisClient* _tmp0_;
	SoundServicesMprisClient* _tmp1_;
	SoundServicesPlayerIface* _tmp2_;
	SoundServicesPlayerIface* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp14_ = FALSE;
	SoundServicesMprisClient* _tmp15_;
	SoundServicesMprisClient* _tmp16_;
	SoundServicesPlayerIface* _tmp17_;
	SoundServicesPlayerIface* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gboolean _tmp22_;
	g_return_if_fail (self != NULL);
	_tmp0_ = sound_widgets_player_row_get_client (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = sound_services_mpris_client_get_player (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = sound_services_player_iface_get_playback_status (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strcmp0 (_tmp6_, "Playing") == 0;
	_g_free0 (_tmp6_);
	if (_tmp7_) {
		GtkButton* _tmp8_;
		GtkWidget* _tmp9_;
		GtkWidget* _tmp10_;
		_tmp8_ = self->priv->play_btn;
		_tmp9_ = gtk_button_get_image (_tmp8_);
		_tmp10_ = _tmp9_;
		g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_image_get_type (), GtkImage), "icon-name", "media-playback-pause-symbolic", NULL);
	} else {
		GtkButton* _tmp11_;
		GtkWidget* _tmp12_;
		GtkWidget* _tmp13_;
		_tmp11_ = self->priv->play_btn;
		_tmp12_ = gtk_button_get_image (_tmp11_);
		_tmp13_ = _tmp12_;
		g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_image_get_type (), GtkImage), "icon-name", "media-playback-start-symbolic", NULL);
	}
	_tmp15_ = sound_widgets_player_row_get_client (self);
	_tmp16_ = _tmp15_;
	_tmp17_ = sound_services_mpris_client_get_player (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = sound_services_player_iface_get_playback_status (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strcmp0 (_tmp21_, "Stopped") == 0;
	_g_free0 (_tmp21_);
	if (_tmp22_) {
		GAppInfo* _tmp23_;
		GAppInfo* _tmp24_;
		_tmp23_ = sound_widgets_player_row_get_app_info (self);
		_tmp24_ = _tmp23_;
		_tmp14_ = _tmp24_ == NULL;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		gtk_widget_set_no_show_all ((GtkWidget*) self, TRUE);
		gtk_widget_hide ((GtkWidget*) self);
	} else {
		gtk_widget_set_no_show_all ((GtkWidget*) self, FALSE);
		gtk_widget_show ((GtkWidget*) self);
	}
}

/**
     * Update prev/next sensitivity based on player requirements
     */
static void
sound_widgets_player_row_update_controls (SoundWidgetsPlayerRow* self)
{
	SoundServicesMediaPlayer* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mp_client;
	if (_tmp0_ == NULL) {
		GtkButton* _tmp1_;
		SoundServicesMprisClient* _tmp2_;
		SoundServicesMprisClient* _tmp3_;
		SoundServicesPlayerIface* _tmp4_;
		SoundServicesPlayerIface* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		GtkButton* _tmp8_;
		SoundServicesMprisClient* _tmp9_;
		SoundServicesMprisClient* _tmp10_;
		SoundServicesPlayerIface* _tmp11_;
		SoundServicesPlayerIface* _tmp12_;
		gboolean _tmp13_;
		gboolean _tmp14_;
		_tmp1_ = self->priv->prev_btn;
		_tmp2_ = sound_widgets_player_row_get_client (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = sound_services_mpris_client_get_player (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = sound_services_player_iface_get_can_go_previous (_tmp5_);
		_tmp7_ = _tmp6_;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, _tmp7_);
		_tmp8_ = self->priv->next_btn;
		_tmp9_ = sound_widgets_player_row_get_client (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = sound_services_mpris_client_get_player (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = sound_services_player_iface_get_can_go_next (_tmp12_);
		_tmp14_ = _tmp13_;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, _tmp14_);
	} else {
		GtkButton* _tmp15_;
		GtkButton* _tmp16_;
		_tmp15_ = self->priv->prev_btn;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp15_, TRUE);
		_tmp16_ = self->priv->next_btn;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp16_, TRUE);
	}
}

/**
     * Utility, handle updating the album art
     */
static void
sound_widgets_player_row_update_art (SoundWidgetsPlayerRow* self,
                                     const gchar* uri)
{
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	if (!g_str_has_prefix (uri, "file://")) {
		_tmp0_ = !g_str_has_prefix (uri, "http");
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkImage* _tmp1_;
		GIcon* _tmp2_;
		GtkImage* _tmp3_;
		GtkStyleContext* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		GtkImage* _tmp7_;
		GtkImage* _tmp8_;
		_tmp1_ = self->priv->background;
		_tmp2_ = self->priv->app_icon;
		g_object_set (_tmp1_, "gicon", _tmp2_, NULL);
		_tmp3_ = self->priv->background;
		_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
		_tmp5_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
		_tmp6_ = _tmp5_;
		gtk_style_context_set_scale (_tmp4_, _tmp6_);
		_tmp7_ = self->priv->mask;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp7_, TRUE);
		_tmp8_ = self->priv->mask;
		gtk_widget_hide ((GtkWidget*) _tmp8_);
		return;
	}
	if (g_str_has_prefix (uri, "file://")) {
		gchar* fname = NULL;
		gchar** _tmp9_;
		gchar** _tmp10_;
		gchar** _tmp11_;
		gint _tmp11__length1;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		_tmp10_ = _tmp9_ = g_strsplit (uri, "file://", 0);
		_tmp11_ = _tmp10_;
		_tmp11__length1 = _vala_array_length (_tmp9_);
		_tmp12_ = _tmp11_[1];
		_tmp13_ = g_strdup (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
		fname = _tmp14_;
		_tmp15_ = fname;
		if (!g_file_test (_tmp15_, G_FILE_TEST_EXISTS)) {
			gchar* folder_pattern = NULL;
			gchar* _tmp16_;
			GRegex* temp_regex = NULL;
			const gchar* _tmp17_;
			GRegex* _tmp18_;
			GMatchInfo* regex_match = NULL;
			GRegex* _tmp19_;
			const gchar* _tmp20_;
			GMatchInfo* _tmp21_ = NULL;
			gboolean _tmp22_;
			_tmp16_ = g_strdup ("^(/tmp/.)(?<appName>([a-zA-Z]*[.]){2}([a-zA-Z]*)).*$");
			folder_pattern = _tmp16_;
			_tmp17_ = folder_pattern;
			_tmp18_ = g_regex_new (_tmp17_, 0, 0, &_inner_error0_);
			temp_regex = _tmp18_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (folder_pattern);
				_g_free0 (fname);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp19_ = temp_regex;
			_tmp20_ = fname;
			_tmp22_ = g_regex_match (_tmp19_, _tmp20_, 0, &_tmp21_);
			_g_match_info_unref0 (regex_match);
			regex_match = _tmp21_;
			if (_tmp22_) {
				gchar* app_name = NULL;
				GMatchInfo* _tmp23_;
				gchar* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				gchar* _tmp28_;
				_tmp23_ = regex_match;
				_tmp24_ = g_match_info_fetch_named (_tmp23_, "appName");
				app_name = _tmp24_;
				_tmp25_ = g_get_user_runtime_dir ();
				_tmp26_ = app_name;
				_tmp27_ = fname;
				_tmp28_ = g_build_path (G_DIR_SEPARATOR_S, _tmp25_, ".flatpak", _tmp26_, _tmp27_, NULL);
				_g_free0 (fname);
				fname = _tmp28_;
				_g_free0 (app_name);
			}
			_g_match_info_unref0 (regex_match);
			_g_regex_unref0 (temp_regex);
			_g_free0 (folder_pattern);
		}
		{
			GdkPixbuf* pbuf = NULL;
			const gchar* _tmp29_;
			gint _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			gint _tmp33_;
			GdkPixbuf* _tmp34_;
			GtkImage* _tmp35_;
			GdkPixbuf* _tmp36_;
			gint _tmp37_;
			gint _tmp38_;
			GdkPixbuf* _tmp39_;
			GdkPixbuf* _tmp40_;
			GtkImage* _tmp41_;
			GtkStyleContext* _tmp42_;
			GtkImage* _tmp43_;
			GtkImage* _tmp44_;
			_tmp29_ = fname;
			_tmp30_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
			_tmp31_ = _tmp30_;
			_tmp32_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
			_tmp33_ = _tmp32_;
			_tmp34_ = gdk_pixbuf_new_from_file_at_size (_tmp29_, ICON_SIZE * _tmp31_, ICON_SIZE * _tmp33_, &_inner_error0_);
			pbuf = _tmp34_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp35_ = self->priv->background;
			_tmp36_ = pbuf;
			_tmp37_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
			_tmp38_ = _tmp37_;
			_tmp39_ = sound_widgets_player_row_mask_pixbuf (_tmp36_, _tmp38_);
			_tmp40_ = _tmp39_;
			g_object_set (_tmp35_, "gicon", (GIcon*) _tmp40_, NULL);
			_g_object_unref0 (_tmp40_);
			_tmp41_ = self->priv->background;
			_tmp42_ = gtk_widget_get_style_context ((GtkWidget*) _tmp41_);
			gtk_style_context_set_scale (_tmp42_, 1);
			_tmp43_ = self->priv->mask;
			gtk_widget_set_no_show_all ((GtkWidget*) _tmp43_, FALSE);
			_tmp44_ = self->priv->mask;
			gtk_widget_show ((GtkWidget*) _tmp44_);
			_g_object_unref0 (pbuf);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp45_;
			const gchar* _tmp46_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp45_ = e;
			_tmp46_ = _tmp45_->message;
			g_warning ("PlayerRow.vala:503: %s", _tmp46_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (fname);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_free0 (fname);
	} else {
		GCancellable* _tmp47_;
		GCancellable* _tmp48_;
		_tmp47_ = self->priv->load_remote_art_cancel;
		g_cancellable_cancel (_tmp47_);
		_tmp48_ = self->priv->load_remote_art_cancel;
		g_cancellable_reset (_tmp48_);
		sound_widgets_player_row_load_remote_art (self, uri, NULL, NULL);
	}
}

static void
sound_widgets_player_row_load_remote_art_data_free (gpointer _data)
{
	SoundWidgetsPlayerRowLoadRemoteArtData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uri);
	_g_object_unref0 (_data_->self);
	g_slice_free (SoundWidgetsPlayerRowLoadRemoteArtData, _data_);
}

static void
sound_widgets_player_row_load_remote_art (SoundWidgetsPlayerRow* self,
                                          const gchar* uri,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	SoundWidgetsPlayerRowLoadRemoteArtData* _data_;
	SoundWidgetsPlayerRow* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_data_ = g_slice_new0 (SoundWidgetsPlayerRowLoadRemoteArtData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, sound_widgets_player_row_load_remote_art_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (uri);
	_g_free0 (_data_->uri);
	_data_->uri = _tmp1_;
	sound_widgets_player_row_load_remote_art_co (_data_);
}

static void
sound_widgets_player_row_load_remote_art_finish (SoundWidgetsPlayerRow* self,
                                                 GAsyncResult* _res_)
{
	SoundWidgetsPlayerRowLoadRemoteArtData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
sound_widgets_player_row_load_remote_art_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	SoundWidgetsPlayerRowLoadRemoteArtData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	sound_widgets_player_row_load_remote_art_co (_data_);
}

static gboolean
sound_widgets_player_row_load_remote_art_co (SoundWidgetsPlayerRowLoadRemoteArtData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_file_new_for_uri (_data_->uri);
	_data_->file = _data_->_tmp0_;
	{
		_data_->_tmp1_ = _data_->file;
		_data_->_tmp2_ = _data_->self->priv->load_remote_art_cancel;
		_data_->_state_ = 1;
		g_file_read_async (_data_->_tmp1_, G_PRIORITY_DEFAULT, _data_->_tmp2_, sound_widgets_player_row_load_remote_art_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp3_ = g_file_read_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
		_data_->stream = _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp4_ = _data_->stream;
		_data_->_tmp5_ = _data_->self->priv->load_remote_art_cancel;
		_data_->_state_ = 2;
		gdk_pixbuf_new_from_stream_async ((GInputStream*) _data_->_tmp4_, _data_->_tmp5_, sound_widgets_player_row_load_remote_art_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp6_ = (GdkPixbuf*) gdk_pixbuf_new_from_stream_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->pixbuf = _data_->_tmp6_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->stream);
			goto __catch0_g_error;
		}
		_data_->_tmp7_ = _data_->pixbuf;
		if (_data_->_tmp7_ != NULL) {
			_data_->_tmp8_ = _data_->self->priv->background;
			_data_->_tmp9_ = _data_->pixbuf;
			_data_->_tmp10_ = gtk_widget_get_scale_factor ((GtkWidget*) _data_->self);
			_data_->_tmp11_ = _data_->_tmp10_;
			_data_->_tmp12_ = sound_widgets_player_row_mask_pixbuf (_data_->_tmp9_, _data_->_tmp11_);
			_data_->_tmp13_ = _data_->_tmp12_;
			g_object_set (_data_->_tmp8_, "gicon", (GIcon*) _data_->_tmp13_, NULL);
			_g_object_unref0 (_data_->_tmp13_);
			_data_->_tmp14_ = _data_->self->priv->background;
			_data_->_tmp15_ = gtk_widget_get_style_context ((GtkWidget*) _data_->_tmp14_);
			gtk_style_context_set_scale (_data_->_tmp15_, 1);
			_data_->_tmp16_ = _data_->self->priv->mask;
			gtk_widget_set_no_show_all ((GtkWidget*) _data_->_tmp16_, FALSE);
			_data_->_tmp17_ = _data_->self->priv->mask;
			gtk_widget_show ((GtkWidget*) _data_->_tmp17_);
		}
		_g_object_unref0 (_data_->pixbuf);
		_g_object_unref0 (_data_->stream);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
		_data_->_tmp18_ = _data_->self->priv->background;
		_data_->_tmp19_ = _data_->self->priv->app_icon;
		g_object_set (_data_->_tmp18_, "gicon", _data_->_tmp19_, NULL);
		_data_->_tmp20_ = _data_->self->priv->background;
		_data_->_tmp21_ = gtk_widget_get_style_context ((GtkWidget*) _data_->_tmp20_);
		_data_->_tmp22_ = gtk_widget_get_scale_factor ((GtkWidget*) _data_->self);
		_data_->_tmp23_ = _data_->_tmp22_;
		gtk_style_context_set_scale (_data_->_tmp21_, _data_->_tmp23_);
		_data_->_tmp24_ = _data_->self->priv->mask;
		gtk_widget_set_no_show_all ((GtkWidget*) _data_->_tmp24_, TRUE);
		_data_->_tmp25_ = _data_->self->priv->mask;
		gtk_widget_hide ((GtkWidget*) _data_->_tmp25_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->file);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
     * Update display info such as artist, the background image, etc.
     */
static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

void
sound_widgets_player_row_update_from_meta (SoundWidgetsPlayerRow* self)
{
	GHashTable* metadata = NULL;
	SoundServicesMprisClient* _tmp0_;
	SoundServicesMprisClient* _tmp1_;
	SoundServicesPlayerIface* _tmp2_;
	SoundServicesPlayerIface* _tmp3_;
	GHashTable* _tmp4_;
	GHashTable* _tmp5_;
	GHashTable* _tmp6_;
	gchar* title = NULL;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	GHashTable* _tmp24_;
	GtkLabel* _tmp37_;
	const gchar* _tmp38_;
	gboolean _tmp39_ = FALSE;
	GHashTable* _tmp40_;
	g_return_if_fail (self != NULL);
	_tmp0_ = sound_widgets_player_row_get_client (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = sound_services_mpris_client_get_player (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = sound_services_player_iface_get_metadata (_tmp3_);
	_tmp5_ = _tmp4_;
	metadata = _tmp5_;
	_tmp6_ = metadata;
	if (g_hash_table_contains (_tmp6_, "mpris:artUrl")) {
		gchar* url = NULL;
		GHashTable* _tmp7_;
		gconstpointer _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp7_ = metadata;
		_tmp8_ = g_hash_table_lookup (_tmp7_, "mpris:artUrl");
		_tmp9_ = g_variant_get_string ((GVariant*) _tmp8_, NULL);
		_tmp10_ = g_strdup (_tmp9_);
		url = _tmp10_;
		_tmp11_ = url;
		_tmp12_ = self->priv->last_art_url;
		if (g_strcmp0 (_tmp11_, _tmp12_) != 0) {
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp13_ = url;
			sound_widgets_player_row_update_art (self, _tmp13_);
			_tmp14_ = url;
			_tmp15_ = g_strdup (_tmp14_);
			_g_free0 (self->priv->last_art_url);
			self->priv->last_art_url = _tmp15_;
		}
		_g_free0 (url);
	} else {
		gchar* _tmp16_;
		GtkImage* _tmp17_;
		GtkImage* _tmp18_;
		GIcon* _tmp19_;
		GtkImage* _tmp20_;
		GtkImage* _tmp21_;
		_tmp16_ = g_strdup ("");
		_g_free0 (self->priv->last_art_url);
		self->priv->last_art_url = _tmp16_;
		_tmp17_ = self->priv->background;
		gtk_image_set_pixel_size (_tmp17_, ICON_SIZE);
		_tmp18_ = self->priv->background;
		_tmp19_ = self->priv->app_icon;
		g_object_set (_tmp18_, "gicon", _tmp19_, NULL);
		_tmp20_ = self->priv->mask;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp20_, TRUE);
		_tmp21_ = self->priv->mask;
		gtk_widget_hide ((GtkWidget*) _tmp21_);
	}
	_tmp24_ = metadata;
	if (g_hash_table_contains (_tmp24_, "xesam:title")) {
		GHashTable* _tmp25_;
		gconstpointer _tmp26_;
		const GVariantType* _tmp27_;
		_tmp25_ = metadata;
		_tmp26_ = g_hash_table_lookup (_tmp25_, "xesam:title");
		_tmp27_ = G_VARIANT_TYPE_STRING;
		_tmp23_ = g_variant_is_of_type ((GVariant*) _tmp26_, _tmp27_);
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		GHashTable* _tmp28_;
		gconstpointer _tmp29_;
		const gchar* _tmp30_;
		_tmp28_ = metadata;
		_tmp29_ = g_hash_table_lookup (_tmp28_, "xesam:title");
		_tmp30_ = g_variant_get_string ((GVariant*) _tmp29_, NULL);
		_tmp22_ = g_strcmp0 (_tmp30_, "") != 0;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		GHashTable* _tmp31_;
		gconstpointer _tmp32_;
		const gchar* _tmp33_;
		gchar* _tmp34_;
		_tmp31_ = metadata;
		_tmp32_ = g_hash_table_lookup (_tmp31_, "xesam:title");
		_tmp33_ = g_variant_get_string ((GVariant*) _tmp32_, NULL);
		_tmp34_ = g_strdup (_tmp33_);
		_g_free0 (title);
		title = _tmp34_;
	} else {
		const gchar* _tmp35_;
		gchar* _tmp36_;
		_tmp35_ = self->priv->app_name;
		_tmp36_ = g_strdup (_tmp35_);
		_g_free0 (title);
		title = _tmp36_;
	}
	_tmp37_ = self->priv->title_label;
	_tmp38_ = title;
	gtk_label_set_label (_tmp37_, _tmp38_);
	_tmp40_ = metadata;
	if (g_hash_table_contains (_tmp40_, "xesam:artist")) {
		GHashTable* _tmp41_;
		gconstpointer _tmp42_;
		const GVariantType* _tmp43_;
		_tmp41_ = metadata;
		_tmp42_ = g_hash_table_lookup (_tmp41_, "xesam:artist");
		_tmp43_ = G_VARIANT_TYPE_STRING_ARRAY;
		_tmp39_ = g_variant_is_of_type ((GVariant*) _tmp42_, _tmp43_);
	} else {
		_tmp39_ = FALSE;
	}
	if (_tmp39_) {
		const gchar** artists = NULL;
		GHashTable* _tmp44_;
		gconstpointer _tmp45_;
		gsize _tmp46_ = 0;
		const gchar** _tmp47_;
		gint artists_length1;
		gint _artists_size_;
		GtkLabel* _tmp48_;
		const gchar** _tmp49_;
		gint _tmp49__length1;
		gchar* _tmp50_;
		gchar* _tmp51_;
		_tmp44_ = metadata;
		_tmp45_ = g_hash_table_lookup (_tmp44_, "xesam:artist");
		_tmp47_ = g_variant_get_strv ((GVariant*) _tmp45_, &_tmp46_);
		artists = _tmp47_;
		artists_length1 = _tmp46_;
		_artists_size_ = artists_length1;
		_tmp48_ = self->priv->artist_label;
		_tmp49_ = artists;
		_tmp49__length1 = artists_length1;
		_tmp50_ = _vala_g_strjoinv (", ", _tmp49_, (gint) _tmp49__length1);
		_tmp51_ = _tmp50_;
		gtk_label_set_label (_tmp48_, _tmp51_);
		_g_free0 (_tmp51_);
		artists = (g_free (artists), NULL);
	} else {
		SoundServicesMprisClient* _tmp52_;
		SoundServicesMprisClient* _tmp53_;
		SoundServicesPlayerIface* _tmp54_;
		SoundServicesPlayerIface* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		gboolean _tmp59_;
		_tmp52_ = sound_widgets_player_row_get_client (self);
		_tmp53_ = _tmp52_;
		_tmp54_ = sound_services_mpris_client_get_player (_tmp53_);
		_tmp55_ = _tmp54_;
		_tmp56_ = sound_services_player_iface_get_playback_status (_tmp55_);
		_tmp57_ = _tmp56_;
		_tmp58_ = _tmp57_;
		_tmp59_ = g_strcmp0 (_tmp58_, "Playing") == 0;
		_g_free0 (_tmp58_);
		if (_tmp59_) {
			GtkLabel* _tmp60_;
			_tmp60_ = self->priv->artist_label;
			gtk_label_set_label (_tmp60_, _ ("Unknown Artist"));
		} else {
			GtkLabel* _tmp61_;
			_tmp61_ = self->priv->artist_label;
			gtk_label_set_label (_tmp61_, SOUND_WIDGETS_PLAYER_ROW_NOT_PLAYING);
		}
	}
	_g_free0 (title);
	_g_hash_table_unref0 (metadata);
}

static GdkPixbuf*
sound_widgets_player_row_mask_pixbuf (GdkPixbuf* pixbuf,
                                      gint scale)
{
	gint size = 0;
	gint mask_offset = 0;
	gint mask_size_offset = 0;
	gint mask_size = 0;
	gint offset_x = 0;
	gint offset_y = 0;
	GdkPixbuf* input = NULL;
	GdkPixbuf* _tmp0_;
	cairo_surface_t* surface = NULL;
	cairo_surface_t* _tmp1_;
	cairo_t* cr = NULL;
	cairo_t* _tmp2_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* result;
	g_return_val_if_fail (pixbuf != NULL, NULL);
	size = ICON_SIZE * scale;
	mask_offset = 4 * scale;
	mask_size_offset = mask_offset * 2;
	mask_size = ICON_SIZE * scale;
	offset_x = mask_offset;
	offset_y = mask_offset + scale;
	size = size - mask_size_offset;
	_tmp0_ = gdk_pixbuf_scale_simple (pixbuf, size, size, GDK_INTERP_BILINEAR);
	input = _tmp0_;
	_tmp1_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, mask_size, mask_size);
	surface = _tmp1_;
	_tmp2_ = cairo_create (surface);
	cr = _tmp2_;
	granite_drawing_utilities_cairo_rounded_rectangle (cr, (gdouble) offset_x, (gdouble) offset_y, (gdouble) size, (gdouble) size, (gdouble) mask_offset);
	cairo_clip (cr);
	gdk_cairo_set_source_pixbuf (cr, input, (gdouble) offset_x, (gdouble) offset_y);
	cairo_paint (cr);
	_tmp3_ = gdk_pixbuf_get_from_surface (surface, 0, 0, mask_size, mask_size);
	result = _tmp3_;
	_cairo_destroy0 (cr);
	_cairo_surface_destroy0 (surface);
	_g_object_unref0 (input);
	return result;
}

void
sound_widgets_player_row_update_play (SoundWidgetsPlayerRow* self,
                                      const gchar* playing,
                                      const gchar* title,
                                      const gchar* artist)
{
	gboolean _tmp9_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (playing != NULL);
	g_return_if_fail (title != NULL);
	g_return_if_fail (artist != NULL);
	if (g_strcmp0 (playing, "") != 0) {
		const gchar* _tmp0_;
		GQuark _tmp2_ = 0U;
		static GQuark _tmp1_label0 = 0;
		_tmp0_ = playing;
		_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
		if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("playing")))) {
			switch (0) {
				default:
				{
					GtkButton* _tmp3_;
					GtkWidget* _tmp4_;
					GtkWidget* _tmp5_;
					_tmp3_ = self->priv->play_btn;
					_tmp4_ = gtk_button_get_image (_tmp3_);
					_tmp5_ = _tmp4_;
					g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_image_get_type (), GtkImage), "icon-name", "media-playback-pause-symbolic", NULL);
					break;
				}
			}
		} else {
			switch (0) {
				default:
				{
					GtkButton* _tmp6_;
					GtkWidget* _tmp7_;
					GtkWidget* _tmp8_;
					_tmp6_ = self->priv->play_btn;
					_tmp7_ = gtk_button_get_image (_tmp6_);
					_tmp8_ = _tmp7_;
					g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_image_get_type (), GtkImage), "icon-name", "media-playback-start-symbolic", NULL);
					break;
				}
			}
		}
	}
	if (g_strcmp0 (title, "") != 0) {
		_tmp9_ = g_strcmp0 (artist, "") != 0;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		GtkLabel* _tmp10_;
		GtkLabel* _tmp11_;
		_tmp10_ = self->priv->title_label;
		gtk_label_set_label (_tmp10_, title);
		_tmp11_ = self->priv->artist_label;
		gtk_label_set_label (_tmp11_, artist);
	}
}

GAppInfo*
sound_widgets_player_row_get_app_info (SoundWidgetsPlayerRow* self)
{
	GAppInfo* result;
	GAppInfo* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->ainfo;
	result = _tmp0_;
	return result;
}

void
sound_widgets_player_row_set_app_info (SoundWidgetsPlayerRow* self,
                                       GAppInfo* value)
{
	GAppInfo* _tmp0_;
	GAppInfo* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->ainfo);
	self->priv->ainfo = _tmp0_;
	_tmp1_ = self->priv->ainfo;
	if (_tmp1_ != NULL) {
		GAppInfo* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		GIcon* icon = NULL;
		GIcon* _tmp9_;
		GIcon* _tmp10_;
		GIcon* _tmp11_;
		_tmp2_ = self->priv->ainfo;
		_tmp3_ = g_app_info_get_display_name (_tmp2_);
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (self->priv->app_name);
		self->priv->app_name = _tmp4_;
		_tmp5_ = self->priv->app_name;
		if (g_strcmp0 (_tmp5_, "") == 0) {
			GAppInfo* _tmp6_;
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp6_ = self->priv->ainfo;
			_tmp7_ = g_app_info_get_name (_tmp6_);
			_tmp8_ = g_strdup (_tmp7_);
			_g_free0 (self->priv->app_name);
			self->priv->app_name = _tmp8_;
		}
		_tmp9_ = g_app_info_get_icon (value);
		_tmp10_ = _g_object_ref0 (_tmp9_);
		icon = _tmp10_;
		_tmp11_ = icon;
		if (_tmp11_ != NULL) {
			GIcon* _tmp12_;
			GIcon* _tmp13_;
			GtkImage* _tmp14_;
			GIcon* _tmp15_;
			_tmp12_ = icon;
			_tmp13_ = _g_object_ref0 (_tmp12_);
			_g_object_unref0 (self->priv->app_icon);
			self->priv->app_icon = _tmp13_;
			_tmp14_ = self->priv->background;
			_tmp15_ = self->priv->app_icon;
			g_object_set (_tmp14_, "gicon", _tmp15_, NULL);
		}
		_g_object_unref0 (icon);
	}
	g_object_notify_by_pspec ((GObject *) self, sound_widgets_player_row_properties[SOUND_WIDGETS_PLAYER_ROW_APP_INFO_PROPERTY]);
}

SoundServicesMprisClient*
sound_widgets_player_row_get_client (SoundWidgetsPlayerRow* self)
{
	SoundServicesMprisClient* result;
	SoundServicesMprisClient* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->client_;
	result = _tmp0_;
	return result;
}

static gboolean
_sound_widgets_player_row_client_____lambda22_ (SoundWidgetsPlayerRow* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		SoundServicesMprisClient* _tmp0_;
		SoundServicesMprisClient* _tmp1_;
		SoundServicesPlayerIface* _tmp2_;
		SoundServicesPlayerIface* _tmp3_;
		self->priv->launched_by_indicator = FALSE;
		_tmp0_ = sound_widgets_player_row_get_client (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = sound_services_mpris_client_get_player (_tmp1_);
		_tmp3_ = _tmp2_;
		sound_services_player_iface_play_pause (_tmp3_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("PlayerRow.vala:82: Could not play/pause: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp6_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp6_;
	}
	result = FALSE;
	return result;
}

static gboolean
__sound_widgets_player_row_client_____lambda22__gsource_func (gpointer self)
{
	gboolean result;
	result = _sound_widgets_player_row_client_____lambda22_ ((SoundWidgetsPlayerRow*) self);
	return result;
}

void
sound_widgets_player_row_set_client (SoundWidgetsPlayerRow* self,
                                     SoundServicesMprisClient* value)
{
	SoundServicesMprisClient* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->client_);
	self->priv->client_ = _tmp0_;
	if (value != NULL) {
		gchar* desktop_entry = NULL;
		SoundServicesMprisClient* _tmp1_;
		SoundServicesMprisClient* _tmp2_;
		SoundServicesPlayerIface* _tmp3_;
		SoundServicesPlayerIface* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gboolean _tmp7_ = FALSE;
		const gchar* _tmp8_;
		_tmp1_ = sound_widgets_player_row_get_client (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = sound_services_mpris_client_get_player (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = sound_services_mpris_iface_get_desktop_entry ((SoundServicesMprisIface*) _tmp4_);
		_tmp6_ = _tmp5_;
		desktop_entry = _tmp6_;
		_tmp8_ = desktop_entry;
		if (_tmp8_ != NULL) {
			const gchar* _tmp9_;
			_tmp9_ = desktop_entry;
			_tmp7_ = g_strcmp0 (_tmp9_, "") != 0;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			GDesktopAppInfo* _tmp13_;
			GDesktopAppInfo* _tmp14_;
			_tmp10_ = desktop_entry;
			_tmp11_ = g_strdup_printf ("%s.desktop", _tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_desktop_app_info_new (_tmp12_);
			_tmp14_ = _tmp13_;
			sound_widgets_player_row_set_app_info (self, (GAppInfo*) _tmp14_);
			_g_object_unref0 (_tmp14_);
			_g_free0 (_tmp12_);
		}
		sound_widgets_player_row_connect_to_client (self);
		sound_widgets_player_row_update_play_status (self);
		sound_widgets_player_row_update_from_meta (self);
		sound_widgets_player_row_update_controls (self);
		if (self->priv->launched_by_indicator) {
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __sound_widgets_player_row_client_____lambda22__gsource_func, g_object_ref (self), g_object_unref);
		}
		_g_free0 (desktop_entry);
	} else {
		GtkButton* _tmp15_;
		GtkWidget* _tmp16_;
		GtkWidget* _tmp17_;
		GtkButton* _tmp18_;
		GtkButton* _tmp19_;
		GSettings* _tmp20_;
		GAppInfo* _tmp21_;
		GAppInfo* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		GtkLabel* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		GtkLabel* _tmp28_;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		const gchar* _tmp31_;
		gchar* _tmp32_;
		gchar** _tmp33_;
		gchar** _tmp34_;
		gint _tmp34__length1;
		gchar* _tmp35_;
		_tmp15_ = self->priv->play_btn;
		_tmp16_ = gtk_button_get_image (_tmp15_);
		_tmp17_ = _tmp16_;
		g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_image_get_type (), GtkImage), "icon-name", "media-playback-start-symbolic", NULL);
		_tmp18_ = self->priv->prev_btn;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp18_, FALSE);
		_tmp19_ = self->priv->next_btn;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp19_, FALSE);
		_tmp20_ = sound_indicator_settings;
		_tmp21_ = sound_widgets_player_row_get_app_info (self);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_app_info_get_id (_tmp22_);
		_tmp24_ = g_strdup (_tmp23_);
		_tmp25_ = self->priv->title_label;
		_tmp26_ = gtk_label_get_text (_tmp25_);
		_tmp27_ = g_strdup (_tmp26_);
		_tmp28_ = self->priv->artist_label;
		_tmp29_ = gtk_label_get_text (_tmp28_);
		_tmp30_ = g_strdup (_tmp29_);
		_tmp31_ = self->priv->last_art_url;
		_tmp32_ = g_strdup (_tmp31_);
		_tmp33_ = g_new0 (gchar*, 4 + 1);
		_tmp33_[0] = _tmp24_;
		_tmp33_[1] = _tmp27_;
		_tmp33_[2] = _tmp30_;
		_tmp33_[3] = _tmp32_;
		_tmp34_ = _tmp33_;
		_tmp34__length1 = 4;
		g_settings_set_strv (_tmp20_, "last-title-info", _tmp34_);
		_tmp34_ = (_vala_array_free (_tmp34_, _tmp34__length1, (GDestroyNotify) g_free), NULL);
		_tmp35_ = g_strdup ("");
		_g_free0 (self->mpris_name);
		self->mpris_name = _tmp35_;
	}
	g_object_notify_by_pspec ((GObject *) self, sound_widgets_player_row_properties[SOUND_WIDGETS_PLAYER_ROW_CLIENT_PROPERTY]);
}

static gboolean
_sound_widgets_player_row_raise_player_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                      GdkEventButton* event,
                                                                      gpointer self)
{
	gboolean result;
	result = sound_widgets_player_row_raise_player ((SoundWidgetsPlayerRow*) self);
	return result;
}

static void*
___lambda26_ (SoundWidgetsPlayerRow* self)
{
	GError* _inner_error0_ = NULL;
	void* result;
	{
		SoundServicesMediaPlayer* _tmp0_;
		_tmp0_ = self->priv->mp_client;
		if (_tmp0_ == NULL) {
			SoundServicesMprisClient* _tmp1_;
			SoundServicesMprisClient* _tmp2_;
			SoundServicesPlayerIface* _tmp3_;
			SoundServicesPlayerIface* _tmp4_;
			_tmp1_ = sound_widgets_player_row_get_client (self);
			_tmp2_ = _tmp1_;
			_tmp3_ = sound_services_mpris_client_get_player (_tmp2_);
			_tmp4_ = _tmp3_;
			sound_services_player_iface_previous (_tmp4_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		} else {
			SoundServicesMediaPlayer* _tmp5_;
			_tmp5_ = self->priv->mp_client;
			if (_tmp5_ != NULL) {
				SoundServicesMediaPlayer* _tmp6_;
				_tmp6_ = self->priv->mp_client;
				sound_services_media_player_previous (_tmp6_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("PlayerRow.vala:276: Going to previous track probably failed (faulty MP" \
"RIS interface): %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = NULL;
	return result;
}

static gpointer
____lambda26__gthread_func (gpointer self)
{
	gpointer result;
	result = ___lambda26_ ((SoundWidgetsPlayerRow*) self);
	g_object_unref (self);
	return result;
}

static gboolean
__lambda25_ (SoundWidgetsPlayerRow* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	if (!g_thread_supported ()) {
		g_warning ("PlayerRow.vala:257: Threading is not supported. DBus timeout could be " \
"blocking UI");
		{
			gboolean _tmp0_ = FALSE;
			SoundServicesMediaPlayer* _tmp1_;
			_tmp1_ = self->priv->mp_client;
			if (_tmp1_ == NULL) {
				SoundServicesMprisClient* _tmp2_;
				SoundServicesMprisClient* _tmp3_;
				SoundServicesPlayerIface* _tmp4_;
				SoundServicesPlayerIface* _tmp5_;
				gboolean _tmp6_;
				gboolean _tmp7_;
				_tmp2_ = sound_widgets_player_row_get_client (self);
				_tmp3_ = _tmp2_;
				_tmp4_ = sound_services_mpris_client_get_player (_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = sound_services_player_iface_get_can_go_previous (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp0_ = _tmp7_;
			} else {
				_tmp0_ = FALSE;
			}
			if (_tmp0_) {
				SoundServicesMprisClient* _tmp8_;
				SoundServicesMprisClient* _tmp9_;
				SoundServicesPlayerIface* _tmp10_;
				SoundServicesPlayerIface* _tmp11_;
				_tmp8_ = sound_widgets_player_row_get_client (self);
				_tmp9_ = _tmp8_;
				_tmp10_ = sound_services_mpris_client_get_player (_tmp9_);
				_tmp11_ = _tmp10_;
				sound_services_player_iface_previous (_tmp11_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			} else {
				SoundServicesMediaPlayer* _tmp12_;
				_tmp12_ = self->priv->mp_client;
				if (_tmp12_ != NULL) {
					SoundServicesMediaPlayer* _tmp13_;
					_tmp13_ = self->priv->mp_client;
					sound_services_media_player_previous (_tmp13_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
				}
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp14_;
			const gchar* _tmp15_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp14_ = e;
			_tmp15_ = _tmp14_->message;
			g_warning ("PlayerRow.vala:265: Going to previous track probably failed (faulty MP" \
"RIS interface): %s", _tmp15_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp16_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp16_;
		}
	} else {
		GThread* _tmp17_;
		GThread* _tmp18_;
		_tmp17_ = g_thread_new ("wingpanel_indicator_sound_dbus_backward_thread", ____lambda26__gthread_func, g_object_ref (self));
		_tmp18_ = _tmp17_;
		_g_thread_unref0 (_tmp18_);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda25__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda25_ ((SoundWidgetsPlayerRow*) self);
	return result;
}

static void
_sound_widgets_player_row___lambda24_ (SoundWidgetsPlayerRow* self)
{
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda25__gsource_func, g_object_ref (self), g_object_unref);
}

static void
__sound_widgets_player_row___lambda24__gtk_button_clicked (GtkButton* _sender,
                                                           gpointer self)
{
	_sound_widgets_player_row___lambda24_ ((SoundWidgetsPlayerRow*) self);
}

static void*
___lambda29_ (SoundWidgetsPlayerRow* self)
{
	GError* _inner_error0_ = NULL;
	void* result;
	{
		SoundServicesMediaPlayer* _tmp0_;
		_tmp0_ = self->priv->mp_client;
		if (_tmp0_ == NULL) {
			SoundServicesMprisClient* _tmp1_;
			SoundServicesMprisClient* _tmp2_;
			SoundServicesPlayerIface* _tmp3_;
			SoundServicesPlayerIface* _tmp4_;
			_tmp1_ = sound_widgets_player_row_get_client (self);
			_tmp2_ = _tmp1_;
			_tmp3_ = sound_services_mpris_client_get_player (_tmp2_);
			_tmp4_ = _tmp3_;
			sound_services_player_iface_play_pause (_tmp4_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		} else {
			SoundServicesMediaPlayer* _tmp5_;
			_tmp5_ = self->priv->mp_client;
			if (_tmp5_ != NULL) {
				SoundServicesMediaPlayer* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				gboolean _tmp10_;
				_tmp6_ = self->priv->mp_client;
				_tmp7_ = sound_services_media_player_get_status (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = _tmp8_;
				_tmp10_ = g_strcmp0 (_tmp9_, "playing") == 0;
				_g_free0 (_tmp9_);
				if (_tmp10_) {
					SoundServicesMediaPlayer* _tmp11_;
					_tmp11_ = self->priv->mp_client;
					sound_services_media_player_pause (_tmp11_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
				} else {
					SoundServicesMediaPlayer* _tmp12_;
					_tmp12_ = self->priv->mp_client;
					sound_services_media_player_play (_tmp12_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
				}
				sound_widgets_player_row_update_play_status (self);
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_warning ("PlayerRow.vala:319: Playing/Pausing probably failed (faulty MPRIS inte" \
"rface): %s", _tmp14_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = NULL;
	return result;
}

static gpointer
____lambda29__gthread_func (gpointer self)
{
	gpointer result;
	result = ___lambda29_ ((SoundWidgetsPlayerRow*) self);
	g_object_unref (self);
	return result;
}

static gboolean
__lambda28_ (SoundWidgetsPlayerRow* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	if (!g_thread_supported ()) {
		g_warning ("PlayerRow.vala:290: Threading is not supported. DBus timeout could be " \
"blocking UI");
		{
			SoundServicesMediaPlayer* _tmp0_;
			_tmp0_ = self->priv->mp_client;
			if (_tmp0_ == NULL) {
				SoundServicesMprisClient* _tmp1_;
				SoundServicesMprisClient* _tmp2_;
				SoundServicesPlayerIface* _tmp3_;
				SoundServicesPlayerIface* _tmp4_;
				_tmp1_ = sound_widgets_player_row_get_client (self);
				_tmp2_ = _tmp1_;
				_tmp3_ = sound_services_mpris_client_get_player (_tmp2_);
				_tmp4_ = _tmp3_;
				sound_services_player_iface_play_pause (_tmp4_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			} else {
				SoundServicesMediaPlayer* _tmp5_;
				_tmp5_ = self->priv->mp_client;
				if (_tmp5_ != NULL) {
					SoundServicesMediaPlayer* _tmp6_;
					gchar* _tmp7_;
					gchar* _tmp8_;
					gchar* _tmp9_;
					gboolean _tmp10_;
					_tmp6_ = self->priv->mp_client;
					_tmp7_ = sound_services_media_player_get_status (_tmp6_);
					_tmp8_ = _tmp7_;
					_tmp9_ = _tmp8_;
					_tmp10_ = g_strcmp0 (_tmp9_, "playing") == 0;
					_g_free0 (_tmp9_);
					if (_tmp10_) {
						SoundServicesMediaPlayer* _tmp11_;
						_tmp11_ = self->priv->mp_client;
						sound_services_media_player_pause (_tmp11_, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch0_g_error;
						}
					} else {
						SoundServicesMediaPlayer* _tmp12_;
						_tmp12_ = self->priv->mp_client;
						sound_services_media_player_play (_tmp12_, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch0_g_error;
						}
					}
					sound_widgets_player_row_update_play_status (self);
				}
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp13_;
			const gchar* _tmp14_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp13_ = e;
			_tmp14_ = _tmp13_->message;
			g_warning ("PlayerRow.vala:303: Playing/Pausing probably failed (faulty MPRIS inte" \
"rface): %s", _tmp14_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp15_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp15_;
		}
	} else {
		GThread* _tmp16_;
		GThread* _tmp17_;
		_tmp16_ = g_thread_new ("wingpanel_indicator_sound_dbus_backward_thread", ____lambda29__gthread_func, g_object_ref (self));
		_tmp17_ = _tmp16_;
		_g_thread_unref0 (_tmp17_);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda28__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda28_ ((SoundWidgetsPlayerRow*) self);
	return result;
}

static void
_sound_widgets_player_row___lambda27_ (SoundWidgetsPlayerRow* self)
{
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda28__gsource_func, g_object_ref (self), g_object_unref);
}

static void
__sound_widgets_player_row___lambda27__gtk_button_clicked (GtkButton* _sender,
                                                           gpointer self)
{
	_sound_widgets_player_row___lambda27_ ((SoundWidgetsPlayerRow*) self);
}

static void*
___lambda32_ (SoundWidgetsPlayerRow* self)
{
	GError* _inner_error0_ = NULL;
	void* result;
	{
		SoundServicesMediaPlayer* _tmp0_;
		_tmp0_ = self->priv->mp_client;
		if (_tmp0_ == NULL) {
			SoundServicesMprisClient* _tmp1_;
			SoundServicesMprisClient* _tmp2_;
			SoundServicesPlayerIface* _tmp3_;
			SoundServicesPlayerIface* _tmp4_;
			_tmp1_ = sound_widgets_player_row_get_client (self);
			_tmp2_ = _tmp1_;
			_tmp3_ = sound_services_mpris_client_get_player (_tmp2_);
			_tmp4_ = _tmp3_;
			sound_services_player_iface_next (_tmp4_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		} else {
			SoundServicesMediaPlayer* _tmp5_;
			_tmp5_ = self->priv->mp_client;
			if (_tmp5_ != NULL) {
				SoundServicesMediaPlayer* _tmp6_;
				_tmp6_ = self->priv->mp_client;
				sound_services_media_player_next (_tmp6_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("PlayerRow.vala:352: Going to next track probably failed (faulty MPRIS " \
"interface): %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = NULL;
	return result;
}

static gpointer
____lambda32__gthread_func (gpointer self)
{
	gpointer result;
	result = ___lambda32_ ((SoundWidgetsPlayerRow*) self);
	g_object_unref (self);
	return result;
}

static gboolean
__lambda31_ (SoundWidgetsPlayerRow* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	if (!g_thread_supported ()) {
		g_warning ("PlayerRow.vala:333: Threading is not supported. DBus timeout could be " \
"blocking UI");
		{
			gboolean _tmp0_ = FALSE;
			SoundServicesMediaPlayer* _tmp1_;
			_tmp1_ = self->priv->mp_client;
			if (_tmp1_ == NULL) {
				SoundServicesMprisClient* _tmp2_;
				SoundServicesMprisClient* _tmp3_;
				SoundServicesPlayerIface* _tmp4_;
				SoundServicesPlayerIface* _tmp5_;
				gboolean _tmp6_;
				gboolean _tmp7_;
				_tmp2_ = sound_widgets_player_row_get_client (self);
				_tmp3_ = _tmp2_;
				_tmp4_ = sound_services_mpris_client_get_player (_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = sound_services_player_iface_get_can_go_next (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp0_ = _tmp7_;
			} else {
				_tmp0_ = FALSE;
			}
			if (_tmp0_) {
				SoundServicesMprisClient* _tmp8_;
				SoundServicesMprisClient* _tmp9_;
				SoundServicesPlayerIface* _tmp10_;
				SoundServicesPlayerIface* _tmp11_;
				_tmp8_ = sound_widgets_player_row_get_client (self);
				_tmp9_ = _tmp8_;
				_tmp10_ = sound_services_mpris_client_get_player (_tmp9_);
				_tmp11_ = _tmp10_;
				sound_services_player_iface_next (_tmp11_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			} else {
				SoundServicesMediaPlayer* _tmp12_;
				_tmp12_ = self->priv->mp_client;
				if (_tmp12_ != NULL) {
					SoundServicesMediaPlayer* _tmp13_;
					_tmp13_ = self->priv->mp_client;
					sound_services_media_player_next (_tmp13_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
				}
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp14_;
			const gchar* _tmp15_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp14_ = e;
			_tmp15_ = _tmp14_->message;
			g_warning ("PlayerRow.vala:341: Going to next track probably failed (faulty MPRIS " \
"interface): %s", _tmp15_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp16_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp16_;
		}
	} else {
		GThread* _tmp17_;
		GThread* _tmp18_;
		_tmp17_ = g_thread_new ("wingpanel_indicator_sound_dbus_forward_thread", ____lambda32__gthread_func, g_object_ref (self));
		_tmp18_ = _tmp17_;
		_g_thread_unref0 (_tmp18_);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda31__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda31_ ((SoundWidgetsPlayerRow*) self);
	return result;
}

static void
_sound_widgets_player_row___lambda30_ (SoundWidgetsPlayerRow* self)
{
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda31__gsource_func, g_object_ref (self), g_object_unref);
}

static void
__sound_widgets_player_row___lambda30__gtk_button_clicked (GtkButton* _sender,
                                                           gpointer self)
{
	_sound_widgets_player_row___lambda30_ ((SoundWidgetsPlayerRow*) self);
}

static GObject *
sound_widgets_player_row_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SoundWidgetsPlayerRow * self;
	GThemedIcon* _tmp0_;
	GCancellable* _tmp1_;
	GtkImage* _tmp2_ = NULL;
	GtkImage* _tmp3_ = NULL;
	GtkOverlay* overlay = NULL;
	GtkImage* _tmp4_;
	GtkWidget* _tmp5_;
	GtkOverlay* _tmp6_ = NULL;
	GtkOverlay* _tmp7_;
	GtkImage* _tmp8_;
	GtkLabel* _tmp9_ = NULL;
	GtkLabel* _tmp10_ = NULL;
	GtkLabel* _tmp11_;
	GtkStyleContext* _tmp12_;
	GtkLabel* _tmp13_;
	GtkStyleContext* _tmp14_;
	GtkGrid* titles = NULL;
	GtkGrid* _tmp15_ = NULL;
	GtkGrid* _tmp16_;
	GtkOverlay* _tmp17_;
	GtkGrid* _tmp18_;
	GtkLabel* _tmp19_;
	GtkGrid* _tmp20_;
	GtkLabel* _tmp21_;
	GtkEventBox* titles_events = NULL;
	GtkEventBox* _tmp22_ = NULL;
	GtkEventBox* _tmp23_;
	GtkGrid* _tmp24_;
	GtkButton* _tmp25_ = NULL;
	GtkButton* _tmp26_;
	GtkStyleContext* _tmp27_;
	GtkButton* _tmp28_ = NULL;
	GtkButton* _tmp29_;
	GtkStyleContext* _tmp30_;
	GtkButton* _tmp31_ = NULL;
	GtkButton* _tmp32_;
	GtkStyleContext* _tmp33_;
	GtkEventBox* _tmp34_;
	GtkButton* _tmp35_;
	GtkButton* _tmp36_;
	GtkButton* _tmp37_;
	SoundServicesMprisClient* _tmp38_;
	SoundServicesMprisClient* _tmp39_;
	GtkEventBox* _tmp40_;
	GtkButton* _tmp41_;
	GtkButton* _tmp42_;
	GtkButton* _tmp43_;
	parent_class = G_OBJECT_CLASS (sound_widgets_player_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SOUND_WIDGETS_TYPE_PLAYER_ROW, SoundWidgetsPlayerRow);
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("application-default-icon");
	_g_object_unref0 (self->priv->app_icon);
	self->priv->app_icon = (GIcon*) _tmp0_;
	_tmp1_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->load_remote_art_cancel);
	self->priv->load_remote_art_cancel = _tmp1_;
	_tmp2_ = (GtkImage*) gtk_image_new ();
	gtk_image_set_pixel_size (_tmp2_, ICON_SIZE);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->background);
	self->priv->background = _tmp2_;
	_tmp3_ = (GtkImage*) gtk_image_new_from_resource ("/io/elementary/wingpanel/sound/image-mask.svg");
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp3_, TRUE);
	gtk_image_set_pixel_size (_tmp3_, 48);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->mask);
	self->priv->mask = _tmp3_;
	_tmp4_ = self->priv->background;
	_tmp5_ = _g_object_ref0 ((GtkWidget*) _tmp4_);
	_tmp6_ = (GtkOverlay*) gtk_overlay_new ();
	gtk_widget_set_can_focus ((GtkWidget*) _tmp6_, TRUE);
	g_object_set ((GtkContainer*) _tmp6_, "child", _tmp5_, NULL);
	_g_object_unref0 (_tmp5_);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp6_, 2);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp6_, 4);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp6_, 4);
	g_object_ref_sink (_tmp6_);
	overlay = _tmp6_;
	_tmp7_ = overlay;
	_tmp8_ = self->priv->mask;
	gtk_overlay_add_overlay (_tmp7_, (GtkWidget*) _tmp8_);
	_tmp9_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_label_set_ellipsize (_tmp9_, PANGO_ELLIPSIZE_END);
	gtk_label_set_max_width_chars (_tmp9_, 16);
	gtk_widget_set_valign ((GtkWidget*) _tmp9_, GTK_ALIGN_END);
	gtk_label_set_width_chars (_tmp9_, 16);
	gtk_label_set_xalign (_tmp9_, (gfloat) 0);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->title_label);
	self->priv->title_label = _tmp9_;
	_tmp10_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_label_set_ellipsize (_tmp10_, PANGO_ELLIPSIZE_END);
	gtk_widget_set_halign ((GtkWidget*) _tmp10_, GTK_ALIGN_START);
	gtk_widget_set_valign ((GtkWidget*) _tmp10_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->artist_label);
	self->priv->artist_label = _tmp10_;
	_tmp11_ = self->priv->artist_label;
	_tmp12_ = gtk_widget_get_style_context ((GtkWidget*) _tmp11_);
	gtk_style_context_add_class (_tmp12_, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp13_ = self->priv->artist_label;
	_tmp14_ = gtk_widget_get_style_context ((GtkWidget*) _tmp13_);
	gtk_style_context_add_class (_tmp14_, GRANITE_STYLE_CLASS_SMALL_LABEL);
	_tmp15_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp15_, 3);
	g_object_ref_sink (_tmp15_);
	titles = _tmp15_;
	_tmp16_ = titles;
	_tmp17_ = overlay;
	gtk_grid_attach (_tmp16_, (GtkWidget*) _tmp17_, 0, 0, 1, 2);
	_tmp18_ = titles;
	_tmp19_ = self->priv->title_label;
	gtk_grid_attach (_tmp18_, (GtkWidget*) _tmp19_, 1, 0, 1, 1);
	_tmp20_ = titles;
	_tmp21_ = self->priv->artist_label;
	gtk_grid_attach (_tmp20_, (GtkWidget*) _tmp21_, 1, 1, 1, 1);
	_tmp22_ = (GtkEventBox*) gtk_event_box_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp22_, TRUE);
	g_object_ref_sink (_tmp22_);
	titles_events = _tmp22_;
	_tmp23_ = titles_events;
	_tmp24_ = titles;
	gtk_container_add ((GtkContainer*) _tmp23_, (GtkWidget*) _tmp24_);
	_tmp25_ = (GtkButton*) gtk_button_new_from_icon_name ("media-skip-backward-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp25_, FALSE);
	gtk_widget_set_valign ((GtkWidget*) _tmp25_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp25_);
	_g_object_unref0 (self->priv->prev_btn);
	self->priv->prev_btn = _tmp25_;
	_tmp26_ = self->priv->prev_btn;
	_tmp27_ = gtk_widget_get_style_context ((GtkWidget*) _tmp26_);
	gtk_style_context_add_class (_tmp27_, "circular");
	_tmp28_ = (GtkButton*) gtk_button_new_from_icon_name ("media-playback-start-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp28_, TRUE);
	gtk_widget_set_valign ((GtkWidget*) _tmp28_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (self->priv->play_btn);
	self->priv->play_btn = _tmp28_;
	_tmp29_ = self->priv->play_btn;
	_tmp30_ = gtk_widget_get_style_context ((GtkWidget*) _tmp29_);
	gtk_style_context_add_class (_tmp30_, "circular");
	_tmp31_ = (GtkButton*) gtk_button_new_from_icon_name ("media-skip-forward-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp31_, FALSE);
	gtk_widget_set_valign ((GtkWidget*) _tmp31_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp31_);
	_g_object_unref0 (self->priv->next_btn);
	self->priv->next_btn = _tmp31_;
	_tmp32_ = self->priv->next_btn;
	_tmp33_ = gtk_widget_get_style_context ((GtkWidget*) _tmp32_);
	gtk_style_context_add_class (_tmp33_, "circular");
	gtk_box_set_spacing ((GtkBox*) self, 6);
	gtk_widget_set_margin_end ((GtkWidget*) self, 12);
	_tmp34_ = titles_events;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp34_);
	_tmp35_ = self->priv->prev_btn;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp35_);
	_tmp36_ = self->priv->play_btn;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp36_);
	_tmp37_ = self->priv->next_btn;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp37_);
	_tmp38_ = sound_widgets_player_row_get_client (self);
	_tmp39_ = _tmp38_;
	if (_tmp39_ != NULL) {
		sound_widgets_player_row_connect_to_client (self);
		sound_widgets_player_row_update_play_status (self);
		sound_widgets_player_row_update_from_meta (self);
		sound_widgets_player_row_update_controls (self);
	}
	_tmp40_ = titles_events;
	g_signal_connect_object ((GtkWidget*) _tmp40_, "button-press-event", (GCallback) _sound_widgets_player_row_raise_player_gtk_widget_button_press_event, self, 0);
	_tmp41_ = self->priv->prev_btn;
	g_signal_connect_object (_tmp41_, "clicked", (GCallback) __sound_widgets_player_row___lambda24__gtk_button_clicked, self, 0);
	_tmp42_ = self->priv->play_btn;
	g_signal_connect_object (_tmp42_, "clicked", (GCallback) __sound_widgets_player_row___lambda27__gtk_button_clicked, self, 0);
	_tmp43_ = self->priv->next_btn;
	g_signal_connect_object (_tmp43_, "clicked", (GCallback) __sound_widgets_player_row___lambda30__gtk_button_clicked, self, 0);
	_g_object_unref0 (titles_events);
	_g_object_unref0 (titles);
	_g_object_unref0 (overlay);
	return obj;
}

static void
sound_widgets_player_row_base_init (SoundWidgetsPlayerRowClass * klass)
{
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "player-row");
}

static void
sound_widgets_player_row_class_init (SoundWidgetsPlayerRowClass * klass,
                                     gpointer klass_data)
{
	sound_widgets_player_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SoundWidgetsPlayerRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_sound_widgets_player_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sound_widgets_player_row_set_property;
	G_OBJECT_CLASS (klass)->constructor = sound_widgets_player_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = sound_widgets_player_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_WIDGETS_PLAYER_ROW_APP_INFO_PROPERTY, sound_widgets_player_row_properties[SOUND_WIDGETS_PLAYER_ROW_APP_INFO_PROPERTY] = g_param_spec_object ("app-info", "app-info", "app-info", g_app_info_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_WIDGETS_PLAYER_ROW_CLIENT_PROPERTY, sound_widgets_player_row_properties[SOUND_WIDGETS_PLAYER_ROW_CLIENT_PROPERTY] = g_param_spec_object ("client", "client", "client", SOUND_SERVICES_TYPE_MPRIS_CLIENT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	sound_widgets_player_row_signals[SOUND_WIDGETS_PLAYER_ROW_CLOSE_SIGNAL] = g_signal_new ("close", SOUND_WIDGETS_TYPE_PLAYER_ROW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
sound_widgets_player_row_instance_init (SoundWidgetsPlayerRow * self,
                                        gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = sound_widgets_player_row_get_instance_private (self);
	self->priv->background = NULL;
	self->priv->launched_by_indicator = FALSE;
	_tmp0_ = g_strdup (_ ("Music player"));
	self->priv->app_name = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->mpris_name = _tmp1_;
	self->priv->client_ = NULL;
	self->priv->mp_client = NULL;
}

static void
sound_widgets_player_row_finalize (GObject * obj)
{
	SoundWidgetsPlayerRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SOUND_WIDGETS_TYPE_PLAYER_ROW, SoundWidgetsPlayerRow);
	_g_object_unref0 (self->priv->background);
	_g_object_unref0 (self->priv->mask);
	_g_object_unref0 (self->priv->title_label);
	_g_object_unref0 (self->priv->artist_label);
	_g_object_unref0 (self->priv->prev_btn);
	_g_object_unref0 (self->priv->play_btn);
	_g_object_unref0 (self->priv->next_btn);
	_g_object_unref0 (self->priv->app_icon);
	_g_object_unref0 (self->priv->load_remote_art_cancel);
	_g_free0 (self->priv->app_name);
	_g_free0 (self->priv->last_art_url);
	_g_free0 (self->mpris_name);
	_g_object_unref0 (self->priv->ainfo);
	_g_object_unref0 (self->priv->client_);
	_g_object_unref0 (self->priv->mp_client);
	G_OBJECT_CLASS (sound_widgets_player_row_parent_class)->finalize (obj);
}

/**
 * A PlayerRow is simply used to control and display information in a two-way
 * fashion with an underlying MPRIS provider (MediaPlayer2)
 * It is "designed" to be self contained and added to a large UI, enabling multiple
 * MPRIS clients to be controlled with multiple widgets
 */
static GType
sound_widgets_player_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SoundWidgetsPlayerRowClass), (GBaseInitFunc) sound_widgets_player_row_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sound_widgets_player_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SoundWidgetsPlayerRow), 0, (GInstanceInitFunc) sound_widgets_player_row_instance_init, NULL };
	GType sound_widgets_player_row_type_id;
	sound_widgets_player_row_type_id = g_type_register_static (gtk_box_get_type (), "SoundWidgetsPlayerRow", &g_define_type_info, 0);
	SoundWidgetsPlayerRow_private_offset = g_type_add_instance_private (sound_widgets_player_row_type_id, sizeof (SoundWidgetsPlayerRowPrivate));
	return sound_widgets_player_row_type_id;
}

GType
sound_widgets_player_row_get_type (void)
{
	static volatile gsize sound_widgets_player_row_type_id__once = 0;
	if (g_once_init_enter (&sound_widgets_player_row_type_id__once)) {
		GType sound_widgets_player_row_type_id;
		sound_widgets_player_row_type_id = sound_widgets_player_row_get_type_once ();
		g_once_init_leave (&sound_widgets_player_row_type_id__once, sound_widgets_player_row_type_id);
	}
	return sound_widgets_player_row_type_id__once;
}

static void
_vala_sound_widgets_player_row_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	SoundWidgetsPlayerRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SOUND_WIDGETS_TYPE_PLAYER_ROW, SoundWidgetsPlayerRow);
	switch (property_id) {
		case SOUND_WIDGETS_PLAYER_ROW_APP_INFO_PROPERTY:
		g_value_set_object (value, sound_widgets_player_row_get_app_info (self));
		break;
		case SOUND_WIDGETS_PLAYER_ROW_CLIENT_PROPERTY:
		g_value_set_object (value, sound_widgets_player_row_get_client (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sound_widgets_player_row_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	SoundWidgetsPlayerRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SOUND_WIDGETS_TYPE_PLAYER_ROW, SoundWidgetsPlayerRow);
	switch (property_id) {
		case SOUND_WIDGETS_PLAYER_ROW_APP_INFO_PROPERTY:
		sound_widgets_player_row_set_app_info (self, g_value_get_object (value));
		break;
		case SOUND_WIDGETS_PLAYER_ROW_CLIENT_PROPERTY:
		sound_widgets_player_row_set_client (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

