/*
 * Xournal++
 *
 * Static project constants
 *
 * @author Xournal++ Team
 * https://github.com/xournalpp/xournalpp
 *
 * @license GNU GPLv2 or later
 */

#pragma once

/* --- Project info --- */

/**
 * Full name of this project and package
 */
constexpr auto PROJECT_NAME = "xournalpp";

/**
 * Project version number
 */
constexpr auto PROJECT_VERSION = "1.3.1";

/**
 * Address where bug reports for this project should be sent
 */
constexpr auto PROJECT_BUGREPORT = "https://github.com/xournalpp/xournalpp/issues/new?assignees=&labels=bug&projects=&template=bug_report.yml";

/**
 * Address where crash reports for this project should be sent
 */
constexpr auto PROJECT_CRASHREPORT = "https://github.com/xournalpp/xournalpp/issues/new?template=crash_report.yml";

/**
 * Full name and version of this project
 */
constexpr auto PROJECT_STRING = "xournalpp 1.3.1";

/**
 * Project URL
 */
constexpr auto PROJECT_HOMEPAGE_URL = "https://xournalpp.github.io/";

/**
 * File format version
 */
constexpr int FILE_FORMAT_VERSION = 4;


/* --- I18N --- */

/**
 * Enable i18n
 */
#define ENABLE_NLS

/**
 * Gettext package
 */
constexpr auto GETTEXT_PACKAGE = "xournalpp";
