// generated by Fast Light User Interface Designer (fluid) version 1.0404

#include "SUBnoteUI.h"
// SubNoteUI.cc
// Original ZynAddSubFX author Nasca Octavian Paul
// Copyright (C) 2002-2005 Nasca Octavian Paul
// Copyright 2009-2011, Alan Calvert
// Copyright 2015-2025, Will Godfrey & others

// This file is part of yoshimi, which is free software: you can redistribute
// it and/or modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either version 2 of
// the License, or (at your option) any later version.

// yoshimi is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.   See the GNU General Public License (version 2 or
// later) for more details.

// You should have received a copy of the GNU General Public License along with
// yoshimi; if not, write to the Free Software Foundation, Inc., 51 Franklin
// Street, Fifth Floor, Boston, MA  02110-1301, USA.

// This file is derivative of ZynAddSubFX original code


#include "MasterUI.h"
#include "Misc/SynthHelper.h"
    using synth::getDetune;
#include "Misc/TextMsgBuffer.h"

    namespace { // Implementation details...
        TextMsgBuffer& textMsgBuffer = TextMsgBuffer::instance();
    }

void SUBnoteharmonic::cb_mag_i(mwheel_slider* o, void*) {
  //
          int x = 0;
          if (Fl::event_button() != 3)
              x = lrint(o->value());
          else
          {
              if (n == 0)
                  x = 127;
              o->value(x);
          }
          if (n == 0)
              o->selection_color(setSlider(o->value(),127));
          else
              o->selection_color(setSlider(o->value(),0));
          send_data(0, TOPLEVEL::insert::harmonicAmplitude, n, x, TOPLEVEL::type::Integer);
}
void SUBnoteharmonic::cb_mag(mwheel_slider* o, void* v) {
  ((SUBnoteharmonic*)(o->parent()->user_data()))->cb_mag_i(o,v);
}

void SUBnoteharmonic::cb_bw_i(mwheel_slider* o, void*) {
  //
          int x = 64;
          if (Fl::event_button() != 3)
              x = 64 + lrint(o->value());
          else
              o->value(0);
          o->selection_color(setSlider(o->value(),0));
          send_data(0, TOPLEVEL::insert::harmonicBandwidth, n, x, TOPLEVEL::type::Integer);
}
void SUBnoteharmonic::cb_bw(mwheel_slider* o, void* v) {
  ((SUBnoteharmonic*)(o->parent()->user_data()))->cb_bw_i(o,v);
}

Fl_Group* SUBnoteharmonic::make_window() {
  { harmonic = new Fl_Group(0, 0, 50, 300);
    harmonic->box(FL_NO_BOX);
    harmonic->color(FL_BACKGROUND_COLOR);
    harmonic->selection_color(FL_BACKGROUND_COLOR);
    harmonic->labeltype(FL_NO_LABEL);
    harmonic->labelfont(0);
    harmonic->labelsize(14);
    harmonic->labelcolor(FL_FOREGROUND_COLOR);
    harmonic->user_data((void*)(this));
    harmonic->align(Fl_Align(FL_ALIGN_TOP));
    harmonic->when(FL_WHEN_RELEASE);
    { mwheel_slider* o = mag = new mwheel_slider(0, 2, 15, 131);
      mag->tooltip("Harmonic\'s magnitude");
      mag->type(4);
      mag->box(FL_FLAT_BOX);
      mag->color(FL_BACKGROUND_COLOR);
      mag->selection_color(FL_BACKGROUND_COLOR);
      mag->labeltype(FL_NORMAL_LABEL);
      mag->labelfont(0);
      mag->labelsize(14);
      mag->labelcolor((Fl_Color)64);
      mag->minimum(127);
      mag->maximum(0);
      mag->step(1);
      mag->value(127);
      mag->callback((Fl_Callback*)cb_mag);
      mag->align(Fl_Align(FL_ALIGN_BOTTOM));
      mag->when(FL_WHEN_CHANGED);
      o->setValueType(VC_SubHarmonicMagnitude); o->useCustomTip(true);
    } // mwheel_slider* mag
    { mwheel_slider* o = bw = new mwheel_slider(0, 166, 15, 128);
      bw->tooltip("Harmonic\'s bandwidth multiplier");
      bw->type(4);
      bw->box(FL_FLAT_BOX);
      bw->color(FL_BACKGROUND_COLOR);
      bw->selection_color(FL_BACKGROUND_COLOR);
      bw->labeltype(FL_NORMAL_LABEL);
      bw->labelfont(0);
      bw->labelsize(14);
      bw->labelcolor((Fl_Color)64);
      bw->minimum(63);
      bw->maximum(-64);
      bw->step(1);
      bw->callback((Fl_Callback*)cb_bw);
      bw->align(Fl_Align(FL_ALIGN_BOTTOM));
      bw->when(FL_WHEN_CHANGED);
      o->setValueType(VC_SubBandwidthRel);
      o->useCustomTip(true);
    } // mwheel_slider* bw
    { Fl_Box* o = h_dash = new Fl_Box(16, 227, 10, 3);
      h_dash->box(FL_FLAT_BOX);
      h_dash->color(FL_DARK3);
      if (n+1==MAX_SUB_HARMONICS) o->hide();
    } // Fl_Box* h_dash
    { Fl_Box* o = h_num = new Fl_Box(0, 142, 15, 15, "01");
      h_num->labelfont(1);
      h_num->labelsize(12);
      h_num->labelcolor((Fl_Color)64);
      h_num->align(Fl_Align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE));
      char tmp[12];snprintf(tmp,12,"%d",n+1);o->label(strdup(tmp));
    } // Fl_Box* h_num
    harmonic->resizable(harmonic);
    harmonic->end();
  } // Fl_Group* harmonic
  return harmonic;
}

SUBnoteharmonic::SUBnoteharmonic(int x,int y, int w, int h, const char *label):Fl_Group(x,y,w,h,label) {
  n=0;
}

void SUBnoteharmonic::send_data(int action, int insert, int control, float value, int type) {
  //
          type |= TOPLEVEL::type::Write;
          collect_writeData(synth, value, action, type, control, npart, kititem, PART::engine::subSynth, insert);
}

void SUBnoteharmonic::init(SUBnoteParameters *pars_, int n_, int npart_, int kititem_) {
  //
      pars=pars_;
      synth = & pars->getSynthEngine();
      n=n_;
      npart = npart_;
      kititem = kititem_;
      make_window();
      refresh();
      harmonic->show();
      end();
}

void SUBnoteharmonic::refresh() {
  //
          unsigned char magVal = collect_readData(synth, 0, n, npart, kititem, PART::engine::subSynth, TOPLEVEL::insert::harmonicAmplitude);
          mag->value(magVal);
          if (n == 0)
              mag->selection_color(setSlider(magVal,127));
          else
              mag->selection_color(setSlider(magVal,0));

          unsigned char bwVal = collect_readData(synth, 0, n, npart, kititem, PART::engine::subSynth, TOPLEVEL::insert::harmonicBandwidth) - 64;
          bw->value(bwVal);
          bw->selection_color(setSlider(bwVal,0));
          ;
}

SUBnoteharmonic::~SUBnoteharmonic() {
  //
      harmonic->hide();
      hide();
}

void SUBnoteUI::cb_SUBparameters_i(ScaleTrackedWindow* o, void*) {
  //
      if (subSeen)
          saveWin(synth,o->w(), SUBparameters->h(),o->x(), o->y(), false, "SubSynth");
      subSeen = false;
      o->hide();
}
void SUBnoteUI::cb_SUBparameters(ScaleTrackedWindow* o, void* v) {
  ((SUBnoteUI*)(o->user_data()))->cb_SUBparameters_i(o,v);
}

void SUBnoteUI::cb_vol_i(WidgetPDial* o, void*) {
  //
            o->selection_color(setKnob(o->value(),96));

            send_data (0, SUBSYNTH::control::volume, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_vol(WidgetPDial* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_vol_i(o,v);
}

void SUBnoteUI::cb_vsns_i(WidgetPDial* o, void*) {
  //
            o->selection_color(setKnob(o->value(),90));
            send_data (0, SUBSYNTH::control::velocitySense, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_vsns(WidgetPDial* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_vsns_i(o,v);
}

void SUBnoteUI::cb_pan_i(WidgetPDial* o, void*) {
  //
            o->selection_color(setKnob(o->value(),64));
            send_data (0, SUBSYNTH::control::panning, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_pan(WidgetPDial* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_pan_i(o,v);
}

void SUBnoteUI::cb_panwidth_i(WidgetPDial* o, void*) {
  //
            o->selection_color(setKnob(o->value(),63));
            send_data (0, SUBSYNTH::control::randomWidth, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_panwidth(WidgetPDial* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_panwidth_i(o,v);
}

void SUBnoteUI::cb_randompan_i(Fl_Check_Button2* o, void*) {
  //
          int tmp = o->value();
          if (tmp == 0)
              panwidth->deactivate();
          else
              panwidth->activate();
          send_data(0, SUBSYNTH::control::enableRandomPan, tmp, TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_randompan(Fl_Check_Button2* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_randompan_i(o,v);
}

void SUBnoteUI::cb_freqee_i(Fl_Check_Button2* o, void*) {
  //
            if (o->value() == 0)
                freqenvelopegroup->deactivate();
            else
                freqenvelopegroup->activate();
            o->show();
            freqsettingsui->redraw();
            send_data (0, SUBSYNTH::control::enableFrequencyEnvelope, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_freqee(Fl_Check_Button2* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_freqee_i(o,v);
}

void SUBnoteUI::cb_freqlfo_i(Fl_Check_Button2* o, void*) {
  //
          if (o->value() == 0)
              freqlfogroup->deactivate();
          else
              freqlfogroup->activate();
          o->show();
          freqsettingsui->redraw();
          send_data (0, SUBSYNTH::control::enableFrequencyLFO, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_freqlfo(Fl_Check_Button2* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_freqlfo_i(o,v);
}

void SUBnoteUI::cb_octave_i(Fl_Counter* o, void*) {
  //
            send_data (0, SUBSYNTH::control::octave, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_octave(Fl_Counter* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_octave_i(o,v);
}

void SUBnoteUI::cb_bend_i(WidgetPDial* o, void*) {
  //
            o->selection_color(setKnob(o->value(),88));
            send_data(0, SUBSYNTH::control::pitchBendAdjustment, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_bend(WidgetPDial* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_bend_i(o,v);
}

void SUBnoteUI::cb_offset_i(WidgetPDial* o, void*) {
  //
            o->selection_color(setKnob(o->value(),64));
            send_data(0, SUBSYNTH::control::pitchBendOffset, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_offset(WidgetPDial* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_offset_i(o,v);
}

void SUBnoteUI::cb_hz440_i(Fl_Check_Button2* o, void*) {
  //
            int x = (int) o->value();

            if (x == 0)
                fixedfreqetdial->deactivate();
            else
                fixedfreqetdial->activate();
            send_data (0, SUBSYNTH::control::baseFrequencyAs440Hz, x, TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_hz440(Fl_Check_Button2* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_hz440_i(o,v);
}

void SUBnoteUI::cb_fixedfreqetdial_i(WidgetPDial* o, void*) {
  //
            o->selection_color(setKnob(o->value(),0));
            send_data (0, SUBSYNTH::control::equalTemperVariation, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_fixedfreqetdial(WidgetPDial* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_fixedfreqetdial_i(o,v);
}

void SUBnoteUI::cb_detune_i(mwheel_slider_rev* o, void*) {
  //
            o->selection_color(setSlider(o->value(),0));
            send_data (TOPLEVEL::action::forceUpdate, SUBSYNTH::control::detuneFrequency, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_detune(mwheel_slider_rev* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_detune_i(o,v);
}

void SUBnoteUI::cb_detunetype_i(Fl_Choice* o, void*) {
  //

            send_data (TOPLEVEL::action::forceUpdate, SUBSYNTH::control::detuneType, o->value() + 1, TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_detunetype(Fl_Choice* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_detunetype_i(o,v);
}

void SUBnoteUI::cb_coarsedet_i(Fl_Counter* o, void*) {
  //
            int k = (int) o->value();
            if (k < 0)
                k += 1024;

            send_data (0, SUBSYNTH::control::coarseDetune, k, TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_coarsedet(Fl_Counter* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_coarsedet_i(o,v);
}

void SUBnoteUI::cb_detunevalueoutput_i(Fl_Value_Output* o, void*) {
  //
                o->value(getDetune(detunetype->value()+1,0, detune->value()+8192));
                ;
}
void SUBnoteUI::cb_detunevalueoutput(Fl_Value_Output* o, void* v) {
  ((SUBnoteUI*)(o->parent()->user_data()))->cb_detunevalueoutput_i(o,v);
}

void SUBnoteUI::cb_bwee_i(Fl_Check_Button2* o, void*) {
  //
            if (o->value() == 0)
                bandwidthenvelopegroup->deactivate();
            else
                bandwidthenvelopegroup->activate();
            o->show();
            bandwidthsettingsui->redraw();
            send_data (0, SUBSYNTH::control::enableBandwidthEnvelope, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_bwee(Fl_Check_Button2* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_bwee_i(o,v);
}

void SUBnoteUI::cb_bandwidth_i(mwheel_slider_rev* o, void*) {
  //
            o->selection_color(setSlider(o->value(),40));
            send_data (0, SUBSYNTH::control::bandwidth, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_bandwidth(mwheel_slider_rev* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_bandwidth_i(o,v);
}

void SUBnoteUI::cb_bwidthscale_i(mwheel_slider_rev* o, void*) {
  //
            o->selection_color(setSlider(o->value(),0));
            send_data (0, SUBSYNTH::control::bandwidthScale, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_bwidthscale(mwheel_slider_rev* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_bwidthscale_i(o,v);
}

void SUBnoteUI::cb_spreadpar1_i(WidgetPDial* o, void*) {
  //
            o->selection_color(setKnob(o->value(),0));
            send_data (TOPLEVEL::action::forceUpdate, SUBSYNTH::control::overtoneParameter1, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_spreadpar1(WidgetPDial* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_spreadpar1_i(o,v);
}

void SUBnoteUI::cb_spreadpar2_i(WidgetPDial* o, void*) {
  //
            o->selection_color(setKnob(o->value(),0));
            send_data (0, SUBSYNTH::control::overtoneParameter2, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_spreadpar2(WidgetPDial* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_spreadpar2_i(o,v);
}

void SUBnoteUI::cb_spreadpar3_i(WidgetPDial* o, void*) {
  //
            o->selection_color(setKnob(o->value(),0));
            send_data (0, SUBSYNTH::control::overtoneForceHarmonics, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_spreadpar3(WidgetPDial* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_spreadpar3_i(o,v);
}

void SUBnoteUI::cb_spreadtype_i(Fl_Choice* o, void*) {
  //
            send_data (TOPLEVEL::action::forceUpdate, SUBSYNTH::control::overtonePosition, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_spreadtype(Fl_Choice* o, void* v) {
  ((SUBnoteUI*)(o->parent()->user_data()))->cb_spreadtype_i(o,v);
}

void SUBnoteUI::cb_filtere_i(Fl_Check_Button2* o, void*) {
  //
          if (o->value() == 0)
              globalfiltergroup->deactivate();
          else
              globalfiltergroup->activate();
          o->show();
          globalfiltergroup->redraw();
          send_data (0, SUBSYNTH::control::enableFilter, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_filtere(Fl_Check_Button2* o, void* v) {
  ((SUBnoteUI*)(o->parent()->user_data()))->cb_filtere_i(o,v);
}

void SUBnoteUI::cb_filterstages_i(Fl_Counter* o, void*) {
  //
            send_data (0, SUBSYNTH::control::filterStages, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_filterstages(Fl_Counter* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_filterstages_i(o,v);
}

void SUBnoteUI::cb_magtype_i(Fl_Choice* o, void*) {
  //
            send_data (0, SUBSYNTH::control::magType, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_magtype(Fl_Choice* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_magtype_i(o,v);
}

void SUBnoteUI::cb_start_i(Fl_Choice* o, void*) {
  //
            send_data (0, SUBSYNTH::control::startPosition, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_start(Fl_Choice* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_start_i(o,v);
}

void SUBnoteUI::cb_stereo_i(Fl_Check_Button2* o, void*) {
  //
          send_data (0, SUBSYNTH::control::stereo, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_stereo(Fl_Check_Button2* o, void* v) {
  ((SUBnoteUI*)(o->parent()->user_data()))->cb_stereo_i(o,v);
}

void SUBnoteUI::cb_subClear_i(Fl_Button* o, void*) {
  //
          send_data (TOPLEVEL::action::forceUpdate, SUBSYNTH::control::clearHarmonics, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_subClear(Fl_Button* o, void* v) {
  ((SUBnoteUI*)(o->parent()->user_data()))->cb_subClear_i(o,v);
}

void SUBnoteUI::cb_subCopy_i(Fl_Button*, void*) {
  //
          synth->getGuiMaster()->getPresetsUi()->Ucopy(npart, kititem, PART::engine::subSynth);
}
void SUBnoteUI::cb_subCopy(Fl_Button* o, void* v) {
  ((SUBnoteUI*)(o->parent()->user_data()))->cb_subCopy_i(o,v);
}

void SUBnoteUI::cb_subPaste_i(Fl_Button*, void*) {
  //
          synth->getGuiMaster()->getPresetsUi()->Upaste(npart, kititem, PART::engine::subSynth);
}
void SUBnoteUI::cb_subPaste(Fl_Button* o, void* v) {
  ((SUBnoteUI*)(o->parent()->user_data()))->cb_subPaste_i(o,v);
}

void SUBnoteUI::cb_subClose_i(Fl_Button*, void*) {
  //
          saveWin(synth, SUBparameters->w(), SUBparameters->h(), SUBparameters->x(), SUBparameters->y(), false, "SubSynth");
          subSeen = false;
          SUBparameters->hide();
          if ((Fl::event_button() == 3))
          {
              if (synth->getGuiMaster()->partui->partKitOn)
                  synth->getGuiMaster()->partui->instrumentkitlist->show();
              else
                  synth->getGuiMaster()->partui->instrumenteditwindow->show();
          }
}
void SUBnoteUI::cb_subClose(Fl_Button* o, void* v) {
  ((SUBnoteUI*)(o->parent()->user_data()))->cb_subClose_i(o,v);
}

ScaleTrackedWindow* SUBnoteUI::make_window() {
// randompan MUST be placed after panwidth
  { ScaleTrackedWindow* o = SUBparameters = new ScaleTrackedWindow(805, 551, "SUBsynth Parameters");
    SUBparameters->box(FL_FLAT_BOX);
    SUBparameters->color(FL_BACKGROUND_COLOR);
    SUBparameters->selection_color(FL_BACKGROUND_COLOR);
    SUBparameters->labeltype(FL_NO_LABEL);
    SUBparameters->labelfont(0);
    SUBparameters->labelsize(14);
    SUBparameters->labelcolor((Fl_Color)64);
    SUBparameters->callback((Fl_Callback*)cb_SUBparameters, (void*)(this));
    SUBparameters->align(Fl_Align(FL_ALIGN_TOP));
    SUBparameters->when(FL_WHEN_RELEASE);
    { frame = new Fl_Scroll(4, 221, 506, 326);
      frame->type(1);
      frame->box(FL_THIN_UP_BOX);
      frame->when(FL_WHEN_CHANGED);
      { Fl_Pack* o = harmonics = new Fl_Pack(4, 229, 505, 290);
        harmonics->type(1);
        new Fl_Box(0,0,9,o->h());
        for (int i=0;i<MAX_SUB_HARMONICS;i++){h[i]=new SUBnoteharmonic(0,0,20,o->h(),"");h[i]->init(pars, i, npart, kititem);}
        new Fl_Box(0,0,3,o->h());
        harmonics->end();
        Fl_Group::current()->resizable(harmonics);
      } // Fl_Pack* harmonics
      frame->end();
    } // Fl_Scroll* frame
    { ampgrp = new Fl_Group(4, 5, 285, 215);
      ampgrp->box(FL_THIN_UP_FRAME);
      ampgrp->labelfont(1);
      ampgrp->labelsize(11);
      ampgrp->labelcolor((Fl_Color)64);
      ampgrp->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
      { EnvelopeUI* o = ampenv = new EnvelopeUI(9, 67, 275, 70, "Yoshimi : SubSynth - Amplitude Envelope");
        ampenv->box(FL_FLAT_BOX);
        ampenv->color((Fl_Color)51);
        ampenv->selection_color(FL_BACKGROUND_COLOR);
        ampenv->labeltype(FL_NORMAL_LABEL);
        ampenv->labelfont(0);
        ampenv->labelsize(14);
        ampenv->labelcolor((Fl_Color)64);
        ampenv->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
        ampenv->when(FL_WHEN_RELEASE);
        o->init(pars->AmpEnvelope.get(), npart, kititem, PART::engine::subSynth, 0);
        ampenv->end();
      } // EnvelopeUI* ampenv
      { Fl_Box* o = new Fl_Box(9, 6, 275, 63);
        o->box(FL_PLASTIC_UP_BOX);
        o->color(FL_CYAN);
      } // Fl_Box* o
      { WidgetPDial* o = vol = new WidgetPDial(25, 22, 29, 29, "Volume");
        vol->tooltip("Volume");
        vol->box(FL_ROUND_UP_BOX);
        vol->color(FL_BACKGROUND_COLOR);
        vol->selection_color(FL_INACTIVE_COLOR);
        vol->labeltype(FL_NORMAL_LABEL);
        vol->labelfont(0);
        vol->labelsize(10);
        vol->labelcolor((Fl_Color)64);
        vol->maximum(127);
        vol->step(1);
        vol->callback((Fl_Callback*)cb_vol);
        vol->align(Fl_Align(FL_ALIGN_BOTTOM_RIGHT));
        vol->when(FL_WHEN_CHANGED);
        o->setValueType(VC_InstrumentVolume);
      } // WidgetPDial* vol
      { WidgetPDial* o = vsns = new WidgetPDial(90, 22, 29, 29, "Vel Sens");
        vsns->tooltip("Velocity sensing");
        vsns->box(FL_ROUND_UP_BOX);
        vsns->color(FL_BACKGROUND_COLOR);
        vsns->selection_color(FL_INACTIVE_COLOR);
        vsns->labeltype(FL_NORMAL_LABEL);
        vsns->labelfont(0);
        vsns->labelsize(10);
        vsns->labelcolor((Fl_Color)64);
        vsns->maximum(127);
        vsns->step(1);
        vsns->callback((Fl_Callback*)cb_vsns);
        vsns->align(Fl_Align(FL_ALIGN_BOTTOM));
        vsns->when(FL_WHEN_CHANGED);
        o->setValueType(VC_AmpVelocitySense);
      } // WidgetPDial* vsns
      { WidgetPDial* o = pan = new WidgetPDial(165, 22, 29, 29, "Pan");
        pan->tooltip("Panning");
        pan->box(FL_ROUND_UP_BOX);
        pan->color(FL_BACKGROUND_COLOR);
        pan->selection_color(FL_INACTIVE_COLOR);
        pan->labeltype(FL_NORMAL_LABEL);
        pan->labelfont(0);
        pan->labelsize(10);
        pan->labelcolor((Fl_Color)64);
        pan->maximum(127);
        pan->step(1);
        pan->callback((Fl_Callback*)cb_pan);
        pan->align(Fl_Align(FL_ALIGN_BOTTOM));
        pan->when(FL_WHEN_CHANGED);
        o->setValueType(VC_PanningStd);
      } // WidgetPDial* pan
      { WidgetPDial* o = panwidth = new WidgetPDial(240, 22, 29, 29, "Width");
        panwidth->tooltip("Random Width");
        panwidth->box(FL_ROUND_UP_BOX);
        panwidth->color(FL_BACKGROUND_COLOR);
        panwidth->selection_color(FL_INACTIVE_COLOR);
        panwidth->labeltype(FL_NORMAL_LABEL);
        panwidth->labelfont(0);
        panwidth->labelsize(10);
        panwidth->labelcolor((Fl_Color)64);
        panwidth->maximum(63);
        panwidth->step(1);
        panwidth->value(63);
        panwidth->callback((Fl_Callback*)cb_panwidth);
        panwidth->align(Fl_Align(FL_ALIGN_BOTTOM));
        panwidth->when(FL_WHEN_CHANGED);
        o->setValueType(VC_PanningRandom);
      } // WidgetPDial* panwidth
      { randompan = new Fl_Check_Button2(210, 28, 15, 15, "Rand");
        randompan->tooltip("Enable random panning");
        randompan->box(FL_NO_BOX);
        randompan->down_box(FL_DOWN_BOX);
        randompan->color((Fl_Color)48);
        randompan->selection_color((Fl_Color)64);
        randompan->labeltype(FL_NORMAL_LABEL);
        randompan->labelfont(0);
        randompan->labelsize(11);
        randompan->labelcolor((Fl_Color)64);
        randompan->callback((Fl_Callback*)cb_randompan);
        randompan->align(Fl_Align(FL_ALIGN_TOP));
        randompan->when(FL_WHEN_RELEASE);
      } // Fl_Check_Button2* randompan
      { LFOUI* o = amplfo = new LFOUI(9, 140, 275, 75, "Amplitude LFO");
        amplfo->box(FL_FLAT_BOX);
        amplfo->color((Fl_Color)51);
        amplfo->selection_color(FL_BACKGROUND_COLOR);
        amplfo->labeltype(FL_NORMAL_LABEL);
        amplfo->labelfont(0);
        amplfo->labelsize(14);
        amplfo->labelcolor((Fl_Color)64);
        amplfo->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
        amplfo->when(FL_WHEN_RELEASE);
        o->init(synth, npart, kititem, PART::engine::subSynth,
TOPLEVEL::insertType::amplitude);
        amplfo->end();
      } // LFOUI* amplfo
      { Fl_Box* o = new Fl_Box(140, 22, 4, 38);
        o->box(FL_THIN_DOWN_FRAME);
      } // Fl_Box* o
      { ampLabel = new Fl_Box(135, 10, 20, 12, "AMPLITUDE");
        ampLabel->labelfont(1);
        ampLabel->labelsize(11);
        ampLabel->labelcolor((Fl_Color)64);
      } // Fl_Box* ampLabel
      ampgrp->end();
    } // Fl_Group* ampgrp
    { freqsettingsui = new Fl_Group(510, 5, 293, 215, "FREQUENCY");
      freqsettingsui->box(FL_THIN_UP_FRAME);
      freqsettingsui->labelfont(1);
      freqsettingsui->labelsize(11);
      freqsettingsui->labelcolor((Fl_Color)64);
      freqsettingsui->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
      { EnvelopeUI* o = freqenvelopegroup = new EnvelopeUI(515, 67, 205, 70, "Yoshimi : SubSynth - Frequency Envelope");
        freqenvelopegroup->box(FL_FLAT_BOX);
        freqenvelopegroup->color((Fl_Color)51);
        freqenvelopegroup->selection_color(FL_BACKGROUND_COLOR);
        freqenvelopegroup->labeltype(FL_NORMAL_LABEL);
        freqenvelopegroup->labelfont(0);
        freqenvelopegroup->labelsize(14);
        freqenvelopegroup->labelcolor(FL_FOREGROUND_COLOR);
        freqenvelopegroup->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
        freqenvelopegroup->when(FL_WHEN_RELEASE);
        o->init(pars->FreqEnvelope.get(), npart, kititem, PART::engine::subSynth, 1);
        if (collect_readData(synth, 0, SUBSYNTH::control::enableFrequencyEnvelope, npart, kititem, PART::engine::subSynth) == 0) o->deactivate();
        freqenvelopegroup->end();
      } // EnvelopeUI* freqenvelopegroup
      { LFOUI* o = freqlfogroup = new LFOUI(515, 140, 280, 75, "Frequency LFO");
        freqlfogroup->box(FL_FLAT_BOX);
        freqlfogroup->color((Fl_Color)51);
        freqlfogroup->selection_color(FL_BACKGROUND_COLOR);
        freqlfogroup->labeltype(FL_NORMAL_LABEL);
        freqlfogroup->labelfont(0);
        freqlfogroup->labelsize(14);
        freqlfogroup->labelcolor(FL_FOREGROUND_COLOR);
        freqlfogroup->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
        freqlfogroup->when(FL_WHEN_RELEASE);
        freqlfogroup->deactivate();
        o->init(synth, npart, kititem, PART::engine::subSynth,
TOPLEVEL::insertType::frequency);
        freqlfogroup->end();
      } // LFOUI* freqlfogroup
      { freqee = new Fl_Check_Button2(515, 69, 34, 12, "On");
        freqee->box(FL_NO_BOX);
        freqee->down_box(FL_DOWN_BOX);
        freqee->color(FL_BACKGROUND_COLOR);
        freqee->selection_color((Fl_Color)64);
        freqee->labeltype(FL_NORMAL_LABEL);
        freqee->labelfont(3);
        freqee->labelsize(10);
        freqee->labelcolor((Fl_Color)226);
        freqee->callback((Fl_Callback*)cb_freqee);
        freqee->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
        freqee->when(FL_WHEN_RELEASE);
      } // Fl_Check_Button2* freqee
      { freqlfo = new Fl_Check_Button2(520, 144, 36, 13, "On");
        freqlfo->box(FL_NO_BOX);
        freqlfo->down_box(FL_DOWN_BOX);
        freqlfo->color(FL_BACKGROUND_COLOR);
        freqlfo->selection_color((Fl_Color)64);
        freqlfo->labeltype(FL_NORMAL_LABEL);
        freqlfo->labelfont(3);
        freqlfo->labelsize(10);
        freqlfo->labelcolor((Fl_Color)226);
        freqlfo->callback((Fl_Callback*)cb_freqlfo);
        freqlfo->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
        freqlfo->when(FL_WHEN_RELEASE);
      } // Fl_Check_Button2* freqlfo
      { octavetext = new Fl_Text_Display(516, 19, 50, 7, "Octave");
        octavetext->box(FL_NO_BOX);
        octavetext->labelfont(3);
        octavetext->labelsize(10);
        octavetext->labelcolor((Fl_Color)226);
      } // Fl_Text_Display* octavetext
      { octave = new Fl_Counter(515, 18, 52, 15);
        octave->tooltip("Octave");
        octave->type(1);
        octave->selection_color(FL_BACKGROUND_COLOR);
        octave->labelfont(3);
        octave->labelsize(10);
        octave->labelcolor((Fl_Color)64);
        octave->minimum(-8);
        octave->maximum(7);
        octave->step(1);
        octave->textfont(1);
        octave->textsize(11);
        octave->textcolor((Fl_Color)64);
        octave->callback((Fl_Callback*)cb_octave);
        octave->align(Fl_Align(FL_ALIGN_TOP));
      } // Fl_Counter* octave
      { WidgetPDial* o = bend = new WidgetPDial(570, 21, 20, 20, "Bend");
        bend->tooltip("Pitch bend range scaling");
        bend->box(FL_ROUND_UP_BOX);
        bend->color(FL_BACKGROUND_COLOR);
        bend->selection_color(FL_INACTIVE_COLOR);
        bend->labeltype(FL_NORMAL_LABEL);
        bend->labelfont(0);
        bend->labelsize(10);
        bend->labelcolor((Fl_Color)64);
        bend->maximum(127);
        bend->step(1);
        bend->callback((Fl_Callback*)cb_bend);
        bend->align(Fl_Align(FL_ALIGN_RIGHT));
        bend->when(FL_WHEN_CHANGED);
        o->setValueType(VC_PitchBend);
      } // WidgetPDial* bend
      { WidgetPDial* o = offset = new WidgetPDial(628, 21, 20, 20, "Offset");
        offset->tooltip("Offset of the frequency in Hz.");
        offset->box(FL_ROUND_UP_BOX);
        offset->color(FL_BACKGROUND_COLOR);
        offset->selection_color(FL_INACTIVE_COLOR);
        offset->labeltype(FL_NORMAL_LABEL);
        offset->labelfont(0);
        offset->labelsize(10);
        offset->labelcolor((Fl_Color)64);
        offset->maximum(127);
        offset->step(1);
        offset->callback((Fl_Callback*)cb_offset);
        offset->align(Fl_Align(FL_ALIGN_RIGHT));
        offset->when(FL_WHEN_CHANGED);
        o->setValueType(VC_FreqOffsetHz);
      } // WidgetPDial* offset
      { Fl_Check_Button2* o = hz440 = new Fl_Check_Button2(693, 24, 48, 15, "440Hz");
        hz440->tooltip("set the base frequency to 440Hz");
        hz440->box(FL_NO_BOX);
        hz440->down_box(FL_DOWN_BOX);
        hz440->color(FL_BACKGROUND_COLOR);
        hz440->selection_color((Fl_Color)64);
        hz440->labeltype(FL_NORMAL_LABEL);
        hz440->labelfont(1);
        hz440->labelsize(10);
        hz440->labelcolor((Fl_Color)64);
        hz440->callback((Fl_Callback*)cb_hz440);
        hz440->align(Fl_Align(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE));
        hz440->when(FL_WHEN_RELEASE);
        o->value(collect_readData(synth, 0, SUBSYNTH::control::baseFrequencyAs440Hz, npart, kititem, PART::engine::subSynth));
      } // Fl_Check_Button2* hz440
      { WidgetPDial* o = fixedfreqetdial = new WidgetPDial(750, 21, 20, 20, "Eq.T.");
        fixedfreqetdial->tooltip("How the frequency varies according to the keyboard (leftmost for fixed freque"
"ncy)");
        fixedfreqetdial->box(FL_ROUND_UP_BOX);
        fixedfreqetdial->color(FL_BACKGROUND_COLOR);
        fixedfreqetdial->selection_color(FL_INACTIVE_COLOR);
        fixedfreqetdial->labeltype(FL_NORMAL_LABEL);
        fixedfreqetdial->labelfont(0);
        fixedfreqetdial->labelsize(10);
        fixedfreqetdial->labelcolor((Fl_Color)64);
        fixedfreqetdial->maximum(127);
        fixedfreqetdial->step(1);
        fixedfreqetdial->callback((Fl_Callback*)cb_fixedfreqetdial);
        fixedfreqetdial->align(Fl_Align(FL_ALIGN_RIGHT));
        fixedfreqetdial->when(FL_WHEN_CHANGED);
        o->setValueType(VC_FixedFreqET);
      } // WidgetPDial* fixedfreqetdial
      { mwheel_slider_rev* o = detune = new mwheel_slider_rev(561, 47, 236, 15);
        detune->tooltip("Fine Detune (cents)");
        detune->type(5);
        detune->box(FL_THIN_DOWN_BOX);
        detune->color(FL_BACKGROUND_COLOR);
        detune->selection_color(FL_BACKGROUND_COLOR);
        detune->labeltype(FL_NORMAL_LABEL);
        detune->labelfont(0);
        detune->labelsize(14);
        detune->labelcolor((Fl_Color)64);
        detune->minimum(-8192);
        detune->maximum(8191);
        detune->step(1);
        detune->callback((Fl_Callback*)cb_detune);
        detune->align(Fl_Align(FL_ALIGN_BOTTOM));
        detune->when(FL_WHEN_CHANGED);
        o->selection_color(setSlider(o->value(),0));
      } // mwheel_slider_rev* detune
      { Fl_Choice* o = detunetype = new Fl_Choice(725, 78, 73, 15, "Detune Type");
        detunetype->down_box(FL_BORDER_BOX);
        detunetype->selection_color((Fl_Color)64);
        detunetype->labelsize(10);
        detunetype->labelcolor((Fl_Color)64);
        detunetype->textfont(1);
        detunetype->textsize(10);
        detunetype->textcolor((Fl_Color)64);
        detunetype->callback((Fl_Callback*)cb_detunetype);
        detunetype->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        o->add("L35cents");o->add("L10cents");o->add("E100cents");o->add("E1200cents");
      } // Fl_Choice* detunetype
      { Fl_Counter* o = coarsedet = new Fl_Counter(724, 111, 74, 15, "Coarse Det.");
        coarsedet->tooltip("Coarse Detune");
        coarsedet->selection_color((Fl_Color)64);
        coarsedet->labelsize(10);
        coarsedet->labelcolor((Fl_Color)64);
        coarsedet->minimum(-64);
        coarsedet->maximum(63);
        coarsedet->step(1);
        coarsedet->textfont(1);
        coarsedet->textsize(11);
        coarsedet->textcolor((Fl_Color)64);
        coarsedet->callback((Fl_Callback*)cb_coarsedet);
        coarsedet->align(Fl_Align(FL_ALIGN_TOP));
        o->lstep(10);
      } // Fl_Counter* coarsedet
      freqsettingsui->end();
    } // Fl_Group* freqsettingsui
    { Fl_Value_Output* o = detunevalueoutput = new Fl_Value_Output(515, 47, 45, 15, "Detune");
      detunevalueoutput->labelsize(10);
      detunevalueoutput->labelcolor((Fl_Color)64);
      detunevalueoutput->minimum(-5000);
      detunevalueoutput->maximum(5000);
      detunevalueoutput->textfont(1);
      detunevalueoutput->textsize(10);
      detunevalueoutput->textcolor((Fl_Color)64);
      detunevalueoutput->callback((Fl_Callback*)cb_detunevalueoutput);
      detunevalueoutput->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      o->step(0.01, 1);
    } // Fl_Value_Output* detunevalueoutput
    { Fl_Box* o = new Fl_Box(510, 486, 65, 35);
      o->box(FL_THIN_UP_FRAME);
    } // Fl_Box* o
    { bandwidthsettingsui = new Fl_Group(290, 5, 220, 135, "BANDWIDTH");
      bandwidthsettingsui->box(FL_THIN_UP_FRAME);
      bandwidthsettingsui->labelfont(1);
      bandwidthsettingsui->labelsize(11);
      bandwidthsettingsui->labelcolor((Fl_Color)64);
      bandwidthsettingsui->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
      { EnvelopeUI* o = bandwidthenvelopegroup = new EnvelopeUI(295, 67, 210, 70, "Yoshimi : SubSynth - BandWidth Envelope");
        bandwidthenvelopegroup->box(FL_FLAT_BOX);
        bandwidthenvelopegroup->color((Fl_Color)51);
        bandwidthenvelopegroup->selection_color(FL_BACKGROUND_COLOR);
        bandwidthenvelopegroup->labeltype(FL_NORMAL_LABEL);
        bandwidthenvelopegroup->labelfont(0);
        bandwidthenvelopegroup->labelsize(14);
        bandwidthenvelopegroup->labelcolor(FL_FOREGROUND_COLOR);
        bandwidthenvelopegroup->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
        bandwidthenvelopegroup->when(FL_WHEN_RELEASE);
        o->init(pars->BandWidthEnvelope.get(), npart, kititem, PART::engine::subSynth, 3);
        if (collect_readData(synth, 0, SUBSYNTH::control::enableBandwidthEnvelope, npart, kititem, PART::engine::subSynth)==0) o->deactivate();
        bandwidthenvelopegroup->end();
      } // EnvelopeUI* bandwidthenvelopegroup
      { bwee = new Fl_Check_Button2(295, 69, 34, 12, "On");
        bwee->box(FL_NO_BOX);
        bwee->down_box(FL_DOWN_BOX);
        bwee->color(FL_BACKGROUND_COLOR);
        bwee->selection_color((Fl_Color)64);
        bwee->labeltype(FL_NORMAL_LABEL);
        bwee->labelfont(3);
        bwee->labelsize(10);
        bwee->labelcolor((Fl_Color)226);
        bwee->callback((Fl_Callback*)cb_bwee);
        bwee->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
        bwee->when(FL_WHEN_RELEASE);
      } // Fl_Check_Button2* bwee
      { mwheel_slider_rev* o = bandwidth = new mwheel_slider_rev(295, 40, 115, 15, "Bandwidth");
        bandwidth->tooltip("Base bandwidth, approximate");
        bandwidth->type(5);
        bandwidth->box(FL_THIN_DOWN_BOX);
        bandwidth->color(FL_BACKGROUND_COLOR);
        bandwidth->selection_color(FL_BACKGROUND_COLOR);
        bandwidth->labeltype(FL_NORMAL_LABEL);
        bandwidth->labelfont(0);
        bandwidth->labelsize(10);
        bandwidth->labelcolor((Fl_Color)64);
        bandwidth->maximum(127);
        bandwidth->step(1);
        bandwidth->textcolor((Fl_Color)64);
        bandwidth->callback((Fl_Callback*)cb_bandwidth);
        bandwidth->align(Fl_Align(FL_ALIGN_TOP));
        bandwidth->when(FL_WHEN_CHANGED);
        o->setValueType(VC_SubBandwidth);
        o->useCustomTip(true);
      } // mwheel_slider_rev* bandwidth
      { mwheel_slider_rev* o = bwidthscale = new mwheel_slider_rev(414, 40, 90, 15, "Bandwidth Scale");
        bwidthscale->tooltip("Freq-dep. bw. scaling");
        bwidthscale->type(5);
        bwidthscale->box(FL_THIN_DOWN_BOX);
        bwidthscale->color(FL_BACKGROUND_COLOR);
        bwidthscale->selection_color(FL_BACKGROUND_COLOR);
        bwidthscale->labeltype(FL_NORMAL_LABEL);
        bwidthscale->labelfont(0);
        bwidthscale->labelsize(10);
        bwidthscale->labelcolor((Fl_Color)64);
        bwidthscale->minimum(-64);
        bwidthscale->maximum(63);
        bwidthscale->step(1);
        bwidthscale->textcolor((Fl_Color)64);
        bwidthscale->callback((Fl_Callback*)cb_bwidthscale);
        bwidthscale->align(Fl_Align(FL_ALIGN_TOP));
        bwidthscale->when(FL_WHEN_CHANGED);
        o->setValueType(VC_SubBandwidthScale); o->setGraphicsType(VC_SubBandwidthScale);
        o->useCustomTip(true);
      } // mwheel_slider_rev* bwidthscale
      bandwidthsettingsui->end();
    } // Fl_Group* bandwidthsettingsui
    { spreadGroup = new Fl_Group(290, 140, 220, 80, "OVERTONES");
      spreadGroup->box(FL_THIN_UP_FRAME);
      spreadGroup->labelfont(1);
      spreadGroup->labelsize(11);
      spreadGroup->labelcolor((Fl_Color)64);
      spreadGroup->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
      { spreadpar1 = new WidgetPDial(401, 166, 30, 30, "Par1");
        spreadpar1->box(FL_ROUND_UP_BOX);
        spreadpar1->color(FL_BACKGROUND_COLOR);
        spreadpar1->selection_color(FL_INACTIVE_COLOR);
        spreadpar1->labeltype(FL_NORMAL_LABEL);
        spreadpar1->labelfont(0);
        spreadpar1->labelsize(10);
        spreadpar1->labelcolor((Fl_Color)64);
        spreadpar1->maximum(255);
        spreadpar1->step(1);
        spreadpar1->callback((Fl_Callback*)cb_spreadpar1);
        spreadpar1->align(Fl_Align(FL_ALIGN_BOTTOM));
        spreadpar1->when(FL_WHEN_CHANGED);
      } // WidgetPDial* spreadpar1
      { spreadpar2 = new WidgetPDial(437, 166, 30, 30, "Par2");
        spreadpar2->box(FL_ROUND_UP_BOX);
        spreadpar2->color(FL_BACKGROUND_COLOR);
        spreadpar2->selection_color(FL_INACTIVE_COLOR);
        spreadpar2->labeltype(FL_NORMAL_LABEL);
        spreadpar2->labelfont(0);
        spreadpar2->labelsize(10);
        spreadpar2->labelcolor((Fl_Color)64);
        spreadpar2->maximum(255);
        spreadpar2->step(1);
        spreadpar2->callback((Fl_Callback*)cb_spreadpar2);
        spreadpar2->align(Fl_Align(FL_ALIGN_BOTTOM));
        spreadpar2->when(FL_WHEN_CHANGED);
      } // WidgetPDial* spreadpar2
      { WidgetPDial* o = spreadpar3 = new WidgetPDial(473, 166, 30, 30, "ForceH");
        spreadpar3->tooltip("Move towards closest harmonic");
        spreadpar3->box(FL_ROUND_UP_BOX);
        spreadpar3->color(FL_BACKGROUND_COLOR);
        spreadpar3->selection_color(FL_INACTIVE_COLOR);
        spreadpar3->labeltype(FL_NORMAL_LABEL);
        spreadpar3->labelfont(0);
        spreadpar3->labelsize(10);
        spreadpar3->labelcolor((Fl_Color)64);
        spreadpar3->maximum(255);
        spreadpar3->step(1);
        spreadpar3->callback((Fl_Callback*)cb_spreadpar3);
        spreadpar3->align(Fl_Align(FL_ALIGN_BOTTOM));
        spreadpar3->when(FL_WHEN_CHANGED);
        o->setValueType(VC_percent255);
      } // WidgetPDial* spreadpar3
      spreadGroup->end();
    } // Fl_Group* spreadGroup
    { Fl_Choice* o = spreadtype = new Fl_Choice(303, 170, 87, 20, "Overtone Positions");
      spreadtype->down_box(FL_BORDER_BOX);
      spreadtype->selection_color((Fl_Color)64);
      spreadtype->labelsize(11);
      spreadtype->labelcolor((Fl_Color)64);
      spreadtype->textfont(1);
      spreadtype->textsize(11);
      spreadtype->textcolor((Fl_Color)64);
      spreadtype->callback((Fl_Callback*)cb_spreadtype);
      spreadtype->align(Fl_Align(FL_ALIGN_BOTTOM));
      o->add("Harmonic");o->add("ShiftU");o->add("ShiftL");o->add("PowerU");o->add("PowerL");o->add("Sine");o->add("Power");o->add("Shift");
    } // Fl_Choice* spreadtype
    { Fl_Group* o = globalfiltergroup = new Fl_Group(510, 221, 293, 265, " FILTER ");
      globalfiltergroup->box(FL_THIN_UP_FRAME);
      globalfiltergroup->labelfont(1);
      globalfiltergroup->labelsize(11);
      globalfiltergroup->labelcolor((Fl_Color)64);
      globalfiltergroup->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
      { EnvelopeUI* o = filterenv = new EnvelopeUI(516, 325, 280, 75, "Yoshimi : SubSynth - Filter Envelope");
        filterenv->box(FL_FLAT_BOX);
        filterenv->color((Fl_Color)51);
        filterenv->selection_color(FL_BACKGROUND_COLOR);
        filterenv->labeltype(FL_NORMAL_LABEL);
        filterenv->labelfont(0);
        filterenv->labelsize(14);
        filterenv->labelcolor(FL_FOREGROUND_COLOR);
        filterenv->align(Fl_Align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE));
        filterenv->when(FL_WHEN_RELEASE);
        o->init(pars->GlobalFilterEnvelope.get(), npart, kititem, PART::engine::subSynth, 2);
        filterenv->end();
      } // EnvelopeUI* filterenv
      { FilterUI* o = filterui = new FilterUI(516, 246, 280, 75, "Yoshimi : SubSynth - Filter");
        filterui->box(FL_FLAT_BOX);
        filterui->color(FL_LIGHT1);
        filterui->selection_color(FL_BACKGROUND_COLOR);
        filterui->labeltype(FL_NORMAL_LABEL);
        filterui->labelfont(0);
        filterui->labelsize(14);
        filterui->labelcolor(FL_FOREGROUND_COLOR);
        filterui->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
        filterui->when(FL_WHEN_RELEASE);
        o->init(pars->GlobalFilter.get(),&pars->PGlobalFilterVelocityScale,&pars->PGlobalFilterVelocityScaleFunction, npart, kititem, 1);
        filterui->end();
      } // FilterUI* filterui
      { LFOUI* o = filterlfo = new LFOUI(516, 405, 280, 75, "Filter LFO");
        filterlfo->box(FL_FLAT_BOX);
        filterlfo->color((Fl_Color)51);
        filterlfo->selection_color(FL_BACKGROUND_COLOR);
        filterlfo->labeltype(FL_NORMAL_LABEL);
        filterlfo->labelfont(0);
        filterlfo->labelsize(14);
        filterlfo->labelcolor(FL_FOREGROUND_COLOR);
        filterlfo->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
        filterlfo->when(FL_WHEN_RELEASE);
        o->init(synth, npart, kititem, PART::engine::subSynth,
TOPLEVEL::insertType::filter);
        filterlfo->end();
      } // LFOUI* filterlfo
      if (collect_readData(synth, 0, SUBSYNTH::control::enableFilter, npart, kititem, PART::engine::subSynth)==0) o->deactivate();
      globalfiltergroup->end();
    } // Fl_Group* globalfiltergroup
    { filtere = new Fl_Check_Button2(516, 227, 36, 13, "On");
      filtere->box(FL_NO_BOX);
      filtere->down_box(FL_DOWN_BOX);
      filtere->color(FL_BACKGROUND_COLOR);
      filtere->selection_color((Fl_Color)64);
      filtere->labeltype(FL_NORMAL_LABEL);
      filtere->labelfont(3);
      filtere->labelsize(10);
      filtere->labelcolor((Fl_Color)226);
      filtere->callback((Fl_Callback*)cb_filtere);
      filtere->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      filtere->when(FL_WHEN_RELEASE);
    } // Fl_Check_Button2* filtere
    { Fl_Group* o = new Fl_Group(574, 486, 229, 35);
      o->box(FL_THIN_UP_FRAME);
      { filterstages = new Fl_Counter(593, 501, 66, 15, "Filter Stages");
        filterstages->tooltip("How many times the noise is filtered");
        filterstages->type(1);
        filterstages->selection_color((Fl_Color)64);
        filterstages->labelfont(1);
        filterstages->labelsize(10);
        filterstages->labelcolor((Fl_Color)64);
        filterstages->minimum(1);
        filterstages->maximum(5);
        filterstages->step(1);
        filterstages->value(1);
        filterstages->textsize(10);
        filterstages->textcolor((Fl_Color)64);
        filterstages->callback((Fl_Callback*)cb_filterstages);
        filterstages->align(Fl_Align(FL_ALIGN_TOP));
      } // Fl_Counter* filterstages
      { Fl_Choice* o = magtype = new Fl_Choice(660, 501, 65, 15, "Mag.Type");
        magtype->down_box(FL_BORDER_BOX);
        magtype->selection_color((Fl_Color)64);
        magtype->labelfont(1);
        magtype->labelsize(10);
        magtype->labelcolor((Fl_Color)64);
        magtype->textfont(1);
        magtype->textsize(11);
        magtype->textcolor((Fl_Color)64);
        magtype->callback((Fl_Callback*)cb_magtype);
        magtype->align(Fl_Align(FL_ALIGN_TOP));
        o->add("Linear");o->add("-40dB");o->add("-60dB");o->add("-80dB");o->add("-100dB");
      } // Fl_Choice* magtype
      { Fl_Choice* o = start = new Fl_Choice(740, 501, 50, 15, "Start");
        start->down_box(FL_BORDER_BOX);
        start->selection_color((Fl_Color)64);
        start->labelfont(1);
        start->labelsize(10);
        start->labelcolor((Fl_Color)64);
        start->textfont(1);
        start->textsize(11);
        start->textcolor((Fl_Color)64);
        start->callback((Fl_Callback*)cb_start);
        start->align(Fl_Align(FL_ALIGN_TOP));
        o->add("Zero");o->add("Rnd");o->add("Max.");
      } // Fl_Choice* start
      o->end();
    } // Fl_Group* o
    { stereo = new Fl_Check_Button2(512, 495, 59, 15, " Stereo");
      stereo->box(FL_NO_BOX);
      stereo->down_box(FL_DOWN_BOX);
      stereo->color(FL_BACKGROUND_COLOR);
      stereo->selection_color((Fl_Color)64);
      stereo->labeltype(FL_NORMAL_LABEL);
      stereo->labelfont(3);
      stereo->labelsize(10);
      stereo->labelcolor((Fl_Color)226);
      stereo->callback((Fl_Callback*)cb_stereo);
      stereo->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      stereo->when(FL_WHEN_RELEASE);
    } // Fl_Check_Button2* stereo
    { subClear = new Fl_Button(515, 526, 70, 20, "Clear");
      subClear->tooltip("Clear the harmonics");
      subClear->box(FL_PLASTIC_UP_BOX);
      subClear->color((Fl_Color)228);
      subClear->labelfont(1);
      subClear->labelsize(11);
      subClear->labelcolor((Fl_Color)64);
      subClear->callback((Fl_Callback*)cb_subClear);
    } // Fl_Button* subClear
    { subCopy = new Fl_Button(610, 529, 25, 15, "C");
      subCopy->box(FL_THIN_UP_BOX);
      subCopy->color((Fl_Color)179);
      subCopy->labelfont(1);
      subCopy->labelsize(11);
      subCopy->labelcolor((Fl_Color)197);
      subCopy->callback((Fl_Callback*)cb_subCopy);
    } // Fl_Button* subCopy
    { subPaste = new Fl_Button(646, 529, 25, 15, "P");
      subPaste->box(FL_THIN_UP_BOX);
      subPaste->color((Fl_Color)179);
      subPaste->labelfont(1);
      subPaste->labelsize(11);
      subPaste->labelcolor((Fl_Color)197);
      subPaste->callback((Fl_Callback*)cb_subPaste);
    } // Fl_Button* subPaste
    { subClose = new Fl_Button(695, 526, 105, 20, "&Close");
      subClose->tooltip("Right click: also reopen previous");
      subClose->box(FL_THIN_UP_BOX);
      subClose->color((Fl_Color)196);
      subClose->labelfont(1);
      subClose->labelsize(11);
      subClose->labelcolor((Fl_Color)64);
      subClose->callback((Fl_Callback*)cb_subClose);
    } // Fl_Button* subClose
    SUBparameters->resizable(SUBparameters);
    o->copy_label(textMsgBuffer.fetch(collect_readData(synth, textMsgBuffer.push("SubSynth"), npart, TOPLEVEL::windowTitle, kititem)).c_str());
    subDW = o->w();subDH=o->h();
    SUBparameters->size_range(subDW, subDH, 0, 0, 0, 0, 1);
    SUBparameters->end();
  } // ScaleTrackedWindow* SUBparameters
  return SUBparameters;
}

void SUBnoteUI::refresh() {
  //
      for (int i = 0; i < MAX_SUB_HARMONICS; ++i)
          h[i]->refresh();
      vol->value(collect_readData(synth, 0, SUBSYNTH::control::volume, npart, kititem, PART::engine::subSynth));
          vol->selection_color(setKnob(vol->value(),96));
      vsns->value(collect_readData(synth, 0, SUBSYNTH::control::velocitySense, npart, kititem, PART::engine::subSynth));
          vsns->selection_color(setKnob(vsns->value(),90));
      pan->value(collect_readData(synth, 0, SUBSYNTH::control::panning, npart, kititem, PART::engine::subSynth));
          pan->selection_color(setKnob(pan->value(),64));
      randompan->value(collect_readData(synth, 0, SUBSYNTH::control::enableRandomPan, npart, kititem, PART::engine::subSynth));
      if (randompan->value() == 0)
          panwidth->deactivate();
      else
          panwidth->activate();
      panwidth->value(collect_readData(synth, 0, SUBSYNTH::control::randomWidth, npart, kititem, PART::engine::subSynth));
          panwidth->selection_color(setKnob(panwidth->value(),63));

      bandwidth->value(collect_readData(synth, 0, SUBSYNTH::control::bandwidth, npart, kititem, PART::engine::subSynth));
          bandwidth->selection_color(setSlider(bandwidth->value(),40));
      bwidthscale->value(collect_readData(synth, 0, SUBSYNTH::control::bandwidthScale, npart, kititem, PART::engine::subSynth));
          bwidthscale->selection_color(setSlider(bwidthscale->value(),0));
      bwee->value(collect_readData(synth, 0, SUBSYNTH::control::enableBandwidthEnvelope, npart, kititem, PART::engine::subSynth));
      if (bwee->value() == 0)
          bandwidthenvelopegroup->deactivate();
      else
          bandwidthenvelopegroup->activate();
      bwee->show();
      bandwidthsettingsui->redraw();

      bend->value(collect_readData(synth, 0, SUBSYNTH::control::pitchBendAdjustment, npart, kititem, PART::engine::subSynth));
          bend->selection_color(setKnob(bend->value(),88));
      offset->value(collect_readData(synth, 0, SUBSYNTH::control::pitchBendOffset, npart, kititem, PART::engine::subSynth));
          offset->selection_color(setKnob(offset->value(),64));
      hz440->value(collect_readData(synth, 0, SUBSYNTH::control::baseFrequencyAs440Hz, npart, kititem, PART::engine::subSynth));
      if (hz440->value() == 0)
          fixedfreqetdial->deactivate();
      else
          fixedfreqetdial->activate();
      fixedfreqetdial->value(collect_readData(synth, 0, SUBSYNTH::control::equalTemperVariation, npart, kititem, PART::engine::subSynth));
          fixedfreqetdial->selection_color(setKnob(fixedfreqetdial->value(),0));

      freqee->value(collect_readData(synth, 0, SUBSYNTH::control::enableFrequencyEnvelope, npart, kititem, PART::engine::subSynth));
      if (freqee->value() == 0)
          freqenvelopegroup->deactivate();
      else
          freqenvelopegroup->activate();
      freqee->show();
      freqsettingsui->redraw();

      freqlfo->value(collect_readData(synth, 0, SUBSYNTH::control::enableFrequencyLFO, npart, kititem, PART::engine::subSynth));
      if (freqlfo->value() == 0)
          freqlfogroup->deactivate();
      else
          freqlfogroup->activate();
      freqlfo->show();
      freqsettingsui->redraw();

      octave->value(collect_readData(synth, 0, SUBSYNTH::control::octave, npart, kititem, PART::engine::subSynth));

      int detVal = collect_readData(synth, 0, SUBSYNTH::control::detuneFrequency, npart, kititem, PART::engine::subSynth);
      detune->value(detVal);
          detune->selection_color(setSlider(detVal,0));

      int detType = collect_readData(synth, 0, SUBSYNTH::control::detuneType, npart, kititem, PART::engine::subSynth);
      detunetype->value(detType - 1);

      coarsedet->value(collect_readData(synth, 0, SUBSYNTH::control::coarseDetune, npart, kititem, PART::engine::subSynth));
      detunevalueoutput->value(getDetune(detType,0,detVal+8192));

      spreadtype->value(collect_readData(synth, 0, SUBSYNTH::control::overtonePosition, npart, kititem, PART::engine::subSynth));
      if (spreadtype->value() > 0)
      {
          spreadGroup->activate();
      }
      else
      {
          spreadGroup->deactivate();
      }
      spreadpar1->value(collect_readData(synth, 0, SUBSYNTH::control::overtoneParameter1, npart, kititem, PART::engine::subSynth));
          spreadpar1->selection_color(setKnob(spreadpar1->value(),0));
      spreadpar2->value(collect_readData(synth, 0, SUBSYNTH::control::overtoneParameter2, npart, kititem, PART::engine::subSynth));
          spreadpar2->selection_color(setKnob(spreadpar1->value(),0));
      spreadpar3->value(collect_readData(synth, 0, SUBSYNTH::control::overtoneForceHarmonics, npart, kititem, PART::engine::subSynth));
          spreadpar3->selection_color(setKnob(spreadpar1->value(),0));

      filtere->value(collect_readData(synth, 0, SUBSYNTH::control::enableFilter, npart, kititem, PART::engine::subSynth));
      if (filtere->value() == 0)
          globalfiltergroup->deactivate();
      else
          globalfiltergroup->activate();
      filtere->show();
      globalfiltergroup->redraw();

      filterstages->value(collect_readData(synth, 0, SUBSYNTH::control::filterStages, npart, kititem, PART::engine::subSynth));
      magtype->value(collect_readData(synth, 0, SUBSYNTH::control::magType, npart, kititem, PART::engine::subSynth));
      start->value(collect_readData(synth, 0, SUBSYNTH::control::startPosition, npart, kititem, PART::engine::subSynth));

      stereo->value(collect_readData(synth, 0, SUBSYNTH::control::stereo, npart, kititem, PART::engine::subSynth));

      ampenv->refresh();
      bandwidthenvelopegroup->refresh();
      freqenvelopegroup->refresh();
      filterui->refresh();
      filterenv->refresh();
}

void SUBnoteUI::Showsub() {
  //
      int fetchW, fetchH, fetchX, fetchY, fetchO;
      loadWin(synth, fetchW, fetchH, fetchX, fetchY, fetchO, "SubSynth");
      if (fetchW < subDW || fetchH < subDH)
      {
          fetchW = subDW;
          fetchH = subDH;
      }
      checkSane(fetchX, fetchY, fetchW, fetchH, subDW, subDH);

      SUBparameters->resize(fetchX, fetchY, fetchW, fetchH);
      SUBparameters->show();
      lastsubW = 0;
      subSeen = true;
}

void SUBnoteUI::subRtext() {
  //
      ampenv->wincheck();
      bandwidthenvelopegroup->wincheck();
      filterenv->wincheck();
      freqenvelopegroup->wincheck();

      if (filterui->formantparswindow->visible())
          filterui->formantRtext();

      if (!SUBparameters->visible())
          return;

      if(SUBparameters->w() == lastsubW)
           return;

      lastsubW = SUBparameters->w();

      float dScale = SUBparameters->w() / float(subDW);
      if (dScale < 0.2f)
          dScale = 0.2f;

      amplfo->lfoRtext(dScale);
      ampenv->envRtext(dScale);
      bandwidthenvelopegroup->envRtext(dScale);
      filterlfo->lfoRtext(dScale);
      filterenv->envRtext(dScale);
      freqenvelopegroup->envRtext(dScale);
      freqlfogroup->lfoRtext(dScale);

      filterui->filterRtext(dScale);

      int size = int(10 * dScale);
      int size11 = int(11 * dScale);
      frame->scroll_to(0, 0);
      frame->size(int(505 * dScale), int(326 * dScale));
      frame->scrollbar_size(12 * dScale);
      harmonics->size(int(435 * dScale), int(275 * dScale * 1.1));

      for (int i=0;i<MAX_SUB_HARMONICS;i++)
      {
          h[i]->size(20 * dScale, 275 * dScale * 1.1);
          h[i]->h_num->labelsize(int(12 * dScale));
          h[i]->h_dash->size(int(10 * dScale), int(3 * dScale));
      }

      ampLabel->labelsize(size11);
      vol->labelsize(size);
      vsns->labelsize(size);
      pan->labelsize(size);
      panwidth->labelsize(size);
      randompan->labelsize(size11);

      freqsettingsui->labelsize(size11);
      freqee->labelsize(size);
      freqlfo->labelsize(size);
      octavetext->labelsize(size);
          octave->textsize(size11);
      bend->labelsize(size);
      offset->labelsize(size);
      hz440->labelsize(size);
      fixedfreqetdial->labelsize(size);
      detunevalueoutput->labelsize(size);
          detunevalueoutput->textsize(size);
      detunetype->labelsize(size);
          detunetype->textsize(size);
      coarsedet->labelsize(size);
          coarsedet->textsize(size11);

      bandwidthsettingsui->labelsize(size11);
      bwee->labelsize(size);
      bandwidth->labelsize(size);
           bandwidth->textsize(size);
      bwidthscale->labelsize(size);
          bwidthscale->textsize(size);

      spreadGroup->labelsize(size11);
      spreadpar1->labelsize(size);
      spreadpar2->labelsize(size);
      spreadpar3->labelsize(size);
      spreadtype->labelsize(size11);
          spreadtype->textsize(size11);

      globalfiltergroup->labelsize(size11);
      filtere->labelsize(size);
      filterstages->labelsize(size);
          filterstages->textsize(size11);
      magtype->labelsize(size);
          magtype->textsize(size11);
      start->labelsize(size);
          start->textsize(size11);

      stereo->labelsize(size);
      subClear->labelsize(size11);
      subCopy->labelsize(size11);
      subPaste->labelsize(size11);
      subClose->labelsize(size11);

      SUBparameters->redraw();
}

void SUBnoteUI::theme() {
  //
          if(SUBparameters->visible())
          {
              lastsubW = 0;
              subRtext();
          }
          ampenv->theme();
          freqenvelopegroup->theme();
          filterenv->theme();
          bandwidthenvelopegroup->theme();
          if (filterui->formantparswindow->visible())
              filterui->theme();
          ;
}

void SUBnoteUI::send_data(int action, int control, float value, int type) {
  //
          type |= TOPLEVEL::type::Write;
          collect_writeData(synth, value, action, type, control, npart, kititem, 1);
}

void SUBnoteUI::returns_update(CommandBlock *getData) {
  //
      float value = getData->data.value;
      unsigned char control = getData->data.control;
      unsigned char insert = getData->data.insert;
      bool val_bool = _SYS_::F2B(value);
      int value_int = int(value);
      if (insert == TOPLEVEL::insert::harmonicAmplitude)
      {
          h[control]->mag->value(value_int);
          int temp = 127;
          if (control > 0)
              temp = 0;
          h[control]->mag->selection_color(setSlider(value_int,temp));
          return;
      }
      if (insert == TOPLEVEL::insert::harmonicBandwidth)
      {
          h[control]->bw->value(value_int - 64);
          h[control]->bw->selection_color(setSlider(value_int,64));
          return;
      }

      switch(control)
      {
          case SUBSYNTH::control::volume:
              vol->value(value);
              vol->selection_color(setKnob(value,96));

              break;

          case SUBSYNTH::control::velocitySense:
              vsns->value(value);
              vsns->selection_color(setKnob(value,90));

              break;

          case SUBSYNTH::control::panning:
              pan->value(value);
              pan->selection_color(setKnob(value,64));
              break;
          case SUBSYNTH::control::enableRandomPan:
              randompan->value(val_bool);
              if (val_bool)
                  panwidth->activate();
              else
                  panwidth->deactivate();
              break;
          case SUBSYNTH::control::randomWidth:
              panwidth->value(value);
              panwidth->selection_color(setKnob(value,63));
              break;

          case SUBSYNTH::control::bandwidth:
              bandwidth->value(value);
              bandwidth->selection_color(setSlider(value,40));
              break;

          case SUBSYNTH::control::bandwidthScale:
              bwidthscale->value(value);
              bwidthscale->selection_color(setSlider(value,0));
              break;

          case SUBSYNTH::control::enableBandwidthEnvelope:
              bwee->value(val_bool);
              if (val_bool)
                  bandwidthenvelopegroup->activate();
              else
                  bandwidthenvelopegroup->deactivate();
              bwee->show();
              break;

          case SUBSYNTH::control::detuneFrequency:
              detune->value(value);
              detune->selection_color(setSlider(value,0));
              detunevalueoutput->do_callback();
              break;

          case SUBSYNTH::control::equalTemperVariation:
              fixedfreqetdial->value(value);
              fixedfreqetdial->selection_color(setKnob(value,0));
              break;

          case SUBSYNTH::control::baseFrequencyAs440Hz:
              hz440->value(_SYS_::F2B(value));
              if (value == 0)
                  fixedfreqetdial->deactivate();
              else
                  fixedfreqetdial->activate();
              break;

          case SUBSYNTH::control::octave:
              octave->value(lrint(value));
              break;

          case SUBSYNTH::control::detuneType:
              detunetype->value(value - 1);
              break;

          case SUBSYNTH::control::coarseDetune:
              coarsedet->value(value);
              break;

          case SUBSYNTH::control::pitchBendAdjustment:
              bend->value(value);
              bend->selection_color(setKnob(value,88));
              break;

          case SUBSYNTH::control::pitchBendOffset:
              offset->value(value);
              offset->selection_color(setKnob(value,64));
              break;

          case SUBSYNTH::control::enableFrequencyEnvelope:
              freqee->value(value);
              if (val_bool)
                  freqenvelopegroup->activate();
              else
                  freqenvelopegroup->deactivate();
              freqee->show();
              break;

          case SUBSYNTH::control::enableFrequencyLFO:
              freqlfo->value(value);
              if (val_bool)
                  freqlfogroup->activate();
              else
                  freqlfogroup->deactivate();
              freqlfo->show();
              break;

          case SUBSYNTH::control::overtoneParameter1:
              spreadpar1->value((unsigned int) value);
              spreadpar1->selection_color(setKnob(value,0));
              break;

          case SUBSYNTH::control::overtoneParameter2:
              spreadpar2->value((unsigned int) value);
              spreadpar2->selection_color(setKnob(value,0));
              break;

          case SUBSYNTH::control::overtoneForceHarmonics:
              spreadpar3->value((unsigned int) value);
              spreadpar3->selection_color(setKnob(value,0));
              break;

          case SUBSYNTH::control::overtonePosition:
              spreadtype->value((int) value);
              if (spreadtype->value() > 0)
              {
                  spreadGroup->activate();
                  if (spreadtype->value() < 7)
                      spreadpar2->activate();
                  else
                      spreadpar2->deactivate();
              }
              else
                  spreadGroup->deactivate();
              break;

          case SUBSYNTH::control::enableFilter:
              filtere->value(val_bool);
              if (val_bool)
                  globalfiltergroup->activate();
              else
                  globalfiltergroup->deactivate();
              globalfiltergroup->redraw();
              break;

          case SUBSYNTH::control::filterStages:
              filterstages->value((int) value);
              break;
          case SUBSYNTH::control::magType:
              magtype->value((int) value);
              break;

          case SUBSYNTH::control::startPosition:
              start->value((int) value);
              break;

          case SUBSYNTH::control::clearHarmonics:
              for (int i = 0; i < MAX_SUB_HARMONICS; i++)
              {
                  if (i == 0)
                  {
                      h[i]->mag->value(127);
                      h[i]->mag->selection_color(setSlider(127,127));
                  }
                  else
                  {
                      h[i]->mag->value(0);
                      h[i]->mag->selection_color(setSlider(0,0));
                  }
                  h[i]->bw->value(0);
                  h[i]->bw->selection_color(setSlider(64,64));
              }

              break;

          case SUBSYNTH::control::stereo:
              stereo->value(val_bool);
              break;
      }
}

SUBnoteUI::SUBnoteUI(SUBnoteParameters *parameters, int npart_, int kititem_) {
  //
      pars = parameters;
      synth = & pars->getSynthEngine();
      npart = npart_;
      kititem = kititem_;
      lastsubW = 0;
      subSeen = false;
      make_window();
      refresh();
}

SUBnoteUI::~SUBnoteUI() {
  //
      if (subSeen)
          saveWin(synth, SUBparameters->w(), SUBparameters->h(), SUBparameters->x(), SUBparameters->y(),  true, "SubSynth");
      subSeen = false;
      SUBparameters->hide();
      delete(SUBparameters);
}
