/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer;

import java.io.OutputStream;
import java.io.PrintStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.tools.transfer.DataTransferPipe;
import org.jkiss.dbeaver.tools.transfer.DataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProcessor;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProducer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.utils.CommonUtils;

public class DataTransferJob
extends AbstractJob {
    private final DBCStatistics totalStatistics = new DBCStatistics();
    private final DataTransferSettings settings;
    private final DBTTask task;
    private final DBRProgressMonitor parentMonitor;
    private long elapsedTime;
    private boolean hasErrors;
    private final Log log;
    private final PrintStream logStream;

    public DataTransferJob(@NotNull DataTransferSettings settings, @NotNull DBTTask task, @NotNull Log log, @Nullable PrintStream logStream, @Nullable DBRProgressMonitor parentMonitor, int index) {
        super("Data transfer job [" + index + "]: " + settings.getConsumer().getName());
        this.settings = settings;
        this.task = task;
        this.log = log;
        this.logStream = logStream;
        this.parentMonitor = parentMonitor;
    }

    public DataTransferSettings getSettings() {
        return this.settings;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public boolean isHasErrors() {
        return this.hasErrors;
    }

    public DBCStatistics getTotalStatistics() {
        return this.totalStatistics;
    }

    @NotNull
    protected IStatus run(@NotNull DBRProgressMonitor jobMonitor) {
        DataTransferPipe transferPipe;
        int pipeCount = this.settings.getDataPipes().size();
        DBRProgressMonitor monitor = this.parentMonitor != null ? this.parentMonitor : jobMonitor;
        monitor.beginTask("Perform data transfer", pipeCount);
        this.hasErrors = false;
        long startTime = System.currentTimeMillis();
        while (!monitor.isCanceled() && (transferPipe = this.settings.acquireDataPipe(monitor, this.task)) != null) {
            try {
                if (this.logStream != null) {
                    Log.setLogWriter((OutputStream)this.logStream);
                }
                boolean transferResult = this.transferData(monitor, transferPipe);
                Log.setLogWriter(null);
                this.hasErrors |= !transferResult;
                if (this.parentMonitor != null) {
                    this.parentMonitor.worked(1);
                }
                jobMonitor.worked(1);
            }
            catch (Exception e) {
                transferPipe.getConsumer();
                return new Status(0, ((Object)((Object)this)).getClass(), "Data transfer failed", (Throwable)e);
            }
        }
        monitor.done();
        this.elapsedTime = System.currentTimeMillis() - startTime;
        return Status.OK_STATUS;
    }

    private boolean transferData(DBRProgressMonitor monitor, DataTransferPipe transferPipe) throws Exception {
        IDataTransferProducer<?> producer = transferPipe.getProducer();
        IDataTransferConsumer<?, ?> consumer = transferPipe.getConsumer();
        String inputName = producer.getObjectFullName(monitor);
        String outputName = consumer.getObjectFullName(monitor);
        monitor.beginTask(NLS.bind((String)DTMessages.data_transfer_wizard_job_container_name, (Object)CommonUtils.truncateString((String)inputName, (int)200), (Object)CommonUtils.truncateString((String)outputName, (int)200)), 1);
        IDataTransferSettings nodeSettings = this.settings.getNodeSettings(this.settings.getProducer());
        try {
            IDataTransferProcessor processor = this.settings.getProcessor() == null ? null : this.settings.getProcessor().getInstance();
            producer.transferData(monitor, consumer, processor, nodeSettings, this.task);
            this.totalStatistics.accumulate(producer.getStatistics());
            this.totalStatistics.accumulate(consumer.getStatistics());
            consumer.finishTransfer(monitor, false);
            return true;
        }
        catch (Exception e) {
            consumer.finishTransfer(monitor, e, this.task, false);
            this.log.error((Object)("Error transferring data from " + inputName + " to " + outputName), (Throwable)e);
            throw e;
        }
        finally {
            monitor.done();
        }
    }
}

