/*
 * Decompiled with CFR 0.152.
 */
package org.cugos.wkg;

import java.util.List;
import org.cugos.wkg.Coordinate;
import org.cugos.wkg.Dimension;
import org.cugos.wkg.Envelope;
import org.cugos.wkg.WKTWriter;

public abstract class Geometry {
    protected String srid;
    protected final Dimension dimension;
    protected Object data;

    protected Geometry(Dimension dimension, String srid) {
        this.dimension = dimension;
        this.srid = srid;
    }

    public abstract boolean isEmpty();

    public abstract int getNumberOfCoordinates();

    public abstract List<Coordinate> getCoordinates();

    public Envelope getEnvelope() {
        double minX = Double.NaN;
        double minY = Double.NaN;
        double maxX = Double.NaN;
        double maxY = Double.NaN;
        double minZ = Double.NaN;
        double maxZ = Double.NaN;
        double minM = Double.NaN;
        double maxM = Double.NaN;
        for (Coordinate coordinate : this.getCoordinates()) {
            minX = Double.isNaN(minX) ? coordinate.getX() : Math.min(coordinate.getX(), minX);
            minY = Double.isNaN(minY) ? coordinate.getY() : Math.min(coordinate.getY(), minY);
            maxX = Double.isNaN(maxX) ? coordinate.getX() : Math.max(coordinate.getX(), maxX);
            maxY = Double.isNaN(maxY) ? coordinate.getY() : Math.max(coordinate.getY(), maxY);
            minZ = Double.isNaN(minZ) ? coordinate.getZ() : Math.min(coordinate.getZ(), minZ);
            maxZ = Double.isNaN(maxZ) ? coordinate.getZ() : Math.max(coordinate.getZ(), maxZ);
            minM = Double.isNaN(minM) ? coordinate.getM() : Math.min(coordinate.getM(), minM);
            if (Double.isNaN(maxM)) {
                maxM = coordinate.getM();
                continue;
            }
            maxM = Math.max(coordinate.getM(), maxM);
        }
        return Envelope.create3DM(minX, minY, minZ, minM, maxX, maxY, maxZ, maxM);
    }

    public String getSrid() {
        return this.srid;
    }

    public Geometry setSrid(String srid) {
        this.srid = srid;
        return this;
    }

    public Object getData() {
        return this.data;
    }

    public Geometry setData(Object data) {
        this.data = data;
        return this;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public String toString() {
        return new WKTWriter().write(this);
    }
}

