/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources.components;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.freeplane.core.ui.textchanger.TranslatedElement;
import org.freeplane.core.util.TextUtils;

public abstract class PropertyAdapter {
    private String tooltip;
    private String label;
    private final String name;
    protected JLabel labelComponent;

    public JLabel getLabelComponent() {
        return this.labelComponent;
    }

    public abstract JComponent getValueComponent();

    protected void setLabelComponent(JLabel labelComponent) {
        this.labelComponent = labelComponent;
    }

    public PropertyAdapter(String name) {
        this(name, "OptionPanel." + name, "OptionPanel." + name + ".tooltip");
    }

    public PropertyAdapter(String name, String label, String tooltip) {
        assert (name != null);
        this.name = name;
        this.label = label;
        this.tooltip = tooltip;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public String getLabel() {
        return this.label;
    }

    void setLabel(String label) {
        this.label = label;
    }

    public String getName() {
        return this.name;
    }

    public void setNameAsLabelAndToolTip() {
        this.label = this.name;
        this.tooltip = this.name + ".tooltip";
    }

    public void setEnabled(boolean pEnabled) {
        if (this.labelComponent != null) {
            this.labelComponent.setEnabled(pEnabled);
        }
    }

    public boolean isEnabled() {
        return this.labelComponent == null || this.labelComponent.isEnabled();
    }

    protected void appendToForm(DefaultFormBuilder builder, JComponent component) {
        String labelKey = this.getLabel();
        String optionalText = TextUtils.getOptionalText(labelKey);
        this.labelComponent = builder.append(optionalText, (Component)component);
        if (optionalText != null) {
            TranslatedElement.TEXT.setKey(this.labelComponent, labelKey);
        }
        String tooltipKey = this.getTooltip();
        String tooltip = TextUtils.getOptionalText(tooltipKey, null);
        if (tooltipKey != null) {
            TranslatedElement.TOOLTIP.setKey(this.labelComponent, tooltipKey);
        }
        this.labelComponent.setToolTipText(tooltip);
        component.setToolTipText(tooltip);
    }
}

