/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.Image;
import java.text.Collator;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.modules.autoupdate.ui.Containers;
import org.netbeans.modules.autoupdate.ui.PluginManagerUI;
import org.netbeans.modules.autoupdate.ui.UnitCategoryTableModel;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public abstract class Unit {
    UpdateUnit updateUnit = null;
    private boolean isVisible;
    private String filter;
    private String categoryName;
    static final Logger log = Logger.getLogger(Unit.class.getName());
    private String displayDate = null;

    protected abstract UpdateElement getRelevantElement();

    public abstract boolean isMarked();

    public abstract void setMarked(boolean var1);

    public abstract int getCompleteSize();

    Unit(String categoryName) {
        this.categoryName = categoryName;
    }

    public abstract UnitCategoryTableModel.Type getModelType();

    public void initState() {
        if (UnitCategoryTableModel.isMarkedAsDefault(this.getModelType()) && !this.isMarked() && this.canBeMarked()) {
            this.setMarked(true);
        }
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public boolean canBeMarked() {
        RequestProcessor.Task t = PluginManagerUI.getRunningTask();
        return t == null || t.isFinished();
    }

    public String getDisplayName() {
        return this.getRelevantElement().getDisplayName();
    }

    public final boolean isVisible(String filter) {
        if (this.filter != null && this.filter.equals(filter)) {
            return this.isVisible;
        }
        this.filter = filter;
        boolean bl = this.isVisible = filter.length() == 0;
        if (this.isVisible) {
            return this.isVisible;
        }
        Iterable<String> iterable = this.details();
        for (String detail : iterable) {
            this.isVisible = detail.toLowerCase().contains(filter);
            if (!this.isVisible) continue;
            break;
        }
        return this.isVisible;
    }

    private Iterable<String> details() {
        Iterable<String> retval = new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    int step = 0;

                    @Override
                    public boolean hasNext() {
                        return this.step <= 6;
                    }

                    @Override
                    public String next() {
                        String next = null;
                        switch (this.step++) {
                            case 0: {
                                next = Unit.this.getDisplayName();
                                break;
                            }
                            case 1: {
                                next = Unit.this.getCategoryName();
                                break;
                            }
                            case 2: {
                                next = Unit.this.getDescription();
                                break;
                            }
                            case 3: {
                                next = Unit.this.updateUnit.getCodeName();
                                break;
                            }
                            case 4: {
                                next = Unit.this.getDisplayVersion();
                                break;
                            }
                            case 5: {
                                next = Unit.this.getAuthor();
                                break;
                            }
                            case 6: {
                                next = Unit.this.getHomepage();
                            }
                        }
                        return next != null ? next : "";
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                };
            }
        };
        return retval;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getDescription() {
        return this.getRelevantElement().getDescription();
    }

    public String getNotification() {
        return this.getRelevantElement().getNotification();
    }

    public String getAuthor() {
        return this.getRelevantElement().getAuthor();
    }

    public String getHomepage() {
        return this.getRelevantElement().getHomepage();
    }

    public String getSource() {
        return this.getRelevantElement().getSource();
    }

    public String getDisplayVersion() {
        return this.getRelevantElement().getSpecificationVersion();
    }

    public String getDisplayDate() {
        String sd;
        if (this.displayDate == null && (sd = this.getRelevantElement().getDate()) != null) {
            try {
                Date d = Utilities.DATE_FORMAT.parse(sd);
                this.displayDate = DateFormat.getDateInstance(3, Locale.getDefault()).format(d);
            }
            catch (ParseException pe) {
                log.log(Level.INFO, "ParseException while parsing date " + sd, pe);
            }
        }
        return this.displayDate;
    }

    public static int compareDisplayNames(Unit unit1, Unit unit2) {
        return Utilities.getCategoryComparator().compare(unit1.getDisplayName(), unit2.getDisplayName());
    }

    public static int compareCategories(Unit unit1, Unit unit2) {
        return Utilities.getCategoryComparator().compare(unit1.getCategoryName(), unit2.getCategoryName());
    }

    public static int compareSimpleFormatDates(Unit u1, Unit u2) {
        Date d2;
        Date d1;
        if (u1.getRelevantElement().getDate() == null) {
            if (u2.getRelevantElement().getDate() == null) {
                return 0;
            }
            return -1;
        }
        if (u2.getRelevantElement().getDate() == null) {
            return 1;
        }
        try {
            d1 = Utilities.DATE_FORMAT.parse(u1.getRelevantElement().getDate());
        }
        catch (ParseException pe) {
            log.log(Level.INFO, "ParseException while parsing date " + u1.getRelevantElement().getDate(), pe);
            return -1;
        }
        try {
            d2 = Utilities.DATE_FORMAT.parse(u2.getRelevantElement().getDate());
        }
        catch (ParseException pe) {
            log.log(Level.INFO, "ParseException while parsing date " + u2.getRelevantElement().getDate(), pe);
            return 1;
        }
        return d1.compareTo(d2);
    }

    public static int compareDisplayVersions(Unit unit1, Unit unit2) {
        if (unit1.getDisplayVersion() == null) {
            if (unit2.getDisplayVersion() == null) {
                return 0;
            }
            return -1;
        }
        if (unit2.getDisplayVersion() == null) {
            return 1;
        }
        return new SpecificationVersion(unit1.getDisplayVersion()).compareTo(new SpecificationVersion(unit2.getDisplayVersion()));
    }

    public static int compareCompleteSizes(Unit unit1, Unit unit2) {
        return Integer.valueOf(unit1.getCompleteSize()).compareTo(unit2.getCompleteSize());
    }

    private static String getBundle(String key) {
        return NbBundle.getMessage(Unit.class, (String)key);
    }

    public String toString() {
        return super.toString() + "[" + this.getDisplayName() + "]";
    }

    public static class Available
    extends Unit {
        private UpdateElement updateEl = null;
        private boolean isNbms;
        private int size = -1;

        public Available(UpdateUnit unit, boolean isNbms, String categoryName) {
            super(categoryName);
            this.isNbms = isNbms;
            this.updateUnit = unit;
            this.updateEl = (UpdateElement)unit.getAvailableUpdates().get(0);
            assert (this.updateEl != null) : "Updateable UpdateUnit " + unit + " has UpdateElement for update.";
            this.initState();
        }

        @Override
        public boolean isMarked() {
            Object container = this.isNbms ? Containers.forAvailableNbms() : (UpdateManager.TYPE.CUSTOM_HANDLED_COMPONENT == this.updateUnit.getType() ? Containers.forCustomInstall() : Containers.forAvailable());
            return container.contains(this.updateEl);
        }

        @Override
        public void setMarked(boolean marked) {
            assert (marked != this.isMarked());
            Object container = this.isNbms ? Containers.forAvailableNbms() : (UpdateManager.TYPE.CUSTOM_HANDLED_COMPONENT == this.updateUnit.getType() ? Containers.forCustomInstall() : Containers.forAvailable());
            if (marked) {
                try {
                    container.add(this.updateUnit, this.updateEl);
                }
                catch (IllegalArgumentException iae) {
                    log.warning(iae.getMessage());
                }
            } else {
                container.remove(this.updateEl);
            }
        }

        public static int compareAvailableVersion(Unit u1, Unit u2) {
            if (u1 instanceof Available && u2 instanceof Available) {
                Available unit1 = (Available)u1;
                Available unit2 = (Available)u2;
                return new SpecificationVersion(unit1.getAvailableVersion()).compareTo(new SpecificationVersion(unit2.getAvailableVersion()));
            }
            return Unit.compareDisplayVersions(u1, u2);
        }

        public static int compareSourceCategories(Unit u1, Unit u2) {
            if (u1 instanceof Available && u2 instanceof Available) {
                Available unit1 = (Available)u1;
                Available unit2 = (Available)u2;
                return Collator.getInstance().compare(unit1.getSourceDescription(), unit2.getSourceDescription());
            }
            throw new IllegalStateException();
        }

        public String getAvailableVersion() {
            return this.updateEl.getSpecificationVersion();
        }

        public Integer getMyRating() {
            return null;
        }

        public String getSize() {
            return Utilities.getDownloadSizeAsString(this.updateEl.getDownloadSize());
        }

        @Override
        public UpdateElement getRelevantElement() {
            return this.updateEl;
        }

        @Override
        public int getCompleteSize() {
            if (this.size == -1) {
                this.size = 0;
                OperationContainer c = OperationContainer.createForDirectInstall();
                OperationContainer.OperationInfo i = c.add(this.getRelevantElement());
                Set elems = i.getRequiredElements();
                for (UpdateElement el : elems) {
                    this.size += el.getDownloadSize();
                }
                this.size += this.getRelevantElement().getDownloadSize();
                c.removeAll();
            }
            return this.size;
        }

        @Override
        public UnitCategoryTableModel.Type getModelType() {
            return this.isNbms ? UnitCategoryTableModel.Type.LOCAL : UnitCategoryTableModel.Type.AVAILABLE;
        }

        public Image getSourceIcon() {
            return this.updateEl.getSourceIcon();
        }

        public String getSourceDescription() {
            return this.updateEl.getSourceDescription();
        }
    }

    public static class Update
    extends Unit {
        private UpdateElement installEl = null;
        private UpdateElement updateEl = null;
        private boolean isNbms;
        protected int size = -1;

        public Update(UpdateUnit unit, boolean isNbms, String categoryName) {
            super(categoryName);
            this.isNbms = isNbms;
            this.updateUnit = unit;
            this.installEl = unit.getInstalled();
            assert (this.installEl != null) : "Updateable UpdateUnit " + unit + " has Installed UpdateElement.";
            if (unit.getAvailableUpdates().size() > 0) {
                this.updateEl = (UpdateElement)unit.getAvailableUpdates().get(0);
                assert (this.updateEl != null) : "Updateable UpdateUnit " + unit + " has UpdateElement for update.";
            }
            this.initState();
        }

        @Override
        public boolean isMarked() {
            Object container = this.isNbms ? Containers.forUpdateNbms() : (UpdateManager.TYPE.CUSTOM_HANDLED_COMPONENT == this.updateUnit.getType() ? Containers.forCustomInstall() : Containers.forUpdate());
            return container.contains(this.updateEl);
        }

        @Override
        public void setMarked(boolean marked) {
            if (marked == this.isMarked()) {
                return;
            }
            Object container = this.isNbms ? Containers.forUpdateNbms() : (UpdateManager.TYPE.CUSTOM_HANDLED_COMPONENT == this.updateUnit.getType() ? Containers.forCustomInstall() : Containers.forUpdate());
            if (marked) {
                try {
                    container.add(this.updateUnit, this.updateEl);
                }
                catch (IllegalArgumentException ex) {
                    log.log(Level.WARNING, ex.getMessage());
                }
            } else {
                container.remove(this.updateEl);
            }
        }

        public static int compareInstalledVersions(Unit u1, Unit u2) {
            if (u1 instanceof Update && u2 instanceof Update) {
                Update unit1 = (Update)u1;
                Update unit2 = (Update)u2;
                return new SpecificationVersion(unit1.getInstalledVersion()).compareTo(new SpecificationVersion(unit2.getInstalledVersion()));
            }
            return Unit.compareDisplayVersions(u1, u2);
        }

        public static int compareAvailableVersions(Unit u1, Unit u2) {
            if (u1 instanceof Update && u2 instanceof Update) {
                Update unit1 = (Update)u1;
                Update unit2 = (Update)u2;
                return new SpecificationVersion(unit1.getAvailableVersion()).compareTo(new SpecificationVersion(unit2.getAvailableVersion()));
            }
            return Unit.compareDisplayVersions(u1, u2);
        }

        public String getInstalledVersion() {
            return this.installEl.getSpecificationVersion();
        }

        public String getAvailableVersion() {
            return this.getRelevantElement().getSpecificationVersion();
        }

        public String getSize() {
            return Utilities.getDownloadSizeAsString(this.updateEl.getDownloadSize());
        }

        @Override
        public UpdateElement getRelevantElement() {
            return this.updateEl;
        }

        @Override
        public int getCompleteSize() {
            if (this.size == -1) {
                this.size = 0;
                OperationContainer c = OperationContainer.createForDirectUpdate();
                OperationContainer.OperationInfo i = c.add(this.getRelevantElement());
                Set elems = i.getRequiredElements();
                for (UpdateElement el : elems) {
                    this.size += el.getDownloadSize();
                }
                this.size += this.getRelevantElement().getDownloadSize();
                c.removeAll();
            }
            return this.size;
        }

        @Override
        public UnitCategoryTableModel.Type getModelType() {
            return this.isNbms ? UnitCategoryTableModel.Type.LOCAL : UnitCategoryTableModel.Type.UPDATE;
        }
    }

    public static class CompoundUpdate
    extends Update {
        private TreeSet<UpdateUnit> internalUpdates;

        public CompoundUpdate(UpdateUnit updateUnit, String categoryName) {
            super(updateUnit, false, categoryName);
        }

        public TreeSet<UpdateUnit> getUpdateUnits() {
            if (this.internalUpdates == null) {
                this.internalUpdates = new TreeSet<UpdateUnit>(new Comparator<UpdateUnit>(){

                    @Override
                    public int compare(UpdateUnit uu1, UpdateUnit uu2) {
                        UpdateElement ue1 = uu1.getInstalled() != null ? uu1.getInstalled() : (UpdateElement)uu1.getAvailableUpdates().get(0);
                        UpdateElement ue2 = uu2.getInstalled() != null ? uu2.getInstalled() : (UpdateElement)uu2.getAvailableUpdates().get(0);
                        return ue1.getDisplayName().compareTo(ue2.getDisplayName());
                    }
                });
            }
            return this.internalUpdates;
        }

        public UpdateElement getRealUpdate() {
            return this.hasInternalsOnly() ? null : (UpdateElement)this.updateUnit.getAvailableUpdates().get(0);
        }

        @Override
        public UpdateElement getRelevantElement() {
            return this.hasInternalsOnly() ? this.updateUnit.getInstalled() : (UpdateElement)this.updateUnit.getAvailableUpdates().get(0);
        }

        @Override
        public boolean isMarked() {
            OperationContainer<InstallSupport> container = Containers.forUpdate();
            for (UpdateUnit invisible : this.getUpdateUnits()) {
                if (container.contains((UpdateElement)invisible.getAvailableUpdates().get(0))) continue;
                return false;
            }
            return this.hasInternalsOnly() || container.contains(this.getRelevantElement());
        }

        @Override
        public String getAvailableVersion() {
            if (this.updateUnit.getAvailableUpdates().isEmpty()) {
                return this.getInstalledVersion() + " " + Unit.getBundle("Unit_InternalUpdates_Version");
            }
            return super.getAvailableVersion();
        }

        @Override
        public void setMarked(boolean marked) {
            if (marked == this.isMarked()) {
                log.info("Not necessary mark " + this + " as " + marked + " if it'is marked as " + this.isMarked());
                return;
            }
            OperationContainer<InstallSupport> container = Containers.forUpdate();
            for (UpdateUnit invisible : this.getUpdateUnits()) {
                if (marked) {
                    if (!container.canBeAdded(invisible, (UpdateElement)invisible.getAvailableUpdates().get(0))) continue;
                    container.add(invisible, (UpdateElement)invisible.getAvailableUpdates().get(0));
                    continue;
                }
                container.remove((UpdateElement)invisible.getAvailableUpdates().get(0));
            }
            if (!this.hasInternalsOnly()) {
                if (marked) {
                    if (container.canBeAdded(this.updateUnit, this.getRelevantElement())) {
                        container.add(this.updateUnit, this.getRelevantElement());
                    }
                } else {
                    container.remove(this.getRelevantElement());
                }
            }
        }

        @Override
        public int getCompleteSize() {
            if (this.size == -1) {
                this.size = 0;
                for (UpdateUnit u : this.getUpdateUnits()) {
                    this.size += ((UpdateElement)u.getAvailableUpdates().get(0)).getDownloadSize();
                }
            }
            return this.size;
        }

        @Override
        public String getSize() {
            return Utilities.getDownloadSizeAsString(this.getCompleteSize());
        }

        @Override
        public UnitCategoryTableModel.Type getModelType() {
            return UnitCategoryTableModel.Type.UPDATE;
        }

        private boolean hasInternalsOnly() {
            return this.updateUnit.getAvailableUpdates().isEmpty();
        }
    }

    public static class Installed
    extends Unit {
        private UpdateElement installEl = null;
        private UpdateElement backupEl = null;
        private boolean uninstallationAllowed;
        private boolean deactivationAllowed;
        private boolean activationAllowed;

        public static boolean isOperationAllowed(UpdateUnit uUnit, UpdateElement element, OperationContainer<OperationSupport> container) {
            return container.canBeAdded(uUnit, element);
        }

        public Installed(UpdateUnit unit, String categoryName) {
            super(categoryName);
            this.updateUnit = unit;
            if (unit.getInstalled() == null && unit.isPending()) {
                this.installEl = (UpdateElement)unit.getAvailableUpdates().get(0);
                assert (this.installEl != null) : "Pending UpdateUnit " + unit + " has UpdateElement for update.";
            } else {
                this.installEl = unit.getInstalled();
                assert (this.installEl != null) : "Installed UpdateUnit " + unit + " has Installed UpdateElement.";
            }
            this.backupEl = unit.getBackup();
            OperationContainer<OperationSupport> container = UpdateManager.TYPE.CUSTOM_HANDLED_COMPONENT == this.updateUnit.getType() ? Containers.forCustomUninstall() : Containers.forUninstall();
            this.uninstallationAllowed = Installed.isOperationAllowed(this.updateUnit, this.installEl, container);
            this.deactivationAllowed = Installed.isOperationAllowed(this.updateUnit, this.installEl, Containers.forDisable());
            this.activationAllowed = Installed.isOperationAllowed(this.updateUnit, this.installEl, Containers.forEnable());
            this.initState();
        }

        public boolean isUninstallAllowed() {
            return this.uninstallationAllowed;
        }

        public boolean isDeactivationAllowed() {
            return this.deactivationAllowed;
        }

        public boolean isActivationAllowed() {
            return this.activationAllowed;
        }

        @Override
        public boolean isMarked() {
            OperationContainer<OperationSupport> container = UpdateManager.TYPE.CUSTOM_HANDLED_COMPONENT == this.updateUnit.getType() ? Containers.forCustomUninstall() : Containers.forUninstall();
            boolean uninstallMarked = container.contains(this.installEl);
            boolean deactivateMarked = Containers.forDisable().contains(this.installEl);
            boolean activateMarked = Containers.forEnable().contains(this.installEl);
            return deactivateMarked || uninstallMarked || activateMarked;
        }

        @Override
        public void setMarked(boolean marked) {
            OperationContainer<OperationSupport> container;
            assert (marked != this.isMarked());
            if (this.isUninstallAllowed()) {
                container = UpdateManager.TYPE.CUSTOM_HANDLED_COMPONENT == this.updateUnit.getType() ? Containers.forCustomUninstall() : Containers.forUninstall();
                if (marked) {
                    container.add(this.updateUnit, this.installEl);
                } else {
                    container.remove(this.installEl);
                }
            }
            if (this.isDeactivationAllowed()) {
                container = Containers.forDisable();
                if (marked) {
                    container.add(this.updateUnit, this.installEl);
                } else {
                    container.remove(this.installEl);
                }
            } else if (this.isActivationAllowed()) {
                container = Containers.forEnable();
                if (marked) {
                    container.add(this.updateUnit, this.installEl);
                } else {
                    container.remove(this.installEl);
                }
            }
        }

        public static int compareEnabledState(Unit u1, Unit u2) {
            if (u1 instanceof Installed && u2 instanceof Installed) {
                Installed unit1 = (Installed)u1;
                Installed unit2 = (Installed)u2;
                int retval = Boolean.valueOf(unit1.getRelevantElement().isEnabled()).compareTo(unit2.getRelevantElement().isEnabled());
                return retval == 0 ? Boolean.valueOf(unit1.updateUnit.isPending()).compareTo(unit2.updateUnit.isPending()) : retval;
            }
            return Unit.compareDisplayVersions(u1, u2);
        }

        public static int compareInstalledVersions(Unit u1, Unit u2) {
            if (u1 instanceof Installed && u2 instanceof Installed) {
                Installed unit1 = (Installed)u1;
                Installed unit2 = (Installed)u2;
                if (unit1.getInstalledVersion() == null) {
                    if (unit2.getInstalledVersion() == null) {
                        return 0;
                    }
                    return -1;
                }
                if (unit2.getInstalledVersion() == null) {
                    return 1;
                }
                return new SpecificationVersion(unit1.getInstalledVersion()).compareTo(new SpecificationVersion(unit2.getInstalledVersion()));
            }
            return Unit.compareDisplayVersions(u1, u2);
        }

        @Override
        public boolean canBeMarked() {
            return super.canBeMarked() && (this.isDeactivationAllowed() || this.isUninstallAllowed() || this.isActivationAllowed());
        }

        public String getInstalledVersion() {
            return this.installEl.getSpecificationVersion();
        }

        public String getBackupVersion() {
            return this.backupEl == null ? "-" : this.backupEl.getSpecificationVersion();
        }

        public Integer getMyRating() {
            return null;
        }

        @Override
        public UpdateElement getRelevantElement() {
            return this.installEl;
        }

        @Override
        public int getCompleteSize() {
            return -1;
        }

        @Override
        public UnitCategoryTableModel.Type getModelType() {
            return UnitCategoryTableModel.Type.INSTALLED;
        }
    }
}

