/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.filters.library;

import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.Icon;
import org.gephi.desktop.filters.library.FilterBuilderNodeDefaultAction;
import org.gephi.filters.spi.FilterBuilder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;

public class FilterBuilderNode
extends AbstractNode {
    public static final DataFlavor DATA_FLAVOR = new DataFlavor(FilterBuilder.class, "filterbuilder");
    private final FilterBuilder filterBuilder;
    private final FilterTransferable transferable;

    public FilterBuilderNode(FilterBuilder filterBuilder) {
        super(Children.LEAF);
        this.filterBuilder = filterBuilder;
        this.setName(filterBuilder.getName());
        this.transferable = new FilterTransferable();
        if (filterBuilder.getDescription() != null) {
            this.setShortDescription(filterBuilder.getDescription());
        }
    }

    public String getHtmlDisplayName() {
        return super.getName();
    }

    public Image getIcon(int type) {
        try {
            if (this.filterBuilder.getIcon() != null) {
                return ImageUtilities.icon2Image((Icon)this.filterBuilder.getIcon());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ImageUtilities.loadImage((String)"DesktopFilters/funnel.png", (boolean)false);
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public Action getPreferredAction() {
        return FilterBuilderNodeDefaultAction.instance;
    }

    public FilterBuilder getBuilder() {
        return this.filterBuilder;
    }

    public Transferable drag() throws IOException {
        return this.transferable;
    }

    public Action[] getActions(boolean context) {
        return new Action[0];
    }

    private class FilterTransferable
    implements Transferable {
        private FilterTransferable() {
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DATA_FLAVOR};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor == DATA_FLAVOR;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor == DATA_FLAVOR) {
                return FilterBuilderNode.this.filterBuilder;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }
}

