/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.search.impl;

import org.gephi.desktop.search.api.SearchCategory;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public abstract class SearchCategoryImpl
implements SearchCategory {
    private static final String NODE_ID = "Nodes";
    private static final String EDGE_ID = "Edges";

    public static SearchCategory NODES() {
        return Lookup.getDefault().lookupAll(SearchCategory.class).stream().filter(c -> c.getId().equals(NODE_ID)).findFirst().orElse(null);
    }

    public static SearchCategory EDGES() {
        return Lookup.getDefault().lookupAll(SearchCategory.class).stream().filter(c -> c.getId().equals(EDGE_ID)).findFirst().orElse(null);
    }

    @Override
    public abstract String getId();

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(SearchCategoryImpl.class, (String)("Category." + this.getId() + ".displayName"));
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SearchCategoryImpl)) {
            return false;
        }
        SearchCategory that = (SearchCategory)o;
        return this.getId().equals(that.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public static final class EdgeSearchCategoryImpl
    extends SearchCategoryImpl {
        @Override
        public String getId() {
            return SearchCategoryImpl.EDGE_ID;
        }
    }

    public static final class NodeSearchCategoryImpl
    extends SearchCategoryImpl {
        @Override
        public String getId() {
            return SearchCategoryImpl.NODE_ID;
        }
    }
}

