/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.laf.flatlaf.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.SlidingButton;
import org.netbeans.swing.tabcontrol.SlidingButtonUI;

public class FlatSlidingButtonUI
extends SlidingButtonUI {
    private boolean defaults_initialized = false;
    private Color hoverBackground;
    private Color selectedBackground;
    private Color attentionBackground;
    private Color attentionForeground;
    private static final FlatSlidingButtonUI INSTANCE = new FlatSlidingButtonUI();

    public static ComponentUI createUI(JComponent c) {
        return INSTANCE;
    }

    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        if (!this.defaults_initialized) {
            this.hoverBackground = UIManager.getColor("SlidingButton.hoverBackground");
            this.selectedBackground = UIManager.getColor("SlidingButton.selectedBackground");
            this.attentionBackground = UIManager.getColor("SlidingButton.attentionBackground");
            this.attentionForeground = UIManager.getColor("SlidingButton.attentionForeground");
            this.defaults_initialized = true;
        }
        LookAndFeel.installProperty(b, "opaque", false);
    }

    public void paint(Graphics g, JComponent c) {
        if (((SlidingButton)c).isBlinkState()) {
            g.setColor(this.attentionBackground);
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        super.paint(g, c);
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        if (((SlidingButton)b).isBlinkState()) {
            return;
        }
        ButtonModel bm = b.getModel();
        g.setColor(bm.isPressed() || bm.isArmed() || bm.isSelected() ? this.selectedBackground : this.hoverBackground);
        g.fillRect(0, 0, b.getWidth(), b.getHeight());
    }

    protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
        if (((SlidingButton)b).isBlinkState()) {
            Color oldForeground = b.getForeground();
            b.setForeground(this.attentionForeground);
            super.paintText(g, b, textRect, text);
            b.setForeground(oldForeground);
        } else {
            super.paintText(g, b, textRect, text);
        }
    }
}

