/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradle.diagnostic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\u0018\u0000 \t2\u00060\u0001j\u0002`\u0002:\u0001\tB\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/gradle/diagnostic/CompilerInternalError;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "cause", "", "<init>", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "Companion", "kotlin.gradle.gradle"})
public final class CompilerInternalError
extends Exception {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Pattern STACK_TRACE_ELEMENT_PATTERN = Pattern.compile("at (.+)\\.(.+)\\(([^:]+)(:?)(\\d*)\\)$");
    @NotNull
    private static final String CAUSED_BY_PREFIX = "Caused by:";

    public CompilerInternalError(@NotNull String message2, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        super(message2, cause);
    }

    public /* synthetic */ CompilerInternalError(String string, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        this(string, throwable);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\rJf\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0016\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\n0\u0014j\b\u0012\u0004\u0012\u00020\n`\u00152:\u0010\u0016\u001a6\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\r0\u00170\u0014j\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\r0\u0017`\u0015H\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/gradle/diagnostic/CompilerInternalError$Companion;", "", "<init>", "()V", "STACK_TRACE_ELEMENT_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "CAUSED_BY_PREFIX", "", "parseStackTraceLine", "Ljava/lang/StackTraceElement;", "line", "parseStack", "", "", "rawStack", "joinIntoException", "Lorg/jetbrains/kotlin/idea/gradle/diagnostic/CompilerInternalError;", "message", "currentStack", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "reasonsList", "Lkotlin/Pair;", "kotlin.gradle.gradle"})
    @SourceDebugExtension(value={"SMAP\nCompilerInternalError.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompilerInternalError.kt\norg/jetbrains/kotlin/idea/gradle/diagnostic/CompilerInternalError$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,78:1\n1869#2:79\n1870#2:81\n1869#2:86\n1870#2:91\n1#3:80\n37#4:82\n36#4,3:83\n37#4:87\n36#4,3:88\n*S KotlinDebug\n*F\n+ 1 CompilerInternalError.kt\norg/jetbrains/kotlin/idea/gradle/diagnostic/CompilerInternalError$Companion\n*L\n40#1:79\n40#1:81\n71#1:86\n71#1:91\n69#1:82\n69#1:83,3\n72#1:87\n72#1:88,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final StackTraceElement parseStackTraceLine(String line) {
            Matcher matcher = STACK_TRACE_ELEMENT_PATTERN.matcher(((Object)StringsKt.trim((CharSequence)line)).toString());
            if (matcher.matches()) {
                String declaringClass = matcher.group(1);
                String methodName = matcher.group(2);
                String fileName = matcher.group(3);
                String lineNumberString = matcher.group(5);
                Intrinsics.checkNotNull((Object)lineNumberString);
                int lineNumber = StringsKt.isBlank((CharSequence)lineNumberString) ? 0 : Integer.parseInt(lineNumberString);
                return new StackTraceElement(declaringClass, methodName, fileName, lineNumber);
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Throwable> parseStack(@NotNull List<String> rawStack) {
            Intrinsics.checkNotNullParameter(rawStack, (String)"rawStack");
            Ref.ObjectRef currentMessage = new Ref.ObjectRef();
            Ref.ObjectRef currentStack = new Ref.ObjectRef();
            currentStack.element = new ArrayList();
            Ref.ObjectRef currentReasonsList = new Ref.ObjectRef();
            currentReasonsList.element = new ArrayList();
            ArrayList<CompilerInternalError> exceptions = new ArrayList<CompilerInternalError>();
            org.jetbrains.kotlin.idea.gradle.diagnostic.CompilerInternalError$Companion.parseStack$clearValues((Ref.ObjectRef<String>)currentMessage, (Ref.ObjectRef<ArrayList<StackTraceElement>>)currentStack, (Ref.ObjectRef<ArrayList<Pair<String, List<StackTraceElement>>>>)currentReasonsList);
            Iterable $this$forEach$iv = rawStack;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object;
                block11: {
                    String it;
                    block10: {
                        void message2;
                        it = (String)element$iv;
                        boolean bl = false;
                        if (((CharSequence)it).length() == 0 || StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)it)).toString(), (String)"...", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)it)).toString(), (String)"Attachments:", (boolean)false, (int)2, null)) continue;
                        if (StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)it)).toString(), (String)"---", (boolean)false, (int)2, null)) {
                            exceptions.add(Companion.joinIntoException((String)currentMessage.element, (ArrayList)currentStack.element, (ArrayList)currentReasonsList.element));
                            org.jetbrains.kotlin.idea.gradle.diagnostic.CompilerInternalError$Companion.parseStack$clearValues((Ref.ObjectRef<String>)currentMessage, (Ref.ObjectRef<ArrayList<StackTraceElement>>)currentStack, (Ref.ObjectRef<ArrayList<Pair<String, List<StackTraceElement>>>>)currentReasonsList);
                            continue;
                        }
                        if (StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)it)).toString(), (String)"at", (boolean)false, (int)2, null)) {
                            if (Companion.parseStackTraceLine(((Object)StringsKt.trim((CharSequence)it)).toString()) != null) {
                                StackTraceElement stackTraceElement;
                                StackTraceElement it2 = stackTraceElement;
                                boolean bl2 = false;
                                ((ArrayList)currentStack.element).add(it2);
                            }
                            continue;
                        }
                        if (StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)it)).toString(), (String)CompilerInternalError.CAUSED_BY_PREFIX, (boolean)false, (int)2, null)) {
                            ArrayList arrayList = (ArrayList)currentReasonsList.element;
                            String string = (String)currentMessage.element;
                            if (string == null) {
                                string = "TODO";
                            }
                            arrayList.add(new Pair((Object)string, currentStack.element));
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)StringsKt.trim((CharSequence)it)).toString().substring(10), (String)"substring(...)");
                            currentMessage.element = currentMessage.element;
                            currentStack.element = new ArrayList();
                            continue;
                        }
                        Ref.ObjectRef objectRef = currentMessage;
                        object = (String)currentMessage.element;
                        if (object == null) break block10;
                        String bl2 = object;
                        Ref.ObjectRef objectRef2 = objectRef;
                        boolean bl3 = false;
                        String string = (String)message2 + " " + ((Object)StringsKt.trim((CharSequence)it)).toString();
                        objectRef = objectRef2;
                        object = string;
                        if (string != null) break block11;
                    }
                    object = ((Object)StringsKt.trim((CharSequence)it)).toString();
                }
                objectRef.element = object;
            }
            exceptions.add(this.joinIntoException((String)currentMessage.element, (ArrayList)currentStack.element, (ArrayList)currentReasonsList.element));
            return exceptions;
        }

        /*
         * WARNING - void declaration
         */
        private final CompilerInternalError joinIntoException(String message2, ArrayList<StackTraceElement> currentStack, ArrayList<Pair<String, List<StackTraceElement>>> reasonsList) {
            void it;
            CompilerInternalError compilerInternalError;
            Ref.ObjectRef exception = new Ref.ObjectRef();
            String string = message2;
            if (string == null) {
                string = "TODO";
            }
            CompilerInternalError compilerInternalError2 = compilerInternalError = new CompilerInternalError(string, null, 2, null);
            Ref.ObjectRef objectRef = exception;
            boolean bl = false;
            Collection $this$toTypedArray$iv = currentStack;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            it.setStackTrace(thisCollection$iv.toArray(new StackTraceElement[0]));
            objectRef.element = compilerInternalError;
            Iterable $this$forEach$iv = CollectionsKt.asReversedMutable((List)reasonsList);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void it2;
                CompilerInternalError compilerInternalError3;
                Pair pair = (Pair)element$iv;
                boolean bl2 = false;
                String message3 = (String)pair.component1();
                List stacktrace = (List)pair.component2();
                CompilerInternalError compilerInternalError4 = compilerInternalError3 = new CompilerInternalError(message3, (Throwable)exception.element);
                Ref.ObjectRef objectRef2 = exception;
                boolean bl3 = false;
                Collection $this$toTypedArray$iv2 = stacktrace;
                boolean $i$f$toTypedArray2 = false;
                Collection thisCollection$iv2 = $this$toTypedArray$iv2;
                it2.setStackTrace(thisCollection$iv2.toArray(new StackTraceElement[0]));
                objectRef2.element = compilerInternalError3;
            }
            return (CompilerInternalError)exception.element;
        }

        private static final void parseStack$clearValues(Ref.ObjectRef<String> currentMessage, Ref.ObjectRef<ArrayList<StackTraceElement>> currentStack, Ref.ObjectRef<ArrayList<Pair<String, List<StackTraceElement>>>> currentReasonsList) {
            currentMessage.element = null;
            currentStack.element = new ArrayList();
            currentReasonsList.element = new ArrayList();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

