/*
 * Decompiled with CFR 0.152.
 */
package externalApp;

import externalApp.ExternalApp;
import externalApp.ExternalAppEntry;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;

class ExternalAppEntryImpl
implements ExternalAppEntry {
    private final String[] args;
    private final Class<? extends ExternalApp> externalAppClass;

    ExternalAppEntryImpl(String[] args, Class<? extends ExternalApp> externalAppClass) {
        this.args = args;
        this.externalAppClass = externalAppClass;
    }

    @Override
    public String[] getArgs() {
        return this.args;
    }

    @Override
    public Map<String, String> getEnvironment() {
        return System.getenv();
    }

    @Override
    public String getWorkingDirectory() {
        return System.getProperty("user.dir");
    }

    @Override
    public PrintStream getStderr() {
        return System.err;
    }

    @Override
    public PrintStream getStdout() {
        return System.out;
    }

    @Override
    public InputStream getStdin() {
        return System.in;
    }

    @Override
    public Path getExecutablePath() {
        try {
            return Paths.get(this.externalAppClass.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

