/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.core.trace.impl.interpret;

import com.intellij.debugger.streams.core.trace.ArrayReference;
import com.intellij.debugger.streams.core.trace.CallTraceInterpreter;
import com.intellij.debugger.streams.core.trace.IntegerValue;
import com.intellij.debugger.streams.core.trace.TraceElement;
import com.intellij.debugger.streams.core.trace.TraceInfo;
import com.intellij.debugger.streams.core.trace.Value;
import com.intellij.debugger.streams.core.trace.impl.TraceElementImpl;
import com.intellij.debugger.streams.core.trace.impl.interpret.SimplePeekCallTraceInterpreter;
import com.intellij.debugger.streams.core.trace.impl.interpret.ValuesOrderInfo;
import com.intellij.debugger.streams.core.trace.impl.interpret.ex.UnexpectedValueException;
import com.intellij.debugger.streams.core.trace.impl.interpret.ex.UnexpectedValueTypeException;
import com.intellij.debugger.streams.core.wrapper.StreamCall;
import java.util.HashMap;
import java.util.Map;
import java.util.PrimitiveIterator;
import one.util.streamex.IntStreamEx;
import org.jetbrains.annotations.NotNull;

public class CollectIdentityTraceInterpreter
implements CallTraceInterpreter {
    private final SimplePeekCallTraceInterpreter myPeekResolver = new SimplePeekCallTraceInterpreter();

    @Override
    @NotNull
    public TraceInfo resolve(@NotNull StreamCall call, @NotNull Value value) {
        if (call == null) {
            CollectIdentityTraceInterpreter.$$$reportNull$$$0(0);
        }
        if (value == null) {
            CollectIdentityTraceInterpreter.$$$reportNull$$$0(1);
        }
        if (!(value instanceof ArrayReference)) {
            throw new UnexpectedValueTypeException("Array reference expected. But " + value.typeName() + " received");
        }
        ArrayReference array = (ArrayReference)value;
        TraceInfo resolved = this.myPeekResolver.resolve(call, array.getValue(0));
        Map<Integer, TraceElement> before = resolved.getValuesOrderBefore();
        if (before.isEmpty()) {
            TraceInfo traceInfo = resolved;
            if (traceInfo == null) {
                CollectIdentityTraceInterpreter.$$$reportNull$$$0(2);
            }
            return traceInfo;
        }
        int timeAfter = CollectIdentityTraceInterpreter.extractTime(array) + 1;
        PrimitiveIterator.OfInt iterator = IntStreamEx.of(before.keySet()).sorted().iterator();
        HashMap<Integer, TraceElementImpl> after = new HashMap<Integer, TraceElementImpl>(before.size());
        while (iterator.hasNext()) {
            int timeBefore = iterator.next();
            TraceElement elementBefore = before.get(timeBefore);
            TraceElementImpl elementAfter = new TraceElementImpl(timeAfter, elementBefore.getValue());
            after.put(timeAfter, elementAfter);
            ++timeAfter;
        }
        return new ValuesOrderInfo(call, before, after);
    }

    public static int extractTime(@NotNull ArrayReference value) {
        Value time;
        Value timeArray;
        if (value == null) {
            CollectIdentityTraceInterpreter.$$$reportNull$$$0(3);
        }
        if ((timeArray = value.getValue(1)) instanceof ArrayReference && (time = ((ArrayReference)timeArray).getValue(0)) instanceof IntegerValue) {
            return ((IntegerValue)time).value();
        }
        throw new UnexpectedValueException("Could not find a maximum time value");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/streams/core/trace/impl/interpret/CollectIdentityTraceInterpreter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/streams/core/trace/impl/interpret/CollectIdentityTraceInterpreter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "extractTime";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

