/*
 * Decompiled with CFR 0.152.
 */
package org.GNOME.Accessibility;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.swing.JComboBox;
import org.GNOME.Accessibility.AtkKeyEvent;
import org.GNOME.Accessibility.AtkUtil;

public class AtkWrapper {
    static boolean accessibilityEnabled = false;
    final WindowAdapter winAdapter = new WindowAdapter(this){
        {
            Objects.requireNonNull(atkWrapper);
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object instanceof Accessible) {
                AccessibleContext accessibleContext = ((Accessible)object).getAccessibleContext();
                AtkWrapper.windowActivate(accessibleContext);
            }
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object instanceof Accessible) {
                AccessibleContext accessibleContext = ((Accessible)object).getAccessibleContext();
                AtkWrapper.windowDeactivate(accessibleContext);
            }
        }

        @Override
        public void windowStateChanged(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object instanceof Accessible) {
                AccessibleContext accessibleContext = ((Accessible)object).getAccessibleContext();
                AtkWrapper.windowStateChange(accessibleContext);
                if ((windowEvent.getNewState() & 6) == 6) {
                    AtkWrapper.windowMaximize(accessibleContext);
                }
            }
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object instanceof Accessible) {
                AccessibleContext accessibleContext = ((Accessible)object).getAccessibleContext();
                AtkWrapper.windowRestore(accessibleContext);
            }
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object instanceof Accessible) {
                AccessibleContext accessibleContext = ((Accessible)object).getAccessibleContext();
                AtkWrapper.windowMinimize(accessibleContext);
            }
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object instanceof Accessible) {
                boolean bl = AtkWrapper.isToplevel(object);
                AccessibleContext accessibleContext = ((Accessible)object).getAccessibleContext();
                AtkWrapper.windowOpen(accessibleContext, bl);
            }
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object instanceof Accessible) {
                boolean bl = AtkWrapper.isToplevel(object);
                AccessibleContext accessibleContext = ((Accessible)object).getAccessibleContext();
                AtkWrapper.windowClose(accessibleContext, bl);
            }
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object instanceof Accessible) {
                boolean bl = AtkWrapper.isToplevel(object);
                AccessibleContext accessibleContext = ((Accessible)object).getAccessibleContext();
                AtkWrapper.windowClose(accessibleContext, bl);
            }
        }

        @Override
        public void windowGainedFocus(WindowEvent windowEvent) {
        }

        @Override
        public void windowLostFocus(WindowEvent windowEvent) {
        }
    };
    final ComponentAdapter componentAdapter = new ComponentAdapter(this){
        {
            Objects.requireNonNull(atkWrapper);
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            Object object = componentEvent.getSource();
            if (object instanceof Accessible) {
                AccessibleContext accessibleContext = ((Accessible)object).getAccessibleContext();
                AtkWrapper.boundsChanged(accessibleContext);
            }
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            Object object = componentEvent.getSource();
            if (object instanceof Accessible) {
                AccessibleContext accessibleContext = ((Accessible)object).getAccessibleContext();
                AtkWrapper.boundsChanged(accessibleContext);
            }
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            Object object = componentEvent.getSource();
            if (object instanceof Accessible) {
                AccessibleContext accessibleContext = ((Accessible)object).getAccessibleContext();
                AtkWrapper.componentAdded(accessibleContext);
            }
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            Object object = componentEvent.getSource();
            if (object instanceof Accessible) {
                AccessibleContext accessibleContext = ((Accessible)object).getAccessibleContext();
                AtkWrapper.componentRemoved(accessibleContext);
            }
        }
    };
    final AWTEventListener globalListener = new AWTEventListener(this){
        private boolean firstEvent;
        final /* synthetic */ AtkWrapper this$0;
        {
            AtkWrapper atkWrapper2 = atkWrapper;
            Objects.requireNonNull(atkWrapper2);
            this.this$0 = atkWrapper2;
            this.firstEvent = true;
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            if (this.firstEvent && accessibilityEnabled) {
                this.firstEvent = false;
                try {
                    AtkWrapper.loadAtkBridge();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (aWTEvent instanceof WindowEvent) {
                switch (aWTEvent.getID()) {
                    case 200: {
                        Window window = ((WindowEvent)aWTEvent).getWindow();
                        window.addWindowListener(this.this$0.winAdapter);
                        window.addWindowStateListener(this.this$0.winAdapter);
                        window.addWindowFocusListener(this.this$0.winAdapter);
                        break;
                    }
                    case 208: {
                        AtkWrapper.dispatchFocusEvent(null);
                        break;
                    }
                }
            } else if (aWTEvent instanceof ContainerEvent) {
                switch (aWTEvent.getID()) {
                    case 300: {
                        Component component = ((ContainerEvent)aWTEvent).getChild();
                        component.addComponentListener(this.this$0.componentAdapter);
                        break;
                    }
                    case 301: {
                        Component component = ((ContainerEvent)aWTEvent).getChild();
                        component.removeComponentListener(this.this$0.componentAdapter);
                        break;
                    }
                }
            } else if (aWTEvent instanceof FocusEvent) {
                switch (aWTEvent.getID()) {
                    case 1004: {
                        AtkWrapper.dispatchFocusEvent(aWTEvent.getSource());
                        break;
                    }
                }
            }
        }
    };
    static AccessibleContext oldSourceContext;
    static AccessibleContext savedSourceContext;
    static AccessibleContext oldPaneContext;
    final Toolkit toolkit = Toolkit.getDefaultToolkit();
    static PropertyChangeListener propertyChangeListener;

    static void initAtk() {
        System.loadLibrary("atk-wrapper");
        if (AtkWrapper.initNativeLibrary()) {
            accessibilityEnabled = true;
        }
    }

    public static boolean isToplevel(Object object) {
        boolean bl = false;
        if (object instanceof Window || object instanceof Frame || object instanceof Dialog) {
            bl = true;
        }
        return bl;
    }

    static void dispatchFocusEvent(Object object) {
        if (object == null) {
            oldSourceContext = null;
            return;
        }
        try {
            Object object2;
            Object object3;
            AccessibleRole accessibleRole;
            AccessibleContext accessibleContext;
            if (object instanceof AccessibleContext) {
                accessibleContext = (AccessibleContext)object;
            } else if (object instanceof Accessible) {
                accessibleContext = ((Accessible)object).getAccessibleContext();
            } else {
                return;
            }
            if (accessibleContext == oldSourceContext) {
                return;
            }
            if (oldSourceContext != null) {
                accessibleRole = oldSourceContext.getAccessibleRole();
                if ((accessibleRole == AccessibleRole.MENU || accessibleRole == AccessibleRole.MENU_ITEM) && ((String)(object3 = "javax.swing.JRootPane$AccessibleJRootPane")).compareTo((String)(object2 = accessibleContext.getClass().getName())) == 0) {
                    oldPaneContext = accessibleContext;
                    return;
                }
                savedSourceContext = accessibleContext;
            } else if (oldPaneContext == accessibleContext) {
                accessibleContext = savedSourceContext;
            } else {
                savedSourceContext = accessibleContext;
            }
            oldSourceContext = accessibleContext;
            accessibleRole = accessibleContext.getAccessibleRole();
            if (accessibleRole == AccessibleRole.PAGE_TAB_LIST && (object3 = accessibleContext.getAccessibleSelection()) != null && object3.getAccessibleSelectionCount() > 0) {
                object2 = object3.getAccessibleSelection(0);
                if (object2 instanceof AccessibleContext) {
                    accessibleContext = (AccessibleContext)object2;
                } else if (object2 instanceof Accessible) {
                    accessibleContext = ((Accessible)object2).getAccessibleContext();
                } else {
                    return;
                }
            }
            AtkWrapper.focusNotify(accessibleContext);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void registerPropertyChangeListener(AccessibleContext accessibleContext) {
        if (accessibleContext != null) {
            AtkUtil.invokeInSwing(() -> accessibleContext.addPropertyChangeListener(propertyChangeListener));
        }
    }

    public static native boolean initNativeLibrary();

    public static native void loadAtkBridge();

    public static native void GC();

    public static native void focusNotify(AccessibleContext var0);

    public static native void windowOpen(AccessibleContext var0, boolean var1);

    public static native void windowClose(AccessibleContext var0, boolean var1);

    public static native void windowMinimize(AccessibleContext var0);

    public static native void windowMaximize(AccessibleContext var0);

    public static native void windowRestore(AccessibleContext var0);

    public static native void windowActivate(AccessibleContext var0);

    public static native void windowDeactivate(AccessibleContext var0);

    public static native void windowStateChange(AccessibleContext var0);

    public static native void emitSignal(AccessibleContext var0, int var1, Object[] var2);

    public static native void objectStateChange(AccessibleContext var0, Object var1, boolean var2);

    public static native void componentAdded(AccessibleContext var0);

    public static native void componentRemoved(AccessibleContext var0);

    public static native void boundsChanged(AccessibleContext var0);

    public static native boolean dispatchKeyEvent(AtkKeyEvent var0);

    public static native long getInstance(AccessibleContext var0);

    public static void printLog(String string) {
        System.out.println(string);
    }

    public AtkWrapper() {
        if (!accessibilityEnabled) {
            return;
        }
        this.toolkit.addAWTEventListener(this.globalListener, 70L);
        this.toolkit.getSystemEventQueue().push(new EventQueue(this){
            boolean previousPressConsumed;
            {
                Objects.requireNonNull(atkWrapper);
                this.previousPressConsumed = false;
            }

            @Override
            public void dispatchEvent(AWTEvent aWTEvent) {
                if (aWTEvent instanceof KeyEvent) {
                    if (aWTEvent.getID() == 401) {
                        boolean bl = AtkWrapper.dispatchKeyEvent(new AtkKeyEvent((KeyEvent)aWTEvent));
                        if (bl) {
                            this.previousPressConsumed = true;
                            return;
                        }
                    } else if (aWTEvent.getID() == 400) {
                        if (this.previousPressConsumed) {
                            return;
                        }
                    } else if (aWTEvent.getID() == 402) {
                        boolean bl = AtkWrapper.dispatchKeyEvent(new AtkKeyEvent((KeyEvent)aWTEvent));
                        this.previousPressConsumed = false;
                        if (bl) {
                            return;
                        }
                    }
                }
                super.dispatchEvent(aWTEvent);
            }
        });
    }

    public static long getInstanceFromSwing(AccessibleContext accessibleContext) {
        return AtkUtil.invokeInSwing(() -> AtkWrapper.getInstance(accessibleContext), 0L);
    }

    public static void main(String[] stringArray) {
        new AtkWrapper();
    }

    static {
        try {
            String string;
            Process process = Runtime.getRuntime().exec("/usr/bin/xprop -root");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.indexOf("AT_SPI_IOR") < 0 && string.indexOf("AT_SPI_BUS") < 0) continue;
                AtkWrapper.initAtk();
                break;
            }
            if (!accessibilityEnabled) {
                process = Runtime.getRuntime().exec("dbus-send --session --dest=org.a11y.Bus --print-reply /org/a11y/bus org.a11y.Bus.GetAddress");
                bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while (bufferedReader.readLine() != null) {
                }
                process.waitFor();
                if (process.exitValue() == 0) {
                    AtkWrapper.initAtk();
                }
            }
            List<GarbageCollectorMXBean> list = ManagementFactory.getGarbageCollectorMXBeans();
            for (GarbageCollectorMXBean garbageCollectorMXBean : list) {
                NotificationEmitter notificationEmitter = (NotificationEmitter)((Object)garbageCollectorMXBean);
                NotificationListener notificationListener = new NotificationListener(){

                    @Override
                    public void handleNotification(Notification notification, Object object) {
                        AtkWrapper.GC();
                    }
                };
                notificationEmitter.addNotificationListener(notificationListener, null, null);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            exception.getCause();
        }
        oldSourceContext = null;
        savedSourceContext = null;
        oldPaneContext = null;
        propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                AccessibleContext accessibleContext;
                Object object = propertyChangeEvent.getSource();
                if (object instanceof AccessibleContext) {
                    accessibleContext = (AccessibleContext)object;
                } else if (object instanceof Accessible) {
                    accessibleContext = ((Accessible)object).getAccessibleContext();
                } else {
                    return;
                }
                Object object2 = propertyChangeEvent.getOldValue();
                Object object3 = propertyChangeEvent.getNewValue();
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("AccessibleCaret")) {
                    Object[] objectArray = new Object[]{object3};
                    AtkWrapper.emitSignal(accessibleContext, 0, objectArray);
                } else if (string.equals("AccessibleText")) {
                    if (object3 == null) {
                        return;
                    }
                    if (object3 instanceof Integer) {
                        Object[] objectArray = new Object[]{object3};
                        AtkWrapper.emitSignal(accessibleContext, 21, objectArray);
                    }
                } else if (string.equals("AccessibleChild")) {
                    if (object2 == null && object3 != null) {
                        if (!(object3 instanceof Accessible)) {
                            return;
                        }
                        AccessibleContext accessibleContext2 = ((Accessible)object3).getAccessibleContext();
                        Object[] objectArray = new Object[]{accessibleContext2.getAccessibleIndexInParent(), accessibleContext2};
                        AtkWrapper.emitSignal(accessibleContext, 4, objectArray);
                    } else if (object2 != null && object3 == null) {
                        if (!(object2 instanceof Accessible)) {
                            return;
                        }
                        AccessibleContext accessibleContext3 = ((Accessible)object2).getAccessibleContext();
                        Object[] objectArray = new Object[]{accessibleContext3.getAccessibleIndexInParent(), accessibleContext3};
                        AtkWrapper.emitSignal(accessibleContext, 5, objectArray);
                    }
                } else if (string.equals("AccessibleActiveDescendant")) {
                    if (!(object3 instanceof Accessible)) {
                        return;
                    }
                    AccessibleContext accessibleContext4 = ((Accessible)object3).getAccessibleContext();
                    Object[] objectArray = new Object[]{accessibleContext4};
                    AtkWrapper.emitSignal(accessibleContext, 6, objectArray);
                } else if (string.equals("AccessibleSelection")) {
                    AccessibleSelection accessibleSelection;
                    boolean bl = false;
                    AccessibleRole accessibleRole = accessibleContext.getAccessibleRole();
                    if (accessibleRole == AccessibleRole.TEXT || accessibleRole.toDisplayString(Locale.US).equalsIgnoreCase("paragraph")) {
                        bl = true;
                    } else if (accessibleRole == AccessibleRole.MENU_BAR) {
                        AtkWrapper.dispatchFocusEvent(object);
                    } else if (accessibleRole == AccessibleRole.PAGE_TAB_LIST && (accessibleSelection = accessibleContext.getAccessibleSelection()) != null && accessibleSelection.getAccessibleSelectionCount() > 0) {
                        Accessible accessible = accessibleSelection.getAccessibleSelection(0);
                        AtkWrapper.dispatchFocusEvent(accessible);
                    }
                    if (!bl) {
                        AtkWrapper.emitSignal(accessibleContext, 7, null);
                    }
                } else if (string.equals("AccessibleVisibleData")) {
                    AtkWrapper.emitSignal(accessibleContext, 8, null);
                } else if (string.equals("accessibleActionProperty")) {
                    Object[] objectArray = new Object[]{object2, object3};
                    AtkWrapper.emitSignal(accessibleContext, 9, objectArray);
                } else if (string.equals("AccessibleValue")) {
                    if (object2 instanceof Number && object3 instanceof Number) {
                        Object[] objectArray = new Object[]{((Number)object2).doubleValue(), ((Number)object3).doubleValue()};
                        AtkWrapper.emitSignal(accessibleContext, 10, objectArray);
                    }
                } else if (string.equals("AccessibleDescription")) {
                    AtkWrapper.emitSignal(accessibleContext, 11, null);
                } else if (string.equals("AccessibleName")) {
                    AtkWrapper.emitSignal(accessibleContext, 12, null);
                } else if (string.equals("AccessibleHypertextOffset")) {
                    AtkWrapper.emitSignal(accessibleContext, 13, null);
                } else if (string.equals("accessibleTableModelChanged")) {
                    AtkWrapper.emitSignal(accessibleContext, 20, null);
                } else if (string.equals("accessibleTableCaptionChanged")) {
                    AtkWrapper.emitSignal(accessibleContext, 14, null);
                } else if (string.equals("accessibleTableSummaryChanged")) {
                    AtkWrapper.emitSignal(accessibleContext, 15, null);
                } else if (string.equals("accessibleTableColumnHeaderChanged")) {
                    AtkWrapper.emitSignal(accessibleContext, 16, null);
                } else if (string.equals("accessibleTableColumnDescriptionChanged")) {
                    AtkWrapper.emitSignal(accessibleContext, 17, null);
                } else if (string.equals("accessibleTableRowHeaderChanged")) {
                    AtkWrapper.emitSignal(accessibleContext, 18, null);
                } else if (string.equals("accessibleTableRowDescriptionChanged")) {
                    AtkWrapper.emitSignal(accessibleContext, 19, null);
                } else if (string.equals("AccessibleState")) {
                    AccessibleState accessibleState;
                    Accessible accessible = accessibleContext.getAccessibleParent();
                    AccessibleRole accessibleRole = accessibleContext.getAccessibleRole();
                    if (accessibleRole != null && (object3 == AccessibleState.FOCUSED || object3 == AccessibleState.SELECTED)) {
                        AtkWrapper.dispatchFocusEvent(object);
                    }
                    boolean bl = false;
                    if (object3 != null) {
                        accessibleState = (AccessibleState)object3;
                        bl = true;
                    } else {
                        accessibleState = (AccessibleState)object2;
                        bl = false;
                    }
                    if (accessibleState == AccessibleState.COLLAPSED) {
                        accessibleState = AccessibleState.EXPANDED;
                        bl = false;
                    }
                    if (accessible instanceof JComboBox && object2 == AccessibleState.VISIBLE) {
                        AtkWrapper.objectStateChange(accessibleContext, AccessibleState.SHOWING, bl);
                    }
                    AtkWrapper.objectStateChange(accessibleContext, accessibleState, bl);
                    if (accessible instanceof JComboBox && object3 == AccessibleState.VISIBLE && object2 == null) {
                        AtkWrapper.objectStateChange(accessibleContext, AccessibleState.SHOWING, bl);
                    }
                }
            }
        };
    }
}

