/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.inchi;

import com.sun.jna.Native;
import io.github.dan2097.jnainchi.InchiAtom;
import io.github.dan2097.jnainchi.InchiBond;
import io.github.dan2097.jnainchi.InchiBondStereo;
import io.github.dan2097.jnainchi.InchiBondType;
import io.github.dan2097.jnainchi.InchiFlag;
import io.github.dan2097.jnainchi.InchiInput;
import io.github.dan2097.jnainchi.InchiOptions;
import io.github.dan2097.jnainchi.InchiOutput;
import io.github.dan2097.jnainchi.InchiStereo;
import io.github.dan2097.jnainchi.JnaInchi;
import io.github.dan2097.jnainchi.inchi.InchiLibrary;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javajs.util.BS;
import org.iupac.InChIStructureProvider;
import org.iupac.InchiUtils;
import org.jmol.inchi.InchiJmol;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.viewer.Viewer;

public class InChIJNA
extends InchiJmol {
    private InchiInput inchiModel;
    private Map<InchiAtom, Integer> map = new Hashtable<InchiAtom, Integer>();
    private InchiAtom thisAtom;
    private InchiBond thisBond;
    private InchiStereo thisStereo;
    private static String inchiVersionInternal;

    @Override
    public String getInchi(Viewer vwr, BS atoms, Object molData, String options) {
        if ("version".equals(options)) {
            return InChIJNA.getInternalInchiVersion();
        }
        try {
            options = this.setParameters(options, molData, atoms, vwr);
            if (options == null) {
                return "";
            }
            InchiOptions ops = InChIJNA.getOptions(options.toLowerCase());
            InchiOutput out = null;
            if (this.inputInChI) {
                out = JnaInchi.inchiToInchi((String)molData, ops);
            } else if (!this.optionalFixedH) {
                if (atoms == null) {
                    out = JnaInchi.molToInchi((String)molData, ops);
                } else {
                    InchiInput in = InChIJNA.newInchiStructureBS(vwr, atoms);
                    out = JnaInchi.toInchi(in, InChIJNA.getOptions(this.doGetSmiles ? "fixedh" : options));
                }
            }
            if (out != null) {
                String msg = out.getMessage();
                if (msg != null) {
                    System.err.println(msg);
                }
                this.inchi = out.getInchi();
            }
            if (this.doGetSmiles || this.getInchiModel) {
                this.inchiModel = JnaInchi.getInchiInputFromInchi(this.inchi).getInchiInput();
                return this.doGetSmiles ? this.getSmiles(vwr, this.smilesOptions) : InChIJNA.toJSON(this.inchiModel);
            }
            return this.getKey ? JnaInchi.inchiToInchiKey(this.inchi).getInchiKey() : this.inchi;
        }
        catch (Throwable e) {
            System.out.println(e);
            if (e.getMessage() != null && e.getMessage().indexOf("ption") >= 0) {
                System.out.println(e.getMessage() + ": " + options.toLowerCase() + "\n See https://www.inchi-trust.org/download/104/inchi-faq.pdf for valid options");
            } else {
                e.printStackTrace();
            }
            return "";
        }
    }

    private static InchiOptions getOptions(String options) {
        InchiOptions.InchiOptionsBuilder builder = new InchiOptions.InchiOptionsBuilder();
        StringTokenizer t = new StringTokenizer(options);
        block8: while (t.hasMoreElements()) {
            String o;
            switch (o = t.nextToken()) {
                case "smiles": 
                case "amide": 
                case "imine": {
                    continue block8;
                }
            }
            InchiFlag f = InchiFlag.getFlagFromName((String)o);
            if (f == null) {
                System.err.println("InChIJNA InChI option " + o + " not recognized -- ignored");
                continue;
            }
            builder.withFlag(f);
        }
        return builder.build();
    }

    private static InchiInput newInchiStructureBS(Viewer vwr, BS bsAtoms) {
        InchiInput mol = new InchiInput();
        InchiAtom[] atoms = new InchiAtom[bsAtoms.cardinality()];
        int[] map = new int[bsAtoms.length()];
        BS bsBonds = vwr.ms.getBondsForSelectedAtoms(bsAtoms, false);
        int pt = 0;
        int i = bsAtoms.nextSetBit(0);
        while (i >= 0) {
            Atom a = vwr.ms.at[i];
            String sym = a.getElementSymbolIso(false);
            int iso = a.getIsotopeNumber();
            if (a.getElementNumber() == 1) {
                sym = "H";
            }
            atoms[pt] = new InchiAtom(sym, a.x, a.y, a.z);
            mol.addAtom(atoms[pt]);
            atoms[pt].setCharge(a.getFormalCharge());
            if (iso > 0) {
                atoms[pt].setIsotopicMass(iso);
            }
            map[i] = pt++;
            i = bsAtoms.nextSetBit(i + 1);
        }
        Bond[] bonds = vwr.ms.bo;
        i = bsBonds.nextSetBit(0);
        while (i >= 0) {
            InchiBondType order;
            Bond bond = bonds[i];
            if (bond != null && (order = InChIJNA.getOrder(Math.max(bond.isPartial() ? 1 : 0, bond.getCovalentOrder()))) != null) {
                int atom1 = bond.getAtomIndex1();
                int atom2 = bond.getAtomIndex2();
                InchiBondStereo stereo = InChIJNA.getInChIStereo(bond.getBondType());
                mol.addBond(new InchiBond(atoms[map[atom1]], atoms[map[atom2]], order, stereo));
            }
            i = bsBonds.nextSetBit(i + 1);
        }
        return mol;
    }

    private static InchiBondStereo getInChIStereo(int jmolOrder) {
        switch (jmolOrder) {
            case 1041: {
                return InchiBondStereo.SINGLE_1DOWN;
            }
            case 1025: {
                return InchiBondStereo.SINGLE_1UP;
            }
            case 1057: {
                return InchiBondStereo.SINGLE_1EITHER;
            }
        }
        return InchiBondStereo.NONE;
    }

    private static InchiBondType getOrder(int jmolOrder) {
        switch (jmolOrder) {
            case 1: 
            case 1025: 
            case 1041: 
            case 1057: {
                return InchiBondType.SINGLE;
            }
            case 2: {
                return InchiBondType.DOUBLE;
            }
            case 3: {
                return InchiBondType.TRIPLE;
            }
        }
        return null;
    }

    private static String toJSON(InchiInput mol) {
        int i;
        int na = InChIJNA.sizeof(mol.getAtoms());
        int nb = InChIJNA.sizeof(mol.getBonds());
        int ns = InChIJNA.sizeof(mol.getStereos());
        HashMap<InchiAtom, Integer> mapAtoms = new HashMap<InchiAtom, Integer>();
        boolean haveXYZ = false;
        for (int i2 = 0; i2 < na; ++i2) {
            InchiAtom a = mol.getAtom(i2);
            if (a.getX() == 0.0 && a.getY() == 0.0 && a.getZ() == 0.0) continue;
            haveXYZ = true;
            break;
        }
        String s = "{";
        s = s + "\n\"atomCount\":" + na + ",\n";
        s = s + "\"atoms\":[\n";
        for (i = 0; i < na; ++i) {
            InchiAtom a = mol.getAtom(i);
            mapAtoms.put(a, i);
            if (i > 0) {
                s = s + ",\n";
            }
            s = s + "{";
            s = s + InChIJNA.toJSONInt("index", i, "");
            s = s + InChIJNA.toJSONNotNone("elname", a.getElName(), ",");
            if (haveXYZ) {
                s = s + InChIJNA.toJSONDouble("x", a.getX(), ",");
                s = s + InChIJNA.toJSONDouble("y", a.getY(), ",");
                s = s + InChIJNA.toJSONDouble("z", a.getZ(), ",");
            }
            s = s + InChIJNA.toJSONNonZero("isotopeMass", a.getIsotopicMass(), ",");
            s = s + InChIJNA.toJSONNonZero("charge", a.getCharge(), ",");
            s = s + InChIJNA.toJSONNotNone("radical", (Object)a.getRadical(), ",");
            if (a.getImplicitHydrogen() > 0) {
                s = s + InChIJNA.toJSONNonZero("implicitH", a.getImplicitHydrogen(), ",");
            }
            s = s + InChIJNA.toJSONNonZero("implicitDeuterium", a.getImplicitDeuterium(), ",");
            s = s + InChIJNA.toJSONNonZero("implicitProtium", a.getImplicitProtium(), ",");
            s = s + InChIJNA.toJSONNonZero("implicitTritium", a.getImplicitTritium(), ",");
            s = s + "}";
        }
        s = s + "\n],";
        s = s + "\n\"bondCount\":" + nb + ",\n";
        s = s + "\n\"bonds\":[\n";
        for (i = 0; i < nb; ++i) {
            if (i > 0) {
                s = s + ",\n";
            }
            s = s + "{";
            InchiBond b = mol.getBond(i);
            s = s + InChIJNA.toJSONInt("originAtom", (Integer)mapAtoms.get(b.getStart()), "");
            s = s + InChIJNA.toJSONInt("targetAtom", (Integer)mapAtoms.get(b.getEnd()), ",");
            String bt = InChIJNA.uc((Object)b.getType());
            if (!bt.equals("SINGLE")) {
                s = s + InChIJNA.toJSONString("type", bt, ",");
            }
            s = s + InChIJNA.toJSONNotNone("stereo", InChIJNA.uc((Object)b.getStereo()), ",");
            s = s + "}";
        }
        s = s + "\n]";
        if (ns > 0) {
            s = s + ",\n\"stereoCount\":" + ns + ",\n";
            s = s + "\"stereo\":[\n";
            for (i = 0; i < ns; ++i) {
                if (i > 0) {
                    s = s + ",\n";
                }
                s = s + "{";
                InchiStereo d = mol.getStereos().get(i);
                s = s + InChIJNA.toJSONNotNone("type", InChIJNA.uc((Object)d.getType()), "");
                s = s + InChIJNA.toJSONNotNone("parity", InChIJNA.uc((Object)d.getParity()), ",");
                InchiAtom[] an = d.getAtoms();
                int[] nbs = new int[an.length];
                for (int j = 0; j < an.length; ++j) {
                    nbs[j] = (Integer)mapAtoms.get(an[j]);
                }
                s = s + InChIJNA.toJSONArray("neighbors", nbs, ",");
                InchiAtom a = d.getCentralAtom();
                if (a != null) {
                    s = s + InChIJNA.toJSONInt("centralAtom", (Integer)mapAtoms.get(a), ",");
                }
                s = s + "}";
            }
            s = s + "\n]";
        }
        s = s + "}";
        System.out.println(s);
        return s;
    }

    private static int sizeof(List<?> list) {
        return list == null ? 0 : list.size();
    }

    private static String toJSONArray(String key, int[] val, String term) {
        String s = term + "\"" + key + "\":[" + val[0];
        for (int i = 1; i < val.length; ++i) {
            s = s + "," + val[i];
        }
        return s + "]";
    }

    private static String toJSONNonZero(String key, int val, String term) {
        return val == 0 ? "" : InChIJNA.toJSONInt(key, val, term);
    }

    private static String toJSONInt(String key, int val, String term) {
        return term + "\"" + key + "\":" + val;
    }

    private static String toJSONDouble(String key, double val, String term) {
        String s;
        if (val == 0.0) {
            s = "0";
        } else {
            s = "" + (val + (val > 0.0 ? 1.0E-8 : -1.0E-8));
            s = s.substring(0, s.indexOf(".") + 5);
            int n = s.length();
            while (s.charAt(--n) == '0') {
            }
            s = s.substring(0, n + 1);
        }
        return term + "\"" + key + "\":" + s;
    }

    private static String toJSONString(String key, String val, String term) {
        return term + "\"" + key + "\":\"" + val + "\"";
    }

    private static String toJSONNotNone(String key, Object val, String term) {
        String s = val.toString();
        return "NONE".equals(s) ? "" : term + "\"" + key + "\":\"" + s + "\"";
    }

    public void initializeModelForSmiles() {
        int i = this.getNumAtoms();
        while (--i >= 0) {
            this.map.put(this.inchiModel.getAtom(i), i);
        }
    }

    public int getNumAtoms() {
        return InChIJNA.sizeof(this.inchiModel.getAtoms());
    }

    public InChIStructureProvider setAtom(int i) {
        this.thisAtom = this.inchiModel.getAtom(i);
        return this;
    }

    public String getElementType() {
        return this.thisAtom.getElName();
    }

    public double getX() {
        return this.thisAtom.getX();
    }

    public double getY() {
        return this.thisAtom.getY();
    }

    public double getZ() {
        return this.thisAtom.getZ();
    }

    public int getCharge() {
        return this.thisAtom.getCharge();
    }

    public int getIsotopicMass() {
        return InchiUtils.getActualMass((String)this.getElementType(), (int)this.thisAtom.getIsotopicMass());
    }

    public int getImplicitH() {
        return this.thisAtom.getImplicitHydrogen();
    }

    public int getNumBonds() {
        return InChIJNA.sizeof(this.inchiModel.getBonds());
    }

    public InChIStructureProvider setBond(int i) {
        this.thisBond = this.inchiModel.getBond(i);
        return this;
    }

    public int getIndexOriginAtom() {
        return this.map.get(this.thisBond.getStart());
    }

    public int getIndexTargetAtom() {
        return this.map.get(this.thisBond.getEnd());
    }

    public String getInchiBondType() {
        InchiBondType type = this.thisBond.getType();
        return type.name();
    }

    public int getNumStereo0D() {
        return InChIJNA.sizeof(this.inchiModel.getStereos());
    }

    public InChIStructureProvider setStereo0D(int i) {
        this.thisStereo = this.inchiModel.getStereos().get(i);
        return this;
    }

    public int[] getNeighbors() {
        InchiAtom[] an = this.thisStereo.getAtoms();
        int n = an.length;
        int[] a = new int[n];
        for (int i = 0; i < n; ++i) {
            a[i] = this.map.get(an[i]);
        }
        return a;
    }

    public int getCenterAtom() {
        InchiAtom ca = this.thisStereo.getCentralAtom();
        return ca == null ? -1 : this.map.get(ca);
    }

    public String getStereoType() {
        return InChIJNA.uc((Object)this.thisStereo.getType());
    }

    public String getParity() {
        return InChIJNA.uc((Object)this.thisStereo.getParity());
    }

    private static String uc(Object o) {
        return o.toString().toUpperCase();
    }

    public static String getInternalInchiVersion() {
        if (inchiVersionInternal == null) {
            File f = InchiLibrary.JNA_NATIVE_LIB.getFile();
            inchiVersionInternal = InChIJNA.extractInchiVersionInternal(f);
            if (inchiVersionInternal == null) {
                try {
                    f = Native.extractFromResourcePath(InchiLibrary.JNA_NATIVE_LIB.getName());
                    inchiVersionInternal = InChIJNA.extractInchiVersionInternal(f);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (inchiVersionInternal == null) {
                inchiVersionInternal = "unknown";
            }
        }
        return inchiVersionInternal;
    }

    private static String extractInchiVersionInternal(File f) {
        String s = null;
        try (FileInputStream fis = new FileInputStream(f);){
            byte[] b = new byte[(int)f.length()];
            fis.read(b);
            s = new String(b);
            int pt = s.indexOf("InChI version");
            s = pt < 0 ? null : s.substring(pt, s.indexOf(0, pt));
            fis.close();
            f.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s;
    }
}

