/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.bbox.BBoxChooser;
import org.openstreetmap.josm.gui.bbox.SlippyMapBBoxChooser;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class MinimapDialog
extends ToggleDialog
implements NavigatableComponent.ZoomChangeListener,
PropertyChangeListener {
    private SlippyMapBBoxChooser slippyMap;
    private boolean skipEvents;

    public MinimapDialog() {
        super(I18n.tr("Mini map", new Object[0]), "minimap", I18n.tr("Displays a small map of the current edit location", new Object[0]), Shortcut.registerShortcut("subwindow:minimap", I18n.tr("Windows: {0}", I18n.tr("Mini map", new Object[0])), 65535, 5000), 150);
    }

    private synchronized void initialize() {
        if (this.slippyMap != null) {
            return;
        }
        this.slippyMap = new SlippyMapBBoxChooser();
        this.createLayout(this.slippyMap, false, Collections.emptyList());
        this.slippyMap.setSizeButtonVisible(false);
        this.slippyMap.addPropertyChangeListener(BBoxChooser.BBOX_PROP, this);
        MainApplication.getLayerManager().addLayerChangeListener(this.slippyMap);
    }

    @Override
    public void showDialog() {
        this.initialize();
        NavigatableComponent.addZoomChangeListener(this);
        super.showDialog();
    }

    @Override
    public void hideDialog() {
        NavigatableComponent.removeZoomChangeListener(this);
        super.hideDialog();
    }

    @Override
    public void zoomChanged() {
        if (!this.skipEvents && MainApplication.isDisplayingMapView()) {
            MapView mv = MainApplication.getMap().mapView;
            Bounds currentBounds = new Bounds(mv.getLatLon(0, mv.getHeight()), mv.getLatLon(mv.getWidth(), 0));
            this.skipEvents = true;
            this.slippyMap.setBoundingBox(currentBounds);
            this.slippyMap.zoomOut();
            this.skipEvents = false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.skipEvents) {
            this.skipEvents = true;
            MainApplication.getMap().mapView.zoomTo(this.slippyMap.getBoundingBox());
            this.skipEvents = false;
        }
    }
}

