/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view;

import javax.swing.table.AbstractTableModel;
import org.jsampler.CC;
import org.jsampler.JSI18n;
import org.jsampler.MidiInstrumentMap;
import org.jsampler.SamplerModel;
import org.jsampler.event.ListEvent;
import org.jsampler.event.ListListener;
import org.jsampler.event.MidiInstrumentMapEvent;
import org.jsampler.event.MidiInstrumentMapListener;
import org.jsampler.view.MidiMapTable;

public class MidiMapTableModel
extends AbstractTableModel {
    private final MidiMapTable table;
    private final Handler eventHandler = new Handler();

    public MidiMapTableModel(MidiMapTable midiMapTable) {
        this.table = midiMapTable;
        SamplerModel samplerModel = CC.getSamplerModel();
        for (int i = 0; i < samplerModel.getMidiInstrumentMapCount(); ++i) {
            samplerModel.getMidiInstrumentMap(i).addMidiInstrumentMapListener(this.getHandler());
        }
        samplerModel.addMidiInstrumentMapListListener(this.getHandler());
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public int getRowCount() {
        return CC.getSamplerModel().getMidiInstrumentMapCount();
    }

    @Override
    public String getColumnName(int n) {
        return JSI18n.i18n.getLabel("MidiMapTableModel.title");
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return CC.getSamplerModel().getMidiInstrumentMap(n);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.fireTableCellUpdated(n, n2);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    private Handler getHandler() {
        return this.eventHandler;
    }

    private class Handler
    implements ListListener<MidiInstrumentMap>,
    MidiInstrumentMapListener {
        private Handler() {
        }

        @Override
        public void entryAdded(ListEvent<MidiInstrumentMap> listEvent) {
            listEvent.getEntry().addMidiInstrumentMapListener(MidiMapTableModel.this.getHandler());
            MidiMapTableModel.this.fireTableDataChanged();
            MidiMapTableModel.this.table.setSelectedMidiInstrumentMap(listEvent.getEntry());
        }

        @Override
        public void entryRemoved(ListEvent<MidiInstrumentMap> listEvent) {
            listEvent.getEntry().removeMidiInstrumentMapListener(MidiMapTableModel.this.getHandler());
            MidiMapTableModel.this.fireTableDataChanged();
        }

        @Override
        public void nameChanged(MidiInstrumentMapEvent midiInstrumentMapEvent) {
            MidiInstrumentMap midiInstrumentMap = (MidiInstrumentMap)midiInstrumentMapEvent.getSource();
            int n = CC.getSamplerModel().getMidiInstrumentMapIndex(midiInstrumentMap);
            MidiMapTableModel.this.fireTableRowsUpdated(n, n);
        }

        @Override
        public void instrumentAdded(MidiInstrumentMapEvent midiInstrumentMapEvent) {
        }

        @Override
        public void instrumentRemoved(MidiInstrumentMapEvent midiInstrumentMapEvent) {
        }
    }
}

