/*
 * Decompiled with CFR 0.152.
 */
package org.linuxsampler.lscp;

import org.linuxsampler.lscp.AbstractParameter;
import org.linuxsampler.lscp.LscpException;
import org.linuxsampler.lscp.LscpI18n;
import org.linuxsampler.lscp.ParameterType;
import org.linuxsampler.lscp.Parser;

public class FloatParameter
extends AbstractParameter<Float> {
    public FloatParameter() {
        this.setType(ParameterType.FLOAT);
        this.setMultiplicity(false);
    }

    public FloatParameter(String string) {
        this(string, null);
    }

    public FloatParameter(String string, Float f) {
        this();
        this.setName(string);
        this.setValue(f);
    }

    protected FloatParameter(String[] stringArray) throws LscpException {
        this();
        this.parseLines(stringArray);
    }

    @Override
    public boolean parse(String string) throws LscpException {
        if (super.parse(string)) {
            return true;
        }
        if (string.startsWith("RANGE_MIN: ")) {
            string = string.substring("RANGE_MIN: ".length(), string.length());
            try {
                this.setRangeMin(Float.valueOf(Float.parseFloat(string)));
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                throw new LscpException(LscpI18n.getLogMsg("notFloat!", "RANGE_MIN"), numberFormatException);
            }
        }
        if (string.startsWith("RANGE_MAX: ")) {
            string = string.substring("RANGE_MAX: ".length(), string.length());
            try {
                this.setRangeMax(Float.valueOf(Float.parseFloat(string)));
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                throw new LscpException(LscpI18n.getLogMsg("notFloat!", "RANGE_MAX"), numberFormatException);
            }
        }
        if (string.startsWith("DEFAULT: ")) {
            string = string.substring("DEFAULT: ".length(), string.length());
            try {
                this.setDefault(Float.valueOf(Float.parseFloat(string)));
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                throw new LscpException(LscpI18n.getLogMsg("notFloat!", "DEFAULT"), numberFormatException);
            }
        }
        if (string.startsWith("POSSIBILITIES: ")) {
            string = string.substring("POSSIBILITIES: ".length(), string.length());
            this.setPossibilities(Parser.parseFloatList(string));
            return true;
        }
        return false;
    }

    @Override
    public void parseValue(String string) throws LscpException {
        this.setValue(Float.valueOf(Parser.parseFloat(string)));
    }

    @Override
    public String getStringValue() {
        return String.valueOf(this.getValue());
    }
}

