/*
 * Decompiled with CFR 0.152.
 */
package org.linuxsampler.lscp;

import java.util.Vector;
import org.linuxsampler.lscp.Client;
import org.linuxsampler.lscp.LSException;
import org.linuxsampler.lscp.LscpException;
import org.linuxsampler.lscp.LscpI18n;
import org.linuxsampler.lscp.ParameterType;
import org.linuxsampler.lscp.ResultSet;

public final class Parser {
    private Parser() {
    }

    protected static int parseInt(String string) throws LscpException {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new LscpException(LscpI18n.getLogMsg("Parser.notInt!", string), numberFormatException);
        }
    }

    protected static float parseFloat(String string) throws LscpException {
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new LscpException(LscpI18n.getLogMsg("Parser.notFloat!", string));
        }
    }

    public static String[] parseList(String string) {
        return Parser.parseList(string, ',');
    }

    public static String[] parseList(String string, char c) {
        int n;
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        int n2 = 0;
        Vector<String> vector = new Vector<String>();
        while ((n = string.indexOf(c, n2)) > 0) {
            vector.add(string.substring(n2, n));
            n2 = n + 1;
        }
        if (n2 < string.length()) {
            vector.add(string.substring(n2));
        }
        return vector.toArray(new String[vector.size()]);
    }

    public static Boolean[] parseBoolList(String string) {
        String[] stringArray = Parser.parseList(string);
        Boolean[] booleanArray = new Boolean[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            booleanArray[i] = Boolean.parseBoolean(stringArray[i]);
        }
        return booleanArray;
    }

    public static Integer[] parseIntList(String string) throws LscpException {
        return Parser.parseIntList(string, ',');
    }

    public static Integer[] parseIntList(String string, char c) throws LscpException {
        String[] stringArray = Parser.parseList(string, c);
        Integer[] integerArray = new Integer[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            integerArray[i] = Parser.parseInt(stringArray[i]);
        }
        return integerArray;
    }

    public static Float[] parseFloatList(String string) throws LscpException {
        String[] stringArray = Parser.parseList(string);
        Float[] floatArray = new Float[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            floatArray[i] = Float.valueOf(Parser.parseFloat(stringArray[i]));
        }
        return floatArray;
    }

    public static String[] parseEscapedStringList(String string) throws LscpException {
        return Parser.parseEscapedStringList(string, ',');
    }

    public static String[] parseEscapedStringList(String string, char c) throws LscpException {
        Vector<String> vector;
        block4: {
            if (string == null || string.length() == 0) {
                return new String[0];
            }
            int n = 0;
            int n2 = 0;
            vector = new Vector<String>();
            do {
                if (string.charAt(n) != '\'') {
                    throw new LscpException(LscpI18n.getLogMsg("Parser.brokenList!"));
                }
                n2 = Parser.findApostrophe(string, n + 1);
                if (n2 == -1) {
                    throw new LscpException(LscpI18n.getLogMsg("Parser.EOL!"));
                }
                vector.add(string.substring(n + 1, n2));
                if (n2 + 1 >= string.length()) break block4;
                if (string.charAt(n2 + 1) == c) continue;
                throw new LscpException(LscpI18n.getLogMsg("Parser.brokenList!"));
            } while ((n = n2 + 2) < string.length());
            throw new LscpException(LscpI18n.getLogMsg("Parser.EOL!"));
        }
        return vector.toArray(new String[vector.size()]);
    }

    private static int findApostrophe(String string, int n) {
        return Parser.findNonEscapedChar(string, n, '\'');
    }

    public static String[] parseStringList(String string) throws LscpException {
        return Parser.parseStringList(string, ',');
    }

    public static String[] parseStringList(String string, char c) throws LscpException {
        Vector<String> vector;
        block4: {
            if (string == null || string.length() == 0) {
                return new String[0];
            }
            int n = 0;
            int n2 = 0;
            vector = new Vector<String>();
            do {
                if (string.charAt(n) != '\'') {
                    throw new LscpException(LscpI18n.getLogMsg("Parser.brokenList!"));
                }
                n2 = string.indexOf(39, n + 1);
                if (n2 == -1) {
                    throw new LscpException(LscpI18n.getLogMsg("Parser.EOL!"));
                }
                vector.add(string.substring(n + 1, n2));
                if (n2 + 1 >= string.length()) break block4;
                if (string.charAt(n2 + 1) == c) continue;
                throw new LscpException(LscpI18n.getLogMsg("Parser.brokenList!"));
            } while ((n = n2 + 2) < string.length());
            throw new LscpException(LscpI18n.getLogMsg("Parser.EOL!"));
        }
        return vector.toArray(new String[vector.size()]);
    }

    protected static String[][] parseListOfStringLists(String string) throws LscpException {
        if (string.length() == 0) {
            return new String[0][0];
        }
        if (!string.startsWith("''") && !string.startsWith("\"\"")) {
            String[][] stringArray = new String[][]{Parser.parseStringList(string)};
            return stringArray;
        }
        int n = 0;
        int n2 = 0;
        Vector<String> vector = new Vector<String>();
        while (true) {
            n2 = Parser.getEndListIndex(n, string);
            vector.add(string.substring(n + 1, n2));
            if (n2 == string.length() - 1) break;
            if (string.charAt(n2 + 1) != ',') {
                throw new LscpException(LscpI18n.getLogMsg("Parser.brokenList!"));
            }
            n = n2 + 2;
        }
        String[][] stringArray = new String[vector.size()][];
        for (n = 0; n < vector.size(); ++n) {
            stringArray[n] = Parser.parseStringList((String)vector.get(n));
        }
        return stringArray;
    }

    public static String[] parseArray(String string) throws LscpException {
        Vector<String> vector;
        block4: {
            if (string == null || string.length() == 0) {
                return new String[0];
            }
            int n = 0;
            int n2 = 0;
            vector = new Vector<String>();
            do {
                if (string.charAt(n) != '{') {
                    throw new LscpException(LscpI18n.getLogMsg("Parser.brokenList!"));
                }
                n2 = string.indexOf(125, n + 1);
                if (n2 == -1) {
                    throw new LscpException(LscpI18n.getLogMsg("Parser.EOL!"));
                }
                vector.add(string.substring(n + 1, n2));
                if (n2 + 1 >= string.length()) break block4;
                if (string.charAt(n2 + 1) == ',') continue;
                throw new LscpException(LscpI18n.getLogMsg("Parser.brokenList!"));
            } while ((n = n2 + 2) < string.length());
            throw new LscpException(LscpI18n.getLogMsg("Parser.EOL!"));
        }
        return vector.toArray(new String[vector.size()]);
    }

    private static int getEndListIndex(int n, String string) throws LscpException {
        int n2 = n + 1;
        char c = string.charAt(0);
        if (string.charAt(n) != c) {
            throw new LscpException(LscpI18n.getLogMsg("Parser.brokenList!"));
        }
        if (string.charAt(n2) == '\'' && (n2 == string.length() - 1 || string.charAt(n2 + 1) == ',')) {
            return n2;
        }
        while (true) {
            if (string.charAt(n2) != c) {
                throw new LscpException(LscpI18n.getLogMsg("Parser.brokenList!"));
            }
            if ((n2 = string.indexOf(c, n2 + 1)) == -1 || n2 == string.length() - 1) {
                throw new LscpException(LscpI18n.getLogMsg("Parser.brokenList!"));
            }
            if (string.charAt(n2 + 1) == c) {
                return n2 + 1;
            }
            if (string.charAt(n2 + 1) != ',') {
                throw new LscpException(LscpI18n.getLogMsg("Parser.brokenList!"));
            }
            n2 += 2;
        }
    }

    protected static ParameterType parseType(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        for (String string : stringArray) {
            if (!string.startsWith("TYPE: ")) continue;
            String string2 = string.substring("TYPE: ".length(), string.length());
            if (string2.equals("BOOL")) {
                return ParameterType.BOOL;
            }
            if (string2.equals("INT")) {
                return ParameterType.INT;
            }
            if (string2.equals("FOAT")) {
                return ParameterType.FLOAT;
            }
            if (!string2.equals("STRING")) continue;
            return ParameterType.STRING;
        }
        return null;
    }

    protected static Boolean parseMultiplicity(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        for (String string : stringArray) {
            if (!string.startsWith("MULTIPLICITY: ")) continue;
            return Boolean.parseBoolean(string.substring("MULTIPLICITY: ".length(), string.length()));
        }
        return null;
    }

    protected static ResultSet parseEmptyResultSet(String string) throws LscpException, LSException {
        ResultSet resultSet = new ResultSet();
        if (string.equals("OK")) {
            return resultSet;
        }
        if (string.startsWith("OK[") && string.endsWith("]")) {
            string = string.substring("OK[".length(), string.length() - 1);
            try {
                resultSet.setIndex(Integer.parseInt(string));
                return resultSet;
            }
            catch (NumberFormatException numberFormatException) {
                throw new LscpException(LscpI18n.getLogMsg("CommandFailed!"), numberFormatException);
            }
        }
        if (string.startsWith("WRN")) {
            Parser.parseWarning(string, resultSet);
            Client.getLogger().warning(resultSet.getMessage());
            return resultSet;
        }
        if (string.startsWith("ERR:")) {
            Parser.parseError(string, resultSet);
            throw new LSException(resultSet.getCode(), resultSet.getMessage());
        }
        throw new LscpException(LscpI18n.getLogMsg("CommandFailed!"));
    }

    protected static void parseWarning(String string, ResultSet resultSet) throws LscpException {
        int n;
        int n2;
        if (!string.startsWith("WRN")) {
            throw new LscpException(LscpI18n.getLogMsg("CommandFailed!"));
        }
        resultSet.setWarning(true);
        if (string.charAt(3) == '[') {
            n2 = string.indexOf(93);
            if (n2 == -1) {
                throw new LscpException(LscpI18n.getLogMsg("CommandFailed!"));
            }
            try {
                n = Integer.parseInt(string.substring("WRN[".length(), n2));
                resultSet.setIndex(n);
            }
            catch (NumberFormatException numberFormatException) {
                throw new LscpException(LscpI18n.getLogMsg("CommandFailed!"), numberFormatException);
            }
            if (string.charAt(n2 + 1) != ':') {
                throw new LscpException(LscpI18n.getLogMsg("CommandFailed!"));
            }
        }
        if ((n2 = string.indexOf(58)) == -1) {
            throw new LscpException(LscpI18n.getLogMsg("CommandFailed!"));
        }
        n = string.indexOf(58, n2 + 1);
        if (n == -1) {
            throw new LscpException(LscpI18n.getLogMsg("CommandFailed!"));
        }
        try {
            resultSet.setCode(Integer.parseInt(string.substring(n2 + 1, n)));
        }
        catch (NumberFormatException numberFormatException) {
            throw new LscpException(LscpI18n.getLogMsg("CommandFailed!"), numberFormatException);
        }
        resultSet.setMessage(string.substring(n + 1));
    }

    protected static void parseError(String string, ResultSet resultSet) throws LscpException {
        if (!string.startsWith("ERR:")) {
            throw new LscpException(LscpI18n.getLogMsg("CommandFailed!"));
        }
        int n = string.indexOf(58, "ERR:".length());
        if (n == -1) {
            throw new LscpException(LscpI18n.getLogMsg("CommandFailed!"));
        }
        try {
            resultSet.setCode(Integer.parseInt(string.substring("ERR:".length(), n)));
        }
        catch (NumberFormatException numberFormatException) {
            throw new LscpException(LscpI18n.getLogMsg("CommandFailed!"), numberFormatException);
        }
        resultSet.setMessage(string.substring(n + 1));
    }

    protected static String getCategoryInfo(String[] stringArray, String string) {
        String string2 = string + ": ";
        for (String string3 : stringArray) {
            if (!string3.startsWith(string2)) continue;
            return string3.substring(string2.length(), string3.length());
        }
        return null;
    }

    public static String removeQuotation(String string) {
        if (string == null || string.length() < 2) {
            return string;
        }
        char c = string.charAt(0);
        char c2 = string.charAt(string.length() - 1);
        if (c == '\'' && c2 == '\'' || c == '\"' && c2 == '\"') {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static String toEscapedString(Object object) {
        String string = object.toString();
        StringBuffer stringBuffer = new StringBuffer();
        block10: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block10;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block10;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block10;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block10;
                }
                case '\u000b': {
                    stringBuffer.append("\\v");
                    continue block10;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    continue block10;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block10;
                }
                default: {
                    stringBuffer.append(string.charAt(i));
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String toEscapedFileName(Object object) {
        String string = object.toString();
        StringBuffer stringBuffer = new StringBuffer();
        block11: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '/': {
                    stringBuffer.append("\\x2f");
                    continue block11;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block11;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block11;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block11;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block11;
                }
                case '\u000b': {
                    stringBuffer.append("\\v");
                    continue block11;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    continue block11;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block11;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block11;
                }
                default: {
                    stringBuffer.append(string.charAt(i));
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String toExtendedEscapeSequence(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '`') {
                stringBuffer.append("\\x60");
                continue;
            }
            if (c < ' ' || c > '~') {
                stringBuffer.append(Parser.toEscapeString(c));
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static String toEscapeString(char c) {
        String string = Integer.toHexString(c);
        if (string.length() % 2 != 0) {
            string = "0" + string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); i += 2) {
            stringBuffer.append("\\x").append(string.charAt(i)).append(string.charAt(i + 1));
        }
        return stringBuffer.toString();
    }

    public static String toNonEscapedFileName(Object object) {
        return Parser.toNonEscapedString(object);
    }

    public static String toNonEscapedString(Object object) {
        String string = object.toString();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                Character c2;
                char c3;
                if (i >= string.length()) {
                    Client.getLogger().info("Broken escape sequence!");
                    break;
                }
                if ((c3 = string.charAt(++i)) == '\'') {
                    stringBuffer.append('\'');
                    continue;
                }
                if (c3 == '\"') {
                    stringBuffer.append('\"');
                    continue;
                }
                if (c3 == '\\') {
                    stringBuffer.append('\\');
                    continue;
                }
                if (c3 == 'r') {
                    stringBuffer.append('\r');
                    continue;
                }
                if (c3 == 'n') {
                    stringBuffer.append('\n');
                    continue;
                }
                if (c3 == 'f') {
                    stringBuffer.append('\f');
                    continue;
                }
                if (c3 == 't') {
                    stringBuffer.append('\t');
                    continue;
                }
                if (c3 == 'v') {
                    stringBuffer.append('\u000b');
                    continue;
                }
                if (c3 == 'x') {
                    c2 = Parser.getHexEscapeSequence(string, i + 1);
                    if (c2 != null) {
                        stringBuffer.append(c2.charValue());
                    }
                    i += 2;
                    continue;
                }
                if (c3 >= '0' && c3 <= '9') {
                    c2 = Parser.getOctEscapeSequence(string, i);
                    if (c2 != null) {
                        stringBuffer.append(c2.charValue());
                    }
                    i += 2;
                    continue;
                }
                Client.getLogger().info("Unknown escape sequence \\" + c3);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static Character getHexEscapeSequence(String string, int n) {
        Character c = null;
        if (n + 1 >= string.length()) {
            Client.getLogger().info("Broken escape sequence");
            return c;
        }
        try {
            c = Character.valueOf((char)Integer.parseInt(string.substring(n, n + 2), 16));
        }
        catch (Exception exception) {
            Client.getLogger().info("Broken escape sequence!");
        }
        return c;
    }

    private static Character getOctEscapeSequence(String string, int n) {
        Character c = null;
        if (n + 2 >= string.length()) {
            Client.getLogger().info("Broken escape sequence");
            return c;
        }
        try {
            c = Character.valueOf((char)Integer.parseInt(string.substring(n, n + 3), 8));
        }
        catch (Exception exception) {
            Client.getLogger().info("Broken escape sequence!");
        }
        return c;
    }

    public static boolean isEscaped(String string, int n) {
        if (n < 0 || n >= string.length()) {
            return false;
        }
        int n2 = 0;
        for (int i = n - 1; i >= 0 && string.charAt(i) == '\\'; --i) {
            ++n2;
        }
        return n2 % 2 != 0;
    }

    private static int findNonEscapedChar(String string, int n, char c) {
        int n2;
        if (string == null) {
            return -1;
        }
        int n3 = n;
        if (n3 < 0 || n3 >= string.length()) {
            return -1;
        }
        while ((n2 = string.indexOf(c, n3)) != -1) {
            if (!Parser.isEscaped(string, n2)) {
                return n2;
            }
            n3 = n2 + 1;
            if (n3 < string.length()) continue;
            break;
        }
        return -1;
    }

    private static int findFileSeparator(String string, int n) {
        return Parser.findNonEscapedChar(string, n, '/');
    }

    private static int getLastFileSeparator(String string) {
        if (string == null || string.length() == 0) {
            return -1;
        }
        int n = string.length() - 1;
        while ((n = string.lastIndexOf(47, n)) != -1) {
            if (!Parser.isEscaped(string, n)) {
                return n;
            }
            --n;
        }
        return -1;
    }

    public static boolean hasEndingFileSeparator(String string) {
        if (string == null || string.length() < 2) {
            return false;
        }
        int n = string.length() - 1;
        return string.charAt(n) == '/' && !Parser.isEscaped(string, n);
    }

    public static String removeEndingFileSeparator(String string) {
        if (string == null || string.length() < 2) {
            return string;
        }
        int n = string.length() - 1;
        if (string.charAt(n) == '/' && !Parser.isEscaped(string, n)) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String getParentDirectory(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.charAt(0) != '/') {
            return null;
        }
        if (string.length() == 1) {
            return null;
        }
        int n = Parser.getLastFileSeparator(string = Parser.removeEndingFileSeparator(string));
        if (n == 0) {
            return "/";
        }
        return string.substring(0, n);
    }

    public static String getFileName(String string) {
        if (string == null || string.length() < 2) {
            return null;
        }
        int n = Parser.getLastFileSeparator(string);
        if (n == -1) {
            return null;
        }
        if (n == string.length() - 1) {
            return null;
        }
        return string.substring(n + 1);
    }

    public static String[] getDirectoryList(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.charAt(0) != '/') {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        vector.add("/");
        if (string.length() == 1) {
            return vector.toArray(new String[vector.size()]);
        }
        if (!Parser.hasEndingFileSeparator(string)) {
            string = string + "/";
        }
        int n = 1;
        int n2 = Parser.findFileSeparator(string, n);
        while (n2 != -1) {
            vector.add(string.substring(n, n2));
            n = n2 + 1;
            if (n >= string.length()) {
                return vector.toArray(new String[vector.size()]);
            }
            n2 = Parser.findFileSeparator(string, n);
        }
        return null;
    }
}

