/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.classic;

import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.juife.wizard.UserInputPage;
import org.jsampler.view.classic.ClassicI18n;
import org.jsampler.view.classic.NewChannelWizardModel;
import org.linuxsampler.lscp.MidiInputDevice;
import org.linuxsampler.lscp.MidiPort;

class MidiPortWizardPage
extends UserInputPage {
    private final JLabel lPort = new JLabel(ClassicI18n.i18n.getLabel("MidiPortWizardPage.lPort"));
    private final JComboBox cbPorts = new JComboBox();

    MidiPortWizardPage() {
        super(ClassicI18n.i18n.getLabel("MidiPortWizardPage.subtitle"));
        this.setMainInstructions(ClassicI18n.i18n.getLabel("MidiPortWizardPage.mainInstructions"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.lPort);
        jPanel.add(Box.createRigidArea(new Dimension(6, 0)));
        this.cbPorts.setMaximumSize(this.cbPorts.getPreferredSize());
        jPanel.add(this.cbPorts);
        this.setMainPane(jPanel);
    }

    @Override
    public void preinitPage() {
        this.updatePorts(((NewChannelWizardModel)this.getWizardModel()).getSelectedMidiDevice());
    }

    public MidiPort getSelectedPort() {
        return (MidiPort)this.cbPorts.getSelectedItem();
    }

    public void updatePorts(MidiInputDevice midiInputDevice) {
        Object object = this.cbPorts.getSelectedItem();
        this.cbPorts.removeAllItems();
        if (midiInputDevice != null) {
            for (MidiPort midiPort : midiInputDevice.getMidiPorts()) {
                this.cbPorts.addItem(midiPort);
            }
        }
        if (object != null) {
            this.cbPorts.setSelectedItem(object);
        }
        this.cbPorts.setEnabled(this.cbPorts.getItemCount() > 0);
        this.cbPorts.setMaximumSize(this.cbPorts.getPreferredSize());
    }
}

