/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Objects;

public final class StringUtil {
    private StringUtil() {
    }

    public static String changePrefix(String name, String oldPrefix, String newPrefix) {
        if (!name.startsWith(oldPrefix)) {
            return name;
        }
        int oldLen = oldPrefix.length();
        int diff = newPrefix.length() - oldLen;
        int nameLen = name.length();
        StringBuilder builder = new StringBuilder(nameLen + diff);
        builder.append(newPrefix);
        builder.append(name, oldLen, nameLen);
        return builder.toString();
    }

    public static Iterator<String> camelHumpsIterator(final String str) {
        return new Iterator<String>(){
            int idx;

            @Override
            public boolean hasNext() {
                return this.idx < str.length();
            }

            @Override
            public String next() {
                if (this.idx == str.length()) {
                    throw new NoSuchElementException();
                }
                if (str.startsWith("JBoss", this.idx)) {
                    this.idx += 5;
                    return "JBoss";
                }
                int start = this.idx;
                int c = str.codePointAt(this.idx);
                if (Character.isUpperCase(c)) {
                    this.idx = str.offsetByCodePoints(this.idx, 1);
                    if (this.idx < str.length()) {
                        c = str.codePointAt(this.idx);
                        if (Character.isUpperCase(c)) {
                            int nextIdx = str.offsetByCodePoints(this.idx, 1);
                            while (nextIdx < str.length()) {
                                c = str.codePointAt(nextIdx);
                                if (Character.isLowerCase(c)) {
                                    return str.substring(start, this.idx);
                                }
                                this.idx = nextIdx;
                                nextIdx = str.offsetByCodePoints(this.idx, 1);
                            }
                            this.idx = str.length();
                            return str.substring(start);
                        }
                        this.idx = str.offsetByCodePoints(this.idx, 1);
                        while (this.idx < str.length()) {
                            c = str.codePointAt(this.idx);
                            if (Character.isUpperCase(c)) {
                                return str.substring(start, this.idx);
                            }
                            this.idx = str.offsetByCodePoints(this.idx, 1);
                        }
                        return str.substring(start);
                    }
                    return str.substring(start);
                }
                this.idx = str.offsetByCodePoints(this.idx, 1);
                while (this.idx < str.length()) {
                    c = str.codePointAt(this.idx);
                    if (Character.isUpperCase(c)) {
                        return str.substring(start, this.idx);
                    }
                    this.idx = str.offsetByCodePoints(this.idx, 1);
                }
                return str.substring(start);
            }
        };
    }

    public static Iterator<String> lowerCase(final Iterator<String> orig) {
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return orig.hasNext();
            }

            @Override
            public String next() {
                return ((String)orig.next()).toLowerCase(Locale.ROOT);
            }
        };
    }

    private static String join(String delim, Iterator<String> it) {
        StringBuilder b = new StringBuilder();
        if (it.hasNext()) {
            b.append(it.next());
            while (it.hasNext()) {
                b.append(delim);
                b.append(it.next());
            }
        }
        return b.toString();
    }

    public static String join(Iterator<String> it) {
        StringBuilder b = new StringBuilder();
        if (it.hasNext()) {
            b.append(it.next());
            while (it.hasNext()) {
                b.append(it.next());
            }
        }
        return b.toString();
    }

    public static Iterator<String> lowerCaseFirst(final Iterator<String> orig) {
        return new Iterator<String>(){
            boolean first = true;

            @Override
            public boolean hasNext() {
                return orig.hasNext();
            }

            @Override
            public String next() {
                String next = (String)orig.next();
                if (this.first) {
                    this.first = false;
                    return next.toLowerCase(Locale.ROOT);
                }
                return next;
            }
        };
    }

    public static Iterator<String> withoutSuffix(final Iterator<String> orig, final String ... suffixes) {
        return new Iterator<String>(){
            String next = null;

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    if (!orig.hasNext()) {
                        return false;
                    }
                    String next = (String)orig.next();
                    if (!orig.hasNext() && StringUtil.arrayContains(next, suffixes)) {
                        return false;
                    }
                    this.next = next;
                }
                return true;
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                String next = this.next;
                this.next = null;
                return next;
            }
        };
    }

    @SafeVarargs
    public static <T> List<T> withoutSuffix(List<T> list, T ... segments) {
        if (list.size() < segments.length) {
            return list;
        }
        for (int i = 0; i < segments.length; ++i) {
            if (list.get(list.size() - i - 1).equals(segments[segments.length - i - 1])) continue;
            return list;
        }
        return list.subList(0, list.size() - segments.length);
    }

    public static List<String> toList(Iterator<String> orig) {
        return StringUtil.toList(orig, 0);
    }

    private static List<String> toList(Iterator<String> orig, int idx) {
        if (orig.hasNext()) {
            String item = orig.next();
            List<String> list = StringUtil.toList(orig, idx + 1);
            list.set(idx, item);
            return list;
        }
        return Arrays.asList(new String[idx]);
    }

    @SafeVarargs
    private static <T> boolean arrayContains(T item, T ... array) {
        for (T arrayItem : array) {
            if (!Objects.equals(arrayItem, item)) continue;
            return true;
        }
        return false;
    }

    public static String hyphenate(String orig) {
        return StringUtil.join("-", StringUtil.lowerCase(StringUtil.camelHumpsIterator(orig)));
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }
}

