/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.spi;

import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.lsp4j.services.LanguageServer;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.lsp.client.LSPBindings;
import org.netbeans.modules.lsp.client.LanguageServerProviderAccessor;
import org.openide.util.Lookup;

public interface LanguageServerProvider {
    @CheckForNull
    public LanguageServerDescription startServer(@NonNull Lookup var1);

    public static final class LanguageServerDescription {
        private final InputStream in;
        private final OutputStream out;
        private final Process process;
        private final LanguageServer server;
        private LSPBindings bindings;

        @NonNull
        public static LanguageServerDescription create(@NonNull InputStream in, @NonNull OutputStream out, @NullAllowed Process process) {
            return new LanguageServerDescription(in, out, process, null);
        }

        @NonNull
        static LanguageServerDescription create(@NonNull LanguageServer server) {
            return new LanguageServerDescription(null, null, null, server);
        }

        private LanguageServerDescription(InputStream in, OutputStream out, Process process, LanguageServer server) {
            this.in = in;
            this.out = out;
            this.process = process;
            this.server = server;
        }

        static {
            LanguageServerProviderAccessor.setINSTANCE(new LanguageServerProviderAccessor(){

                @Override
                public InputStream getInputStream(LanguageServerDescription desc) {
                    return desc.in;
                }

                @Override
                public OutputStream getOutputStream(LanguageServerDescription desc) {
                    return desc.out;
                }

                @Override
                public Process getProcess(LanguageServerDescription desc) {
                    return desc.process;
                }

                @Override
                public LanguageServer getServer(LanguageServerDescription desc) {
                    return desc.server;
                }

                @Override
                public LSPBindings getBindings(LanguageServerDescription desc) {
                    return desc.bindings;
                }

                @Override
                public void setBindings(LanguageServerDescription desc, LSPBindings bindings) {
                    desc.bindings = bindings;
                }

                @Override
                public LanguageServerDescription createLanguageServerDescription(LanguageServer server) {
                    return LanguageServerDescription.create(server);
                }
            });
        }
    }
}

