/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator.support;

import org.netbeans.lib.terminalemulator.Coord;
import org.netbeans.lib.terminalemulator.Extent;
import org.netbeans.lib.terminalemulator.LogicalLineVisitor;
import org.netbeans.lib.terminalemulator.Term;
import org.netbeans.lib.terminalemulator.support.FindState;

public class DefaultFindState
implements FindState {
    private final Term term;
    private boolean visible = false;
    private String pattern;
    private boolean tentative;
    private Direction direction;
    private Extent extent = null;
    private FindState.Status status = FindState.Status.EMPTYPATTERN;
    private boolean found = false;
    private LogicalLineVisitor forwardVisitor = new LogicalLineVisitor(){

        @Override
        public boolean visit(int line, Coord begin, Coord end, String text) {
            int i = text.indexOf(DefaultFindState.this.pattern);
            if (i == -1) {
                return true;
            }
            if (!DefaultFindState.this.tentative) {
                DefaultFindState.this.extent = DefaultFindState.this.term.extentInLogicalLine(begin, i, DefaultFindState.this.pattern.length());
                DefaultFindState.this.term.setSelectionExtent(DefaultFindState.this.extent);
                ((DefaultFindState)DefaultFindState.this).extent.end = DefaultFindState.this.term.advance(((DefaultFindState)DefaultFindState.this).extent.end);
            }
            DefaultFindState.this.found = true;
            return false;
        }
    };
    private LogicalLineVisitor backwardVisitor = new LogicalLineVisitor(){

        @Override
        public boolean visit(int line, Coord begin, Coord end, String text) {
            int i = text.lastIndexOf(DefaultFindState.this.pattern);
            if (i == -1) {
                return true;
            }
            if (!DefaultFindState.this.tentative) {
                DefaultFindState.this.extent = DefaultFindState.this.term.extentInLogicalLine(begin, i, DefaultFindState.this.pattern.length());
                DefaultFindState.this.term.setSelectionExtent(DefaultFindState.this.extent);
                Coord bckp = DefaultFindState.this.term.backup(((DefaultFindState)DefaultFindState.this).extent.begin);
                if (bckp != null) {
                    ((DefaultFindState)DefaultFindState.this).extent.begin = bckp;
                }
            }
            DefaultFindState.this.found = true;
            return false;
        }
    };

    public DefaultFindState(Term term) {
        this.term = term;
        this.direction = Direction.FORWARD;
    }

    @Override
    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.found = false;
        this.status = pattern == null || pattern.equals("") ? FindState.Status.EMPTYPATTERN : FindState.Status.OK;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void next() {
        if (this.status == FindState.Status.EMPTYPATTERN) {
            return;
        }
        this.found = false;
        this.tentative = false;
        this.term.visitLogicalLines(this.end(), null, this.forwardVisitor);
        if (this.found) {
            this.term.possiblyNormalize(this.end());
            this.status = FindState.Status.OK;
        } else {
            this.tentative = true;
            this.term.visitLogicalLines(null, null, this.forwardVisitor);
            if (this.found) {
                this.extent.end = null;
                this.status = FindState.Status.WILLWRAP;
            } else {
                this.status = FindState.Status.NOTFOUND;
            }
        }
    }

    @Override
    public void prev() {
        if (this.status == FindState.Status.EMPTYPATTERN) {
            return;
        }
        this.found = false;
        this.tentative = false;
        this.term.reverseVisitLogicalLines(null, this.begin(), this.backwardVisitor);
        if (this.found) {
            this.term.possiblyNormalize(this.begin());
            this.status = FindState.Status.OK;
        } else {
            this.tentative = true;
            this.term.reverseVisitLogicalLines(null, null, this.backwardVisitor);
            if (this.found) {
                this.extent.begin = null;
                this.status = FindState.Status.WILLWRAP;
            } else {
                this.status = FindState.Status.NOTFOUND;
            }
        }
    }

    @Override
    public FindState.Status getStatus() {
        return this.status;
    }

    private Coord begin() {
        return this.extent == null ? null : this.extent.begin;
    }

    private Coord end() {
        return this.extent == null ? null : this.extent.end;
    }

    private static enum Direction {
        BACKWARD,
        FORWARD;

    }
}

