/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.webkit.tooling.networkmonitor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.browser.api.BrowserFamilyId;
import org.netbeans.modules.web.webkit.debugging.api.network.Network;
import org.netbeans.modules.web.webkit.tooling.networkmonitor.Bundle;
import org.netbeans.modules.web.webkit.tooling.networkmonitor.ModelItem;
import org.openide.util.Lookup;

class Model
extends AbstractTableModel {
    private static final int MAX_NUMBER_OF_REQUESTS = 1000;
    private final List<ModelItem> visibleRequests = Collections.synchronizedList(new ArrayList());
    private volatile boolean passive = true;
    private final Project project;
    private final BrowserFamilyId browserFamilyId;

    public Model(Lookup projectContext) {
        this.project = (Project)projectContext.lookup(Project.class);
        this.browserFamilyId = (BrowserFamilyId)projectContext.lookup(BrowserFamilyId.class);
    }

    Project getProject() {
        Iterator<ModelItem> iterator = this.visibleRequests.iterator();
        if (iterator.hasNext()) {
            return iterator.next().getProject();
        }
        return null;
    }

    void passivate() {
        this.passive = true;
    }

    void activate() {
        this.passive = false;
    }

    public void add(Network.Request r) {
        if (this.passive) {
            return;
        }
        r.addPropertyChangeListener((PropertyChangeListener)new PropertyChangeListenerImpl(r, this.browserFamilyId, this.project));
    }

    public void add(Network.WebSocketRequest r) {
        if (this.passive) {
            return;
        }
        this.addVisibleItem(new ModelItem(null, r, this.browserFamilyId, this.project));
    }

    void addVisibleItem(final ModelItem modelItem) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ Model this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.visibleRequests.add(modelItem);
                assert (modelItem.canBeShownToUser()) : modelItem.toString();
                int index = this.this$0.visibleRequests.size() - 1;
                this.this$0.fireTableRowsInserted(index, index);
                this.this$0.cleanUp();
            }
        });
    }

    void reset() {
        assert (SwingUtilities.isEventDispatchThread());
        this.visibleRequests.clear();
        this.fireTableDataChanged();
    }

    void cleanUp() {
        assert (SwingUtilities.isEventDispatchThread());
        int removed = 0;
        while (this.visibleRequests.size() > 1000) {
            this.visibleRequests.remove(0);
            ++removed;
        }
        if (removed > 0) {
            this.fireTableRowsDeleted(0, removed);
        }
    }

    ModelItem getItem(int index) {
        return index == -1 ? null : this.visibleRequests.get(index);
    }

    @Override
    public int getRowCount() {
        return this.visibleRequests.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int column) {
        String name;
        switch (column) {
            case 0: {
                name = Bundle.RequestTable_ColumnName_URL();
                break;
            }
            case 1: {
                name = Bundle.RequestTable_ColumnName_Status();
                break;
            }
            case 2: {
                name = Bundle.RequestTable_ColumnName_HTTPMethod();
                break;
            }
            case 3: {
                name = Bundle.RequestTable_ColumnName_ContentType();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return name;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String value;
        ModelItem item = this.getItem(rowIndex);
        switch (columnIndex) {
            case 0: {
                value = item.getURL();
                break;
            }
            case 1: {
                value = Model.statusHTML(item);
                break;
            }
            case 2: {
                value = item.getHTTPMethod();
                break;
            }
            case 3: {
                value = item.getContentType();
                value = value == null ? "-" : value;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return value;
    }

    private static String statusHTML(ModelItem item) {
        int status = item.getStatus();
        String text = status > 0 ? Integer.toString(status) : null;
        if (item.isError()) {
            if (text == null) {
                text = Bundle.RequestTable_Status_Failed();
            }
            text = "<html><!--" + text + "--><font color='red'>" + text;
        } else {
            if (text == null) {
                text = Bundle.RequestTable_Status_Pending();
            }
            text = "<html><!--" + text + "-->" + text;
        }
        return text;
    }

    private final class PropertyChangeListenerImpl
    implements PropertyChangeListener {
        private final Network.Request request;
        private final BrowserFamilyId browserFamilyId;
        private final Project project;

        public PropertyChangeListenerImpl(Network.Request request, BrowserFamilyId browserFamilyId, Project project) {
            this.request = request;
            this.browserFamilyId = browserFamilyId;
            this.project = project;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            assert (evt.getSource() == this.request) : evt.getSource() + " != " + this.request;
            if ("Network.Request.Response".equals(evt.getPropertyName())) {
                this.request.removePropertyChangeListener((PropertyChangeListener)this);
                ModelItem modelItem = new ModelItem(this.request, null, this.browserFamilyId, this.project);
                if (modelItem.canBeShownToUser()) {
                    Model.this.addVisibleItem(modelItem);
                }
            }
        }
    }
}

