/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.netbeans.lib.profiler.ui.results.ColoredFilter;
import org.netbeans.lib.profiler.ui.results.PackageColorer;
import org.netbeans.lib.profiler.ui.swing.PopupButton;
import org.netbeans.lib.profiler.ui.swing.ProfilerPopup;
import org.netbeans.lib.profiler.ui.swing.TextArea;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.v2.impl.Bundle;

public abstract class FilterSelector {
    public void show(Component invoker, FilterName filterName, String filterValue) {
        UI ui = new UI(filterName, filterValue);
        ui.show(invoker);
    }

    protected abstract void filterChanged(FilterName var1, String var2);

    private static Component createStrut(JComponent c, int width, boolean before) {
        Insets i;
        Border b = c.getBorder();
        Insets insets = i = b != null ? b.getBorderInsets(c) : null;
        int w = i == null ? width : Math.max(width - (before ? i.left : i.right), 0);
        return Box.createHorizontalStrut(w);
    }

    private class UI {
        private JRadioButton noFilterChoice;
        private JRadioButton javaClassesChoice;
        private JRadioButton excludeCustomChoice;
        private JRadioButton includeCustomChoice;
        private TextArea customClasses;
        private PopupButton insertFilter;
        private JPanel panel;

        UI(FilterName filterName, String filterValue) {
            this.populatePopup(filterName, filterValue);
        }

        void show(Component invoker) {
            int resizeMode = 6;
            ProfilerPopup.createRelative((Component)invoker, (Component)this.panel, (int)4, (int)resizeMode).show();
        }

        private void populatePopup(FilterName filterName, String filterValue) {
            JPanel content = new JPanel(new BorderLayout());
            JLabel hint = new JLabel(Bundle.FilterSelector_outgoingCalls(), 10);
            hint.setBorder(BorderFactory.createEmptyBorder(0, 0, 7, 0));
            content.add((Component)hint, "North");
            ButtonGroup bg = new ButtonGroup(){

                @Override
                public void setSelected(ButtonModel m, boolean b) {
                    super.setSelected(m, b);
                    if (b && m.isSelected()) {
                        UI.this.filterChanged(true);
                    }
                }
            };
            JPanel filters = new JPanel(new GridLayout(3, 1));
            this.noFilterChoice = new JRadioButton(Bundle.FilterSelector_noFilter(), FilterName.NO_FILTER == filterName);
            bg.add(this.noFilterChoice);
            JPanel noFilter = new JPanel(null);
            noFilter.setLayout(new BoxLayout(noFilter, 2));
            noFilter.add(this.noFilterChoice);
            filters.add(noFilter);
            this.javaClassesChoice = new JRadioButton(Bundle.FilterSelector_excludeCoreJava(), FilterName.EXCLUDE_JAVA_FILTER == filterName);
            bg.add(this.javaClassesChoice);
            JLabel javaClassesHint = new JLabel("(java.*, javax.*, sun.*, com.sun.*, etc.)", 10);
            javaClassesHint.setFont(javaClassesHint.getFont().deriveFont(javaClassesHint.getFont().getSize2D() - 1.0f));
            javaClassesHint.setEnabled(false);
            JPanel javaFilters = new JPanel(null);
            javaFilters.setLayout(new BoxLayout(javaFilters, 2));
            javaFilters.add(this.javaClassesChoice);
            javaFilters.add(FilterSelector.createStrut(this.javaClassesChoice, 5, false));
            javaFilters.add(javaClassesHint);
            filters.add(javaFilters);
            this.excludeCustomChoice = new JRadioButton(Bundle.FilterSelector_excludeCustomEx(), FilterName.EXCLUDE_CUSTOM_FILTER == filterName);
            bg.add(this.excludeCustomChoice);
            this.includeCustomChoice = new JRadioButton(Bundle.FilterSelector_includeCustomEx(), FilterName.INCLUDE_CUSTOM_FILTER == filterName);
            bg.add(this.includeCustomChoice);
            JPanel customFilters = new JPanel(null);
            customFilters.setLayout(new BoxLayout(customFilters, 2));
            customFilters.add(this.excludeCustomChoice);
            customFilters.add(FilterSelector.createStrut(this.excludeCustomChoice, 8, false));
            customFilters.add(this.includeCustomChoice);
            filters.add(customFilters);
            if (PackageColorer.hasRegisteredColors()) {
                this.insertFilter = new PopupButton(Icons.getIcon((String)"GeneralIcons.Filter")){
                    {
                        this.setToolTipText(Bundle.FilterSelector_insertFilter());
                    }

                    protected void populatePopup(JPopupMenu popup) {
                        for (final ColoredFilter color : PackageColorer.getRegisteredColors()) {
                            if (color.getValue().trim().isEmpty()) continue;
                            Icon icon = color.getColor() == null ? null : color.getIcon(12, 12);
                            popup.add(new JMenuItem(this, color.getName(), icon){
                                final /* synthetic */ 2 this$2;
                                {
                                    this.this$2 = this$2;
                                    super(text, icon);
                                }

                                @Override
                                protected void fireActionPerformed(ActionEvent event) {
                                    String current;
                                    StringBuilder added = new StringBuilder();
                                    for (String f : color.getValues()) {
                                        if (added.length() > 0) {
                                            added.append(", ");
                                        }
                                        added.append(f);
                                        if (!f.endsWith(".")) continue;
                                        added.append("**");
                                    }
                                    String string = current = this.this$2.UI.this.customClasses.showsHint() ? "" : this.this$2.UI.this.customClasses.getText();
                                    if (!current.isEmpty()) {
                                        current = current + "\n";
                                    }
                                    current = current + added.toString();
                                    this.this$2.UI.this.customClasses.requestFocusInWindow();
                                    this.this$2.UI.this.customClasses.setText(current);
                                }
                            });
                        }
                    }

                    public Dimension getPreferredSize() {
                        Dimension dim = super.getPreferredSize();
                        dim.width -= 2;
                        dim.height -= 2;
                        return dim;
                    }
                };
                customFilters.add(Box.createHorizontalGlue());
                customFilters.add((Component)this.insertFilter);
            }
            JPanel filtersOut = new JPanel(new GridBagLayout());
            int y = 0;
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = y++;
            c.gridwidth = 0;
            c.anchor = 18;
            c.fill = 2;
            c.insets = new Insets(3, 0, 0, 0);
            filtersOut.add((Component)filters, c);
            this.customClasses = new TextArea(){

                protected void changed() {
                    UI.this.filterChanged(true);
                }

                public Point getToolTipLocation(MouseEvent event) {
                    Container scroll = this.getParent().getParent();
                    return SwingUtilities.convertPoint(scroll, 0, scroll.getHeight(), (Component)((Object)this));
                }

                public void setEnabled(boolean enabled) {
                    super.setEnabled(enabled);
                    if (UI.this.insertFilter != null) {
                        UI.this.insertFilter.setEnabled(enabled);
                    }
                }
            };
            this.customClasses.setFont(new Font("Monospaced", 0, this.customClasses.getFont().getSize()));
            this.customClasses.setRows(0);
            this.customClasses.setColumns(0);
            JScrollPane customClassesScroll = new JScrollPane((Component)this.customClasses);
            Dimension d = customClassesScroll.getPreferredSize();
            this.customClasses.setRows(3);
            this.customClasses.setColumns(56);
            Dimension _d = this.customClasses.getPreferredScrollableViewportSize();
            d.width += _d.width;
            d.height += _d.height;
            customClassesScroll.setPreferredSize(d);
            customClassesScroll.setMinimumSize(d);
            this.customClasses.setText(filterValue);
            this.customClasses.setHint(Bundle.FilterSelector_filterHint());
            this.customClasses.setToolTipText(Bundle.FilterSelector_filterTooltip());
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = y++;
            c.gridwidth = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.anchor = 18;
            c.fill = 1;
            c.insets = new Insets(3, 20, 0, 0);
            filtersOut.add((Component)customClassesScroll, c);
            this.filterChanged(false);
            content.add((Component)filtersOut, "Center");
            this.panel = content;
        }

        private void filterChanged(boolean fire) {
            String filterValue;
            this.customClasses.setEnabled(this.excludeCustomChoice.isSelected() || this.includeCustomChoice.isSelected());
            if (!fire) {
                return;
            }
            String string = filterValue = this.customClasses.showsHint() ? "" : this.customClasses.getText().trim();
            if (this.noFilterChoice.isSelected()) {
                FilterSelector.this.filterChanged(FilterName.NO_FILTER, filterValue);
            } else if (this.javaClassesChoice.isSelected()) {
                FilterSelector.this.filterChanged(FilterName.EXCLUDE_JAVA_FILTER, filterValue);
            } else if (this.excludeCustomChoice.isSelected()) {
                FilterSelector.this.filterChanged(FilterName.EXCLUDE_CUSTOM_FILTER, filterValue);
            } else if (this.includeCustomChoice.isSelected()) {
                FilterSelector.this.filterChanged(FilterName.INCLUDE_CUSTOM_FILTER, filterValue);
            }
        }
    }

    public static enum FilterName {
        NO_FILTER,
        EXCLUDE_JAVA_FILTER,
        EXCLUDE_CUSTOM_FILTER,
        INCLUDE_CUSTOM_FILTER;


        public String toString() {
            switch (this.ordinal()) {
                case 0: {
                    return Bundle.FilterSelector_noFilter();
                }
                case 1: {
                    return Bundle.FilterSelector_excludeCoreJava();
                }
                case 2: {
                    return Bundle.FilterSelector_excludeCustom();
                }
                case 3: {
                    return Bundle.FilterSelector_includeCustom();
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

