/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.modules.j2ee.dd.api.common.InitParam;
import org.netbeans.modules.j2ee.dd.api.web.Filter;
import org.netbeans.modules.j2ee.dd.api.web.FilterMapping;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping25;
import org.netbeans.modules.web.wizards.DeployData;
import org.netbeans.modules.web.wizards.FileType;
import org.netbeans.modules.web.wizards.FilterMappingData;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

class ServletData
extends DeployData {
    private static final Logger LOG = Logger.getLogger(ServletData.class.getName());
    private static final Pattern VALID_URI_PATTERN = Pattern.compile("[-_.!~*'();/?:@&=+$,a-zA-Z0-9]+");
    private String errorMessage = null;
    private String name = null;
    private String[] urlMappings = null;
    private List<FilterMappingData> filterMappings = null;
    private String[][] initparams = null;
    private boolean paramOK = true;
    private String duplicitParam = null;
    FileType fileType = null;

    ServletData(FileType fileType) {
        this.fileType = fileType;
    }

    String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    void setName(String name) {
        if (name != this.name) {
            if (this.fileType == FileType.FILTER) {
                this.updateFilterMappings(this.getName(), name);
            }
            this.name = name;
        }
    }

    boolean canCreate(TemplateWizard wizard) {
        if (this.webApp == null) {
            return true;
        }
        if (this.webApp.getStatus() == 3) {
            wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ServletData.class, (String)"MSG_OldVersion"));
            return false;
        }
        if (this.webApp.getStatus() == 2) {
            if (this.webApp.getVersion() == null) {
                wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ServletData.class, (String)"MSG_UnuspportedVersion"));
            } else {
                wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ServletData.class, (String)"MSG_InvalidWebXml"));
            }
            return false;
        }
        return true;
    }

    String[] getServletNames() {
        if (this.webApp == null) {
            return new String[0];
        }
        Servlet[] ss = this.webApp.getServlet();
        String[] names = new String[ss.length];
        for (int i = 0; i < ss.length; ++i) {
            try {
                names[i] = ss[i].getServletName();
                continue;
            }
            catch (Exception e) {
                LOG.log(Level.FINE, "error", e);
                names[i] = "";
            }
        }
        return names;
    }

    private List<String> getUrlPatterns() {
        if (this.webApp == null) {
            return new ArrayList<String>();
        }
        ServletMapping[] maps = this.webApp.getServletMapping();
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < maps.length; ++i) {
            l.addAll(Arrays.asList(((ServletMapping25)maps[i]).getUrlPatterns()));
        }
        return l;
    }

    List<FilterMappingData> getFilterMappings() {
        if (this.filterMappings != null) {
            return this.filterMappings;
        }
        if (this.webApp == null) {
            return new ArrayList<FilterMappingData>();
        }
        LOG.finer("Creating the filter mapping list");
        FilterMapping[] fm = this.webApp.getFilterMapping();
        LOG.finer("Order of mappings according to DD APIs");
        for (int i = 0; i < fm.length; ++i) {
            LOG.finer("Servlet name: " + fm[i].getFilterName());
        }
        this.filterMappings = new ArrayList<FilterMappingData>();
        this.filterMappings.add(new FilterMappingData(this.getName()));
        String[] d = null;
        for (int i = 0; i < fm.length; ++i) {
            FilterMappingData.Dispatcher[] dispatchList;
            FilterMappingData fmd;
            block14: {
                fmd = new FilterMappingData();
                fmd.setName(fm[i].getFilterName());
                String string = fm[i].getUrlPattern();
                if (string == null || string.length() == 0) {
                    fmd.setType(FilterMappingData.Type.SERVLET);
                    fmd.setPattern(fm[i].getServletName());
                } else {
                    fmd.setType(FilterMappingData.Type.URL);
                    fmd.setPattern(string);
                }
                try {
                    if (fm[i].sizeDispatcher() == 0) {
                        this.filterMappings.add(fmd);
                    }
                    break block14;
                }
                catch (Exception ex) {
                    LOG.log(Level.FINE, "error", ex);
                    this.filterMappings.add(fmd);
                }
                continue;
            }
            try {
                d = fm[i].getDispatcher();
            }
            catch (Exception ex) {
                LOG.log(Level.FINE, "error", ex);
            }
            if (d == null) {
                dispatchList = new FilterMappingData.Dispatcher[]{};
            } else {
                dispatchList = new FilterMappingData.Dispatcher[d.length];
                for (int j = 0; j < d.length; ++j) {
                    dispatchList[j] = FilterMappingData.Dispatcher.findDispatcher(d[j]);
                    LOG.finer("Dispatch: " + dispatchList[j]);
                }
            }
            fmd.setDispatcher(dispatchList);
            this.filterMappings.add(fmd);
        }
        return this.filterMappings;
    }

    void setFilterMappings(List<FilterMappingData> fmds) {
        this.filterMappings = fmds;
    }

    private void updateFilterMappings(String oldName, String newName) {
        for (FilterMappingData fmd : this.getFilterMappings()) {
            if (!fmd.getName().equals(oldName)) continue;
            fmd.setName(newName);
        }
    }

    private boolean isNameUnique() {
        if (this.webApp == null) {
            return true;
        }
        Servlet[] ss = this.webApp.getServlet();
        for (int i = 0; i < ss.length; ++i) {
            if (!this.name.equals(ss[i].getServletName())) continue;
            return false;
        }
        Filter[] ff = this.webApp.getFilter();
        for (int i = 0; i < ff.length; ++i) {
            if (!this.name.equals(ff[i].getFilterName())) continue;
            return false;
        }
        return true;
    }

    String[] getUrlMappings() {
        if (this.urlMappings == null) {
            return new String[0];
        }
        return this.urlMappings;
    }

    String createDDServletName(String className) {
        if (this.webApp == null) {
            return null;
        }
        String result = className;
        Servlet servlet = (Servlet)this.webApp.findBeanByName("Servlet", "ServletName", result);
        while (servlet != null) {
            result = this.findNextId(result);
            servlet = (Servlet)this.webApp.findBeanByName("Servlet", "ServletName", result);
        }
        this.setName(result);
        return result;
    }

    void createDDServletMapping(String servletName) {
        if (this.webApp == null) {
            return;
        }
        String result = ServletData.getRFC2396URI("/" + servletName);
        ServletMapping mapping = (ServletMapping)this.webApp.findBeanByName("ServletMapping", "UrlPattern", result);
        while (mapping != null) {
            result = this.findNextId(result);
            mapping = (ServletMapping)this.webApp.findBeanByName("ServletMapping", "UrlPattern", result);
        }
        this.urlMappings = new String[]{result};
    }

    private String findNextId(String id) {
        char ch = id.charAt(id.length() - 1);
        if (Character.isDigit(ch)) {
            String lastDigit = id.substring(id.length() - 1);
            int num = Integer.parseInt(lastDigit) + 1;
            return id.substring(0, id.length() - 1) + num;
        }
        return id + "_1";
    }

    String getUrlMappingsAsString() {
        int index;
        if (this.urlMappings == null || this.urlMappings.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (index = 0; index < this.urlMappings.length - 1; ++index) {
            buf.append(this.urlMappings[index]);
            buf.append(", ");
        }
        buf.append(this.urlMappings[index]);
        return buf.toString();
    }

    void parseUrlMappingString(String raw) {
        this.urlMappings = null;
        StringTokenizer st = new StringTokenizer(raw, ",");
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String mapping = st.nextToken().trim();
            if (mapping.length() == 0) continue;
            list.add(mapping);
        }
        this.urlMappings = new String[list.size()];
        list.toArray(this.urlMappings);
    }

    String[][] getInitParams() {
        if (this.initparams == null) {
            return new String[0][2];
        }
        return this.initparams;
    }

    void setInitParams(String[][] initparams, boolean paramOK, String duplicitParam) {
        this.initparams = initparams;
        this.paramOK = paramOK;
        this.duplicitParam = duplicitParam;
    }

    @Override
    boolean isValid() {
        this.errorMessage = "";
        if (this.getName().length() == 0) {
            this.errorMessage = NbBundle.getMessage(ServletData.class, (String)"MSG_no_name");
            return false;
        }
        if (!this.isNameUnique()) {
            this.errorMessage = NbBundle.getMessage(ServletData.class, (String)"MSG_name_unique");
            return false;
        }
        if (this.fileType == FileType.SERVLET) {
            if (!this.checkMappingsForServlet()) {
                return false;
            }
            if (!this.checkServletDuplicitMappings()) {
                return false;
            }
        } else if (this.fileType == FileType.FILTER && !this.checkMappingsForFilter()) {
            return false;
        }
        if (!this.paramOK) {
            this.errorMessage = NbBundle.getMessage(ServletData.class, (String)"MSG_invalid_param");
            return false;
        }
        if (this.duplicitParam != null) {
            this.errorMessage = NbBundle.getMessage(ServletData.class, (String)"MSG_duplicit_param", (Object)this.duplicitParam);
            return false;
        }
        return true;
    }

    private boolean checkMappingsForServlet() {
        this.errorMessage = "";
        String[] mappings = this.getUrlMappings();
        if (mappings == null || mappings.length == 0) {
            LOG.finer("No URL mappings");
            this.errorMessage = NbBundle.getMessage(ServletData.class, (String)"MSG_no_mapping");
            return false;
        }
        for (int i = 0; i < mappings.length; ++i) {
            String errMessage = this.checkServletMappig(mappings[i]);
            if (errMessage == null) continue;
            this.errorMessage = errMessage;
            return false;
        }
        return true;
    }

    private boolean checkServletDuplicitMappings() {
        this.errorMessage = "";
        String[] newMappings = this.getUrlMappings();
        List<String> urlPatterns = this.getUrlPatterns();
        for (int i = 0; i < newMappings.length; ++i) {
            for (String urlPattern : urlPatterns) {
                if (!newMappings[i].equals(urlPattern)) continue;
                LOG.finer("Duplicit URL mappings");
                this.errorMessage = NbBundle.getMessage(ServletData.class, (String)"MSG_url_pattern_unique");
                return false;
            }
            urlPatterns.add(newMappings[i]);
        }
        return true;
    }

    private boolean checkMappingsForFilter() {
        this.errorMessage = "";
        if (this.filterMappings == null || this.filterMappings.size() == 0) {
            LOG.finer("No mappings");
            this.errorMessage = NbBundle.getMessage(ServletData.class, (String)"MSG_no_mapping");
            return false;
        }
        Iterator<FilterMappingData> i = this.getFilterMappings().iterator();
        boolean found = false;
        while (i.hasNext()) {
            FilterMappingData fmd = i.next();
            if (!fmd.getName().equals(this.getName())) continue;
            found = true;
            break;
        }
        if (!found) {
            this.errorMessage = NbBundle.getMessage(ServletData.class, (String)"MSG_no_mapping");
            return false;
        }
        return true;
    }

    @Override
    void createDDEntries() {
        boolean added;
        if (this.webApp == null) {
            return;
        }
        if (this.fileType == FileType.SERVLET) {
            boolean added2 = this.addServlet();
            if (added2) {
                this.addUrlMappings();
                try {
                    this.writeChanges();
                }
                catch (IOException ex) {
                    LOG.log(Level.FINE, "error", ex);
                }
            }
        } else if (this.fileType == FileType.FILTER && (added = this.addFilter())) {
            this.addFilterMappings();
            try {
                this.writeChanges();
            }
            catch (IOException ex) {
                LOG.log(Level.FINE, "error", ex);
            }
        }
    }

    private boolean addServlet() {
        Servlet s;
        if (this.webApp == null) {
            return false;
        }
        try {
            s = (Servlet)this.webApp.createBean("Servlet");
        }
        catch (ClassNotFoundException cnfe) {
            LOG.log(Level.FINE, "servlet creation error", cnfe);
            return false;
        }
        s.setServletName(this.name);
        s.setServletClass(this.className);
        int numInitParams = this.getInitParams().length;
        for (int i = 0; i < numInitParams; ++i) {
            InitParam param;
            try {
                param = (InitParam)s.createBean("InitParam");
            }
            catch (ClassNotFoundException cnfe) {
                LOG.log(Level.FINE, "servlet init parameter creation error", cnfe);
                continue;
            }
            param.setParamName(this.initparams[i][0]);
            param.setParamValue(this.initparams[i][1]);
            s.addInitParam(param);
        }
        this.webApp.addServlet(s);
        return true;
    }

    private boolean addFilter() {
        Filter f;
        if (this.webApp == null) {
            return false;
        }
        try {
            f = (Filter)this.webApp.createBean("Filter");
        }
        catch (ClassNotFoundException cnfe) {
            LOG.log(Level.FINE, "filter creation error", cnfe);
            return false;
        }
        f.setFilterName(this.name);
        f.setFilterClass(this.className);
        int numInitParams = this.getInitParams().length;
        for (int i = 0; i < numInitParams; ++i) {
            InitParam param;
            try {
                param = (InitParam)f.createBean("InitParam");
            }
            catch (ClassNotFoundException cnfe) {
                LOG.log(Level.FINE, "filter init parameter creation error", cnfe);
                continue;
            }
            param.setParamName(this.initparams[i][0]);
            param.setParamValue(this.initparams[i][1]);
            f.addInitParam(param);
        }
        this.webApp.addFilter(f);
        return true;
    }

    private void addUrlMappings() {
        ServletMapping25 m;
        if (this.webApp == null) {
            return;
        }
        try {
            m = (ServletMapping25)this.webApp.createBean("ServletMapping");
        }
        catch (ClassNotFoundException cnfe) {
            LOG.log(Level.FINE, "error", cnfe);
            return;
        }
        m.setServletName(this.name);
        m.setUrlPatterns(this.urlMappings);
        this.webApp.addServletMapping((ServletMapping)m);
    }

    private void addFilterMappings() {
        if (this.webApp == null) {
            return;
        }
        int numFilterMappings = this.filterMappings.size();
        Iterator<FilterMappingData> iterator = this.filterMappings.iterator();
        FilterMapping[] fm = new FilterMapping[numFilterMappings];
        for (int i = 0; i < numFilterMappings; ++i) {
            FilterMappingData fmd = iterator.next();
            try {
                fm[i] = (FilterMapping)this.webApp.createBean("FilterMapping");
            }
            catch (ClassNotFoundException cnfe) {
                LOG.log(Level.FINE, "filter mapping creation error", cnfe);
                return;
            }
            fm[i].setFilterName(fmd.getName());
            if (fmd.getType() == FilterMappingData.Type.URL) {
                fm[i].setUrlPattern(fmd.getPattern());
            } else {
                fm[i].setServletName(fmd.getPattern());
            }
            int length = fmd.getDispatcher().length;
            if (length == 0) {
                LOG.finer("No dispatcher, continue");
                continue;
            }
            String[] s = new String[length];
            FilterMappingData.Dispatcher[] d = fmd.getDispatcher();
            for (int j = 0; j < length; ++j) {
                s[j] = d[j].toString();
            }
            try {
                fm[i].setDispatcher(s);
                continue;
            }
            catch (Exception e) {
                LOG.log(Level.FINE, "Failed to set dispatcher", e);
            }
        }
        this.webApp.setFilterMapping(fm);
    }

    @Override
    String getErrorMessage() {
        return this.errorMessage;
    }

    private String checkServletMappig(String uri) {
        if (!uri.matches("[\\*/].*")) {
            return NbBundle.getMessage(ServletData.class, (String)"MSG_WrongUriStart");
        }
        if (uri.length() > 1 && uri.endsWith("/")) {
            return NbBundle.getMessage(ServletData.class, (String)"MSG_WrongUriEnd");
        }
        if (uri.matches(".*\\*.*\\*.*")) {
            return NbBundle.getMessage(ServletData.class, (String)"MSG_TwoAsterisks");
        }
        if (uri.matches("..*\\*..*")) {
            return NbBundle.getMessage(ServletData.class, (String)"MSG_AsteriskInTheMiddle");
        }
        if (uri.length() > 1 && !ServletData.isRFC2396URI(uri.substring(1))) {
            return NbBundle.getMessage(ServletData.class, (String)"MSG_WrongUri");
        }
        return null;
    }

    static String getRFC2396URI(String uri) {
        if (ServletData.isRFC2396URI(uri)) {
            return uri;
        }
        StringBuilder sb = new StringBuilder(uri);
        for (int i = 0; i < sb.length(); ++i) {
            if (ServletData.isRFC2396URI(sb.substring(i, i + 1))) continue;
            sb.replace(i, i + 1, "_");
        }
        return sb.toString();
    }

    private static boolean isRFC2396URI(String uri) {
        return VALID_URI_PATTERN.matcher(uri).matches();
    }
}

