/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.el.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.web.el.CompilationContext;
import org.netbeans.modules.web.el.spi.Function;
import org.netbeans.modules.web.el.spi.ImplicitObject;
import org.netbeans.modules.web.el.spi.ResolverContext;
import org.netbeans.modules.web.el.spi.ResourceBundle;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public abstract class ELPlugin {
    public abstract String getName();

    public abstract Collection<String> getMimeTypes();

    public abstract Collection<ImplicitObject> getImplicitObjects(FileObject var1);

    public abstract List<ResourceBundle> getResourceBundles(FileObject var1, ResolverContext var2);

    public abstract List<Function> getFunctions(FileObject var1);

    public boolean isValidProperty(ExecutableElement executableElement, Source source, CodeCompletionContext completionContext, CompilationContext compilationContext) {
        return false;
    }

    public static class Query {
        public static Collection<? extends ELPlugin> getELPlugins() {
            Collection plugins = Lookup.getDefault().lookupAll(ELPlugin.class);
            return plugins;
        }

        public static Collection<ImplicitObject> getImplicitObjects(FileObject file) {
            HashSet<ImplicitObject> result = new HashSet<ImplicitObject>();
            for (ELPlugin eLPlugin : Query.getELPlugins()) {
                result.addAll(eLPlugin.getImplicitObjects(file));
            }
            return result;
        }

        public static List<ResourceBundle> getResourceBundles(FileObject file, ResolverContext context) {
            ArrayList<ResourceBundle> result = new ArrayList<ResourceBundle>();
            for (ELPlugin eLPlugin : Query.getELPlugins()) {
                result.addAll(eLPlugin.getResourceBundles(file, context));
            }
            return result;
        }

        public static List<Function> getFunctions(FileObject file) {
            ArrayList<Function> result = new ArrayList<Function>();
            for (ELPlugin eLPlugin : Query.getELPlugins()) {
                result.addAll(eLPlugin.getFunctions(file));
            }
            return result;
        }

        public static boolean isValidProperty(ExecutableElement executableElement, Source source, CompilationContext compilationContext, CodeCompletionContext completionContext) {
            for (ELPlugin eLPlugin : Query.getELPlugins()) {
                boolean correspondsToSignature = eLPlugin.isValidProperty(executableElement, source, completionContext, compilationContext);
                if (!correspondsToSignature) continue;
                return true;
            }
            return false;
        }
    }
}

