/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.ui;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.netbeans.modules.glassfish.common.GlassFishLogger;
import org.netbeans.modules.glassfish.common.GlassfishInstance;
import org.netbeans.modules.glassfish.common.ui.InstanceLocalPanel;
import org.netbeans.modules.glassfish.common.ui.InstancePanel;
import org.netbeans.modules.glassfish.common.ui.InstanceRemotePanel;
import org.netbeans.modules.glassfish.common.ui.VmCustomizer;
import org.netbeans.modules.glassfish.spi.CustomizerCookie;
import org.openide.util.Lookup;

public class GlassFishPropertiesCustomizer
extends JTabbedPane {
    private static final Logger LOGGER = GlassFishLogger.get(GlassFishPropertiesCustomizer.class);
    private final CustomizerListener customizerListener;

    public GlassFishPropertiesCustomizer(GlassfishInstance instance, Lookup lookup) {
        this.customizerListener = new CustomizerListener(instance);
        this.addAncestorListener(this.customizerListener);
        InstancePanel commonCustomizer = instance.isRemote() ? new InstanceRemotePanel(instance) : new InstanceLocalPanel(instance);
        VmCustomizer vmCustomizer = new VmCustomizer(instance);
        LinkedList<JPanel> pages = new LinkedList<JPanel>();
        Collection lookupAll = lookup.lookupAll(CustomizerCookie.class);
        for (CustomizerCookie cookie : lookupAll) {
            pages.addAll(cookie.getCustomizerPages());
        }
        pages.add(vmCustomizer);
        this.add(commonCustomizer);
        for (JPanel page : pages) {
            this.add(page);
        }
    }

    private static class CustomizerListener
    implements AncestorListener {
        private final GlassfishInstance instance;

        CustomizerListener(GlassfishInstance instance) {
            this.instance = instance;
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            LOGGER.log(Level.INFO, "Storing {0} atributes", this.instance.getDisplayName());
            try {
                if (this.instance.getInstanceProvider().getInstance(this.instance.getUrl()) != null) {
                    GlassfishInstance.writeInstanceToFile(this.instance);
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, "Could not store GlassFish server attributes", ex);
            }
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }
    }
}

