/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.file.launcher;

import java.net.URI;
import java.util.EventListener;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.java.file.launcher.SharedRootData;
import org.netbeans.modules.java.file.launcher.SingleSourceFileUtil;
import org.netbeans.modules.java.file.launcher.queries.MultiSourceRootProvider;
import org.netbeans.modules.java.file.launcher.spi.SingleFileOptionsQueryImplementation;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class AttributeBasedSingleFileOptions
implements SingleFileOptionsQueryImplementation {
    private static final RequestProcessor WORKER = new RequestProcessor(AttributeBasedSingleFileOptions.class.getName(), 1, false, false);

    @Override
    public SingleFileOptionsQueryImplementation.Result optionsFor(FileObject file) {
        if (!SingleSourceFileUtil.isSupportedFile(file)) {
            return null;
        }
        if (file.isData() && !"text/x-java".equals(FileUtil.getMIMEType((FileObject)file))) {
            return null;
        }
        FileObject root = ((MultiSourceRootProvider)Lookup.getDefault().lookup(MultiSourceRootProvider.class)).getSourceRoot(file);
        if (!file.isData()) {
            file = null;
        }
        if (root != null || file != null) {
            return new ResultImpl(root, file);
        }
        return null;
    }

    private static final class ResultImpl
    implements SingleFileOptionsQueryImplementation.Result {
        private final ChangeSupport cs;
        private final FileObject root;
        private final FileObject source;
        private final FileChangeListener attributeChanges = new FileChangeAdapter(){

            public void fileAttributeChanged(FileAttributeEvent fe) {
                if (root != null && this.registerRoot()) {
                    WORKER.post(() -> SharedRootData.ensureRootRegistered(root));
                }
                cs.fireChange();
            }
        };

        ResultImpl(FileObject root, FileObject source) {
            this.cs = new ChangeSupport((Object)this);
            this.root = root;
            this.source = source;
            if (source != null) {
                source.addFileChangeListener((FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)this.attributeChanges, (Object)source));
            }
            if (root != null) {
                root.addFileChangeListener((FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)this.attributeChanges, (Object)root));
            }
        }

        @Override
        public String getOptions() {
            Object vmOptionsObj;
            Object object = vmOptionsObj = this.source != null ? this.source.getAttribute("single_file_vm_options") : null;
            if (vmOptionsObj != null) {
                return (String)vmOptionsObj;
            }
            vmOptionsObj = this.root != null ? this.root.getAttribute("single_file_vm_options") : null;
            String globalVmOptions = NbPreferences.forModule(JavaPlatformManager.class).get("java_file_launcher_global_vm_options", "");
            return vmOptionsObj != null ? (String)vmOptionsObj + " " + globalVmOptions : globalVmOptions;
        }

        @Override
        public URI getWorkDirectory() {
            return this.root != null ? this.root.toURI() : this.source.getParent().toURI();
        }

        @Override
        public boolean registerRoot() {
            Object value = this.source != null ? this.source.getAttribute("register_root") : (this.root != null ? this.root.getAttribute("register_root") : null);
            return SingleSourceFileUtil.isTrue(value);
        }

        @Override
        public void addChangeListener(ChangeListener listener) {
            this.cs.addChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ChangeListener listener) {
            this.cs.removeChangeListener(listener);
        }
    }
}

