/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.coord.common;

import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.MessageHeaders;
import com.sun.xml.ws.api.tx.at.Transactional;
import com.sun.xml.ws.tx.coord.common.WSATCoordinationContextBuilder;
import com.sun.xml.ws.tx.coord.common.client.RegistrationMessageBuilder;
import com.sun.xml.ws.tx.coord.common.client.RegistrationProxyBuilder;
import com.sun.xml.ws.tx.coord.v10.WSCBuilderFactoryImpl;

public abstract class WSCBuilderFactory {
    public static WSCBuilderFactory newInstance(Transactional.Version version) {
        if (Transactional.Version.WSAT10 == version || Transactional.Version.DEFAULT == version) {
            return new WSCBuilderFactoryImpl();
        }
        if (Transactional.Version.WSAT11 == version || Transactional.Version.WSAT12 == version) {
            return new com.sun.xml.ws.tx.coord.v11.WSCBuilderFactoryImpl();
        }
        throw new IllegalArgumentException((Object)((Object)version) + "is not a supported ws-at version");
    }

    public static WSCBuilderFactory fromHeaders(MessageHeaders h) {
        WSCBuilderFactory builder = null;
        HeaderList headers = (HeaderList)h;
        for (int i = 0; i < headers.size(); ++i) {
            Header header = headers.get(i);
            if (!header.getLocalPart().equals("CoordinationContext")) continue;
            if ("http://schemas.xmlsoap.org/ws/2004/10/wsat".equals(header.getNamespaceURI())) {
                builder = new WSCBuilderFactoryImpl();
            } else if ("http://docs.oasis-open.org/ws-tx/wsat/2006/06".equals(header.getNamespaceURI())) {
                builder = new com.sun.xml.ws.tx.coord.v11.WSCBuilderFactoryImpl();
            }
            if (builder == null) continue;
            headers.understood(i);
            return builder;
        }
        return null;
    }

    public abstract WSATCoordinationContextBuilder newWSATCoordinationContextBuilder();

    public abstract RegistrationProxyBuilder newRegistrationProxyBuilder();

    public abstract RegistrationMessageBuilder newWSATRegistrationRequestBuilder();
}

