/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.search.api.request;

import java.util.Objects;
import org.apache.maven.search.api.request.Query;

public abstract class BooleanQuery
extends Query {
    private final Query left;
    private final Query right;

    protected BooleanQuery(Query left, String op, Query right) {
        super(op);
        this.left = Objects.requireNonNull(left);
        this.right = Objects.requireNonNull(right);
    }

    public Query getLeft() {
        return this.left;
    }

    public Query getRight() {
        return this.right;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getLeft()) + " " + this.getValue() + " " + String.valueOf(this.getRight());
    }

    public static BooleanQuery and(Query left, Query ... rights) {
        if (rights.length == 0) {
            throw new IllegalArgumentException("one or more on right needed");
        }
        And result = null;
        for (Query right : rights) {
            result = new And(result == null ? left : result, right);
        }
        return result;
    }

    public static final class And
    extends BooleanQuery {
        private And(Query left, Query right) {
            super(left, "AND", right);
        }
    }
}

