/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.j2ee.sun.dd.api.ASDDVersion;
import org.netbeans.modules.j2ee.sun.share.PrincipalNameMapping;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.PrincipalTableModel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.InputDialog;

public class SecurityEditPrincipalPanel
extends JPanel {
    private static final ResourceBundle customizerBundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.Bundle");
    private final PrincipalTableModel principalModel;
    private final String originalPrincipalName;
    private String principalName;
    private final String originalClassName;
    private String className;
    private final boolean as90FeaturesVisible;
    private JLabel jLblClassName;
    private JLabel jLblPrincipalEntryDesc;
    private JLabel jLblPrincipalName;
    private JTextField jTxtClassName;
    private JTextField jTxtPrincipalName;

    public SecurityEditPrincipalPanel(PrincipalNameMapping entry, PrincipalTableModel pml, ASDDVersion asVersion) {
        this.principalModel = pml;
        this.originalPrincipalName = this.principalName = entry.getPrincipalName();
        this.originalClassName = this.className = entry.getClassName();
        this.as90FeaturesVisible = ASDDVersion.SUN_APPSERVER_9_0.compareTo((Object)asVersion) <= 0;
        this.initComponents();
        this.initUserComponents();
        this.initFields();
    }

    protected String getPrincipalName() {
        return this.principalName;
    }

    protected String getOriginalPrincipalName() {
        return this.originalPrincipalName;
    }

    protected String getClassName() {
        return this.className;
    }

    protected String getOriginalClassName() {
        return this.originalClassName;
    }

    private void initComponents() {
        this.jLblPrincipalEntryDesc = new JLabel();
        this.jLblPrincipalName = new JLabel();
        this.jTxtPrincipalName = new JTextField();
        this.jLblClassName = new JLabel();
        this.jTxtClassName = new JTextField();
        this.setLayout(new GridBagLayout());
        this.jLblPrincipalEntryDesc.setText(customizerBundle.getString("LBL_PrincipalEntryDesc90"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 11, 0, 5);
        this.add((Component)this.jLblPrincipalEntryDesc, gridBagConstraints);
        this.jLblPrincipalName.setLabelFor(this.jTxtPrincipalName);
        this.jLblPrincipalName.setText(customizerBundle.getString("LBL_PrincipalName_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 11, 0, 0);
        this.add((Component)this.jLblPrincipalName, gridBagConstraints);
        this.jTxtPrincipalName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SecurityEditPrincipalPanel.this.jTxtPrincipalNameKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 11);
        this.add((Component)this.jTxtPrincipalName, gridBagConstraints);
        this.jTxtPrincipalName.getAccessibleContext().setAccessibleName(customizerBundle.getString("ACSN_PrincipalName"));
        this.jTxtPrincipalName.getAccessibleContext().setAccessibleDescription(customizerBundle.getString("ACSD_PrincipalName"));
        this.jLblClassName.setLabelFor(this.jTxtClassName);
        this.jLblClassName.setText(customizerBundle.getString("LBL_ClassName_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 11, 0, 0);
        this.add((Component)this.jLblClassName, gridBagConstraints);
        this.jTxtClassName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SecurityEditPrincipalPanel.this.jTxtClassNameKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 11);
        this.add((Component)this.jTxtClassName, gridBagConstraints);
        this.jTxtClassName.getAccessibleContext().setAccessibleName(customizerBundle.getString("ACSN_ClassName"));
        this.jTxtClassName.getAccessibleContext().setAccessibleDescription(customizerBundle.getString("ACSD_ClassName"));
    }

    private void jTxtClassNameKeyReleased(KeyEvent evt) {
        this.className = this.jTxtClassName.getText();
        this.firePropertyChange("UserDataChanged", null, null);
    }

    private void jTxtPrincipalNameKeyReleased(KeyEvent evt) {
        this.principalName = this.jTxtPrincipalName.getText();
        this.firePropertyChange("UserDataChanged", null, null);
    }

    private void initUserComponents() {
        if (!this.as90FeaturesVisible) {
            this.jLblPrincipalEntryDesc.setText(customizerBundle.getString("LBL_PrincipalEntryDesc81"));
            this.jLblClassName.setVisible(false);
            this.jTxtClassName.setVisible(false);
        }
        this.getAccessibleContext().setAccessibleName(customizerBundle.getString("ACSN_EditPrincipalName"));
        this.getAccessibleContext().setAccessibleDescription(customizerBundle.getString("ACSD_EditPrincipalName"));
    }

    private void initFields() {
        this.jTxtPrincipalName.setText(this.principalName);
        this.jTxtClassName.setText(this.className);
    }

    Collection getErrors() {
        String newClassName;
        ArrayList<String> errors = new ArrayList<String>();
        String newPrincipalName = this.getPrincipalName();
        if (!Utils.notEmpty(newPrincipalName)) {
            errors.add(customizerBundle.getString("ERR_BlankPrincipalName"));
        }
        if (newPrincipalName != null && !newPrincipalName.equals(this.getOriginalPrincipalName()) && this.principalModel.contains(new PrincipalNameMapping(newPrincipalName))) {
            errors.add(MessageFormat.format(customizerBundle.getString("ERR_PrincipalExists"), newPrincipalName));
        }
        if (Utils.notEmpty(newClassName = this.getClassName()) && !Utils.isJavaClass(newClassName)) {
            errors.add(customizerBundle.getString("ERR_InvalidJavaClassName"));
        }
        return errors;
    }

    static void editPrincipalName(JPanel parent, PrincipalNameMapping entry, PrincipalTableModel model, ASDDVersion asVersion) {
        SecurityEditPrincipalPanel editPrincipalPanel = new SecurityEditPrincipalPanel(entry, model, asVersion);
        editPrincipalPanel.displayDialog(parent, customizerBundle.getString("TITLE_EditPrincipal"), "AS_CFG_SecurityRoleEditPrincipal");
    }

    private void displayDialog(JPanel parent, String title, String helpId) {
        BetterInputDialog dialog = new BetterInputDialog(parent, title, helpId, this);
        do {
            int dialogChoice = dialog.display();
            if (dialogChoice == 0) break;
            if (dialogChoice != 1) continue;
            Collection errors = this.getErrors();
            String newPrincipalName = this.getPrincipalName();
            String oldPrincipalName = this.getOriginalPrincipalName();
            String newClassName = this.getClassName();
            String oldClassName = this.getOriginalClassName();
            if (dialog.hasErrors()) {
                dialog.showErrors();
                continue;
            }
            if (Utils.strEquals(newPrincipalName, oldPrincipalName) && Utils.strEquals(newClassName, oldClassName)) continue;
            PrincipalNameMapping oldEntry = new PrincipalNameMapping(oldPrincipalName, oldClassName);
            PrincipalNameMapping newEntry = new PrincipalNameMapping(newPrincipalName, newClassName);
            this.principalModel.replaceElement(oldEntry, newEntry);
        } while (dialog.hasErrors());
    }

    private static class BetterInputDialog
    extends InputDialog {
        private final SecurityEditPrincipalPanel dialogPanel;
        private final String panelHelpId;

        public BetterInputDialog(JPanel parent, String title, String helpId, SecurityEditPrincipalPanel childPanel) {
            super(parent, title);
            this.dialogPanel = childPanel;
            this.panelHelpId = helpId;
            this.dialogPanel.setPreferredSize(new Dimension(parent.getWidth() * 3 / 4, this.dialogPanel.getPreferredSize().height));
            this.getAccessibleContext().setAccessibleName(this.dialogPanel.getAccessibleContext().getAccessibleName());
            this.getAccessibleContext().setAccessibleDescription(this.dialogPanel.getAccessibleContext().getAccessibleDescription());
            this.getContentPane().add((Component)childPanel, "Center");
            this.addListeners();
            this.pack();
            this.setLocationInside(parent);
            this.handleErrorDisplay();
        }

        private void addListeners() {
            this.dialogPanel.addPropertyChangeListener("UserDataChanged", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    this.handleErrorDisplay();
                }
            });
        }

        private void handleErrorDisplay() {
            ArrayList errors = new ArrayList();
            errors.addAll(this.dialogPanel.getErrors());
            this.setErrors(errors);
        }

        @Override
        protected String getHelpId() {
            return this.panelHelpId;
        }
    }
}

