/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser.plugins;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.SelectionKey;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.extbrowser.chrome.ChromeBrowserImpl;
import org.netbeans.modules.extbrowser.plugins.Bundle;
import org.netbeans.modules.extbrowser.plugins.Message;
import org.netbeans.modules.extbrowser.plugins.MessageDispatcherImpl;
import org.netbeans.modules.extbrowser.plugins.MessageListener;
import org.netbeans.modules.extbrowser.plugins.chrome.WebKitDebuggingTransport;
import org.netbeans.modules.netserver.api.WebSocketReadHandler;
import org.netbeans.modules.netserver.api.WebSocketServer;
import org.netbeans.modules.web.browser.api.PageInspector;
import org.netbeans.modules.web.browser.api.ResizeOption;
import org.netbeans.modules.web.browser.api.ResizeOptions;
import org.netbeans.modules.web.browser.api.WebBrowserFeatures;
import org.netbeans.modules.web.browser.spi.ExternalModificationsSupport;
import org.netbeans.modules.web.webkit.debugging.api.TransportStateException;
import org.netbeans.modules.web.webkit.debugging.api.WebKitDebugging;
import org.netbeans.modules.web.webkit.debugging.api.WebKitUIManager;
import org.netbeans.modules.web.webkit.debugging.spi.Response;
import org.netbeans.modules.web.webkit.debugging.spi.ResponseCallback;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class ExternalBrowserPlugin {
    static final String FEATURE_ROS = "RoS";
    public static final String UTF_8 = "UTF-8";
    private static final int PORT = 8008;
    private static final Logger LOG = Logger.getLogger(ExternalBrowserPlugin.class.getCanonicalName());
    private final List<MessageListener> listeners;
    private static final ExternalBrowserPlugin INSTANCE = new ExternalBrowserPlugin();
    private static final RequestProcessor RP = new RequestProcessor("ExternalBrowserPlugin", 5);
    private static final RequestProcessor BROWSER_CHANGES = new RequestProcessor("Chrome Browser Changes", 1);
    private WebSocketServer server;
    private final Map<String, Pair> awaitingBrowserResponse = new HashMap<String, Pair>();
    private List<BrowserTabDescriptor> knownBrowserTabs = new CopyOnWriteArrayList<BrowserTabDescriptor>();

    public static ExternalBrowserPlugin getInstance() {
        return INSTANCE;
    }

    private ExternalBrowserPlugin() {
        this.listeners = new CopyOnWriteArrayList<MessageListener>();
        try {
            this.server = new WebSocketServer((SocketAddress)new InetSocketAddress("localhost", 8008), (WebSocketReadHandler)new BrowserPluginHandler());
            this.server.start();
            Thread shutdown = new Thread(){

                @Override
                public void run() {
                    for (BrowserTabDescriptor tab : ExternalBrowserPlugin.this.knownBrowserTabs) {
                        tab.deinitialize();
                    }
                    ExternalBrowserPlugin.this.server.stop();
                }
            };
            Runtime.getRuntime().addShutdownHook(shutdown);
        }
        catch (IOException e) {
            LOG.log(Level.INFO, null, e);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.ServerStartFailed("8008"), 0));
        }
    }

    public boolean isServerRunning() {
        return this.server != null;
    }

    public void register(URL tempURL, URL realUrl, ChromeBrowserImpl browserImpl) {
        this.awaitingBrowserResponse.put(this.urlToString(tempURL), new Pair(browserImpl, realUrl));
    }

    private String urlToString(URL url) {
        try {
            return url.toURI().toASCIIString().toLowerCase();
        }
        catch (URISyntaxException ex) {
            return url.toExternalForm();
        }
    }

    public void showURLInTab(final BrowserTabDescriptor tab, final URL url) {
        RP.post(new Runnable(){
            final /* synthetic */ ExternalBrowserPlugin this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                tab.init();
                SelectionKey k = tab.keyForFeature(ExternalBrowserPlugin.FEATURE_ROS);
                if (k != null) {
                    this.this$0.server.sendMessage(k, this.this$0.createReloadMessage(tab.tabID, url));
                }
            }
        });
    }

    public void close(final BrowserTabDescriptor tab, final boolean closeTab) {
        RP.post(new Runnable(){
            final /* synthetic */ ExternalBrowserPlugin this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                SelectionKey k;
                tab.deinitialize();
                if (closeTab && (k = tab.keyForFeature(ExternalBrowserPlugin.FEATURE_ROS)) != null) {
                    this.this$0.server.sendMessage(k, this.this$0.createCloseTabMessage(tab.tabID));
                }
            }
        });
    }

    public void attachWebKitDebugger(BrowserTabDescriptor tab) {
        SelectionKey k = tab.keyForFeature(FEATURE_ROS);
        if (k != null) {
            this.server.sendMessage(k, this.createAttachDebuggerMessage(tab.tabID));
        }
    }

    public void detachWebKitDebugger(BrowserTabDescriptor tab) {
        SelectionKey k;
        if (tab != null && (k = tab.keyForFeature(FEATURE_ROS)) != null) {
            this.server.sendMessage(k, this.createDetachDebuggerMessage(tab.tabID));
        }
    }

    public void sendWebKitDebuggerCommand(BrowserTabDescriptor tab, JSONObject command) {
        SelectionKey k = tab.keyForFeature(FEATURE_ROS);
        if (k != null) {
            this.server.sendMessage(k, this.createDebuggerCommandMessage(tab.tabID, command));
        }
    }

    public void addMessageListener(MessageListener listener) {
        this.listeners.add(listener);
    }

    public void removeMessageListener(MessageListener listener) {
        this.listeners.remove(listener);
    }

    private void removeKey(SelectionKey key) {
        for (BrowserTabDescriptor browserTab : this.knownBrowserTabs) {
            if (key.equals(browserTab.keyForFeature(FEATURE_ROS))) {
                browserTab.deinitialize();
                browserTab.browserImpl.wasClosed();
            }
            browserTab.unregisterKey(key);
            if (browserTab.isAnyKeyRegistered()) continue;
            this.knownBrowserTabs.remove(browserTab);
        }
    }

    private void notifyDispatchers(String message, SelectionKey key) {
        for (BrowserTabDescriptor browserTab : this.knownBrowserTabs) {
            Lookup lookup;
            MessageDispatcherImpl dispatcher;
            String featureId = browserTab.featureForKey(key);
            if (featureId == null || (dispatcher = (MessageDispatcherImpl)((Object)(lookup = browserTab.browserImpl.getLookup()).lookup(MessageDispatcherImpl.class))) == null) continue;
            dispatcher.dispatchMessage(featureId, message);
        }
    }

    private void fireMessageEvent(Message msg) {
        for (MessageListener listener : this.listeners) {
            listener.messageReceived(msg);
        }
    }

    public void sendMessage(String message, ChromeBrowserImpl impl, String featureId) {
        for (BrowserTabDescriptor browserTab : this.knownBrowserTabs) {
            SelectionKey key;
            if (browserTab.browserImpl != impl || (key = browserTab.keyForFeature(featureId)) == null) continue;
            this.server.sendMessage(key, message);
        }
    }

    private void closeOtherDebuggingSessionsWithPageInspector(int tabId) {
        for (BrowserTabDescriptor browserTab : this.knownBrowserTabs) {
            if (tabId == browserTab.tabID || !browserTab.isPageInspectorActive()) continue;
            this.close(browserTab, false);
        }
    }

    private String createReloadMessage(int tabId, URL newURL) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tabId", tabId);
        if (newURL != null) {
            String url;
            try {
                url = newURL.toURI().toASCIIString();
            }
            catch (URISyntaxException ex) {
                url = newURL.toExternalForm();
            }
            url = ExternalBrowserPlugin.reformatFileURL(url);
            params.put("url", url);
        }
        Message msg = new Message(Message.MessageType.RELOAD, params);
        return msg.toStringValue();
    }

    private static String reformatFileURL(String url) {
        if (!url.startsWith("file:")) {
            return url;
        }
        url = url.substring(5);
        while (url.length() > 0 && url.startsWith("/")) {
            url = url.substring(1);
        }
        return "file:///" + url;
    }

    private String createCloseTabMessage(int tabId) {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("tabId", tabId);
        Message msg = new Message(Message.MessageType.CLOSE, params);
        return msg.toStringValue();
    }

    private String createAttachDebuggerMessage(int tabId) {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("tabId", tabId);
        Message msg = new Message(Message.MessageType.ATTACH_DEBUGGER, params);
        return msg.toStringValue();
    }

    private String createDetachDebuggerMessage(int tabId) {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("tabId", tabId);
        Message msg = new Message(Message.MessageType.DETACH_DEBUGGER, params);
        return msg.toStringValue();
    }

    private String createDebuggerCommandMessage(int tabId, JSONObject params2) {
        JSONObject data = new JSONObject();
        data.put((Object)"tabId", (Object)tabId);
        data.put((Object)"command", (Object)params2);
        Message msg = new Message(Message.MessageType.DEBUGGER_COMMAND, data);
        return msg.toStringValue();
    }

    class BrowserPluginHandler
    implements WebSocketReadHandler {
        private static final String VERSION = "version";
        private static final String URL = "url";

        BrowserPluginHandler() {
        }

        public void read(SelectionKey key, byte[] data, Integer dataType) {
            if (dataType != null && dataType != 1) {
                return;
            }
            String message = new String(data, Charset.forName(ExternalBrowserPlugin.UTF_8));
            Message msg = Message.parse(message);
            if (msg == null || msg.getType() == null) {
                ExternalBrowserPlugin.this.notifyDispatchers(message, key);
                return;
            }
            ExternalBrowserPlugin.this.fireMessageEvent(msg);
            Message.MessageType type = msg.getType();
            switch (type) {
                case INIT: {
                    this.handleInit(msg, key);
                    break;
                }
                case CLOSE: {
                    this.handleClose(msg, key);
                    break;
                }
                case URLCHANGE: {
                    this.handleURLChange(msg, key);
                    break;
                }
                case INSPECT: {
                    this.handleInspect(msg, key);
                    break;
                }
                case ATTACH_DEBUGGER: {
                    break;
                }
                case DETACH_DEBUGGER: {
                    break;
                }
                case DEBUGGER_DETACHED: {
                    this.handleDebuggerDetached(msg);
                    break;
                }
                case DEBUGGER_COMMAND_RESPONSE: {
                    this.handleDebuggerResponse(msg, key);
                    break;
                }
                case LOAD_RESIZE_OPTIONS: {
                    this.handleLoadResizeOptions(key);
                    break;
                }
                case SAVE_RESIZE_OPTIONS: {
                    this.handleSaveResizeOptions(msg.getValue());
                    break;
                }
                case RESOURCE_CHANGED: {
                    this.handleResourceChanged(msg.getValue(), key);
                    break;
                }
                case READY: {
                    break;
                }
                default: {
                    assert (false) : "Unknown message type: " + (Object)((Object)type);
                    break;
                }
            }
        }

        private void handleInit(Message message, SelectionKey key) {
            ChromeBrowserImpl browserImpl;
            assert (key != null) : message;
            String version = (String)message.getValue().get((Object)VERSION);
            String url = (String)message.getValue().get((Object)URL);
            int tabId = message.getTabId();
            if (version == null || url == null || tabId == -1) {
                return;
            }
            Pair p = this.isSupportedVersion(version) ? this.getAwaitingPair(url) : null;
            ChromeBrowserImpl chromeBrowserImpl = browserImpl = p != null ? p.impl : null;
            if (browserImpl == null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("tabId", tabId);
                map.put("status", "notaccepted");
                map.put(VERSION, this.getNetBeansVersion());
                Message msg = new Message(Message.MessageType.INIT, map);
                ExternalBrowserPlugin.this.server.sendMessage(key, msg.toStringValue());
            } else {
                BrowserTabDescriptor tab = new BrowserTabDescriptor(tabId, browserImpl);
                tab.registerKeyForFeature(ExternalBrowserPlugin.FEATURE_ROS, key);
                browserImpl.setBrowserTabDescriptor(tab);
                ExternalBrowserPlugin.this.knownBrowserTabs.add(tab);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("tabId", tabId);
                map.put("status", "accepted");
                map.put(VERSION, this.getNetBeansVersion());
                Message msg = new Message(Message.MessageType.INIT, map);
                ExternalBrowserPlugin.this.server.sendMessage(key, msg.toStringValue());
                assert (p.realURL != null);
                ExternalBrowserPlugin.this.showURLInTab(tab, p.realURL);
            }
        }

        private boolean isSupportedVersion(String version) {
            return version.startsWith("1.");
        }

        private String getNetBeansVersion() {
            return "8.1";
        }

        private void handleDebuggerDetached(Message message) {
            int tabId = message.getTabId();
            if (tabId == -1) {
                return;
            }
            this.deinitializeTab(tabId, false);
        }

        private Pair getAwaitingPair(String url) {
            ChromeBrowserImpl browserImpl;
            if (url.startsWith("chrome")) {
                return null;
            }
            URL u = null;
            try {
                u = new URL(url);
            }
            catch (MalformedURLException ex) {
                LOG.log(Level.WARNING, "cannot parse URL: {0}", url);
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "processing URL: {0}", u == null ? null : ExternalBrowserPlugin.this.urlToString(u));
                for (String awaiting : ExternalBrowserPlugin.this.awaitingBrowserResponse.keySet()) {
                    LOG.log(Level.FINE, "awaiting URL: {0}", awaiting);
                }
            }
            Pair pair = u == null ? null : (Pair)ExternalBrowserPlugin.this.awaitingBrowserResponse.remove(ExternalBrowserPlugin.this.urlToString(u));
            ChromeBrowserImpl chromeBrowserImpl = browserImpl = pair != null ? pair.impl : null;
            if (browserImpl == null && url.endsWith("/")) {
                try {
                    u = new URL(url.substring(0, url.length() - 1));
                    pair = (Pair)ExternalBrowserPlugin.this.awaitingBrowserResponse.remove(ExternalBrowserPlugin.this.urlToString(u));
                    browserImpl = pair != null ? pair.impl : null;
                }
                catch (MalformedURLException ex) {
                    LOG.log(Level.WARNING, "cannot parse URL: {0}", url);
                }
            }
            if (browserImpl == null && u != null && "file".equals(u.getProtocol()) && "localhost".equals(u.getHost())) {
                try {
                    u = new URL(u.getProtocol(), "", u.getPort(), u.getFile());
                    pair = (Pair)ExternalBrowserPlugin.this.awaitingBrowserResponse.remove(ExternalBrowserPlugin.this.urlToString(u));
                }
                catch (MalformedURLException ex) {
                    LOG.log(Level.WARNING, "cannot parse URL: {0}", url);
                }
            }
            return pair;
        }

        private void handleClose(Message message, SelectionKey key) {
            int tabId = message.getTabId();
            if (tabId == -1) {
                return;
            }
            this.deinitializeTab(tabId, true);
        }

        private boolean deinitializeTab(int tabId, boolean close) {
            for (BrowserTabDescriptor browserTab : ExternalBrowserPlugin.this.knownBrowserTabs) {
                if (tabId != browserTab.tabID) continue;
                browserTab.deinitialize();
                browserTab.disableReInitialization();
                if (close) {
                    ExternalBrowserPlugin.this.knownBrowserTabs.remove(browserTab);
                    browserTab.browserImpl.wasClosed();
                }
                return true;
            }
            return false;
        }

        private void handleDebuggerResponse(Message message, SelectionKey key) {
            int tabId = message.getTabId();
            JSONObject response = (JSONObject)message.getValue().get((Object)"response");
            assert (tabId != -1);
            assert (response != null);
            if (tabId == -1 || response == null) {
                return;
            }
            for (BrowserTabDescriptor browserTab : ExternalBrowserPlugin.this.knownBrowserTabs) {
                if (tabId != browserTab.tabID || browserTab.getCallback() == null) continue;
                String error = (String)response.get((Object)"error");
                Response resp = new Response(response, error == null ? null : new TransportStateException(error));
                browserTab.getCallback().handleResponse(resp);
            }
        }

        private void handleURLChange(Message message, SelectionKey key) {
            int tabId = message.getTabId();
            String url = (String)message.getValue().get((Object)URL);
            if (tabId == -1) {
                return;
            }
            for (BrowserTabDescriptor browserTab : ExternalBrowserPlugin.this.knownBrowserTabs) {
                if (tabId != browserTab.tabID) continue;
                browserTab.browserImpl.urlHasChanged(url);
                return;
            }
        }

        private void handleInspect(Message message, SelectionKey key) {
            final PageInspector inspector = PageInspector.getDefault();
            if (inspector == null) {
                LOG.log(Level.INFO, "No PageInspector found: ignoring the request for page inspection!");
            } else {
                int tabId = message.getTabId();
                BrowserTabDescriptor browserTab = null;
                for (BrowserTabDescriptor descriptor : ExternalBrowserPlugin.this.knownBrowserTabs) {
                    if (descriptor.tabID != tabId) continue;
                    browserTab = descriptor;
                }
                if (browserTab == null) {
                    ChromeBrowserImpl impl = new ChromeBrowserImpl(null, false){

                        @Override
                        public void setURL(URL url) {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public void close(boolean closeTab) {
                        }
                    };
                    browserTab = new BrowserTabDescriptor(tabId, impl);
                    impl.setBrowserTabDescriptor(browserTab);
                    impl.initialize(new WebBrowserFeatures());
                    ExternalBrowserPlugin.this.knownBrowserTabs.add(browserTab);
                }
                final ChromeBrowserImpl browserImpl = browserTab.browserImpl;
                final BrowserTabDescriptor tab = browserTab;
                RP.post(new Runnable(){
                    final /* synthetic */ BrowserPluginHandler this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        if (!browserImpl.hasEnhancedMode()) {
                            browserImpl.setTemporaryEnhancedMode(true);
                        }
                        tab.reEnableReInitialization();
                        tab.init();
                        inspector.inspectPage((Lookup)new ProxyLookup(new Lookup[]{browserImpl.getLookup(), browserImpl.getProjectContext()}));
                    }
                });
            }
        }

        private void handleLoadResizeOptions(SelectionKey key) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("resizeOptions", this.createLoadResizeOptionsMessage(ResizeOptions.getDefault().loadAll()));
            Message msg = new Message(Message.MessageType.LOAD_RESIZE_OPTIONS, map);
            ExternalBrowserPlugin.this.server.sendMessage(key, msg.toStringValue());
        }

        private String createLoadResizeOptionsMessage(List<ResizeOption> resizeOptions) {
            JSONArray result = new JSONArray();
            for (ResizeOption resizeOption : resizeOptions) {
                result.add((Object)this.mapResizeOption(resizeOption));
            }
            return result.toJSONString();
        }

        private JSONObject mapResizeOption(ResizeOption resizeOption) {
            JSONObject mapped = new JSONObject();
            mapped.put((Object)"type", (Object)JSONObject.escape((String)resizeOption.getType().name()));
            mapped.put((Object)"displayName", (Object)JSONObject.escape((String)resizeOption.getDisplayName()));
            mapped.put((Object)"width", (Object)resizeOption.getWidth());
            mapped.put((Object)"height", (Object)resizeOption.getHeight());
            mapped.put((Object)"showInToolbar", (Object)resizeOption.isShowInToolbar());
            mapped.put((Object)"isDefault", (Object)resizeOption.isDefault());
            return mapped;
        }

        private void handleSaveResizeOptions(JSONObject value) {
            JSONArray options = (JSONArray)value.get((Object)"resizeOptions");
            ArrayList<ResizeOption> resizeOptions = new ArrayList<ResizeOption>(options.size());
            for (Object item : options) {
                JSONObject option = (JSONObject)item;
                resizeOptions.add(ResizeOption.create((ResizeOption.Type)ResizeOption.Type.valueOf((String)String.valueOf(option.get((Object)"type"))), (String)String.valueOf(option.get((Object)"displayName")), (int)Integer.valueOf(String.valueOf(option.get((Object)"width"))), (int)Integer.valueOf(String.valueOf(option.get((Object)"height"))), (boolean)Boolean.valueOf(String.valueOf(option.get((Object)"showInToolbar"))), (boolean)Boolean.valueOf(String.valueOf(option.get((Object)"isDefault")))));
            }
            ResizeOptions.getDefault().saveAll(resizeOptions);
        }

        public void accepted(SelectionKey key) {
        }

        public void closed(SelectionKey key) {
            ExternalBrowserPlugin.this.removeKey(key);
        }

        private void handleResourceChanged(JSONObject value, SelectionKey key) {
            final String content = String.valueOf(value.get((Object)"content"));
            JSONObject resource = (JSONObject)value.get((Object)"resource");
            final String url = String.valueOf(resource.get((Object)URL));
            final String type = String.valueOf(resource.get((Object)"type"));
            URL mainDocumentUrl = null;
            for (BrowserTabDescriptor browserTab : ExternalBrowserPlugin.this.knownBrowserTabs) {
                if (!key.equals(browserTab.keyForFeature(ExternalBrowserPlugin.FEATURE_ROS))) continue;
                mainDocumentUrl = browserTab.browserImpl.getURL();
            }
            final URL uu = mainDocumentUrl;
            BROWSER_CHANGES.post(new Runnable(){
                final /* synthetic */ BrowserPluginHandler this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void run() {
                    ExternalModificationsSupport.handle((String)url, (String)type, (String)content, (URL)uu);
                }
            });
        }
    }

    private static class Pair {
        ChromeBrowserImpl impl;
        URL realURL;

        public Pair(ChromeBrowserImpl impl, URL realURL) {
            this.impl = impl;
            this.realURL = realURL;
        }
    }

    public static class BrowserTabDescriptor {
        private final Map<String, SelectionKey> keyMap = new HashMap<String, SelectionKey>();
        private int tabID;
        private ChromeBrowserImpl browserImpl;
        private ResponseCallback callback;
        private boolean initialized;
        private boolean doNotInitialize;
        private Session session;
        private Lookup consoleLogger;
        private Lookup networkMonitor;

        public BrowserTabDescriptor(int tabID, ChromeBrowserImpl browserImpl) {
            this.tabID = tabID;
            this.browserImpl = browserImpl;
        }

        synchronized void registerKeyForFeature(String featureId, SelectionKey key) {
            this.keyMap.put(featureId, key);
        }

        synchronized SelectionKey keyForFeature(String featureId) {
            return this.keyMap.get(featureId);
        }

        synchronized void unregisterKey(SelectionKey key) {
            this.keyMap.values().removeAll(Collections.singleton(key));
        }

        synchronized boolean isAnyKeyRegistered() {
            return !this.keyMap.isEmpty();
        }

        synchronized String featureForKey(SelectionKey key) {
            String featureId = null;
            for (Map.Entry<String, SelectionKey> entry : this.keyMap.entrySet()) {
                if (entry.getValue() != key) continue;
                featureId = entry.getKey();
            }
            return featureId;
        }

        public void setCallback(ResponseCallback callback) {
            this.callback = callback;
        }

        private ResponseCallback getCallback() {
            return this.callback;
        }

        private void init() {
            if (this.initialized || !this.browserImpl.hasEnhancedMode() || this.doNotInitialize || this.browserImpl.getBrowserFeatures() == null || !this.browserImpl.getBrowserFeatures().isNetBeansIntegrationEnabled()) {
                return;
            }
            this.initialized = true;
            PageInspector inspector = PageInspector.getDefault();
            if (inspector != null && this.browserImpl.getBrowserFeatures().isPageInspectorEnabled()) {
                ExternalBrowserPlugin.getInstance().closeOtherDebuggingSessionsWithPageInspector(this.tabID);
            }
            Lookup projectContext = this.browserImpl.getProjectContext();
            WebKitDebuggingTransport transport = (WebKitDebuggingTransport)this.browserImpl.getLookup().lookup(WebKitDebuggingTransport.class);
            WebKitDebugging webkitDebugger = (WebKitDebugging)this.browserImpl.getLookup().lookup(WebKitDebugging.class);
            if (webkitDebugger == null || projectContext == null) {
                return;
            }
            transport.attach();
            if (this.browserImpl.getBrowserFeatures().isLiveHTMLEnabled()) {
                webkitDebugger.getDebugger().enableDebuggerInLiveHTMLMode();
            } else if (!webkitDebugger.getDebugger().enable()) {
                this.initialized = false;
                this.doNotInitialize = true;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.DebuggerEnableFailed(), 0));
                    }
                });
                return;
            }
            if (this.browserImpl.getBrowserFeatures().isJsDebuggerEnabled()) {
                this.session = WebKitUIManager.getDefault().createDebuggingSession(webkitDebugger, projectContext);
            }
            if (this.browserImpl.getBrowserFeatures().isConsoleLoggerEnabled()) {
                this.consoleLogger = WebKitUIManager.getDefault().createBrowserConsoleLogger(webkitDebugger, projectContext);
            }
            if (this.browserImpl.getBrowserFeatures().isNetworkMonitorEnabled()) {
                this.networkMonitor = WebKitUIManager.getDefault().createNetworkMonitor(webkitDebugger, projectContext);
            }
            if (inspector != null && this.browserImpl.getBrowserFeatures().isPageInspectorEnabled()) {
                inspector.inspectPage((Lookup)new ProxyLookup(new Lookup[]{this.browserImpl.getLookup(), this.browserImpl.getProjectContext(), Lookups.fixed((Object[])new Object[]{this.browserImpl})}));
            }
        }

        public boolean isInitialized() {
            return this.initialized;
        }

        private void deinitialize() {
            if (!this.initialized || !this.browserImpl.hasEnhancedMode()) {
                return;
            }
            this.initialized = false;
            WebKitDebuggingTransport transport = (WebKitDebuggingTransport)this.browserImpl.getLookup().lookup(WebKitDebuggingTransport.class);
            WebKitDebugging webkitDebugger = (WebKitDebugging)this.browserImpl.getLookup().lookup(WebKitDebugging.class);
            if (webkitDebugger == null) {
                return;
            }
            if (this.session != null) {
                WebKitUIManager.getDefault().stopDebuggingSession(this.session);
            }
            this.session = null;
            if (this.consoleLogger != null) {
                WebKitUIManager.getDefault().stopBrowserConsoleLogger(this.consoleLogger);
            }
            this.consoleLogger = null;
            if (this.networkMonitor != null) {
                WebKitUIManager.getDefault().stopNetworkMonitor(this.networkMonitor);
            }
            this.networkMonitor = null;
            MessageDispatcherImpl dispatcher = (MessageDispatcherImpl)((Object)this.browserImpl.getLookup().lookup(MessageDispatcherImpl.class));
            if (dispatcher != null) {
                dispatcher.dispatchMessage("inspect", null);
            }
            if (webkitDebugger.getDebugger().isEnabled()) {
                webkitDebugger.getDebugger().disable();
            }
            webkitDebugger.reset();
            transport.detach();
            if (this.browserImpl.hasTemporaryEnhancedMode()) {
                this.browserImpl.setTemporaryEnhancedMode(false);
            }
        }

        private void disableReInitialization() {
            this.doNotInitialize = true;
        }

        public void reEnableReInitialization() {
            this.doNotInitialize = false;
        }

        public boolean isPageInspectorActive() {
            return PageInspector.getDefault() != null && this.browserImpl.getBrowserFeatures() != null && this.browserImpl.getBrowserFeatures().isPageInspectorEnabled();
        }
    }
}

