/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.classpath;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.classpath.BootClassPathImpl;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.maven.indexer.api.RepositoryUtil;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

@SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"})
public final class EndorsedClassPathImpl
implements ClassPathImplementation,
FileChangeListener {
    private static final Logger LOG = Logger.getLogger(EndorsedClassPathImpl.class.getName());
    static final RequestProcessor RP = new RequestProcessor(EndorsedClassPathImpl.class);
    private List<? extends PathResourceImplementation> resourcesCache;
    private boolean includeJDKCache;
    private boolean includeFXCache;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private final NbMavenProjectImpl project;
    private BootClassPathImpl bcp;
    private String[] current;
    private final File endorsed;
    private final Map<File, File> endorsed2Repo = new HashMap<File, File>();
    private final Set<URL> djpbcp = new HashSet<URL>();

    EndorsedClassPathImpl(NbMavenProjectImpl project) {
        this.project = project;
        this.endorsed = new File(project.getPOMFile().getParentFile(), "target/endorsed");
        FileUtil.addFileChangeListener((FileChangeListener)this, (File)this.endorsed);
    }

    public List<? extends PathResourceImplementation> getResources() {
        boolean[] arr = new boolean[]{false};
        return this.getResources(arr, arr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final List<? extends PathResourceImplementation> getResources(boolean[] includeJDK, boolean[] includeFx) {
        assert (this.bcp != null);
        Object object = this.bcp.LOCK;
        synchronized (object) {
            if (this.resourcesCache == null) {
                File[] jars;
                ArrayList<PathResourceImplementation> result = new ArrayList<PathResourceImplementation>();
                String[] boot = this.getBootClasspath();
                this.includeJDKCache = true;
                this.includeFXCache = false;
                if (boot != null) {
                    for (String b : boot) {
                        if (!"netbeans.ignore.jdk.bootclasspath".equals(b)) continue;
                        includeJDK[0] = false;
                        this.includeFXCache = false;
                        this.includeJDKCache = false;
                    }
                    StripPlatformResult res = this.stripDefaultJavaPlatform(boot);
                    includeFx[0] = res.hasFx;
                    this.includeFXCache = res.hasFx;
                    for (URL u : res.urls) {
                        if (u == null) continue;
                        result.add(ClassPathSupport.createResource((URL)u));
                    }
                }
                if ((jars = this.endorsed.listFiles()) != null) {
                    for (final File jar : jars) {
                        if (!jar.isFile()) continue;
                        if (this.endorsed2Repo.containsKey(jar)) {
                            URL url;
                            File toScan = this.endorsed2Repo.get(jar);
                            if (toScan == null || (url = FileUtil.urlForArchiveOrDir((File)toScan)) == null) continue;
                            result.add(ClassPathSupport.createResource((URL)url));
                            continue;
                        }
                        LOG.log(Level.FINE, "looking up {0}", jar);
                        RP.post(new Runnable(){
                            final /* synthetic */ EndorsedClassPathImpl this$0;
                            {
                                this.this$0 = this$0;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Object object = this.this$0.bcp.LOCK;
                                synchronized (object) {
                                    if (this.this$0.endorsed2Repo.containsKey(jar)) {
                                        return;
                                    }
                                }
                                if (!jar.isFile()) {
                                    return;
                                }
                                File toScan = null;
                                for (RepositoryInfo repo : RepositoryPreferences.getInstance().getRepositoryInfos()) {
                                    LOG.log(Level.FINE, "checking {0}", repo);
                                    Iterator iterator = RepositoryQueries.findBySHA1Result((File)jar, Collections.singletonList(repo)).getResults().iterator();
                                    if (!iterator.hasNext()) continue;
                                    NBVersionInfo analogue = (NBVersionInfo)iterator.next();
                                    toScan = RepositoryUtil.createArtifact((NBVersionInfo)analogue).getFile();
                                    LOG.log(Level.FINE, "found {0}", toScan);
                                    break;
                                }
                                if (toScan == null) {
                                    try {
                                        toScan = FileUtil.normalizeFile((File)new File(System.getProperty("java.io.tmpdir"), RepositoryUtil.calculateSHA1Checksum((File)jar) + ".jar"));
                                        if (!toScan.isFile()) {
                                            FileUtils.copyFile((File)jar, (File)toScan);
                                        }
                                    }
                                    catch (IOException x) {
                                        LOG.log(Level.INFO, "copying " + String.valueOf(jar) + " to " + String.valueOf(toScan), x);
                                    }
                                }
                                LOG.log(Level.FINE, "mapping {0} -> {1}", new Object[]{jar, toScan});
                                Object object2 = this.this$0.bcp.LOCK;
                                synchronized (object2) {
                                    this.this$0.endorsed2Repo.put(jar, toScan);
                                    this.this$0.resourcesCache = null;
                                }
                                this.this$0.support.firePropertyChange("resources", null, null);
                            }
                        });
                    }
                }
                this.current = boot;
                this.resourcesCache = Collections.unmodifiableList(result);
            } else {
                includeJDK[0] = this.includeJDKCache;
                includeFx[0] = this.includeFXCache;
            }
            return this.resourcesCache;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    private String[] getBootClasspath() {
        String carg2;
        Properties cargs;
        String carg = PluginPropertyUtils.getPluginProperty(this.project, "org.apache.maven.plugins", "maven-compiler-plugin", "compilerArgument", "compile", null);
        if (carg != null) {
            // empty if block
        }
        if ((cargs = PluginPropertyUtils.getPluginPropertyParameter(this.project, "org.apache.maven.plugins", "maven-compiler-plugin", "compilerArguments", "compile")) != null && (carg2 = cargs.getProperty("bootclasspath")) != null) {
            return StringUtils.split((String)carg2, (String)File.pathSeparator);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean resetCache() {
        Object[] newones = this.getBootClasspath();
        boolean fire = false;
        assert (this.bcp != null);
        Object object = this.bcp.LOCK;
        synchronized (object) {
            if (!Arrays.equals(newones, this.current)) {
                this.resourcesCache = null;
                fire = true;
            }
        }
        if (fire) {
            this.support.firePropertyChange("resources", null, null);
        }
        return fire;
    }

    void setBCP(BootClassPathImpl aThis) {
        this.bcp = aThis;
    }

    private StripPlatformResult stripDefaultJavaPlatform(String[] boot) {
        StripPlatformResult res = new StripPlatformResult();
        ArrayList<URL> toRet = new ArrayList<URL>();
        res.urls = toRet;
        Set<URL> defs = this.getDefJavaPlatBCP();
        block0: for (String s : boot) {
            File f = FileUtilities.convertStringToFile(s);
            URL entry = FileUtil.urlForArchiveOrDir((File)f);
            if (entry == null || defs.contains(entry)) continue;
            if (entry.getPath().endsWith("/jfxrt.jar!/")) {
                for (URL d : defs) {
                    if (!d.getPath().endsWith("/jfxrt.jar!/")) continue;
                    res.hasFx = true;
                    continue block0;
                }
            }
            toRet.add(entry);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<URL> getDefJavaPlatBCP() {
        Set<URL> set = this.djpbcp;
        synchronized (set) {
            if (this.djpbcp.isEmpty()) {
                JavaPlatformManager mngr = JavaPlatformManager.getDefault();
                JavaPlatform jp = mngr.getDefaultPlatform();
                ClassPath cp = jp.getBootstrapLibraries();
                for (ClassPath.Entry ent : cp.entries()) {
                    this.djpbcp.add(ent.getURL());
                }
            }
            return Collections.unmodifiableSet(this.djpbcp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileChange() {
        assert (this.bcp != null);
        Object object = this.bcp.LOCK;
        synchronized (object) {
            this.resourcesCache = null;
        }
        this.support.firePropertyChange("resources", null, null);
    }

    public void fileFolderCreated(FileEvent fe) {
        this.fileChange();
    }

    public void fileDataCreated(FileEvent fe) {
        this.fileChange();
    }

    public void fileChanged(FileEvent fe) {
        this.fileChange();
    }

    public void fileDeleted(FileEvent fe) {
        this.fileChange();
    }

    public void fileRenamed(FileRenameEvent fe) {
        this.fileChange();
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    private class StripPlatformResult {
        List<URL> urls;
        boolean hasFx = false;

        private StripPlatformResult() {
        }
    }
}

