/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam.spi;

import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.spi.Validation;
import org.netbeans.modules.xml.xam.spi.ValidationResult;

public interface Validator {
    public String getName();

    public ValidationResult validate(Model var1, Validation var2, Validation.ValidationType var3);

    public static class ResultItem {
        private Validator validator;
        private ResultType type;
        private Component component;
        private String description;
        private int lineNumber;
        private int columnNumber;
        private Model model;

        public ResultItem(Validator validator, ResultType type, Component component, String desc) {
            this(validator, type, desc, component, -1, -1, null);
        }

        public ResultItem(Validator validator, ResultType type, String desc, int lineNumber, int columnNumber, Model model) {
            this(validator, type, desc, null, lineNumber, columnNumber, model);
        }

        private ResultItem(Validator validator, ResultType type, String desc, Component component, int lineNumber, int columnNumber, Model model) {
            this.validator = validator;
            this.type = type;
            this.description = desc;
            this.lineNumber = lineNumber;
            this.columnNumber = columnNumber;
            this.component = component;
            this.model = model != null ? model : (component == null ? null : component.getModel());
        }

        public Validator getValidator() {
            return this.validator;
        }

        public ResultType getType() {
            return this.type;
        }

        public Component getComponents() {
            return this.component;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }

        public Model getModel() {
            return this.model;
        }
    }

    public static enum ResultType {
        ADVICE,
        WARNING,
        ERROR;

    }
}

