/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import org.netbeans.modules.xml.schema.model.AttributeGroupReference;
import org.netbeans.modules.xml.schema.model.AttributeReference;
import org.netbeans.modules.xml.schema.model.ComplexContentRestriction;
import org.netbeans.modules.xml.schema.model.ComplexExtension;
import org.netbeans.modules.xml.schema.model.ElementReference;
import org.netbeans.modules.xml.schema.model.GlobalAttribute;
import org.netbeans.modules.xml.schema.model.GlobalAttributeGroup;
import org.netbeans.modules.xml.schema.model.GlobalComplexType;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalGroup;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.GroupReference;
import org.netbeans.modules.xml.schema.model.List;
import org.netbeans.modules.xml.schema.model.LocalAttribute;
import org.netbeans.modules.xml.schema.model.LocalElement;
import org.netbeans.modules.xml.schema.model.ReferenceableSchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SimpleExtension;
import org.netbeans.modules.xml.schema.model.SimpleTypeRestriction;
import org.netbeans.modules.xml.schema.model.Union;
import org.netbeans.modules.xml.schema.model.visitor.DefaultSchemaVisitor;
import org.netbeans.modules.xml.schema.model.visitor.FindUsageVisitor;
import org.netbeans.modules.xml.schema.model.visitor.Preview;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;

class RefactorVisitor
extends DefaultSchemaVisitor {
    private ReferenceableSchemaComponent global_component = null;
    private String oldName = null;

    public void rename(ReferenceableSchemaComponent component, String newName) {
        FindUsageVisitor usage = new FindUsageVisitor();
        Preview preview = usage.findUsages(Collections.singletonList(component.getModel().getSchema()), component);
        String originalName = component.getName();
        component.setName(newName);
        this.setRenamedElement(component, originalName);
        this.rename(preview);
    }

    public void setRenamedElement(ReferenceableSchemaComponent component, String originalName) {
        this.global_component = component;
        this.oldName = originalName;
    }

    public void rename(Preview preview) {
        if (this.global_component == null || this.oldName == null) {
            return;
        }
        for (SchemaComponent component : preview.getUsages().keySet()) {
            component.accept(this);
        }
    }

    <T extends ReferenceableSchemaComponent> NamedComponentReference<T> createReference(Class<T> type, SchemaComponent referencing) {
        if (type.isAssignableFrom(this.global_component.getClass())) {
            return referencing.createReferenceTo((ReferenceableSchemaComponent)type.cast(this.global_component), type);
        }
        return null;
    }

    @Override
    public void visit(SimpleTypeRestriction str) {
        NamedComponentReference<GlobalSimpleType> ref = this.createReference(GlobalSimpleType.class, str);
        if (ref != null) {
            str.setBase(ref);
        }
    }

    @Override
    public void visit(LocalElement element) {
        NamedComponentReference<GlobalType> ref = this.createReference(GlobalType.class, element);
        if (ref != null) {
            element.setType(ref);
        }
    }

    @Override
    public void visit(ElementReference element) {
        NamedComponentReference<GlobalElement> ref = this.createReference(GlobalElement.class, element);
        if (ref != null) {
            element.setRef(ref);
        }
    }

    @Override
    public void visit(GlobalElement element) {
        NamedComponentReference<GlobalType> ref = this.createReference(GlobalType.class, element);
        if (ref != null) {
            element.setType(ref);
        } else {
            NamedComponentReference<GlobalElement> ref2 = this.createReference(GlobalElement.class, element);
            if (ref2 != null) {
                element.setSubstitutionGroup(ref2);
            }
        }
    }

    @Override
    public void visit(LocalAttribute attribute) {
        NamedComponentReference<GlobalSimpleType> ref = this.createReference(GlobalSimpleType.class, attribute);
        if (ref != null) {
            attribute.setType(ref);
        }
    }

    @Override
    public void visit(AttributeReference attribute) {
        NamedComponentReference<GlobalAttribute> ref = this.createReference(GlobalAttribute.class, attribute);
        if (ref != null) {
            attribute.setRef(ref);
        }
    }

    @Override
    public void visit(AttributeGroupReference agr) {
        NamedComponentReference<GlobalAttributeGroup> ref = this.createReference(GlobalAttributeGroup.class, agr);
        if (ref != null) {
            agr.setGroup(ref);
        }
    }

    @Override
    public void visit(ComplexContentRestriction ccr) {
        NamedComponentReference<GlobalComplexType> ref = this.createReference(GlobalComplexType.class, ccr);
        if (ref != null) {
            ccr.setBase(ref);
        }
    }

    @Override
    public void visit(SimpleExtension extension) {
        NamedComponentReference<GlobalType> ref = this.createReference(GlobalType.class, extension);
        if (ref != null) {
            extension.setBase(ref);
        }
    }

    @Override
    public void visit(ComplexExtension extension) {
        NamedComponentReference<GlobalType> ref = this.createReference(GlobalType.class, extension);
        if (ref != null) {
            extension.setBase(ref);
        }
    }

    @Override
    public void visit(GroupReference gr) {
        NamedComponentReference<GlobalGroup> ref = this.createReference(GlobalGroup.class, gr);
        if (ref != null) {
            gr.setRef(ref);
        }
    }

    @Override
    public void visit(List list) {
        NamedComponentReference<GlobalSimpleType> ref = this.createReference(GlobalSimpleType.class, list);
        if (ref != null) {
            list.setType(ref);
        }
    }

    @Override
    public void visit(Union u) {
        NamedComponentReference<GlobalSimpleType> ref = this.createReference(GlobalSimpleType.class, u);
        if (ref != null) {
            ArrayList<NamedComponentReference<GlobalSimpleType>> members = new ArrayList<NamedComponentReference<GlobalSimpleType>>(u.getMemberTypes());
            for (int i = 0; i < members.size(); ++i) {
                if (members.get(i).getRefString().indexOf(this.oldName) <= -1) continue;
                members.remove(i);
                members.add(i, ref);
                break;
            }
            u.setMemberTypes(members);
        }
    }
}

