/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.DeployArtifactSource;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="deployArtifactSourceType")
@JsonFilter(value="explicitlySetFilter")
public final class GenericDeployArtifactSource
extends DeployArtifactSource {
    @JsonProperty(value="repositoryId")
    private final String repositoryId;
    @JsonProperty(value="deployArtifactPath")
    private final String deployArtifactPath;
    @JsonProperty(value="deployArtifactVersion")
    private final String deployArtifactVersion;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public GenericDeployArtifactSource(String repositoryId, String deployArtifactPath, String deployArtifactVersion) {
        this.repositoryId = repositoryId;
        this.deployArtifactPath = deployArtifactPath;
        this.deployArtifactVersion = deployArtifactVersion;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getDeployArtifactPath() {
        return this.deployArtifactPath;
    }

    public String getDeployArtifactVersion() {
        return this.deployArtifactVersion;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("GenericDeployArtifactSource(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", repositoryId=").append(String.valueOf(this.repositoryId));
        sb.append(", deployArtifactPath=").append(String.valueOf(this.deployArtifactPath));
        sb.append(", deployArtifactVersion=").append(String.valueOf(this.deployArtifactVersion));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenericDeployArtifactSource)) {
            return false;
        }
        GenericDeployArtifactSource other = (GenericDeployArtifactSource)((Object)o);
        return Objects.equals(this.repositoryId, other.repositoryId) && Objects.equals(this.deployArtifactPath, other.deployArtifactPath) && Objects.equals(this.deployArtifactVersion, other.deployArtifactVersion) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.repositoryId == null ? 43 : this.repositoryId.hashCode());
        result = result * 59 + (this.deployArtifactPath == null ? 43 : this.deployArtifactPath.hashCode());
        result = result * 59 + (this.deployArtifactVersion == null ? 43 : this.deployArtifactVersion.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="repositoryId")
        private String repositoryId;
        @JsonProperty(value="deployArtifactPath")
        private String deployArtifactPath;
        @JsonProperty(value="deployArtifactVersion")
        private String deployArtifactVersion;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            this.__explicitlySet__.add("repositoryId");
            return this;
        }

        public Builder deployArtifactPath(String deployArtifactPath) {
            this.deployArtifactPath = deployArtifactPath;
            this.__explicitlySet__.add("deployArtifactPath");
            return this;
        }

        public Builder deployArtifactVersion(String deployArtifactVersion) {
            this.deployArtifactVersion = deployArtifactVersion;
            this.__explicitlySet__.add("deployArtifactVersion");
            return this;
        }

        public GenericDeployArtifactSource build() {
            GenericDeployArtifactSource model = new GenericDeployArtifactSource(this.repositoryId, this.deployArtifactPath, this.deployArtifactVersion);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(GenericDeployArtifactSource model) {
            if (model.wasPropertyExplicitlySet("repositoryId")) {
                this.repositoryId(model.getRepositoryId());
            }
            if (model.wasPropertyExplicitlySet("deployArtifactPath")) {
                this.deployArtifactPath(model.getDeployArtifactPath());
            }
            if (model.wasPropertyExplicitlySet("deployArtifactVersion")) {
                this.deployArtifactVersion(model.getDeployArtifactVersion());
            }
            return this;
        }
    }
}

