/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.text.DateFormat;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.subversion.DiskMapTurboProvider;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.WorkingCopyAttributesCache;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.turbo.CustomProviders;
import org.netbeans.modules.turbo.Turbo;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.util.DelayScanRegistry;
import org.netbeans.modules.versioning.util.ListenersSupport;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.Utilities;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNLock;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNConflictDescriptor;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class FileStatusCache {
    public static final Object EVENT_FILE_STATUS_CHANGED = new Object();
    public static final String PROP_CACHE_READY = "subversion.cache.ready";
    private static final Map<File, FileInformation> NOT_MANAGED_MAP = new NotManagedMap();
    public static final RepositoryStatus REPOSITORY_STATUS_UNKNOWN = null;
    private static final FileInformation FILE_INFORMATION_EXCLUDED = new FileInformation(2, false);
    private static final FileInformation FILE_INFORMATION_EXCLUDED_DIRECTORY = new FileInformation(2, true);
    private static final FileInformation FILE_INFORMATION_UPTODATE_DIRECTORY = new FileInformation(8, true);
    private static final FileInformation FILE_INFORMATION_NOTMANAGED = new FileInformation(1, false);
    private static final FileInformation FILE_INFORMATION_NOTMANAGED_DIRECTORY = new FileInformation(1, true);
    private static final FileInformation FILE_INFORMATION_UNKNOWN = new FileInformation(0, false);
    private static final int CACHE_SIZE_WARNING_THRESHOLD = 100000;
    private static final Pattern auxConflictPattern = Pattern.compile("(.*?)\\.((r\\d+)|(mine)|(working)|(merge-right\\.r\\d+)|((merge-left.r\\d+)))$");
    private final Turbo turbo;
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.subversion.FileStatusCache");
    private boolean ready = false;
    private final String FILE_STATUS_MAP = "subversion.STATUS_MAP";
    private DiskMapTurboProvider cacheProvider;
    private Subversion svn;
    private RequestProcessor rp = new RequestProcessor("Subversion - file status refresh", 1);
    private final LinkedHashSet<File> filesToRefresh = new LinkedHashSet();
    private RequestProcessor.Task refreshTask;
    private final FileLabelCache labelsCache;
    private long refreshedFilesCount;
    private static final boolean EXCLUDE_SYMLINKS = "true".equals(System.getProperty("versioning.subversion.doNotFollowSymlinks", "false"));
    PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    ListenersSupport listenerSupport = new ListenersSupport((Object)this);
    private final LinkedHashMap<Path, Boolean> symlinks = new LinkedHashMap<Path, Boolean>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Path, Boolean> eldest) {
            return this.size() >= 500;
        }
    };

    FileStatusCache() {
        this.svn = Subversion.getInstance();
        this.cacheProvider = new DiskMapTurboProvider();
        this.turbo = Turbo.createCustom((CustomProviders)new CustomProviders(){
            private final Set providers;
            {
                this.providers = Collections.singleton(FileStatusCache.this.cacheProvider);
            }

            public Iterator providers() {
                return this.providers.iterator();
            }
        }, (int)200, (int)5000);
        this.refreshTask = this.rp.create(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                File fileToRefresh;
                if (DelayScanRegistry.getInstance().isDelayed(FileStatusCache.this.refreshTask, LOG, "FileStatusCache.refreshTask")) {
                    return;
                }
                long startTime = 0L;
                long files = 0L;
                boolean logEnabled = LOG.isLoggable(Level.FINE);
                if (logEnabled) {
                    startTime = System.currentTimeMillis();
                }
                do {
                    fileToRefresh = null;
                    LinkedHashSet linkedHashSet = FileStatusCache.this.filesToRefresh;
                    synchronized (linkedHashSet) {
                        Iterator it = FileStatusCache.this.filesToRefresh.iterator();
                        if (it.hasNext()) {
                            fileToRefresh = (File)it.next();
                            it.remove();
                        }
                    }
                    if (fileToRefresh == null) continue;
                    FileStatusCache.this.refresh(fileToRefresh, REPOSITORY_STATUS_UNKNOWN);
                    if (!logEnabled) continue;
                    ++files;
                    ++FileStatusCache.this.refreshedFilesCount;
                } while (fileToRefresh != null);
                if (logEnabled) {
                    LOG.log(Level.FINE, "refreshTask lasted {0} ms for {1} files, {2} files refreshed so far", new Object[]{System.currentTimeMillis() - startTime, files, FileStatusCache.this.refreshedFilesCount});
                }
            }
        });
        this.labelsCache = new FileLabelCache(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsFiles(Context context, int includeStatus, boolean addExcluded) {
        long ts = System.currentTimeMillis();
        try {
            File[] roots = context.getRootFiles();
            boolean bl = this.containsFiles(roots, includeStatus, addExcluded);
            return bl;
        }
        finally {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, " containsFiles(Context, int) took {0}", System.currentTimeMillis() - ts);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsFiles(Set<File> rootFiles, int includeStatus, boolean addExcluded) {
        long ts = System.currentTimeMillis();
        try {
            File[] roots = rootFiles.toArray(new File[0]);
            boolean bl = this.containsFiles(roots, includeStatus, addExcluded);
            return bl;
        }
        finally {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, " containsFiles(Set<File>, int) took {0}", System.currentTimeMillis() - ts);
            }
        }
    }

    private boolean containsFiles(File[] roots, int includeStatus, boolean addExcluded) {
        for (File root : roots) {
            if (!this.containsFilesIntern(this.cacheProvider.getIndexValues(root, includeStatus), includeStatus, !VersioningSupport.isFlat((File)root), addExcluded)) continue;
            return true;
        }
        return this.containsFilesIntern(roots, includeStatus, false, addExcluded);
    }

    private boolean containsFilesIntern(File[] indexRoots, int includeStatus, boolean recursively, boolean addExcluded) {
        if (indexRoots == null || indexRoots.length == 0) {
            return false;
        }
        for (File root : indexRoots) {
            File[] indexValues = this.cacheProvider.getIndexValues(root, includeStatus);
            if (!recursively || !this.containsFilesIntern(indexValues, includeStatus, recursively, addExcluded)) continue;
            return true;
        }
        for (File root : indexRoots) {
            FileInformation fi = this.getCachedStatus(root);
            if (fi == null || (fi.getStatus() & includeStatus) == 0 || !addExcluded && SvnModuleConfig.getDefault().isExcludedFromCommit(root.getAbsolutePath())) continue;
            return true;
        }
        return false;
    }

    public File[] listFiles(File dir) {
        Set<File> files = this.getScannedFiles(dir).keySet();
        return files.toArray(new File[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] listFiles(File[] roots, int includeStatus) {
        long ts = System.currentTimeMillis();
        try {
            HashSet<File> set = new HashSet<File>();
            for (File root : roots) {
                Set<File> files = this.listFilesIntern(this.cacheProvider.getIndexValues(root, includeStatus), includeStatus, !VersioningSupport.isFlat((File)root));
                set.addAll(files);
            }
            set.addAll(this.listFilesIntern(roots, includeStatus, false));
            File[] fileArray = set.toArray(new File[0]);
            return fileArray;
        }
        finally {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, " listFiles(File[], int, boolean) took {0}", System.currentTimeMillis() - ts);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] listFiles(Context context, int includeStatus) {
        long ts = System.currentTimeMillis();
        try {
            HashSet<File> set = new HashSet<File>();
            File[] roots = context.getRootFiles();
            set.addAll(Arrays.asList(this.listFiles(roots, includeStatus)));
            if (context.getExclusions().size() > 0) {
                for (File excluded : context.getExclusions()) {
                    Iterator i = set.iterator();
                    while (i.hasNext()) {
                        File file = (File)i.next();
                        if (!SvnUtils.isParentOrEqual(excluded, file)) continue;
                        i.remove();
                    }
                }
            }
            File[] fileArray = set.toArray(new File[0]);
            return fileArray;
        }
        finally {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, " listFiles(Context, int) took {0}", System.currentTimeMillis() - ts);
            }
        }
    }

    private Set<File> listFilesIntern(File[] roots, int includeStatus, boolean recursively) {
        if (roots == null || roots.length == 0) {
            return Collections.emptySet();
        }
        HashSet<File> ret = new HashSet<File>();
        for (File root : roots) {
            FileInformation fi;
            if (recursively) {
                ret.addAll(this.listFilesIntern(this.cacheProvider.getIndexValues(root, includeStatus), includeStatus, recursively));
            }
            if ((fi = this.getCachedStatus(root)) == null || (fi.getStatus() & includeStatus) == 0) continue;
            ret.add(root);
        }
        return ret;
    }

    public FileInformation getStatus(File file) {
        if (SvnUtils.isAdministrative(file)) {
            return FILE_INFORMATION_NOTMANAGED_DIRECTORY;
        }
        File dir = file.getParentFile();
        if (dir == null) {
            return FILE_INFORMATION_NOTMANAGED;
        }
        Map<File, FileInformation> files = this.getScannedFiles(dir);
        if (files == NOT_MANAGED_MAP) {
            return FILE_INFORMATION_NOTMANAGED;
        }
        FileInformation fi = files.get(file);
        if (fi != null) {
            return fi;
        }
        if (!this.exists(file)) {
            return FILE_INFORMATION_UNKNOWN;
        }
        if (file.isDirectory()) {
            return this.refresh(file, REPOSITORY_STATUS_UNKNOWN);
        }
        return new FileInformation(8, false);
    }

    public FileInformation getCachedStatus(File file) {
        File parent = file.getParentFile();
        if (parent == null) {
            return FILE_INFORMATION_NOTMANAGED_DIRECTORY;
        }
        Map files = (Map)this.turbo.readEntry((Object)parent, "subversion.STATUS_MAP");
        return files != null ? (FileInformation)files.get(file) : null;
    }

    public void refreshAsync(List<File> files) {
        this.refreshAsync(false, files.toArray(new File[0]));
    }

    public void refreshAsync(File ... files) {
        this.refreshAsync(false, files);
    }

    public void refreshAsync(final boolean recursively, final File ... files) {
        if (files == null || files.length == 0) {
            return;
        }
        Subversion.getInstance().getParallelRequestProcessor().post(new Runnable(){
            final /* synthetic */ FileStatusCache this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LinkedHashSet linkedHashSet = this.this$0.filesToRefresh;
                synchronized (linkedHashSet) {
                    for (File file : files) {
                        if (recursively) {
                            this.this$0.filesToRefresh.addAll(SvnUtils.listManagedRecursively(file));
                            continue;
                        }
                        this.this$0.filesToRefresh.add(file);
                    }
                }
                this.this$0.refreshTask.schedule(200);
            }
        });
    }

    public FileInformation refresh(File file, RepositoryStatus repositoryStatus) {
        return this.refresh(file, repositoryStatus, false);
    }

    public void refreshCached(Context ctx) {
        File[] files = this.listFiles(ctx, -3);
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            this.refresh(file, REPOSITORY_STATUS_UNKNOWN);
        }
    }

    public void refreshRecursively(File root) {
        FileInformation info = this.refresh(root, REPOSITORY_STATUS_UNKNOWN);
        if (info == null || (info.getStatus() & 2) == 0) {
            List<File> files = SvnUtils.listChildren(root);
            for (File file : files) {
                this.refreshRecursively(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileInformation refresh(File file, RepositoryStatus repositoryStatus, boolean forceChangeEvent) {
        boolean refreshDone = false;
        FileInformation current = null;
        FileInformation fi = null;
        File[] content = null;
        FileStatusCache fileStatusCache = this;
        synchronized (fileStatusCache) {
            boolean symlink;
            ISVNStatus status;
            Map<File, FileInformation> files;
            File dir;
            block31: {
                dir = file.getParentFile();
                if (dir == null) {
                    return FILE_INFORMATION_NOTMANAGED;
                }
                files = this.getScannedFiles(dir);
                if (files == NOT_MANAGED_MAP && repositoryStatus == REPOSITORY_STATUS_UNKNOWN) {
                    return FILE_INFORMATION_NOTMANAGED;
                }
                current = files.get(file);
                for (Map.Entry<File, FileInformation> e : files.entrySet()) {
                    File fKey = e.getKey();
                    if (!fKey.getAbsolutePath().equals(file.getAbsolutePath())) continue;
                    current = e.getValue();
                    break;
                }
                status = null;
                symlink = false;
                try {
                    File topmost = Subversion.getInstance().getTopmostManagedAncestor(file);
                    boolean bl = symlink = topmost != null && this.isSymlink(file, topmost);
                    if (!symlink && !SvnUtils.isPartOfSubversionMetadata(file)) {
                        if (this.isParentIgnored(file)) {
                            status = null;
                        } else {
                            SvnClient client = Subversion.getInstance().getClient(false);
                            status = SvnUtils.getSingleStatus(client, file);
                            if (status != null && SVNStatusKind.UNVERSIONED.equals((Object)status.getTextStatus())) {
                                status = null;
                            }
                        }
                    }
                }
                catch (SVNClientException e) {
                    if (SvnClientExceptionHandler.isUnversionedResource(e.getMessage()) || WorkingCopyAttributesCache.getInstance().isSuppressed(e)) break block31;
                    SvnClientExceptionHandler.notifyException((Exception)((Object)e), false, false);
                }
            }
            fi = symlink ? new FileInformation(8, false) : this.createFileInformation(file, status, repositoryStatus);
            if (FileStatusCache.equivalent(fi, current)) {
                refreshDone = true;
            }
            if (!refreshDone && current == null && !fi.isDirectory() && fi.getStatus() == 8) {
                refreshDone = true;
            }
            if (!refreshDone) {
                if (fi.getStatus() == 0 && current != null && current.isDirectory() && (current.getStatus() == 2048 || current.getStatus() == 256)) {
                    content = this.listFiles(new File[]{file}, -1);
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "refresh: will need recursive refresh for deleted folder {0}", file.getAbsolutePath());
                    }
                }
                dir = FileUtil.normalizeFile((File)dir);
                file = new File(dir, file.getName());
                HashMap<File, FileInformation> newFiles = new HashMap<File, FileInformation>(files);
                if (fi.getStatus() == 0) {
                    newFiles.remove(file);
                    this.turbo.writeEntry((Object)file, "subversion.STATUS_MAP", null);
                } else if (fi.getStatus() == 8 && file.isFile()) {
                    newFiles.remove(file);
                } else {
                    newFiles.remove(file);
                    newFiles.put(file, fi);
                }
                assert (!newFiles.containsKey(dir)) : "Dir " + dir + "contains " + files.toString();
                this.turbo.writeEntry((Object)dir, "subversion.STATUS_MAP", newFiles.isEmpty() ? null : newFiles);
            }
        }
        if (!refreshDone) {
            if (content == null && file.isDirectory() && this.needRecursiveRefresh(fi, current)) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "refresh: need recursive refresh for {0}", file.getAbsolutePath());
                }
                content = this.listFiles(file);
            }
            if (content != null) {
                for (int i = 0; i < content.length; ++i) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "refresh: recursive refresh for {0}, child of {1}", new Object[]{content[i].getAbsolutePath(), file.getAbsolutePath()});
                    }
                    this.refresh(content[i], REPOSITORY_STATUS_UNKNOWN);
                }
            }
            this.fireFileStatusChanged(file, current, fi);
        } else {
            if (fi.isDirectory() && "true".equals(System.getProperty("org.netbeans.modules.subversion.FileStatusCache.recursiveScan", "false")) && (fi.getStatus() & 3) == 0 && this.turbo.readEntry((Object)file, "subversion.STATUS_MAP") == null) {
                this.refreshAsync(file.listFiles());
            }
            if (forceChangeEvent) {
                this.fireFileStatusChanged(file, current, fi);
            }
        }
        return fi;
    }

    private boolean isParentIgnored(File file) {
        File parent = file.getParentFile();
        if (parent != null) {
            FileInformation parentInfo = this.getCachedStatus(parent);
            return parentInfo != null && parentInfo.getStatus() == 2;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void patchRevision(File[] fileArray, SVNRevision.Number revision) {
        for (File file : fileArray) {
            FileStatusCache fileStatusCache = this;
            synchronized (fileStatusCache) {
                ISVNStatus entry;
                FileInformation status = this.getCachedStatus(file);
                ISVNStatus iSVNStatus = entry = status != null ? status.getEntry(file) : null;
                if (entry != null) {
                    SVNRevision.Number rev = entry.getRevision();
                    if (rev == null) {
                        continue;
                    }
                    if (rev.getNumber() != revision.getNumber()) {
                        FileInformation info = this.createFileInformation(file, new FakeRevisionStatus(entry, revision), REPOSITORY_STATUS_UNKNOWN);
                        File dir = file.getParentFile();
                        Map<File, FileInformation> files = this.getScannedFiles(dir);
                        HashMap<File, FileInformation> newFiles = new HashMap<File, FileInformation>(files);
                        newFiles.put(file, info);
                        this.turbo.writeEntry((Object)dir, "subversion.STATUS_MAP", newFiles.isEmpty() ? null : newFiles);
                    }
                }
            }
        }
    }

    private static boolean equivalent(FileInformation main, FileInformation other) {
        ISVNStatus e2;
        if (other == null || main.getStatus() != other.getStatus() || main.isDirectory() != other.isDirectory()) {
            return false;
        }
        ISVNStatus e1 = main.getEntry(null);
        return e1 == (e2 = other.getEntry(null)) || e1 == null || e2 == null || FileStatusCache.equal(e1, e2);
    }

    private static boolean equal(ISVNStatus e1, ISVNStatus e2) {
        if (!(SVNStatusKind.IGNORED.equals((Object)e1.getTextStatus()) || SVNStatusKind.UNVERSIONED.equals((Object)e1.getTextStatus()) || SVNStatusKind.ADDED.equals((Object)e1.getTextStatus()))) {
            long r1 = -1L;
            if (e1 != null) {
                SVNRevision.Number r = e1.getRevision();
                r1 = r != null ? e1.getRevision().getNumber() : r1;
            }
            long r2 = -2L;
            if (e2 != null) {
                SVNRevision.Number r = e2.getRevision();
                long l = r2 = r != null ? e2.getRevision().getNumber() : r2;
            }
            if (r1 != r2) {
                return false;
            }
        }
        if (e1.isCopied() != e2.isCopied()) {
            return false;
        }
        return e1.getUrl() == e2.getUrl() || e1.getUrl() != null && e1.getUrl().equals((Object)e2.getUrl());
    }

    private boolean needRecursiveRefresh(FileInformation fi, FileInformation current) {
        if (fi.getStatus() == 2 || current != null && current.getStatus() == 2) {
            return true;
        }
        if (fi.getStatus() == 1 || current != null && current.getStatus() == 1) {
            return true;
        }
        return fi.getStatus() == 4 || current != null && current.getStatus() == 4096;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public boolean ready() {
        return this.ready;
    }

    void computeIndex() {
        try {
            this.cacheProvider.computeIndex();
            Subversion.getInstance().refreshAllAnnotations();
        }
        finally {
            this.ready = true;
            this.propertySupport.firePropertyChange(PROP_CACHE_READY, false, true);
        }
    }

    void cleanUp() {
        File[] modifiedFiles = this.cacheProvider.getAllIndexValues();
        if (modifiedFiles.length > 100000) {
            LOG.log(Level.WARNING, "Cache contains too many entries: {0}", modifiedFiles.length);
        }
        for (File file : modifiedFiles) {
            FileInformation info = this.getCachedStatus(file);
            if (info != null && (info.getStatus() & 0x159D4) != 0) {
                this.refresh(file, REPOSITORY_STATUS_UNKNOWN);
                continue;
            }
            if (info != null && info.getStatus() != 2 || this.exists(file)) continue;
            this.refresh(file, REPOSITORY_STATUS_UNKNOWN);
        }
    }

    void directoryContentChanged(File dir) {
        Map originalFiles = (Map)this.turbo.readEntry((Object)dir, "subversion.STATUS_MAP");
        if (originalFiles != null) {
            for (File file : originalFiles.keySet()) {
                this.refresh(file, REPOSITORY_STATUS_UNKNOWN);
            }
        }
    }

    private Map<File, FileInformation> getScannedFiles(File dir) {
        if (SvnUtils.isAdministrative(dir)) {
            return NOT_MANAGED_MAP;
        }
        File parent = dir.getParentFile();
        if (parent != null && SvnUtils.isAdministrative(parent)) {
            return NOT_MANAGED_MAP;
        }
        Map<File, FileInformation> files = (Map<File, FileInformation>)this.turbo.readEntry((Object)dir, "subversion.STATUS_MAP");
        if (files != null) {
            if (files.containsKey(dir)) {
                LOG.log(Level.WARNING, "Corrupted cached entry for folder {0}, it contains {1}", new Object[]{dir, files});
                files.remove(dir);
                this.turbo.writeEntry((Object)dir, "subversion.STATUS_MAP", files);
            }
            return files;
        }
        if (this.isNotManagedByDefault(dir)) {
            return NOT_MANAGED_MAP;
        }
        dir = FileUtil.normalizeFile((File)dir);
        files = this.scanFolder(dir);
        assert (!files.containsKey(dir)) : "Dir " + dir + "contains " + files.toString();
        this.turbo.writeEntry((Object)dir, "subversion.STATUS_MAP", files);
        for (File file : files.keySet()) {
            FileInformation info = files.get(file);
            if ((info.getStatus() & 0x159D6) == 0) continue;
            this.fireFileStatusChanged(file, null, info);
        }
        return files;
    }

    private boolean isNotManagedByDefault(File dir) {
        return !dir.exists() && !SvnUtils.isManaged(dir);
    }

    private Map<File, FileInformation> scanFolder(File dir) {
        ISVNStatus[] entries;
        HashMap<File, FileInformation> folderFiles;
        File[] files;
        block9: {
            files = dir.listFiles();
            if (files == null) {
                files = new File[]{};
            }
            folderFiles = new HashMap<File, FileInformation>(files.length);
            entries = null;
            try {
                if (SvnUtils.isManaged(dir) && !this.isParentIgnored(dir)) {
                    SvnClient client = Subversion.getInstance().getClient(true);
                    entries = client.getStatus(dir, false, true);
                }
            }
            catch (SVNClientException e) {
                if (SvnClientExceptionHandler.isUnversionedResource(e.getMessage()) || WorkingCopyAttributesCache.getInstance().isSuppressed(e)) break block9;
                SvnClientExceptionHandler.notifyException((Exception)((Object)e), false, false);
            }
        }
        if (entries == null) {
            for (int i = 0; i < files.length; ++i) {
                FileInformation fi;
                File file = files[i];
                if (SvnUtils.isAdministrative(file) || !(fi = this.createFileInformation(file, null, REPOSITORY_STATUS_UNKNOWN)).isDirectory() && fi.getStatus() == 8) continue;
                folderFiles.put(file, fi);
            }
        } else {
            HashSet<File> localFiles = new HashSet<File>(Arrays.asList(files));
            for (int i = 0; i < entries.length; ++i) {
                FileInformation fi;
                ISVNStatus entry = entries[i];
                File file = new File(entry.getPath());
                if (file.equals(dir)) continue;
                localFiles.remove(file);
                if (SvnUtils.isAdministrative(file) || !(fi = this.createFileInformation(file, entry, REPOSITORY_STATUS_UNKNOWN)).isDirectory() && fi.getStatus() == 8) continue;
                folderFiles.put(file, fi);
            }
            for (File localFile : localFiles) {
                FileInformation fi = this.createFileInformation(localFile, null, REPOSITORY_STATUS_UNKNOWN);
                File topmost = Subversion.getInstance().getTopmostManagedAncestor(localFile);
                if (!fi.isDirectory() && topmost != null && (fi.getStatus() == 8 || this.isSymlink(localFile, topmost))) continue;
                folderFiles.put(localFile, fi);
            }
        }
        return folderFiles;
    }

    private FileInformation createFileInformation(File file, ISVNStatus status, RepositoryStatus repositoryStatus) {
        if (status == null || status.getTextStatus().equals((Object)SVNStatusKind.UNVERSIONED)) {
            if (!SvnUtils.isManaged(file)) {
                return file.isDirectory() ? FILE_INFORMATION_NOTMANAGED_DIRECTORY : FILE_INFORMATION_NOTMANAGED;
            }
            return this.createMissingEntryFileInformation(file, repositoryStatus);
        }
        return this.createVersionedFileInformation(file, status, repositoryStatus);
    }

    private FileInformation createVersionedFileInformation(File file, ISVNStatus status, RepositoryStatus repositoryStatus) {
        SVNStatusKind kind = status.getTextStatus();
        SVNStatusKind pkind = status.getPropStatus();
        int remoteStatus = 0;
        if (repositoryStatus != REPOSITORY_STATUS_UNKNOWN) {
            if (repositoryStatus.getStatus().getRepositoryTextStatus() == SVNStatusKind.MODIFIED || repositoryStatus.getStatus().getRepositoryPropStatus() == SVNStatusKind.MODIFIED) {
                remoteStatus = 32;
            } else if (repositoryStatus.getStatus().getRepositoryTextStatus() == SVNStatusKind.DELETED) {
                remoteStatus = 1024;
            } else if (!(repositoryStatus.getStatus().getRepositoryTextStatus() == SVNStatusKind.ADDED || repositoryStatus.getStatus().getRepositoryTextStatus() == SVNStatusKind.REPLACED || repositoryStatus.getStatus().getRepositoryTextStatus() == null && repositoryStatus.getStatus().getRepositoryPropStatus() == null || repositoryStatus.getStatus().getRepositoryTextStatus() == SVNStatusKind.NONE && repositoryStatus.getStatus().getRepositoryPropStatus() == SVNStatusKind.NONE)) {
                Subversion.LOG.log(Level.WARNING, "SVN.FSC: unhandled repository status: {0}\n\ttext: {1}\n\tprop: {2}", new Object[]{file.getAbsolutePath(), repositoryStatus.getStatus().getRepositoryTextStatus(), repositoryStatus.getStatus().getRepositoryPropStatus()});
            }
            if (repositoryStatus.getLock() != null) {
                remoteStatus |= 0x8000;
            }
        }
        if (status.getLockOwner() != null) {
            remoteStatus = 0x2000 | remoteStatus;
        }
        int propertyStatus = 0;
        if (!SVNStatusKind.NONE.equals((Object)pkind) && !SVNStatusKind.NORMAL.equals((Object)pkind)) {
            if (SVNStatusKind.MODIFIED.equals((Object)pkind)) {
                propertyStatus = 65536;
            } else {
                if (SVNStatusKind.CONFLICTED.equals((Object)pkind)) {
                    return new FileInformation(0x40 | remoteStatus, status);
                }
                throw new IllegalArgumentException("Unknown prop status: " + status.getPropStatus());
            }
        }
        int additionalStatus = remoteStatus | propertyStatus;
        if (status.hasTreeConflict()) {
            return new FileInformation(0x4000 | additionalStatus, status);
        }
        if (SVNStatusKind.NONE.equals((Object)kind)) {
            return FILE_INFORMATION_UNKNOWN;
        }
        if (SVNStatusKind.NORMAL.equals((Object)kind)) {
            int finalStatus = 8 | remoteStatus;
            if (propertyStatus != 0) {
                finalStatus = additionalStatus;
            }
            return new FileInformation(finalStatus, status);
        }
        if (SVNStatusKind.MODIFIED.equals((Object)kind)) {
            return new FileInformation(0x10 | additionalStatus, status);
        }
        if (SVNStatusKind.ADDED.equals((Object)kind)) {
            return new FileInformation(0x1000 | additionalStatus, status);
        }
        if (SVNStatusKind.DELETED.equals((Object)kind)) {
            return new FileInformation(0x100 | additionalStatus, status);
        }
        if (SVNStatusKind.UNVERSIONED.equals((Object)kind)) {
            return new FileInformation(4 | additionalStatus, status);
        }
        if (SVNStatusKind.MISSING.equals((Object)kind)) {
            return new FileInformation(0x800 | additionalStatus, status);
        }
        if (SVNStatusKind.REPLACED.equals((Object)kind)) {
            return new FileInformation(0x1000 | additionalStatus, status);
        }
        if (SVNStatusKind.MERGED.equals((Object)kind)) {
            return new FileInformation(0x80 | additionalStatus, status);
        }
        if (SVNStatusKind.CONFLICTED.equals((Object)kind)) {
            return new FileInformation(0x40 | additionalStatus, status);
        }
        if (SVNStatusKind.OBSTRUCTED.equals((Object)kind)) {
            return new FileInformation(0x40 | additionalStatus, status);
        }
        if (SVNStatusKind.IGNORED.equals((Object)kind)) {
            return new FileInformation(2 | remoteStatus, status);
        }
        if (SVNStatusKind.INCOMPLETE.equals((Object)kind)) {
            return new FileInformation(0x40 | additionalStatus, status);
        }
        if (SVNStatusKind.EXTERNAL.equals((Object)kind)) {
            return new FileInformation(8 | remoteStatus, status);
        }
        throw new IllegalArgumentException("Unknown text status: " + status.getTextStatus());
    }

    static String statusText(ISVNStatus status) {
        return "file: " + status.getTextStatus().toString() + " copied: " + status.isCopied() + " prop: " + status.getPropStatus().toString();
    }

    private FileInformation createMissingEntryFileInformation(final File file, RepositoryStatus repositoryStatus) {
        String masterName;
        File master;
        int parentStatus;
        boolean exists = file.exists();
        File parent = file.getParentFile();
        if (parent == null) {
            LOG.log(Level.WARNING, "createMissingEntryFileInformation for root folder: {0}, isManaged={1}", new Object[]{file, SvnUtils.isManaged(file)});
        }
        if (exists && Utilities.isMac() && parent != null) {
            File[] files = parent.listFiles(new FilenameFilter(){
                final /* synthetic */ FileStatusCache this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public boolean accept(File dir, String name) {
                    return name.equals(file.getName());
                }
            });
            exists = files != null && files.length > 0;
        }
        boolean isDirectory = exists && file.isDirectory();
        int n = parentStatus = parent == null || this.isNotManagedByDefault(parent) ? 1 : this.getStatus(parent).getStatus();
        if (parentStatus == 2) {
            return isDirectory ? FILE_INFORMATION_EXCLUDED_DIRECTORY : FILE_INFORMATION_EXCLUDED;
        }
        if (exists && parentStatus == 1) {
            if (isDirectory) {
                return SvnUtils.isPartOfSubversionMetadata(file) ? FILE_INFORMATION_NOTMANAGED_DIRECTORY : FILE_INFORMATION_UPTODATE_DIRECTORY;
            }
            return FILE_INFORMATION_NOTMANAGED;
        }
        String name = file.getName();
        Matcher m = auxConflictPattern.matcher(name);
        if (exists && m.matches() && parent != null && (master = new File(parent, masterName = m.group(1))).isFile()) {
            return FILE_INFORMATION_EXCLUDED;
        }
        if (exists) {
            if (Subversion.getInstance().isIgnored(file) || repositoryStatus != null && repositoryStatus.getStatus().getTextStatus() == SVNStatusKind.EXTERNAL) {
                return new FileInformation(2, file.isDirectory());
            }
            return new FileInformation(4, file.isDirectory());
        }
        if (repositoryStatus != REPOSITORY_STATUS_UNKNOWN && (repositoryStatus.getStatus().getRepositoryTextStatus() == SVNStatusKind.ADDED || repositoryStatus.getStatus().getRepositoryTextStatus() == SVNStatusKind.REPLACED)) {
            boolean folder = repositoryStatus.getStatus().getNodeKind() == SVNNodeKind.DIR;
            return new FileInformation(512, folder);
        }
        return FILE_INFORMATION_UNKNOWN;
    }

    private boolean exists(File file) {
        if (!file.exists()) {
            return false;
        }
        return file.getAbsolutePath().equals(FileUtil.normalizeFile((File)file).getAbsolutePath());
    }

    public void addVersioningListener(VersioningListener listener) {
        this.listenerSupport.addListener(listener);
    }

    public void removeVersioningListener(VersioningListener listener) {
        this.listenerSupport.removeListener(listener);
    }

    private void fireFileStatusChanged(File file, FileInformation oldInfo, FileInformation newInfo) {
        this.getLabelsCache().remove(file);
        this.listenerSupport.fireVersioningEvent(EVENT_FILE_STATUS_CHANGED, new Object[]{file, oldInfo, newInfo});
    }

    private boolean isSymlink(File file, File root) {
        boolean symlink = false;
        if (EXCLUDE_SYMLINKS) {
            try {
                Path path = file.toPath().normalize();
                Path checkoutRoot = root.toPath().normalize();
                symlink = this.isSymlink(path, checkoutRoot);
            }
            catch (InvalidPathException ex) {
                LOG.log(Level.INFO, null, ex);
            }
        }
        return symlink;
    }

    private boolean isSymlink(Path path, Path checkoutRoot) {
        boolean symlink = false;
        if (path == null) {
            return false;
        }
        if (EXCLUDE_SYMLINKS) {
            Boolean cached = this.symlinks.get(path);
            if (cached == null) {
                symlink = Files.isSymbolicLink(path);
                if (symlink) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.INFO, "isSymlink(): File {0} will be treated as a symlink", path);
                    }
                } else if (checkoutRoot != null && !path.equals(checkoutRoot)) {
                    symlink = this.isSymlink(path.getParent(), checkoutRoot);
                }
                this.symlinks.put(path, symlink);
            } else {
                symlink = cached;
            }
        }
        return symlink;
    }

    public FileLabelCache getLabelsCache() {
        return this.labelsCache;
    }

    public static class FileLabelCache {
        private static final Logger LABELS_CACHE_LOG = Logger.getLogger("org.netbeans.modules.subversion.FileLabelsCache");
        private final LinkedHashMap<File, FileLabelInfo> fileLabels;
        private static final long VALID_LABEL_PERIOD = 20000L;
        private static final FileLabelInfo FAKE_LABEL_INFO = new FileLabelInfo("", "", "", "", "", "");
        private final Set<File> filesForLabelRefresh = new HashSet<File>();
        private final RequestProcessor.Task labelInfoRefreshTask;
        private boolean mimeTypeFlag;
        private final FileStatusCache master;
        private static final boolean VERSIONING_ASYNC_ANNOTATOR = !"false".equals(System.getProperty("versioning.asyncAnnotator", "true"));

        private FileLabelCache(FileStatusCache master) {
            this.master = master;
            this.labelInfoRefreshTask = master.rp.create((Runnable)((Object)new LabelInfoRefreshTask()));
            this.fileLabels = new LinkedHashMap(100);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flushFileLabels(File ... files) {
            LinkedHashMap<File, FileLabelInfo> linkedHashMap = this.fileLabels;
            synchronized (linkedHashMap) {
                if (files == null) {
                    this.fileLabels.clear();
                    return;
                }
                for (File f : files) {
                    if (LABELS_CACHE_LOG.isLoggable(Level.FINE)) {
                        LABELS_CACHE_LOG.log(Level.FINE, "Removing from cache: {0}", f.getAbsolutePath());
                    }
                    this.fileLabels.remove(f);
                }
            }
        }

        void setMimeTypeFlag(boolean flag) {
            this.mimeTypeFlag = flag;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileLabelInfo getLabelInfo(File file, boolean mimeTypeFlag) {
            FileLabelInfo labelInfo;
            boolean refreshInfo = false;
            LinkedHashMap<File, FileLabelInfo> linkedHashMap = this.fileLabels;
            synchronized (linkedHashMap) {
                labelInfo = this.fileLabels.get(file);
                if (labelInfo == null || !labelInfo.isValid(mimeTypeFlag, true)) {
                    if (LABELS_CACHE_LOG.isLoggable(Level.FINE)) {
                        if (labelInfo == null && LABELS_CACHE_LOG.isLoggable(Level.FINER)) {
                            LABELS_CACHE_LOG.log(Level.FINER, "No item in cache for : {0}", file.getAbsolutePath());
                        } else if (labelInfo != null) {
                            LABELS_CACHE_LOG.log(Level.FINE, "Too old item in cache for : {0}", file.getAbsolutePath());
                        }
                    }
                    if (labelInfo == null) {
                        labelInfo = FAKE_LABEL_INFO;
                    }
                    refreshInfo = true;
                }
            }
            if (refreshInfo) {
                this.refreshLabelFor(file);
            }
            if (VERSIONING_ASYNC_ANNOTATOR) {
                labelInfo = this.fileLabels.get(file);
                assert (labelInfo != null) : "null label info for " + file.getAbsolutePath();
                if (labelInfo == null) {
                    labelInfo = FAKE_LABEL_INFO;
                }
            }
            return labelInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshLabelFor(File file) {
            Set<File> set = this.filesForLabelRefresh;
            synchronized (set) {
                this.filesForLabelRefresh.add(file);
            }
            if (!EventQueue.isDispatchThread() || VERSIONING_ASYNC_ANNOTATOR) {
                this.labelInfoRefreshTask.run();
            } else {
                this.labelInfoRefreshTask.schedule(200);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void remove(File file) {
            LinkedHashMap<File, FileLabelInfo> linkedHashMap = this.fileLabels;
            synchronized (linkedHashMap) {
                this.fileLabels.remove(file);
            }
        }

        public static class FileLabelInfo {
            private final String revisionString;
            private final String binaryString;
            private final String stickyString;
            private final String lastRevisionString;
            private final String lastAuthorString;
            private final String lastDateString;
            private boolean pickedUp;
            private long timestamp;

            private FileLabelInfo(String revisionString, String binaryString, String stickyString, String lastAuthorString, String lastDateString, String lastRevisionString) {
                this.revisionString = revisionString;
                this.binaryString = binaryString;
                this.stickyString = stickyString;
                this.lastAuthorString = lastAuthorString;
                this.lastDateString = lastDateString;
                this.lastRevisionString = lastRevisionString;
                this.updateTimestamp();
            }

            private void updateTimestamp() {
                this.timestamp = System.currentTimeMillis();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private boolean isValid(boolean mimeFlag, boolean checkFirstAccess) {
                block3: {
                    long diff;
                    block2: {
                        diff = System.currentTimeMillis() - this.timestamp;
                        if (!checkFirstAccess || this.pickedUp) break block2;
                        this.pickedUp = true;
                        if (true) break block3;
                    }
                    if (diff > 20000L) return false;
                }
                boolean bl = true;
                boolean valid = bl;
                if (!valid) return false;
                if (!mimeFlag) return true;
                if (this.binaryString == null) return false;
                return true;
            }

            String getRevisionString() {
                return this.revisionString != null ? this.revisionString : "";
            }

            public String getBinaryString() {
                return this.binaryString != null ? this.binaryString : "";
            }

            public String getStickyString() {
                return this.stickyString != null ? this.stickyString : "";
            }

            public String getLastRevisionString() {
                return this.lastRevisionString == null ? "" : this.lastRevisionString;
            }

            public String getLastDateString() {
                return this.lastDateString == null ? "" : this.lastDateString;
            }

            public String getLastAuthorString() {
                return this.lastAuthorString == null ? "" : this.lastAuthorString;
            }

            public boolean equals(Object obj) {
                if (obj instanceof FileLabelInfo) {
                    FileLabelInfo other = (FileLabelInfo)obj;
                    return this.getRevisionString().equals(other.getRevisionString()) && this.getBinaryString().equals(other.getBinaryString()) && this.getStickyString().equals(other.getStickyString()) && this.getLastAuthorString().equals(other.getLastAuthorString()) && this.getLastDateString().equals(other.getLastDateString()) && this.getLastRevisionString().equals(other.getLastRevisionString());
                }
                return super.equals(obj);
            }

            public int hashCode() {
                int hash = 7;
                hash = 71 * hash + (this.revisionString != null ? this.revisionString.hashCode() : 0);
                hash = 71 * hash + (this.binaryString != null ? this.binaryString.hashCode() : 0);
                hash = 71 * hash + (this.stickyString != null ? this.stickyString.hashCode() : 0);
                hash = 71 * hash + (this.lastRevisionString != null ? this.lastRevisionString.hashCode() : 0);
                hash = 71 * hash + (this.lastAuthorString != null ? this.lastAuthorString.hashCode() : 0);
                hash = 71 * hash + (this.lastDateString != null ? this.lastDateString.hashCode() : 0);
                return hash;
            }
        }

        private class LabelInfoRefreshTask
        extends Task {
            private LabelInfoRefreshTask() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                HashSet filesToRefresh;
                Set set = FileLabelCache.this.filesForLabelRefresh;
                synchronized (set) {
                    filesToRefresh = new HashSet(FileLabelCache.this.filesForLabelRefresh);
                    FileLabelCache.this.filesForLabelRefresh.clear();
                }
                if (!filesToRefresh.isEmpty()) {
                    HashMap<Object, FileLabelInfo> labels = new HashMap<Object, FileLabelInfo>(filesToRefresh.size());
                    for (Object file : filesToRefresh) {
                        try {
                            String lastRevisionString;
                            FileInformation fileInformation = FileLabelCache.this.master.getCachedStatus((File)file);
                            if (fileInformation != null && (fileInformation.getStatus() & 2) != 0 || FileLabelCache.this.master.isParentIgnored((File)file)) {
                                labels.put(file, FAKE_LABEL_INFO);
                                continue;
                            }
                            SvnClient client = Subversion.getInstance().getClient(false);
                            ISVNInfo info = SvnUtils.getInfoFromWorkingCopy(client, (File)file);
                            SVNRevision.Number rev = info.getRevision();
                            String binaryString = null;
                            String lastDateString = null;
                            String revisionString = rev != null && !"-1".equals(rev.toString()) ? rev.toString() : "";
                            rev = info.getLastChangedRevision();
                            String string = lastRevisionString = rev != null && !"-1".equals(rev.toString()) ? rev.toString() : "";
                            if (info.getLastChangedDate() != null) {
                                lastDateString = DateFormat.getDateTimeInstance(3, 3).format(info.getLastChangedDate());
                            }
                            if (FileLabelCache.this.mimeTypeFlag) {
                                binaryString = fileInformation == null || (fileInformation.getStatus() & 6) == 0 ? this.getMimeType(client, (File)file) : "";
                            }
                            String stickyString = fileInformation == null || (fileInformation.getStatus() & 2) == 0 ? (info.getUrl() != null ? SvnUtils.getCopy(info.getUrl()) : SvnUtils.getCopy((File)file)) : "";
                            labels.put(file, new FileLabelInfo(revisionString, binaryString, stickyString, info.getLastCommitAuthor(), lastDateString, lastRevisionString));
                        }
                        catch (SVNClientException sVNClientException) {
                            if (WorkingCopyAttributesCache.getInstance().isSuppressed(sVNClientException)) {
                                try {
                                    WorkingCopyAttributesCache.getInstance().logSuppressed(sVNClientException, (File)file);
                                }
                                catch (SVNClientException client) {}
                            } else if (!SvnClientExceptionHandler.isUnversionedResource(sVNClientException.getMessage())) {
                                LABELS_CACHE_LOG.log(Level.WARNING, "LabelInfoRefreshTask: failed getting info and info for {0}", ((File)file).getAbsolutePath());
                                LABELS_CACHE_LOG.log(Level.INFO, null, sVNClientException);
                            }
                            labels.put(file, FAKE_LABEL_INFO);
                        }
                    }
                    Object object = FileLabelCache.this.fileLabels;
                    synchronized (object) {
                        for (Map.Entry entry : labels.entrySet()) {
                            ((FileLabelInfo)entry.getValue()).updateTimestamp();
                            FileLabelInfo oldInfo = (FileLabelInfo)FileLabelCache.this.fileLabels.remove(entry.getKey());
                            FileLabelCache.this.fileLabels.put((File)entry.getKey(), (FileLabelInfo)entry.getValue());
                            if (!((FileLabelInfo)entry.getValue()).equals(oldInfo)) continue;
                            filesToRefresh.remove(entry.getKey());
                        }
                    }
                    if (!VERSIONING_ASYNC_ANNOTATOR) {
                        Subversion.getInstance().refreshAnnotations(filesToRefresh.toArray(new File[0]));
                    }
                    object = FileLabelCache.this.fileLabels;
                    synchronized (object) {
                        if (FileLabelCache.this.fileLabels.size() > 50) {
                            if (LABELS_CACHE_LOG.isLoggable(Level.FINE)) {
                                LABELS_CACHE_LOG.log(Level.FINE, "Cache contains : {0} entries before a cleanup", FileLabelCache.this.fileLabels.size());
                            }
                            Iterator it = FileLabelCache.this.fileLabels.keySet().iterator();
                            while (it.hasNext()) {
                                File file = (File)it.next();
                                if (((FileLabelInfo)FileLabelCache.this.fileLabels.get(file)).isValid(FileLabelCache.this.mimeTypeFlag, false)) break;
                                it.remove();
                            }
                            if (LABELS_CACHE_LOG.isLoggable(Level.FINE)) {
                                LABELS_CACHE_LOG.log(Level.FINE, "Cache contains : {0} entries after a cleanup", FileLabelCache.this.fileLabels.size());
                            }
                        }
                    }
                }
            }

            private String getMimeType(SvnClient client, File file) {
                try {
                    ISVNProperty prop = client.propertyGet(file, "svn:mime-type");
                    if (prop != null) {
                        String mime = prop.getValue();
                        return mime != null ? mime : "";
                    }
                }
                catch (SVNClientException ex) {
                    if (LABELS_CACHE_LOG.isLoggable(Level.FINE)) {
                        LABELS_CACHE_LOG.log(Level.FINE, null, ex);
                    }
                    return "";
                }
                return "";
            }
        }
    }

    public static class RepositoryStatus {
        private final ISVNStatus status;
        private final ISVNLock lock;

        public RepositoryStatus(ISVNStatus status, ISVNLock lock) {
            this.status = status;
            this.lock = lock;
        }

        public ISVNStatus getStatus() {
            return this.status;
        }

        public ISVNLock getLock() {
            return this.lock;
        }
    }

    private class FakeRevisionStatus
    implements ISVNStatus {
        private ISVNStatus value;
        private SVNRevision.Number revision;

        public FakeRevisionStatus(ISVNStatus value, SVNRevision.Number revision) {
            this.value = value;
            this.revision = revision;
        }

        public boolean isWcLocked() {
            return this.value.isWcLocked();
        }

        public boolean isSwitched() {
            return this.value.isSwitched();
        }

        public boolean isCopied() {
            return this.value.isCopied();
        }

        public String getUrlString() {
            return this.value.getUrlString();
        }

        public SVNUrl getUrl() {
            return this.value.getUrl();
        }

        public SVNStatusKind getTextStatus() {
            return this.value.getTextStatus();
        }

        public SVNRevision.Number getRevision() {
            return this.revision;
        }

        public SVNStatusKind getRepositoryTextStatus() {
            return this.value.getRepositoryTextStatus();
        }

        public SVNStatusKind getRepositoryPropStatus() {
            return this.value.getRepositoryPropStatus();
        }

        public SVNStatusKind getPropStatus() {
            return this.value.getPropStatus();
        }

        public String getPath() {
            return this.value.getPath();
        }

        public SVNNodeKind getNodeKind() {
            return this.value.getNodeKind();
        }

        public String getLockOwner() {
            return this.value.getLockOwner();
        }

        public Date getLockCreationDate() {
            return this.value.getLockCreationDate();
        }

        public String getLockComment() {
            return this.value.getLockComment();
        }

        public String getLastCommitAuthor() {
            return this.value.getLastCommitAuthor();
        }

        public SVNRevision.Number getLastChangedRevision() {
            return this.value.getLastChangedRevision();
        }

        public Date getLastChangedDate() {
            return this.value.getLastChangedDate();
        }

        public File getFile() {
            return this.value.getFile();
        }

        public File getConflictWorking() {
            return this.value.getConflictWorking();
        }

        public File getConflictOld() {
            return this.value.getConflictOld();
        }

        public File getConflictNew() {
            return this.value.getConflictNew();
        }

        public boolean hasTreeConflict() {
            return this.value.hasTreeConflict();
        }

        public SVNConflictDescriptor getConflictDescriptor() {
            return this.value.getConflictDescriptor();
        }

        public boolean isFileExternal() {
            return this.value.isFileExternal();
        }

        public String getMovedFromAbspath() {
            return this.value.getMovedFromAbspath();
        }

        public String getMovedToAbspath() {
            return this.value.getMovedToAbspath();
        }
    }

    private static final class NotManagedMap
    extends AbstractMap<File, FileInformation> {
        private NotManagedMap() {
        }

        @Override
        public Set<Map.Entry<File, FileInformation>> entrySet() {
            return Collections.emptySet();
        }
    }
}

