/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.api;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.SvnFileNode;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnClientFactory;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.browser.Browser;
import org.netbeans.modules.subversion.ui.checkout.CheckoutAction;
import org.netbeans.modules.subversion.ui.commit.CommitAction;
import org.netbeans.modules.subversion.ui.commit.CommitOptions;
import org.netbeans.modules.subversion.ui.repository.RepositoryConnection;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.VCSBugtrackingAccessor;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Subversion {
    private static final String WORKINGDIR_KEY_PREFIX = "working.dir.";
    private static final String RELATIVE_PATH_ROOT = "/";
    public static final String CLIENT_UNAVAILABLE_ERROR_MESSAGE = "SVN client unavailable";

    public static String[] selectRepositoryFolders(String dialogTitle, String repositoryUrl) throws MalformedURLException, IOException {
        return Subversion.selectRepositoryFolders(dialogTitle, repositoryUrl, null, null);
    }

    public static String[] selectRepositoryFolders(String dialogTitle, String repositoryUrl, String username, char[] password) throws MalformedURLException, IOException {
        SVNRevision svnRevision;
        if (!Subversion.isClientAvailable(true)) {
            org.netbeans.modules.subversion.Subversion.LOG.log(Level.WARNING, "Subversion client is unavailable");
            throw new IOException(CLIENT_UNAVAILABLE_ERROR_MESSAGE);
        }
        RepositoryConnection conn = new RepositoryConnection(repositoryUrl);
        SVNUrl svnUrl = conn.getSvnUrl();
        RepositoryFile repositoryFile = new RepositoryFile(svnUrl, svnRevision = conn.getSvnRevision());
        Browser browser = new Browser(dialogTitle, 9, repositoryFile, null, username != null ? username : "", (char[])(username != null ? password : null), null, "org.netbeans.modules.subversion.ui.browser.checkout");
        RepositoryFile[] selectedFiles = browser.getRepositoryFiles();
        if (selectedFiles == null || selectedFiles.length == 0) {
            return null;
        }
        String[] relativePaths = Subversion.makeRelativePaths(repositoryFile, selectedFiles);
        return relativePaths;
    }

    public static void checkoutRepositoryFolder(String repositoryUrl, String[] relativePaths, File localFolder, boolean scanForNewProjects) throws MalformedURLException, IOException {
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote repository. Do not call in awt!";
        Subversion.checkoutRepositoryFolder(repositoryUrl, relativePaths, localFolder, null, null, false, scanForNewProjects);
    }

    public static void checkoutRepositoryFolder(String repositoryUrl, String[] relativePaths, File localFolder, boolean atLocalFolderLevel, boolean scanForNewProjects) throws MalformedURLException, IOException {
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote repository. Do not call in awt!";
        Subversion.checkoutRepositoryFolder(repositoryUrl, relativePaths, localFolder, null, null, scanForNewProjects);
    }

    public static void checkoutRepositoryFolder(String repositoryUrl, String[] repoRelativePaths, File localFolder, String username, String password, boolean scanForNewProjects) throws MalformedURLException, IOException {
        Subversion.checkoutRepositoryFolder(repositoryUrl, repoRelativePaths, localFolder, username, password, false, scanForNewProjects);
    }

    public static void checkoutRepositoryFolder(String repositoryUrl, String[] repoRelativePaths, File localFolder, String username, String password, boolean atLocalFolderLevel, boolean scanForNewProjects) throws MalformedURLException, IOException {
        VCSBugtrackingAccessor bugtrackingSupport;
        RepositoryFile[] repositoryFiles;
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote repository. Do not call in awt!";
        if (!Subversion.isClientAvailable(true)) {
            org.netbeans.modules.subversion.Subversion.LOG.log(Level.WARNING, "Subversion client is unavailable");
            throw new IOException(CLIENT_UNAVAILABLE_ERROR_MESSAGE);
        }
        RepositoryConnection conn = new RepositoryConnection(repositoryUrl);
        SVNUrl svnUrl = conn.getSvnUrl();
        SVNRevision svnRevision = conn.getSvnRevision();
        SvnClient client = Subversion.getClient(svnUrl, username, password);
        if (repoRelativePaths.length == 0 || repoRelativePaths.length == 1 && repoRelativePaths[0].trim().equals("")) {
            repositoryFiles = new RepositoryFile[]{new RepositoryFile(svnUrl, ".", svnRevision)};
        } else {
            repositoryFiles = new RepositoryFile[repoRelativePaths.length];
            for (int i = 0; i < repoRelativePaths.length; ++i) {
                String repoRelativePath = repoRelativePaths[i];
                repoRelativePath = Subversion.polishRelativePath(repoRelativePath);
                repositoryFiles[i] = new RepositoryFile(svnUrl, repoRelativePath, svnRevision);
            }
        }
        boolean notVersionedYet = localFolder.exists() && !SvnUtils.isManaged(localFolder);
        CheckoutAction.performCheckout(svnUrl, client, repositoryFiles, localFolder, atLocalFolderLevel, false, scanForNewProjects).waitFinished();
        try {
            Subversion.storeWorkingDir(new URL(repositoryUrl), localFolder.toURI().toURL());
        }
        catch (Exception e) {
            Logger.getLogger(Subversion.class.getName()).log(Level.FINE, "Cannot store subversion workdir preferences", e);
        }
        if (notVersionedYet) {
            Subversion.getSubversion().versionedFilesChanged();
            SvnUtils.refreshParents(localFolder);
            Subversion.getSubversion().getStatusCache().refreshRecursively(localFolder);
        }
        if ((bugtrackingSupport = (VCSBugtrackingAccessor)Lookup.getDefault().lookup(VCSBugtrackingAccessor.class)) != null) {
            bugtrackingSupport.setFirmAssociations(new File[]{localFolder}, repositoryUrl);
        }
    }

    public static void mkdir(String url, String user, String password, String message) throws MalformedURLException, IOException {
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote repository. Do not call in  awt!";
        if (!Subversion.isClientAvailable(true)) {
            org.netbeans.modules.subversion.Subversion.LOG.log(Level.WARNING, "Subversion client is unavailable");
            throw new IOException(CLIENT_UNAVAILABLE_ERROR_MESSAGE);
        }
        SVNUrl svnUrl = new SVNUrl(url);
        SvnClient client = Subversion.getClient(svnUrl, user, password);
        try {
            client.mkdir(svnUrl, true, message);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, true);
            throw new IOException(ex.getMessage());
        }
    }

    public static void addRecentUrl(String url) throws MalformedURLException {
        new SVNUrl(url);
        RepositoryConnection rc = new RepositoryConnection(url);
        SvnModuleConfig.getDefault().insertRecentUrl(rc);
    }

    public static void commit(final File[] roots, final String user, final String password, final String message) throws IOException {
        if (!Subversion.isClientAvailable(true)) {
            org.netbeans.modules.subversion.Subversion.LOG.log(Level.WARNING, "Subversion client is unavailable");
            throw new IOException(CLIENT_UNAVAILABLE_ERROR_MESSAGE);
        }
        FileStatusCache cache = Subversion.getSubversion().getStatusCache();
        File[] files = cache.listFiles(roots, 88532);
        if (files.length == 0) {
            return;
        }
        SvnFileNode[] nodes = new SvnFileNode[files.length];
        for (int i = 0; i < files.length; ++i) {
            nodes[i] = new SvnFileNode(files[i]);
        }
        CommitOptions[] commitOptions = SvnUtils.createDefaultCommitOptions(nodes, false);
        final HashMap<SvnFileNode, CommitOptions> commitFiles = new HashMap<SvnFileNode, CommitOptions>(nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            commitFiles.put(nodes[i], commitOptions[i]);
        }
        try {
            final SVNUrl repositoryUrl = SvnUtils.getRepositoryRootUrl(roots[0]);
            RequestProcessor rp = Subversion.getSubversion().getRequestProcessor(repositoryUrl);
            SvnProgressSupport support = new SvnProgressSupport(){

                @Override
                public void perform() {
                    SvnClient client;
                    try {
                        client = Subversion.getSubversion().getClient(repositoryUrl, user, password.toCharArray(), this);
                    }
                    catch (SVNClientException ex) {
                        SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
                        return;
                    }
                    CommitAction.performCommit(client, message, commitFiles, roots, this, false, Collections.emptyList());
                }
            };
            support.start(rp, repositoryUrl, NbBundle.getMessage(CommitAction.class, (String)"LBL_Commit_Progress")).waitFinished();
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
        }
    }

    public static boolean isRepository(String url) {
        boolean retval = false;
        if (!Subversion.isClientAvailable(false)) {
            return false;
        }
        RepositoryConnection conn = new RepositoryConnection(url);
        SVNUrl svnUrl = null;
        try {
            svnUrl = new SVNUrl(conn.getSvnUrl().toString());
        }
        catch (MalformedURLException ex) {
            org.netbeans.modules.subversion.Subversion.LOG.log(Level.FINE, "Invalid svn url " + url, ex);
        }
        if (svnUrl != null) {
            String protocol = svnUrl.getProtocol();
            if ("svn".equals(protocol) || protocol.startsWith("svn+")) {
                retval = true;
            } else {
                SvnClient client = null;
                try {
                    client = Subversion.getSubversion().getClient(svnUrl, conn.getUsername(), conn.getPassword(), 0);
                }
                catch (SVNClientException ex) {
                    org.netbeans.modules.subversion.Subversion.LOG.log(Level.INFO, "Cannot create client for url: " + url, ex);
                }
                if (client != null) {
                    try {
                        ISVNInfo info = client.getInfo(svnUrl);
                        if (info != null) {
                            retval = true;
                        }
                    }
                    catch (SVNClientException ex) {
                        org.netbeans.modules.subversion.Subversion.LOG.log(Level.FINE, "Invalid url: " + url, ex);
                    }
                }
            }
        }
        return retval;
    }

    public static void openCheckoutWizard(String url) throws MalformedURLException, IOException {
        Subversion.openCheckoutWizard(url, false);
    }

    public static File openCheckoutWizard(String url, boolean waitFinished) throws MalformedURLException, IOException {
        Subversion.addRecentUrl(url);
        if (!Subversion.isClientAvailable(true)) {
            org.netbeans.modules.subversion.Subversion.LOG.log(Level.INFO, "Subversion client is unavailable");
            throw new IOException(CLIENT_UNAVAILABLE_ERROR_MESSAGE);
        }
        return CheckoutAction.performCheckout(waitFinished);
    }

    public static boolean isClientAvailable(boolean showErrorDialog) {
        if (!showErrorDialog) {
            return Subversion.isClientAvailable();
        }
        if (Subversion.getSubversion().checkClientAvailable()) {
            return true;
        }
        return Subversion.isClientAvailable();
    }

    private static boolean isClientAvailable() {
        try {
            SvnClientFactory.checkClientAvailable();
        }
        catch (SVNClientException ex) {
            org.netbeans.modules.subversion.Subversion.LOG.log(Level.INFO, "svn client not available");
            return false;
        }
        return true;
    }

    private static org.netbeans.modules.subversion.Subversion getSubversion() {
        return org.netbeans.modules.subversion.Subversion.getInstance();
    }

    private static String[] makeRelativePaths(RepositoryFile repositoryFile, RepositoryFile[] selectedFiles) {
        String[] result = new String[selectedFiles.length];
        String[] repoPathSegments = repositoryFile.getPathSegments();
        for (int i = 0; i < selectedFiles.length; ++i) {
            RepositoryFile selectedFile = selectedFiles[i];
            result[i] = Subversion.makeRelativePath(repoPathSegments, selectedFile.getPathSegments());
        }
        return result;
    }

    private static String makeRelativePath(String[] repoPathSegments, String[] selectedPathSegments) {
        assert (Subversion.isPrefixOf(repoPathSegments, selectedPathSegments));
        int delta = selectedPathSegments.length - repoPathSegments.length;
        if (delta == 0) {
            return RELATIVE_PATH_ROOT;
        }
        if (delta == 1) {
            return selectedPathSegments[selectedPathSegments.length - 1];
        }
        StringBuilder buf = new StringBuilder(120);
        int startIndex = repoPathSegments.length;
        int endIndex = selectedPathSegments.length;
        buf.append(selectedPathSegments[startIndex++]);
        for (int i = startIndex; i < endIndex; ++i) {
            buf.append('/');
            buf.append(selectedPathSegments[i]);
        }
        return buf.toString();
    }

    private static boolean isPrefixOf(String[] prefix, String[] path) {
        if (prefix.length > path.length) {
            return false;
        }
        for (int i = 0; i < prefix.length; ++i) {
            if (path[i].equals(prefix[i])) continue;
            return false;
        }
        return true;
    }

    private static void storeWorkingDir(URL remoteUrl, URL localFolder) {
        Preferences prf = NbPreferences.forModule(Subversion.class);
        prf.put(WORKINGDIR_KEY_PREFIX + remoteUrl, localFolder.toString());
    }

    private static String polishRelativePath(String path) {
        if (path.length() == 0) {
            throw new IllegalArgumentException("empty path");
        }
        if ((path = Subversion.removeDuplicateSlashes(path)).equals(RELATIVE_PATH_ROOT)) {
            return RELATIVE_PATH_ROOT;
        }
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        if (path.charAt(path.length() - 1) == '/') {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    private static boolean isRootRelativePath(String relativePath) {
        return relativePath.equals(RELATIVE_PATH_ROOT);
    }

    private static String removeDuplicateSlashes(String str) {
        int len = str.length();
        StringBuilder buf = null;
        boolean lastWasSlash = false;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c == '/') {
                if (lastWasSlash) {
                    if (buf != null) continue;
                    buf = new StringBuilder(len);
                    buf.append(str, 0, i);
                    continue;
                }
                lastWasSlash = true;
            } else {
                lastWasSlash = false;
            }
            if (buf == null) continue;
            buf.append(c);
        }
        return buf != null ? buf.toString() : str;
    }

    private static SvnClient getClient(SVNUrl url, String username, String password) {
        try {
            if (username != null) {
                password = password != null ? password : "";
                return Subversion.getSubversion().getClient(url, username, password.toCharArray());
            }
            return Subversion.getSubversion().getClient(url);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, true);
            return null;
        }
    }
}

