/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpplite.project.ui.wizard;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.cpplite.project.ui.wizard.CPPLiteProjectWizardIterator;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CPPLiteProjectPathPanel
extends JPanel {
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private volatile boolean valid;
    private JButton fileChooser;
    private JLabel jLabel1;
    private JTextField path;

    public CPPLiteProjectPathPanel() {
        this.initComponents();
        this.path.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CPPLiteProjectPathPanel.this.pathUpdated();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CPPLiteProjectPathPanel.this.pathUpdated();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.pathUpdated();
    }

    private void pathUpdated() {
        String text = this.path.getText();
        FileObject projectDirectory = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(text)));
        this.valid = projectDirectory != null && projectDirectory.isFolder() && !text.isEmpty();
        this.cs.fireChange();
    }

    public void addChangeListener(ChangeListener l) {
        this.cs.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.cs.removeChangeListener(l);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.fileChooser = new JButton();
        this.path = new JTextField();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(CPPLiteProjectPathPanel.class, (String)"CPPLiteProjectPathPanel.jLabel1.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.fileChooser, (String)NbBundle.getMessage(CPPLiteProjectPathPanel.class, (String)"CPPLiteProjectPathPanel.fileChooser.text"));
        this.fileChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CPPLiteProjectPathPanel.this.fileChooserActionPerformed(evt);
            }
        });
        this.path.setText(NbBundle.getMessage(CPPLiteProjectPathPanel.class, (String)"CPPLiteProjectPathPanel.path.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.path, -1, 265, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileChooser)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileChooser).addComponent(this.path, -2, -1, -2).addComponent(this.jLabel1)));
    }

    private void fileChooserActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        fc.setSelectedFile(new File(this.path.getText()));
        if (fc.showDialog(this, "Select") == 0) {
            this.path.setText(fc.getSelectedFile().getAbsolutePath());
        }
    }

    public static class PanelImpl
    implements WizardDescriptor.FinishablePanel<WizardDescriptor> {
        private CPPLiteProjectPathPanel panel;

        public CPPLiteProjectPathPanel getComponent() {
            if (this.panel == null) {
                this.panel = new CPPLiteProjectPathPanel();
            }
            return this.panel;
        }

        public HelpCtx getHelp() {
            return HelpCtx.DEFAULT_HELP;
        }

        public void readSettings(WizardDescriptor wizard) {
            CPPLiteProjectWizardIterator.CPPLiteProjectSettings settings = CPPLiteProjectWizardIterator.CPPLiteProjectSettings.get(wizard);
            String path = settings.getProjectPath();
            if (path == null) {
                path = "";
            }
            this.getComponent().path.setText(path);
        }

        public void storeSettings(WizardDescriptor wizard) {
            CPPLiteProjectWizardIterator.CPPLiteProjectSettings.get(wizard).setProjectPath(this.getComponent().path.getText());
        }

        public boolean isValid() {
            return this.getComponent().valid;
        }

        public void addChangeListener(ChangeListener l) {
            this.getComponent().addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.getComponent().removeChangeListener(l);
        }

        public boolean isFinishPanel() {
            return true;
        }
    }
}

