/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony.commands;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.symfony.commands.SymfonyCommandVO;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class SymfonyCommandsXmlParser
extends DefaultHandler {
    private static final Logger LOGGER = Logger.getLogger(SymfonyCommandsXmlParser.class.getName());
    private final XMLReader xmlReader;
    private final List<SymfonyCommandVO> commands;
    private String currentCommand = null;
    private String currentDescription = null;
    private Content content = Content.NONE;

    public SymfonyCommandsXmlParser(List<SymfonyCommandVO> commands) throws SAXException {
        assert (commands != null);
        this.commands = commands;
        this.xmlReader = FileUtils.createXmlReader();
        this.xmlReader.setContentHandler(this);
    }

    public static void parse(Reader reader, List<SymfonyCommandVO> commands) {
        try {
            SymfonyCommandsXmlParser parser = new SymfonyCommandsXmlParser(commands);
            parser.xmlReader.parse(new InputSource(reader));
        }
        catch (SAXException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        catch (Throwable ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, null, ex);
            }
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("task".equals(qName)) {
            assert (this.currentCommand == null);
            assert (this.currentDescription == null);
            this.currentCommand = attributes.getValue("id");
        } else if ("description".equals(qName)) {
            assert (this.content == Content.NONE);
            assert (this.currentDescription == null);
            if (this.currentCommand != null) {
                this.content = Content.DESCRIPTION;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("description".equals(qName) && this.content == Content.DESCRIPTION) {
            assert (this.currentCommand != null);
            if (this.currentDescription == null) {
                this.currentDescription = "";
            }
            this.commands.add(new SymfonyCommandVO(this.currentCommand.trim(), this.currentDescription.trim()));
            this.currentCommand = null;
            this.currentDescription = null;
            this.content = Content.NONE;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.content == Content.DESCRIPTION) {
            this.currentDescription = new String(ch, start, length);
        }
    }

    static enum Content {
        NONE,
        DESCRIPTION;

    }
}

