/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.codegen;

import java.io.IOException;
import java.util.Set;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.filesystems.FileObject;

public abstract class AbstractGenerator {
    private ProgressHandle pHandle;
    private int totalWorkUnits;
    private int workUnits;

    public abstract Set<FileObject> generate(ProgressHandle var1) throws IOException;

    protected void initProgressReporting(ProgressHandle pHandle) {
        this.initProgressReporting(pHandle, true);
    }

    protected void initProgressReporting(ProgressHandle pHandle, boolean start) {
        this.pHandle = pHandle;
        this.totalWorkUnits = this.getTotalWorkUnits();
        this.workUnits = 0;
        if (start) {
            if (this.totalWorkUnits > 0) {
                pHandle.start(this.totalWorkUnits);
            } else {
                pHandle.start();
            }
        }
    }

    protected void reportProgress(String message) {
        if (this.pHandle != null) {
            if (this.totalWorkUnits > 0) {
                this.pHandle.progress(message, ++this.workUnits);
            } else {
                this.pHandle.progress(message);
            }
        }
    }

    protected void finishProgressReporting() {
        if (this.pHandle != null) {
            this.pHandle.finish();
        }
    }

    protected int getTotalWorkUnits() {
        return 0;
    }

    protected ProgressHandle getProgressHandle() {
        return this.pHandle;
    }
}

