/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.analysis.ui;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.netbeans.modules.analysis.ui.AnalysisResultTopComponent;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.cookies.OpenCookie;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public abstract class AbstractErrorAction
extends AbstractAction
implements PropertyChangeListener {
    private final AnalysisResultTopComponent comp;
    private final List<Node> currentSubsequentNodes = new ArrayList<Node>();
    private boolean selecting;
    private static final int DESIRED_PREPARED_NODES_COUNT = 2;
    protected static final RequestProcessor WORKER = new RequestProcessor(AnalysisResultTopComponent.class.getName(), 1, false, false);
    private long stateId;

    public AbstractErrorAction(AnalysisResultTopComponent comp) {
        this.comp = comp;
        this.comp.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)this);
        this.updateEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.currentSubsequentNodes.isEmpty()) {
            this.updateEnabled();
            return;
        }
        Node node = this.currentSubsequentNodes.remove(0);
        if (node == null) {
            this.updateEnabled();
            return;
        }
        OpenCookie oc = (OpenCookie)node.getLookup().lookup(OpenCookie.class);
        assert (oc != null);
        this.selecting = true;
        try {
            this.comp.getExplorerManager().setSelectedNodes(new Node[]{node});
        }
        catch (PropertyVetoException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            this.selecting = false;
        }
        oc.open();
        this.ensureNodesFilled();
        this.updateEnabled();
    }

    private void updateEnabled() {
        this.setEnabled(!this.currentSubsequentNodes.isEmpty() && this.currentSubsequentNodes.get(0) != null);
    }

    private void ensureNodesFilled() {
        if (this.currentSubsequentNodes.size() < 2) {
            Node[] selected;
            final long currentRequest = this.stateId;
            final Node from = this.currentSubsequentNodes.isEmpty() ? ((selected = this.comp.getExplorerManager().getSelectedNodes()).length > 0 ? selected[0] : this.comp.getExplorerManager().getRootContext()) : this.currentSubsequentNodes.get(this.currentSubsequentNodes.size() - 1);
            if (from == null) {
                while (this.currentSubsequentNodes.size() < 2) {
                    this.currentSubsequentNodes.add(null);
                }
                return;
            }
            WORKER.post(new Runnable(){
                final /* synthetic */ AbstractErrorAction this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    final Node next = this.this$0.findSubsequentNode(from);
                    SwingUtilities.invokeLater(new Runnable(){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            if (currentRequest != this.this$1.this$0.stateId) {
                                return;
                            }
                            this.this$1.this$0.currentSubsequentNodes.add(next);
                            this.this$1.this$0.ensureNodesFilled();
                            this.this$1.this$0.updateEnabled();
                        }
                    });
                }
            });
        }
    }

    protected abstract Node findSubsequentNode(Node var1);

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.selecting) {
            return;
        }
        ++this.stateId;
        this.currentSubsequentNodes.clear();
        this.ensureNodesFilled();
        this.updateEnabled();
    }

    protected final boolean isUseful(Node n) {
        return n.getLookup().lookup(ErrorDescription.class) != null;
    }
}

