/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common.status;

import org.netbeans.modules.payara.common.PayaraInstance;
import org.netbeans.modules.payara.common.status.BasicStateListener;
import org.netbeans.modules.payara.common.ui.PayaraCredentials;
import org.netbeans.modules.payara.tooling.PayaraStatus;
import org.netbeans.modules.payara.tooling.data.PayaraServer;
import org.netbeans.modules.payara.tooling.data.PayaraStatusTask;
import org.openide.util.NbBundle;

public class AuthFailureStateListener
extends BasicStateListener {
    private static final long POPUP_DELAY = 30000L;
    private volatile boolean popUpLock = false;
    private long lastTm = 0L;
    private final boolean allowPopup;

    public AuthFailureStateListener(boolean allowPopup) {
        this.allowPopup = allowPopup;
    }

    public void currentState(PayaraServer server, PayaraStatus status, PayaraStatusTask task) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newState(PayaraServer server, PayaraStatus status, PayaraStatusTask task) {
        if (this.popUpLock) {
            AuthFailureStateListener authFailureStateListener = this;
            synchronized (authFailureStateListener) {
                if (this.popUpLock) {
                    this.popUpLock = false;
                }
            }
        }
    }

    public void error(PayaraServer server, PayaraStatusTask task) {
        block0 : switch (task.getType()) {
            case LOCATIONS: 
            case VERSION: {
                switch (task.getEvent()) {
                    case AUTH_FAILED_HTTP: {
                        PayaraStatus.suspend((PayaraServer)server);
                        break block0;
                    }
                    case AUTH_FAILED: {
                        if (this.allowPopup) {
                            if (!this.popUpLock) {
                                this.updateCredentials(server);
                                break block0;
                            }
                        } else {
                            PayaraStatus.suspend((PayaraServer)server);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCredentials(PayaraServer server) {
        boolean update = true;
        AuthFailureStateListener authFailureStateListener = this;
        synchronized (authFailureStateListener) {
            if (!this.popUpLock && this.lastTm + 30000L < System.currentTimeMillis()) {
                this.popUpLock = true;
                if (server instanceof PayaraInstance) {
                    try {
                        PayaraInstance instance = (PayaraInstance)server;
                        String message = NbBundle.getMessage(AuthFailureStateListener.class, (String)"AuthFailureStateListener.message", (Object)instance.getDisplayName());
                        update = PayaraCredentials.setCredentials(instance, message);
                        this.popUpLock = !update;
                    }
                    catch (Throwable throwable) {
                        this.popUpLock = !update;
                        this.lastTm = System.currentTimeMillis();
                        throw throwable;
                    }
                    this.lastTm = System.currentTimeMillis();
                }
            }
        }
        if (!update) {
            PayaraStatus.suspend((PayaraServer)server);
        }
    }
}

