/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.SessionId;
import org.netbeans.modules.php.dbgp.SessionManager;
import org.netbeans.modules.php.dbgp.breakpoints.AbstractBreakpoint;
import org.netbeans.modules.php.dbgp.breakpoints.Utils;
import org.netbeans.modules.php.dbgp.packets.BrkpntRemoveCommand;
import org.netbeans.modules.php.dbgp.packets.BrkpntSetCommand;
import org.netbeans.modules.php.dbgp.packets.BrkpntUpdateCommand;

public class BreakpointRuntimeSetter
extends DebuggerManagerAdapter {
    public String[] getProperties() {
        return new String[]{"breakpoints"};
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        breakpoint.addPropertyChangeListener("enabled", (PropertyChangeListener)((Object)this));
        this.performCommand(breakpoint, Lazy.SET_COMMAND);
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        breakpoint.removePropertyChangeListener("enabled", (PropertyChangeListener)((Object)this));
        this.performCommand(breakpoint, Lazy.REMOVE_COMMAND);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (!"enabled".equals(event.getPropertyName())) {
            return;
        }
        Object source = event.getSource();
        if (((Breakpoint)source).isEnabled()) {
            this.performCommand((Breakpoint)source, Lazy.SET_COMMAND);
        } else {
            this.performCommand((Breakpoint)source, Lazy.REMOVE_COMMAND);
        }
    }

    private void performCommand(Breakpoint breakpoint, Command command) {
        Session[] sessions;
        if (!(breakpoint instanceof AbstractBreakpoint)) {
            return;
        }
        AbstractBreakpoint bpoint = (AbstractBreakpoint)breakpoint;
        for (Session sess : sessions = DebuggerManager.getDebuggerManager().getSessions()) {
            SessionId id = (SessionId)sess.lookupFirst(null, SessionId.class);
            if (id == null) continue;
            SessionManager sessionManager = SessionManager.getInstance();
            List<DebugSession> collection = sessionManager.findSessionsById(id);
            for (DebugSession debugSession : collection) {
                command.perform(bpoint, id, debugSession);
            }
        }
    }

    private static class Lazy {
        static final Command SET_COMMAND = new SetBreakpointCommand();
        static final Command REMOVE_COMMAND = new RemoveBreakpointCommand();
        static final Command UPDATE_COMMAND = new UpdateBreakpointCommand();

        private Lazy() {
        }
    }

    private static interface Command {
        public void perform(AbstractBreakpoint var1, SessionId var2, DebugSession var3);
    }

    private static class UpdateBreakpointCommand
    implements Command {
        private static final Logger LOGGER = Logger.getLogger(UpdateBreakpointCommand.class.getName());

        private UpdateBreakpointCommand() {
        }

        @Override
        public void perform(AbstractBreakpoint breakpoint, SessionId id, DebugSession session) {
            if (session != null && breakpoint != null) {
                BrkpntUpdateCommand command = new BrkpntUpdateCommand(session.getTransactionId(), breakpoint.getBreakpointId());
                BrkpntSetCommand.State state = breakpoint.isEnabled() ? BrkpntSetCommand.State.ENABLED : BrkpntSetCommand.State.DISABLED;
                command.setState(state);
                session.sendCommandLater(command);
            } else {
                LOGGER.log(Level.FINE, "Session and Breakpoint can't be null! Session: {0} || Breakpoint: {1}", new Object[]{session, breakpoint});
            }
        }
    }

    private static class RemoveBreakpointCommand
    implements Command {
        private RemoveBreakpointCommand() {
        }

        @Override
        public void perform(AbstractBreakpoint breakpoint, SessionId id, DebugSession session) {
            if (!breakpoint.isSessionRelated(session)) {
                return;
            }
            BrkpntRemoveCommand command = new BrkpntRemoveCommand(session.getTransactionId(), breakpoint.getBreakpointId());
            session.sendCommandLater(command);
        }
    }

    private static class SetBreakpointCommand
    implements Command {
        private SetBreakpointCommand() {
        }

        @Override
        public void perform(AbstractBreakpoint breakpoint, SessionId id, DebugSession session) {
            BrkpntSetCommand command;
            if (session != null && (command = Utils.getCommand(session, id, breakpoint)) != null) {
                session.sendCommandLater(command);
            }
        }
    }
}

