/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.ListBuffer;
import java.util.HashMap;
import java.util.Map;

public class DeferredLintHandler {
    protected static final Context.Key<DeferredLintHandler> deferredLintHandlerKey = new Context.Key();
    private Lint immediateLint;
    private JCDiagnostic.DiagnosticPosition currentPos;
    private Map<JCDiagnostic.DiagnosticPosition, ListBuffer<LintLogger>> loggersQueue = new HashMap<JCDiagnostic.DiagnosticPosition, ListBuffer<LintLogger>>();
    private static final JCDiagnostic.DiagnosticPosition IMMEDIATE_POSITION = new JCDiagnostic.DiagnosticPosition(){

        @Override
        public JCTree getTree() {
            Assert.error();
            return null;
        }

        @Override
        public int getStartPosition() {
            Assert.error();
            return -1;
        }

        @Override
        public int getPreferredPosition() {
            Assert.error();
            return -1;
        }

        @Override
        public int getEndPosition(EndPosTable endPosTable) {
            Assert.error();
            return -1;
        }
    };

    public static DeferredLintHandler instance(Context context) {
        DeferredLintHandler instance = context.get(deferredLintHandlerKey);
        if (instance == null) {
            instance = new DeferredLintHandler(context);
        }
        return instance;
    }

    protected DeferredLintHandler(Context context) {
        context.put(deferredLintHandlerKey, this);
        this.currentPos = IMMEDIATE_POSITION;
        this.immediateLint = Lint.instance(context);
    }

    public void report(LintLogger logger) {
        if (this.currentPos == IMMEDIATE_POSITION) {
            logger.report(this.immediateLint);
        } else {
            ListBuffer<LintLogger> loggers = this.loggersQueue.get(this.currentPos);
            if (loggers == null) {
                loggers = new ListBuffer();
                this.loggersQueue.put(this.currentPos, loggers);
            }
            loggers.append(logger);
        }
    }

    public void flush(JCDiagnostic.DiagnosticPosition pos, Lint lint) {
        ListBuffer<LintLogger> loggers = this.loggersQueue.get(pos);
        if (loggers != null) {
            for (LintLogger lintLogger : loggers) {
                lintLogger.report(lint);
            }
            this.loggersQueue.remove(pos);
        }
    }

    public JCDiagnostic.DiagnosticPosition setPos(JCDiagnostic.DiagnosticPosition currentPos) {
        JCDiagnostic.DiagnosticPosition prevPosition = this.currentPos;
        this.currentPos = currentPos;
        return prevPosition;
    }

    public JCDiagnostic.DiagnosticPosition immediate(Lint lint) {
        this.immediateLint = lint;
        return this.setPos(IMMEDIATE_POSITION);
    }

    public static interface LintLogger {
        public void report(Lint var1);
    }
}

